/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.redis;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import org.apache.beam.sdk.io.redis.AutoValue_RedisConnectionConfiguration;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;
import redis.clients.jedis.Jedis;

@AutoValue
public abstract class RedisConnectionConfiguration
implements Serializable {
    abstract ValueProvider<String> host();

    abstract ValueProvider<Integer> port();

    abstract @Nullable ValueProvider<String> auth();

    abstract ValueProvider<Integer> timeout();

    abstract ValueProvider<Boolean> ssl();

    abstract Builder builder();

    public static RedisConnectionConfiguration create() {
        return new AutoValue_RedisConnectionConfiguration.Builder().setHost((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)"localhost")).setPort((ValueProvider<Integer>)ValueProvider.StaticValueProvider.of((Object)6379)).setTimeout((ValueProvider<Integer>)ValueProvider.StaticValueProvider.of((Object)2000)).setSsl((ValueProvider<Boolean>)ValueProvider.StaticValueProvider.of((Object)Boolean.FALSE)).build();
    }

    public static RedisConnectionConfiguration create(String host, int port) {
        return RedisConnectionConfiguration.create().withHost(host).withPort(port);
    }

    public static RedisConnectionConfiguration create(ValueProvider<String> host, ValueProvider<Integer> port) {
        return RedisConnectionConfiguration.create().withHost(host).withPort(port);
    }

    public RedisConnectionConfiguration withHost(String host) {
        Preconditions.checkArgument((host != null ? 1 : 0) != 0, (Object)"host can not be null");
        return this.withHost((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)host));
    }

    public RedisConnectionConfiguration withHost(ValueProvider<String> host) {
        return this.builder().setHost(host).build();
    }

    public RedisConnectionConfiguration withPort(int port) {
        Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"port can not be negative or 0");
        return this.withPort((ValueProvider<Integer>)ValueProvider.StaticValueProvider.of((Object)port));
    }

    public RedisConnectionConfiguration withPort(ValueProvider<Integer> port) {
        return this.builder().setPort(port).build();
    }

    public RedisConnectionConfiguration withAuth(String auth) {
        Preconditions.checkArgument((auth != null ? 1 : 0) != 0, (Object)"auth can not be null");
        return this.withAuth((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)auth));
    }

    public RedisConnectionConfiguration withAuth(ValueProvider<String> auth) {
        return this.builder().setAuth(auth).build();
    }

    public RedisConnectionConfiguration withTimeout(int timeout) {
        Preconditions.checkArgument((timeout >= 0 ? 1 : 0) != 0, (Object)"timeout can not be negative");
        return this.withTimeout((ValueProvider<Integer>)ValueProvider.StaticValueProvider.of((Object)timeout));
    }

    public RedisConnectionConfiguration withTimeout(ValueProvider<Integer> timeout) {
        return this.builder().setTimeout(timeout).build();
    }

    public RedisConnectionConfiguration enableSSL() {
        return this.withSSL((ValueProvider<Boolean>)ValueProvider.StaticValueProvider.of((Object)Boolean.TRUE));
    }

    public RedisConnectionConfiguration withSSL(ValueProvider<Boolean> ssl) {
        return this.builder().setSsl(ssl).build();
    }

    public Jedis connect() {
        Jedis jedis = new Jedis((String)this.host().get(), ((Integer)this.port().get()).intValue(), ((Integer)this.timeout().get()).intValue(), ((Boolean)this.ssl().get()).booleanValue());
        if (this.auth() != null) {
            jedis.auth((String)this.auth().get());
        }
        return jedis;
    }

    public void populateDisplayData(DisplayData.Builder builder) {
        builder.add(DisplayData.item((String)"host", this.host()));
        builder.add(DisplayData.item((String)"port", this.port()));
        builder.addIfNotNull(DisplayData.item((String)"timeout", this.timeout()));
        builder.add(DisplayData.item((String)"ssl", this.ssl()));
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setHost(ValueProvider<String> var1);

        abstract Builder setPort(ValueProvider<Integer> var1);

        abstract Builder setAuth(ValueProvider<String> var1);

        abstract Builder setTimeout(ValueProvider<Integer> var1);

        abstract Builder setSsl(ValueProvider<Boolean> var1);

        abstract RedisConnectionConfiguration build();
    }
}

