/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.parquet;

import java.io.Serializable;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.parquet.GenericRecordReadConverter;
import org.apache.beam.sdk.io.parquet.ParquetIO;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.io.SchemaIO;
import org.apache.beam.sdk.schemas.io.SchemaIOProvider;
import org.apache.beam.sdk.schemas.utils.AvroUtils;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public class ParquetSchemaIOProvider
implements SchemaIOProvider {
    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "parquet";
    }

    public @UnknownKeyFor @NonNull @Initialized Schema configurationSchema() {
        return Schema.builder().build();
    }

    public @UnknownKeyFor @NonNull @Initialized ParquetSchemaIO from(@UnknownKeyFor @NonNull @Initialized String location, @UnknownKeyFor @NonNull @Initialized Row configuration, @UnknownKeyFor @NonNull @Initialized Schema dataSchema) {
        return new ParquetSchemaIO(location, dataSchema);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean requiresDataSchema() {
        return true;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PCollection.IsBounded isBounded() {
        return PCollection.IsBounded.BOUNDED;
    }

    private static class ParquetSchemaIO
    implements SchemaIO,
    Serializable {
        protected final @UnknownKeyFor @NonNull @Initialized Schema dataSchema;
        protected final @UnknownKeyFor @NonNull @Initialized String location;

        private ParquetSchemaIO(@UnknownKeyFor @NonNull @Initialized String location, @UnknownKeyFor @NonNull @Initialized Schema dataSchema) {
            this.dataSchema = dataSchema;
            this.location = location;
        }

        public @UnknownKeyFor @NonNull @Initialized Schema schema() {
            return this.dataSchema;
        }

        public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> buildReader() {
            return new PTransform<PBegin, PCollection<Row>>(){

                public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PBegin begin) {
                    GenericRecordReadConverter readConverter = GenericRecordReadConverter.builder().beamSchema(dataSchema).build();
                    return (PCollection)((PCollection)begin.apply("ParquetIORead", (PTransform)ParquetIO.read(AvroUtils.toAvroSchema((Schema)dataSchema)).from(location))).apply("GenericRecordToRow", (PTransform)readConverter);
                }
            };
        }

        public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized POutput> buildWriter() {
            throw new UnsupportedOperationException("Writing to a Parquet file is not supported");
        }
    }
}

