/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.mongodb;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.beam.sdk.util.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SSLUtils {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SSLUtils.class);
    private static final @UnknownKeyFor @NonNull @Initialized TrustManager @UnknownKeyFor @NonNull @Initialized [] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public @UnknownKeyFor @NonNull @Initialized X509Certificate @UnknownKeyFor @NonNull @Initialized [] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(@UnknownKeyFor @NonNull @Initialized X509Certificate @UnknownKeyFor @NonNull @Initialized [] certs, @UnknownKeyFor @NonNull @Initialized String authType) {
        }

        @Override
        public void checkServerTrusted(@UnknownKeyFor @NonNull @Initialized X509Certificate @UnknownKeyFor @NonNull @Initialized [] certs, @UnknownKeyFor @NonNull @Initialized String authType) {
        }
    }};

    SSLUtils() {
    }

    static @UnknownKeyFor @NonNull @Initialized SSLContext ignoreSSLCertificate() {
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            KeyStore ks = (KeyStore)Preconditions.checkStateNotNull((Object)KeyStore.getInstance("JKS"), (Object)"Keystore 'JKS' not found");
            ClassLoader classLoader = (ClassLoader)Preconditions.checkStateNotNull((Object)SSLUtils.class.getClassLoader(), (Object)"SSLUtil classloader is null - boot classloader?");
            InputStream inputStream = classLoader.getResourceAsStream("resources/.keystore");
            if (inputStream != null) {
                LOG.info("Found keystore in classpath 'resources/.keystore'. Loading...");
                ks.load(inputStream, "changeit".toCharArray());
            } else {
                LOG.info("Unable to find keystore under 'resources/.keystore' in the classpath. Continuing with an empty keystore.");
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, "changeit".toCharArray());
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(kmf.getKeyManagers(), trustAllCerts, null);
            SSLContext.setDefault(ctx);
            return ctx;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

