/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.mongodb;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import org.apache.beam.sdk.io.mongodb.MongoDbIO;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.bson.Document;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AutoValue_MongoDbIO_Read
extends MongoDbIO.Read {
    private final @Nullable String uri;
    private final int maxConnectionIdleTime;
    private final boolean sslEnabled;
    private final boolean sslInvalidHostNameAllowed;
    private final boolean ignoreSSLCertificate;
    private final @Nullable String database;
    private final @Nullable String collection;
    private final int numSplits;
    private final boolean bucketAuto;
    private final SerializableFunction<MongoCollection<Document>, MongoCursor<Document>> queryFn;

    private AutoValue_MongoDbIO_Read(@Nullable String uri, int maxConnectionIdleTime, boolean sslEnabled, boolean sslInvalidHostNameAllowed, boolean ignoreSSLCertificate, @Nullable String database, @Nullable String collection, int numSplits, boolean bucketAuto, SerializableFunction<MongoCollection<Document>, MongoCursor<Document>> queryFn) {
        this.uri = uri;
        this.maxConnectionIdleTime = maxConnectionIdleTime;
        this.sslEnabled = sslEnabled;
        this.sslInvalidHostNameAllowed = sslInvalidHostNameAllowed;
        this.ignoreSSLCertificate = ignoreSSLCertificate;
        this.database = database;
        this.collection = collection;
        this.numSplits = numSplits;
        this.bucketAuto = bucketAuto;
        this.queryFn = queryFn;
    }

    @Override
    @Nullable String uri() {
        return this.uri;
    }

    @Override
    int maxConnectionIdleTime() {
        return this.maxConnectionIdleTime;
    }

    @Override
    boolean sslEnabled() {
        return this.sslEnabled;
    }

    @Override
    boolean sslInvalidHostNameAllowed() {
        return this.sslInvalidHostNameAllowed;
    }

    @Override
    boolean ignoreSSLCertificate() {
        return this.ignoreSSLCertificate;
    }

    @Override
    @Nullable String database() {
        return this.database;
    }

    @Override
    @Nullable String collection() {
        return this.collection;
    }

    @Override
    int numSplits() {
        return this.numSplits;
    }

    @Override
    boolean bucketAuto() {
        return this.bucketAuto;
    }

    @Override
    SerializableFunction<MongoCollection<Document>, MongoCursor<Document>> queryFn() {
        return this.queryFn;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MongoDbIO.Read) {
            MongoDbIO.Read that = (MongoDbIO.Read)((Object)o);
            return (this.uri == null ? that.uri() == null : this.uri.equals(that.uri())) && this.maxConnectionIdleTime == that.maxConnectionIdleTime() && this.sslEnabled == that.sslEnabled() && this.sslInvalidHostNameAllowed == that.sslInvalidHostNameAllowed() && this.ignoreSSLCertificate == that.ignoreSSLCertificate() && (this.database == null ? that.database() == null : this.database.equals(that.database())) && (this.collection == null ? that.collection() == null : this.collection.equals(that.collection())) && this.numSplits == that.numSplits() && this.bucketAuto == that.bucketAuto() && this.queryFn.equals(that.queryFn());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.uri == null ? 0 : this.uri.hashCode();
        h$ *= 1000003;
        h$ ^= this.maxConnectionIdleTime;
        h$ *= 1000003;
        h$ ^= this.sslEnabled ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.sslInvalidHostNameAllowed ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.ignoreSSLCertificate ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.database == null ? 0 : this.database.hashCode();
        h$ *= 1000003;
        h$ ^= this.collection == null ? 0 : this.collection.hashCode();
        h$ *= 1000003;
        h$ ^= this.numSplits;
        h$ *= 1000003;
        h$ ^= this.bucketAuto ? 1231 : 1237;
        h$ *= 1000003;
        return h$ ^= this.queryFn.hashCode();
    }

    @Override
    MongoDbIO.Read.Builder builder() {
        return new Builder(this);
    }

    static final class Builder
    extends MongoDbIO.Read.Builder {
        private @Nullable String uri;
        private Integer maxConnectionIdleTime;
        private Boolean sslEnabled;
        private Boolean sslInvalidHostNameAllowed;
        private Boolean ignoreSSLCertificate;
        private @Nullable String database;
        private @Nullable String collection;
        private Integer numSplits;
        private Boolean bucketAuto;
        private SerializableFunction<MongoCollection<Document>, MongoCursor<Document>> queryFn;

        Builder() {
        }

        private Builder(MongoDbIO.Read source) {
            this.uri = source.uri();
            this.maxConnectionIdleTime = source.maxConnectionIdleTime();
            this.sslEnabled = source.sslEnabled();
            this.sslInvalidHostNameAllowed = source.sslInvalidHostNameAllowed();
            this.ignoreSSLCertificate = source.ignoreSSLCertificate();
            this.database = source.database();
            this.collection = source.collection();
            this.numSplits = source.numSplits();
            this.bucketAuto = source.bucketAuto();
            this.queryFn = source.queryFn();
        }

        @Override
        MongoDbIO.Read.Builder setUri(String uri) {
            this.uri = uri;
            return this;
        }

        @Override
        MongoDbIO.Read.Builder setMaxConnectionIdleTime(int maxConnectionIdleTime) {
            this.maxConnectionIdleTime = maxConnectionIdleTime;
            return this;
        }

        @Override
        MongoDbIO.Read.Builder setSslEnabled(boolean sslEnabled) {
            this.sslEnabled = sslEnabled;
            return this;
        }

        @Override
        MongoDbIO.Read.Builder setSslInvalidHostNameAllowed(boolean sslInvalidHostNameAllowed) {
            this.sslInvalidHostNameAllowed = sslInvalidHostNameAllowed;
            return this;
        }

        @Override
        MongoDbIO.Read.Builder setIgnoreSSLCertificate(boolean ignoreSSLCertificate) {
            this.ignoreSSLCertificate = ignoreSSLCertificate;
            return this;
        }

        @Override
        MongoDbIO.Read.Builder setDatabase(String database) {
            this.database = database;
            return this;
        }

        @Override
        MongoDbIO.Read.Builder setCollection(String collection) {
            this.collection = collection;
            return this;
        }

        @Override
        MongoDbIO.Read.Builder setNumSplits(int numSplits) {
            this.numSplits = numSplits;
            return this;
        }

        @Override
        MongoDbIO.Read.Builder setBucketAuto(boolean bucketAuto) {
            this.bucketAuto = bucketAuto;
            return this;
        }

        @Override
        MongoDbIO.Read.Builder setQueryFn(SerializableFunction<MongoCollection<Document>, MongoCursor<Document>> queryFn) {
            if (queryFn == null) {
                throw new NullPointerException("Null queryFn");
            }
            this.queryFn = queryFn;
            return this;
        }

        @Override
        MongoDbIO.Read build() {
            String missing = "";
            if (this.maxConnectionIdleTime == null) {
                missing = missing + " maxConnectionIdleTime";
            }
            if (this.sslEnabled == null) {
                missing = missing + " sslEnabled";
            }
            if (this.sslInvalidHostNameAllowed == null) {
                missing = missing + " sslInvalidHostNameAllowed";
            }
            if (this.ignoreSSLCertificate == null) {
                missing = missing + " ignoreSSLCertificate";
            }
            if (this.numSplits == null) {
                missing = missing + " numSplits";
            }
            if (this.bucketAuto == null) {
                missing = missing + " bucketAuto";
            }
            if (this.queryFn == null) {
                missing = missing + " queryFn";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_MongoDbIO_Read(this.uri, this.maxConnectionIdleTime, this.sslEnabled, this.sslInvalidHostNameAllowed, this.ignoreSSLCertificate, this.database, this.collection, this.numSplits, this.bucketAuto, this.queryFn);
        }
    }
}

