/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import org.apache.beam.sdk.io.kafka.KafkaMetrics;
import org.apache.beam.sdk.metrics.DelegatingGauge;
import org.apache.beam.sdk.metrics.DelegatingHistogram;
import org.apache.beam.sdk.metrics.Gauge;
import org.apache.beam.sdk.metrics.Histogram;
import org.apache.beam.sdk.metrics.LabeledMetricNameUtils;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.util.HistogramData;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class KafkaSinkMetrics {
    private static @UnknownKeyFor @NonNull @Initialized boolean supportKafkaMetrics = false;
    public static final @UnknownKeyFor @NonNull @Initialized String METRICS_NAMESPACE = "KafkaSink";
    private static final @UnknownKeyFor @NonNull @Initialized String RPC_LATENCY = "RpcLatency";
    private static final @UnknownKeyFor @NonNull @Initialized String ESTIMATED_BACKLOG_SIZE = "EstimatedBacklogSize";
    private static final @UnknownKeyFor @NonNull @Initialized String TOPIC_LABEL = "topic_name";
    private static final @UnknownKeyFor @NonNull @Initialized String RPC_METHOD = "rpc_method";
    private static final @UnknownKeyFor @NonNull @Initialized String PARTITION_ID = "partition_id";

    public static @UnknownKeyFor @NonNull @Initialized Histogram createRPCLatencyHistogram(@UnknownKeyFor @NonNull @Initialized RpcMethod method, @UnknownKeyFor @NonNull @Initialized String topic) {
        LabeledMetricNameUtils.MetricNameBuilder nameBuilder = LabeledMetricNameUtils.MetricNameBuilder.baseNameBuilder((String)RPC_LATENCY);
        nameBuilder.addLabel(RPC_METHOD, method.toString());
        nameBuilder.addLabel(TOPIC_LABEL, topic);
        MetricName metricName = nameBuilder.build(METRICS_NAMESPACE);
        HistogramData.ExponentialBuckets buckets = HistogramData.ExponentialBuckets.of((int)1, (int)17);
        return new DelegatingHistogram(metricName, (HistogramData.BucketType)buckets, false, true);
    }

    public static @UnknownKeyFor @NonNull @Initialized Gauge createBacklogGauge(@UnknownKeyFor @NonNull @Initialized String topic, @UnknownKeyFor @NonNull @Initialized int partitionId) {
        return new DelegatingGauge(KafkaSinkMetrics.getMetricGaugeName(topic, partitionId), false, true);
    }

    public static @UnknownKeyFor @NonNull @Initialized Gauge createBacklogGauge(@UnknownKeyFor @NonNull @Initialized MetricName name) {
        return new DelegatingGauge(name, false, true);
    }

    public static @UnknownKeyFor @NonNull @Initialized MetricName getMetricGaugeName(@UnknownKeyFor @NonNull @Initialized String topic, @UnknownKeyFor @NonNull @Initialized int partitionId) {
        LabeledMetricNameUtils.MetricNameBuilder nameBuilder = LabeledMetricNameUtils.MetricNameBuilder.baseNameBuilder((String)ESTIMATED_BACKLOG_SIZE);
        nameBuilder.addLabel(PARTITION_ID, String.valueOf(partitionId));
        nameBuilder.addLabel(TOPIC_LABEL, topic);
        return nameBuilder.build(METRICS_NAMESPACE);
    }

    static @UnknownKeyFor @NonNull @Initialized KafkaMetrics kafkaMetrics() {
        if (supportKafkaMetrics) {
            return KafkaMetrics.KafkaMetricsImpl.create();
        }
        return KafkaMetrics.NoOpKafkaMetrics.getInstance();
    }

    public static void setSupportKafkaMetrics(@UnknownKeyFor @NonNull @Initialized boolean supportKafkaMetrics) {
        KafkaSinkMetrics.supportKafkaMetrics = supportKafkaMetrics;
    }

    static enum RpcMethod {
        POLL;

    }
}

