/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import com.google.auto.value.AutoValue;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.beam.sdk.io.kafka.AutoValue_KafkaMetrics_KafkaMetricsImpl;
import org.apache.beam.sdk.io.kafka.KafkaSinkMetrics;
import org.apache.beam.sdk.metrics.Histogram;
import org.apache.beam.sdk.util.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface KafkaMetrics {
    public void updateSuccessfulRpcMetrics(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized Duration var2);

    public void updateKafkaMetrics();

    @AutoValue
    public static abstract class KafkaMetricsImpl
    implements KafkaMetrics {
        private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(KafkaMetricsImpl.class);
        static @UnknownKeyFor @NonNull @Initialized HashMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Histogram> latencyHistograms = new HashMap();

        abstract @UnknownKeyFor @NonNull @Initialized HashMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ConcurrentLinkedQueue<@UnknownKeyFor @NonNull @Initialized Duration>> perTopicRpcLatencies();

        abstract @UnknownKeyFor @NonNull @Initialized AtomicBoolean isWritable();

        public static @UnknownKeyFor @NonNull @Initialized KafkaMetricsImpl create() {
            return new AutoValue_KafkaMetrics_KafkaMetricsImpl(new HashMap<String, ConcurrentLinkedQueue<Duration>>(), new AtomicBoolean(true));
        }

        @Override
        public void updateSuccessfulRpcMetrics(@UnknownKeyFor @NonNull @Initialized String topic, @UnknownKeyFor @NonNull @Initialized Duration elapsedTime) {
            if (this.isWritable().get()) {
                ConcurrentLinkedQueue<Duration> latencies = this.perTopicRpcLatencies().get(topic);
                if (latencies == null) {
                    latencies = new ConcurrentLinkedQueue();
                    latencies.add(elapsedTime);
                    this.perTopicRpcLatencies().put(topic, latencies);
                } else {
                    latencies.add(elapsedTime);
                }
            }
        }

        private void recordRpcLatencyMetrics() {
            for (Map.Entry<String, ConcurrentLinkedQueue<Duration>> topicLatencies : this.perTopicRpcLatencies().entrySet()) {
                Histogram topicHistogram;
                if (latencyHistograms.containsKey(topicLatencies.getKey())) {
                    topicHistogram = latencyHistograms.get(topicLatencies.getKey());
                } else {
                    topicHistogram = KafkaSinkMetrics.createRPCLatencyHistogram(KafkaSinkMetrics.RpcMethod.POLL, topicLatencies.getKey());
                    latencyHistograms.put(topicLatencies.getKey(), topicHistogram);
                }
                for (Duration d : topicLatencies.getValue()) {
                    Preconditions.checkArgumentNotNull((Object)topicHistogram);
                    topicHistogram.update((double)d.toMillis());
                }
            }
        }

        @Override
        public void updateKafkaMetrics() {
            if (!this.isWritable().compareAndSet(true, false)) {
                LOG.warn("Updating stale Kafka metrics container");
                return;
            }
            this.recordRpcLatencyMetrics();
        }
    }

    public static class NoOpKafkaMetrics
    implements KafkaMetrics {
        private static @UnknownKeyFor @NonNull @Initialized NoOpKafkaMetrics singleton = new NoOpKafkaMetrics();

        private NoOpKafkaMetrics() {
        }

        @Override
        public void updateSuccessfulRpcMetrics(@UnknownKeyFor @NonNull @Initialized String topic, @UnknownKeyFor @NonNull @Initialized Duration elapsedTime) {
        }

        @Override
        public void updateKafkaMetrics() {
        }

        static @UnknownKeyFor @NonNull @Initialized NoOpKafkaMetrics getInstance() {
            return singleton;
        }
    }
}

