/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.util.Map;
import org.apache.beam.sdk.io.kafka.KafkaIO;
import org.apache.beam.sdk.io.kafka.KafkaPublishTimestampFunction;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.Serializer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;

final class AutoValue_KafkaIO_WriteRecords<K, V>
extends KafkaIO.WriteRecords<K, V> {
    private final @Nullable String topic;
    private final Map<String, Object> producerConfig;
    private final @Nullable SerializableFunction<Map<String, Object>, Producer<K, V>> producerFactoryFn;
    private final @Nullable Class<? extends Serializer<K>> keySerializer;
    private final @Nullable Class<? extends Serializer<V>> valueSerializer;
    private final @Nullable KafkaPublishTimestampFunction<ProducerRecord<K, V>> publishTimestampFunction;
    private final boolean EOS;
    private final @Nullable String sinkGroupId;
    private final int numShards;
    private final @Nullable SerializableFunction<Map<String, Object>, ? extends Consumer<?, ?>> consumerFactoryFn;

    private AutoValue_KafkaIO_WriteRecords(@Nullable String topic, Map<String, Object> producerConfig, @Nullable SerializableFunction<Map<String, Object>, Producer<K, V>> producerFactoryFn, @Nullable Class<? extends Serializer<K>> keySerializer, @Nullable Class<? extends Serializer<V>> valueSerializer, @Nullable KafkaPublishTimestampFunction<ProducerRecord<K, V>> publishTimestampFunction, boolean EOS, @Nullable String sinkGroupId, int numShards, @Nullable SerializableFunction<Map<String, Object>, ? extends Consumer<?, ?>> consumerFactoryFn) {
        this.topic = topic;
        this.producerConfig = producerConfig;
        this.producerFactoryFn = producerFactoryFn;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.publishTimestampFunction = publishTimestampFunction;
        this.EOS = EOS;
        this.sinkGroupId = sinkGroupId;
        this.numShards = numShards;
        this.consumerFactoryFn = consumerFactoryFn;
    }

    @Override
    @Pure
    @Nullable String getTopic() {
        return this.topic;
    }

    @Override
    @Pure
    Map<String, Object> getProducerConfig() {
        return this.producerConfig;
    }

    @Override
    @Pure
    @Nullable SerializableFunction<Map<String, Object>, Producer<K, V>> getProducerFactoryFn() {
        return this.producerFactoryFn;
    }

    @Override
    @Pure
    @Nullable Class<? extends Serializer<K>> getKeySerializer() {
        return this.keySerializer;
    }

    @Override
    @Pure
    @Nullable Class<? extends Serializer<V>> getValueSerializer() {
        return this.valueSerializer;
    }

    @Override
    @Pure
    @Nullable KafkaPublishTimestampFunction<ProducerRecord<K, V>> getPublishTimestampFunction() {
        return this.publishTimestampFunction;
    }

    @Override
    @Pure
    boolean isEOS() {
        return this.EOS;
    }

    @Override
    @Pure
    @Nullable String getSinkGroupId() {
        return this.sinkGroupId;
    }

    @Override
    @Pure
    int getNumShards() {
        return this.numShards;
    }

    @Override
    @Pure
    @Nullable SerializableFunction<Map<String, Object>, ? extends Consumer<?, ?>> getConsumerFactoryFn() {
        return this.consumerFactoryFn;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof KafkaIO.WriteRecords) {
            KafkaIO.WriteRecords that = (KafkaIO.WriteRecords)((Object)o);
            return (this.topic == null ? that.getTopic() == null : this.topic.equals(that.getTopic())) && this.producerConfig.equals(that.getProducerConfig()) && (this.producerFactoryFn == null ? that.getProducerFactoryFn() == null : this.producerFactoryFn.equals(that.getProducerFactoryFn())) && (this.keySerializer == null ? that.getKeySerializer() == null : this.keySerializer.equals(that.getKeySerializer())) && (this.valueSerializer == null ? that.getValueSerializer() == null : this.valueSerializer.equals(that.getValueSerializer())) && (this.publishTimestampFunction == null ? that.getPublishTimestampFunction() == null : this.publishTimestampFunction.equals(that.getPublishTimestampFunction())) && this.EOS == that.isEOS() && (this.sinkGroupId == null ? that.getSinkGroupId() == null : this.sinkGroupId.equals(that.getSinkGroupId())) && this.numShards == that.getNumShards() && (this.consumerFactoryFn == null ? that.getConsumerFactoryFn() == null : this.consumerFactoryFn.equals(that.getConsumerFactoryFn()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.topic == null ? 0 : this.topic.hashCode();
        h$ *= 1000003;
        h$ ^= this.producerConfig.hashCode();
        h$ *= 1000003;
        h$ ^= this.producerFactoryFn == null ? 0 : this.producerFactoryFn.hashCode();
        h$ *= 1000003;
        h$ ^= this.keySerializer == null ? 0 : this.keySerializer.hashCode();
        h$ *= 1000003;
        h$ ^= this.valueSerializer == null ? 0 : this.valueSerializer.hashCode();
        h$ *= 1000003;
        h$ ^= this.publishTimestampFunction == null ? 0 : this.publishTimestampFunction.hashCode();
        h$ *= 1000003;
        h$ ^= this.EOS ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.sinkGroupId == null ? 0 : this.sinkGroupId.hashCode();
        h$ *= 1000003;
        h$ ^= this.numShards;
        h$ *= 1000003;
        return h$ ^= this.consumerFactoryFn == null ? 0 : this.consumerFactoryFn.hashCode();
    }

    @Override
    KafkaIO.WriteRecords.Builder<K, V> toBuilder() {
        return new Builder(this);
    }

    static final class Builder<K, V>
    extends KafkaIO.WriteRecords.Builder<K, V> {
        private @Nullable String topic;
        private Map<String, Object> producerConfig;
        private @Nullable SerializableFunction<Map<String, Object>, Producer<K, V>> producerFactoryFn;
        private @Nullable Class<? extends Serializer<K>> keySerializer;
        private @Nullable Class<? extends Serializer<V>> valueSerializer;
        private @Nullable KafkaPublishTimestampFunction<ProducerRecord<K, V>> publishTimestampFunction;
        private Boolean EOS;
        private @Nullable String sinkGroupId;
        private Integer numShards;
        private @Nullable SerializableFunction<Map<String, Object>, ? extends Consumer<?, ?>> consumerFactoryFn;

        Builder() {
        }

        private Builder(KafkaIO.WriteRecords<K, V> source) {
            this.topic = source.getTopic();
            this.producerConfig = source.getProducerConfig();
            this.producerFactoryFn = source.getProducerFactoryFn();
            this.keySerializer = source.getKeySerializer();
            this.valueSerializer = source.getValueSerializer();
            this.publishTimestampFunction = source.getPublishTimestampFunction();
            this.EOS = source.isEOS();
            this.sinkGroupId = source.getSinkGroupId();
            this.numShards = source.getNumShards();
            this.consumerFactoryFn = source.getConsumerFactoryFn();
        }

        @Override
        KafkaIO.WriteRecords.Builder<K, V> setTopic(String topic) {
            this.topic = topic;
            return this;
        }

        @Override
        KafkaIO.WriteRecords.Builder<K, V> setProducerConfig(Map<String, Object> producerConfig) {
            if (producerConfig == null) {
                throw new NullPointerException("Null producerConfig");
            }
            this.producerConfig = producerConfig;
            return this;
        }

        @Override
        KafkaIO.WriteRecords.Builder<K, V> setProducerFactoryFn(SerializableFunction<Map<String, Object>, Producer<K, V>> producerFactoryFn) {
            this.producerFactoryFn = producerFactoryFn;
            return this;
        }

        @Override
        KafkaIO.WriteRecords.Builder<K, V> setKeySerializer(Class<? extends Serializer<K>> keySerializer) {
            this.keySerializer = keySerializer;
            return this;
        }

        @Override
        KafkaIO.WriteRecords.Builder<K, V> setValueSerializer(Class<? extends Serializer<V>> valueSerializer) {
            this.valueSerializer = valueSerializer;
            return this;
        }

        @Override
        KafkaIO.WriteRecords.Builder<K, V> setPublishTimestampFunction(KafkaPublishTimestampFunction<ProducerRecord<K, V>> publishTimestampFunction) {
            this.publishTimestampFunction = publishTimestampFunction;
            return this;
        }

        @Override
        KafkaIO.WriteRecords.Builder<K, V> setEOS(boolean EOS) {
            this.EOS = EOS;
            return this;
        }

        @Override
        KafkaIO.WriteRecords.Builder<K, V> setSinkGroupId(String sinkGroupId) {
            this.sinkGroupId = sinkGroupId;
            return this;
        }

        @Override
        KafkaIO.WriteRecords.Builder<K, V> setNumShards(int numShards) {
            this.numShards = numShards;
            return this;
        }

        @Override
        KafkaIO.WriteRecords.Builder<K, V> setConsumerFactoryFn(SerializableFunction<Map<String, Object>, ? extends Consumer<?, ?>> consumerFactoryFn) {
            this.consumerFactoryFn = consumerFactoryFn;
            return this;
        }

        @Override
        KafkaIO.WriteRecords<K, V> build() {
            if (this.producerConfig == null || this.EOS == null || this.numShards == null) {
                StringBuilder missing = new StringBuilder();
                if (this.producerConfig == null) {
                    missing.append(" producerConfig");
                }
                if (this.EOS == null) {
                    missing.append(" EOS");
                }
                if (this.numShards == null) {
                    missing.append(" numShards");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_KafkaIO_WriteRecords(this.topic, this.producerConfig, this.producerFactoryFn, this.keySerializer, this.valueSerializer, this.publishTimestampFunction, this.EOS, this.sinkGroupId, this.numShards, this.consumerFactoryFn);
        }
    }
}

