/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.kafka.common.TopicPartition;

public class TopicPartitionCoder
extends StructuredCoder<TopicPartition> {
    public void encode(TopicPartition value, OutputStream outStream) throws CoderException, IOException {
        StringUtf8Coder.of().encode(value.topic(), outStream);
        VarIntCoder.of().encode(Integer.valueOf(value.partition()), outStream);
    }

    public TopicPartition decode(InputStream inStream) throws CoderException, IOException {
        String topic = StringUtf8Coder.of().decode(inStream);
        int partition = VarIntCoder.of().decode(inStream);
        return new TopicPartition(topic, partition);
    }

    public List<? extends Coder<?>> getCoderArguments() {
        return null;
    }

    public void verifyDeterministic() throws Coder.NonDeterministicException {
    }
}

