/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.io.kafka.KafkaRecord;
import org.apache.beam.sdk.values.KV;

public class KafkaRecordCoder<K, V>
extends StructuredCoder<KafkaRecord<K, V>> {
    private static final StringUtf8Coder stringCoder = StringUtf8Coder.of();
    private static final VarLongCoder longCoder = VarLongCoder.of();
    private static final VarIntCoder intCoder = VarIntCoder.of();
    private final KvCoder<K, V> kvCoder;

    public static <K, V> KafkaRecordCoder<K, V> of(Coder<K> keyCoder, Coder<V> valueCoder) {
        return new KafkaRecordCoder<K, V>(keyCoder, valueCoder);
    }

    public KafkaRecordCoder(Coder<K> keyCoder, Coder<V> valueCoder) {
        this.kvCoder = KvCoder.of(keyCoder, valueCoder);
    }

    public void encode(KafkaRecord<K, V> value, OutputStream outStream) throws CoderException, IOException {
        this.encode(value, outStream, Coder.Context.NESTED);
    }

    public void encode(KafkaRecord<K, V> value, OutputStream outStream, Coder.Context context) throws CoderException, IOException {
        Coder.Context nested = context.nested();
        stringCoder.encode(value.getTopic(), outStream, nested);
        intCoder.encode((Object)value.getPartition(), outStream, nested);
        longCoder.encode((Object)value.getOffset(), outStream, nested);
        longCoder.encode((Object)value.getTimestamp(), outStream, nested);
        this.kvCoder.encode(value.getKV(), outStream, context);
    }

    public KafkaRecord<K, V> decode(InputStream inStream) throws CoderException, IOException {
        return this.decode(inStream, Coder.Context.NESTED);
    }

    public KafkaRecord<K, V> decode(InputStream inStream, Coder.Context context) throws CoderException, IOException {
        Coder.Context nested = context.nested();
        return new KafkaRecord(stringCoder.decode(inStream, nested), (Integer)intCoder.decode(inStream, nested), (Long)longCoder.decode(inStream, nested), (Long)longCoder.decode(inStream, nested), this.kvCoder.decode(inStream, context));
    }

    public List<? extends Coder<?>> getCoderArguments() {
        return this.kvCoder.getCoderArguments();
    }

    public void verifyDeterministic() throws Coder.NonDeterministicException {
        this.kvCoder.verifyDeterministic();
    }

    public boolean isRegisterByteSizeObserverCheap(KafkaRecord<K, V> value) {
        return this.kvCoder.isRegisterByteSizeObserverCheap(value.getKV());
    }

    public Object structuralValue(KafkaRecord<K, V> value) {
        if (this.consistentWithEquals()) {
            return value;
        }
        return new KafkaRecord(value.getTopic(), value.getPartition(), value.getOffset(), value.getTimestamp(), (KV)this.kvCoder.structuralValue(value.getKV()));
    }

    public boolean consistentWithEquals() {
        return this.kvCoder.consistentWithEquals();
    }
}

