/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.jdbc;

import com.google.auto.service.AutoService;
import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.jdbc.AutoValue_JdbcWriteSchemaTransformProvider_JdbcWriteSchemaTransformConfiguration;
import org.apache.beam.sdk.io.jdbc.JdbcIO;
import org.apache.beam.sdk.io.jdbc.JdbcUtil;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoService(value={SchemaTransformProvider.class})
public class JdbcWriteSchemaTransformProvider
extends TypedSchemaTransformProvider<JdbcWriteSchemaTransformConfiguration> {
    protected @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized JdbcWriteSchemaTransformConfiguration> configurationClass() {
        return JdbcWriteSchemaTransformConfiguration.class;
    }

    protected @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized JdbcWriteSchemaTransformConfiguration configuration) {
        configuration.validate();
        return new JdbcWriteSchemaTransform(configuration);
    }

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "beam:schematransform:org.apache.beam:jdbc_write:v1";
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputCollectionNames() {
        return Collections.singletonList("input");
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> outputCollectionNames() {
        return Collections.emptyList();
    }

    @DefaultSchema(value=AutoValueSchema.class)
    @AutoValue
    public static abstract class JdbcWriteSchemaTransformConfiguration
    implements Serializable {
        public abstract @UnknownKeyFor @NonNull @Initialized String getDriverClassName();

        public abstract @UnknownKeyFor @NonNull @Initialized String getJdbcUrl();

        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getUsername();

        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getPassword();

        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getConnectionProperties();

        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized List<@org.checkerframework.checker.nullness.qual.Nullable @UnknownKeyFor @Initialized String> getConnectionInitSql();

        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getLocation();

        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getWriteStatement();

        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Boolean getAutosharding();

        public void validate() throws @UnknownKeyFor @NonNull @Initialized IllegalArgumentException {
            boolean locationPresent;
            if (Strings.isNullOrEmpty((String)this.getDriverClassName())) {
                throw new IllegalArgumentException("JDBC Driver class name cannot be blank.");
            }
            if (Strings.isNullOrEmpty((String)this.getJdbcUrl())) {
                throw new IllegalArgumentException("JDBC URL cannot be blank");
            }
            boolean writeStatementPresent = this.getWriteStatement() != null && !"".equals(this.getWriteStatement());
            boolean bl = locationPresent = this.getLocation() != null && !"".equals(this.getLocation());
            if (writeStatementPresent && locationPresent) {
                throw new IllegalArgumentException("ReadQuery and Location are mutually exclusive configurations");
            }
            if (!writeStatementPresent && !locationPresent) {
                throw new IllegalArgumentException("Either ReadQuery or Location must be set.");
            }
        }

        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_JdbcWriteSchemaTransformProvider_JdbcWriteSchemaTransformConfiguration.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setDriverClassName(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setJdbcUrl(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setUsername(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setPassword(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setConnectionProperties(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setConnectionInitSql(@UnknownKeyFor @NonNull @Initialized List<@org.checkerframework.checker.nullness.qual.Nullable @UnknownKeyFor @Initialized String> var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setLocation(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setWriteStatement(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setAutosharding(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            public abstract @UnknownKeyFor @NonNull @Initialized JdbcWriteSchemaTransformConfiguration build();
        }
    }

    static class JdbcWriteSchemaTransform
    implements SchemaTransform,
    Serializable {
        @UnknownKeyFor @NonNull @Initialized JdbcWriteSchemaTransformConfiguration config;

        public JdbcWriteSchemaTransform(@UnknownKeyFor @NonNull @Initialized JdbcWriteSchemaTransformConfiguration config) {
            this.config = config;
        }

        protected @UnknownKeyFor @NonNull @Initialized JdbcIO.DataSourceConfiguration dataSourceConfiguration() {
            List<String> initialSql;
            JdbcIO.DataSourceConfiguration dsConfig = JdbcIO.DataSourceConfiguration.create(this.config.getDriverClassName(), this.config.getJdbcUrl()).withUsername("".equals(this.config.getUsername()) ? null : this.config.getUsername()).withPassword("".equals(this.config.getPassword()) ? null : this.config.getPassword());
            String connectionProperties = this.config.getConnectionProperties();
            if (connectionProperties != null) {
                dsConfig = dsConfig.withConnectionProperties(connectionProperties);
            }
            if ((initialSql = this.config.getConnectionInitSql()) != null && initialSql.size() > 0) {
                dsConfig = dsConfig.withConnectionInitSqls(initialSql);
            }
            return dsConfig;
        }

        protected @UnknownKeyFor @NonNull @Initialized String writeStatement(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            String writeStatement = this.config.getWriteStatement();
            if (writeStatement != null) {
                return writeStatement;
            }
            StringBuilder statement = new StringBuilder("INSERT INTO ");
            statement.append(this.config.getLocation());
            statement.append(" VALUES(");
            for (int i = 0; i < schema.getFieldCount() - 1; ++i) {
                statement.append("?, ");
            }
            statement.append("?)");
            return statement.toString();
        }

        public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple, @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple> buildTransform() {
            return new PTransform<PCollectionRowTuple, PCollectionRowTuple>(){

                public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
                    JdbcIO.Write<Row> writeRows = JdbcIO.write().withDataSourceConfiguration(this.dataSourceConfiguration()).withStatement(this.writeStatement(input.get("input").getSchema())).withPreparedStatementSetter(new JdbcUtil.BeamRowPreparedStatementSetter());
                    Boolean autosharding = config.getAutosharding();
                    if (autosharding != null && autosharding.booleanValue()) {
                        writeRows = writeRows.withAutoSharding();
                    }
                    input.get("input").apply(writeRows);
                    return PCollectionRowTuple.empty((Pipeline)input.getPipeline());
                }
            };
        }
    }
}

