/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.jdbc;

import com.google.auto.value.AutoValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.sql.DataSource;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.RowCoder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.io.jdbc.AutoValue_JdbcIO_DataSourceConfiguration;
import org.apache.beam.sdk.io.jdbc.AutoValue_JdbcIO_Read;
import org.apache.beam.sdk.io.jdbc.AutoValue_JdbcIO_ReadAll;
import org.apache.beam.sdk.io.jdbc.AutoValue_JdbcIO_ReadRows;
import org.apache.beam.sdk.io.jdbc.AutoValue_JdbcIO_ReadWithPartitions;
import org.apache.beam.sdk.io.jdbc.AutoValue_JdbcIO_RetryConfiguration;
import org.apache.beam.sdk.io.jdbc.AutoValue_JdbcIO_WriteFn_WriteFnSpec;
import org.apache.beam.sdk.io.jdbc.AutoValue_JdbcIO_WriteVoid;
import org.apache.beam.sdk.io.jdbc.AutoValue_JdbcIO_WriteWithResults;
import org.apache.beam.sdk.io.jdbc.JdbcUtil;
import org.apache.beam.sdk.io.jdbc.JdbcWriteResult;
import org.apache.beam.sdk.io.jdbc.SchemaUtil;
import org.apache.beam.sdk.metrics.Distribution;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.schemas.NoSuchSchemaException;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaRegistry;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Filter;
import org.apache.beam.sdk.transforms.GroupIntoBatches;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SerializableFunctions;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.WithKeys;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.BackOffUtils;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DataSourceConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcIO {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcIO.class);
    private static final long DEFAULT_BATCH_SIZE = 1000L;
    private static final int DEFAULT_FETCH_SIZE = 50000;
    private static final Duration DEFAULT_INITIAL_BACKOFF = Duration.standardSeconds((long)1L);
    private static final Duration DEFAULT_MAX_CUMULATIVE_BACKOFF = Duration.standardDays((long)1000L);
    private static final int DEFAULT_NUM_PARTITIONS = 200;

    public static <T> Read<T> read() {
        return new AutoValue_JdbcIO_Read.Builder().setFetchSize(50000).setOutputParallelization(true).build();
    }

    public static ReadRows readRows() {
        return new AutoValue_JdbcIO_ReadRows.Builder().setFetchSize(50000).setOutputParallelization(true).setStatementPreparator(ignored -> {}).build();
    }

    public static <ParameterT, OutputT> ReadAll<ParameterT, OutputT> readAll() {
        return new AutoValue_JdbcIO_ReadAll.Builder().setFetchSize(50000).setOutputParallelization(true).build();
    }

    public static <T, PartitionColumnT> ReadWithPartitions<T, PartitionColumnT> readWithPartitions(TypeDescriptor<PartitionColumnT> partitioningColumnType) {
        return new AutoValue_JdbcIO_ReadWithPartitions.Builder().setPartitionColumnType(partitioningColumnType).setNumPartitions(200).setUseBeamSchema(false).build();
    }

    public static <T> ReadWithPartitions<T, Long> readWithPartitions() {
        return JdbcIO.readWithPartitions(TypeDescriptors.longs());
    }

    public static <T> Write<T> write() {
        return new Write();
    }

    public static <T> WriteVoid<T> writeVoid() {
        return new AutoValue_JdbcIO_WriteVoid.Builder().setBatchSize(1000L).setRetryStrategy(new DefaultRetryStrategy()).setRetryConfiguration(RetryConfiguration.create(5, null, Duration.standardSeconds((long)5L))).build();
    }

    private JdbcIO() {
    }

    static <T> PCollection<Iterable<T>> batchElements(PCollection<T> input, Boolean withAutoSharding, final long batchSize) {
        PCollection iterables = input.isBounded() == PCollection.IsBounded.UNBOUNDED && withAutoSharding != null && withAutoSharding != false ? (PCollection)((PCollection)((PCollection)input.apply((PTransform)WithKeys.of((Object)""))).apply((PTransform)GroupIntoBatches.ofSize((long)batchSize).withMaxBufferingDuration(Duration.millis((long)200L)).withShardedKey())).apply((PTransform)Values.create()) : (PCollection)input.apply((PTransform)ParDo.of((DoFn)new DoFn<T, Iterable<T>>(){
            List<T> outputList;

            @DoFn.ProcessElement
            public void process(DoFn.ProcessContext c) {
                if (this.outputList == null) {
                    this.outputList = new ArrayList();
                }
                this.outputList.add(c.element());
                if ((long)this.outputList.size() > batchSize) {
                    c.output(this.outputList);
                    this.outputList = null;
                }
            }

            @DoFn.FinishBundle
            public void finish(DoFn.FinishBundleContext c) {
                if (this.outputList != null && this.outputList.size() > 0) {
                    c.output(this.outputList, Instant.now(), (BoundedWindow)GlobalWindow.INSTANCE);
                }
                this.outputList = null;
            }
        }));
        return iterables;
    }

    static class WriteFn<T, V>
    extends DoFn<Iterable<T>, V> {
        private static final Distribution RECORDS_PER_BATCH = Metrics.distribution(WriteFn.class, (String)"records_per_jdbc_batch");
        private static final Distribution MS_PER_BATCH = Metrics.distribution(WriteFn.class, (String)"milliseconds_per_batch");
        private final WriteFnSpec<T, V> spec;
        private DataSource dataSource;
        private Connection connection;
        private PreparedStatement preparedStatement;
        private static FluentBackoff retryBackOff;

        public WriteFn(WriteFnSpec<T, V> spec) {
            this.spec = spec;
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            this.spec.populateDisplayData(builder);
            builder.add(DisplayData.item((String)"query", (String)(this.preparedStatement == null ? "null" : this.preparedStatement.toString())));
            builder.add(DisplayData.item((String)"dataSource", (String)(this.dataSource == null ? "null" : this.dataSource.toString())));
            builder.add(DisplayData.item((String)"spec", (String)(this.spec == null ? "null" : this.spec.toString())));
        }

        @DoFn.Setup
        public void setup() {
            this.dataSource = (DataSource)this.spec.getDataSourceProviderFn().apply(null);
            RetryConfiguration retryConfiguration = this.spec.getRetryConfiguration();
            retryBackOff = FluentBackoff.DEFAULT.withInitialBackoff(retryConfiguration.getInitialDuration()).withMaxCumulativeBackoff(retryConfiguration.getMaxDuration()).withMaxRetries(retryConfiguration.getMaxAttempts());
        }

        private Connection getConnection() throws SQLException {
            if (this.connection == null) {
                this.connection = this.dataSource.getConnection();
                this.connection.setAutoCommit(false);
                this.preparedStatement = this.connection.prepareStatement((String)this.spec.getStatement().get());
            }
            return this.connection;
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext context) throws Exception {
            this.executeBatch(context, (Iterable)context.element());
        }

        @DoFn.FinishBundle
        public void finishBundle() throws Exception {
            this.cleanUpStatementAndConnection();
        }

        protected void finalize() throws Throwable {
            this.cleanUpStatementAndConnection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanUpStatementAndConnection() throws Exception {
            block12: {
                try {
                    if (this.preparedStatement == null) break block12;
                    try {
                        this.preparedStatement.close();
                    }
                    finally {
                        this.preparedStatement = null;
                    }
                }
                finally {
                    if (this.connection != null) {
                        try {
                            this.connection.close();
                        }
                        finally {
                            this.connection = null;
                        }
                    }
                }
            }
        }

        private void executeBatch(DoFn.ProcessContext context, Iterable<T> records) throws SQLException, IOException, InterruptedException {
            Long startTimeNs = System.nanoTime();
            Sleeper sleeper = Sleeper.DEFAULT;
            BackOff backoff = retryBackOff.backoff();
            while (true) {
                PreparedStatement preparedStatement = this.getConnection().prepareStatement((String)this.spec.getStatement().get());
                Throwable throwable = null;
                try {
                    int recordsInBatch = 0;
                    for (T record : records) {
                        this.processRecord(record, preparedStatement, context);
                        ++recordsInBatch;
                    }
                    if (!this.spec.getReturnResults().booleanValue()) {
                        preparedStatement.executeBatch();
                        this.getConnection().commit();
                    }
                    RECORDS_PER_BATCH.update((long)recordsInBatch);
                    MS_PER_BATCH.update(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeNs));
                }
                catch (SQLException exception) {
                    LOG.trace("SQL exception thrown while writing to JDBC database: {}", (Object)exception.getMessage());
                    if (!this.spec.getRetryStrategy().apply(exception)) {
                        throw exception;
                    }
                    LOG.warn("Deadlock detected, retrying", (Throwable)exception);
                    preparedStatement.clearBatch();
                    this.connection.rollback();
                    if (BackOffUtils.next((Sleeper)sleeper, (BackOff)backoff)) continue;
                    throw exception;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (preparedStatement == null) continue;
                    if (throwable != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    preparedStatement.close();
                    continue;
                }
                break;
            }
        }

        private void processRecord(T record, PreparedStatement preparedStatement, DoFn.ProcessContext c) {
            try {
                preparedStatement.clearParameters();
                this.spec.getPreparedStatementSetter().setParameters(record, preparedStatement);
                if (this.spec.getReturnResults().booleanValue()) {
                    preparedStatement.execute();
                    this.getConnection().commit();
                    c.output(this.spec.getRowMapper().mapRow(preparedStatement.getResultSet()));
                } else {
                    preparedStatement.addBatch();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @AutoValue
        static abstract class WriteFnSpec<T, V>
        implements Serializable,
        HasDisplayData {
            WriteFnSpec() {
            }

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.addIfNotNull(DisplayData.item((String)"dataSourceProviderFn", (String)(this.getDataSourceProviderFn() == null ? "null" : this.getDataSourceProviderFn().getClass().getName()))).addIfNotNull(DisplayData.item((String)"statement", this.getStatement())).addIfNotNull(DisplayData.item((String)"preparedStatementSetter", (String)(this.getPreparedStatementSetter() == null ? "null" : this.getPreparedStatementSetter().getClass().getName()))).addIfNotNull(DisplayData.item((String)"retryConfiguration", (String)(this.getRetryConfiguration() == null ? "null" : this.getRetryConfiguration().getClass().getName()))).addIfNotNull(DisplayData.item((String)"table", (String)this.getTable())).addIfNotNull(DisplayData.item((String)"rowMapper", (String)(this.getRowMapper() == null ? "null" : this.getRowMapper().getClass().toString()))).addIfNotNull(DisplayData.item((String)"batchSize", (Long)this.getBatchSize()));
            }

            abstract SerializableFunction<Void, DataSource> getDataSourceProviderFn();

            abstract ValueProvider<String> getStatement();

            abstract PreparedStatementSetter<T> getPreparedStatementSetter();

            abstract RetryStrategy getRetryStrategy();

            abstract @Nullable RetryConfiguration getRetryConfiguration();

            abstract @Nullable String getTable();

            abstract @Nullable RowMapper<V> getRowMapper();

            abstract @Nullable Long getBatchSize();

            abstract Boolean getReturnResults();

            static Builder builder() {
                return new AutoValue_JdbcIO_WriteFn_WriteFnSpec.Builder();
            }

            @AutoValue.Builder
            static abstract class Builder<T, V> {
                Builder() {
                }

                abstract Builder<T, V> setDataSourceProviderFn(SerializableFunction<Void, DataSource> var1);

                abstract Builder<T, V> setStatement(ValueProvider<String> var1);

                abstract Builder<T, V> setPreparedStatementSetter(PreparedStatementSetter<T> var1);

                abstract Builder<T, V> setRetryStrategy(RetryStrategy var1);

                abstract Builder<T, V> setRetryConfiguration(RetryConfiguration var1);

                abstract Builder<T, V> setTable(String var1);

                abstract Builder<T, V> setRowMapper(RowMapper<V> var1);

                abstract Builder<T, V> setBatchSize(long var1);

                abstract Builder<T, V> setReturnResults(Boolean var1);

                abstract WriteFnSpec<T, V> build();
            }
        }
    }

    public static class DataSourceProviderFromDataSourceConfiguration
    implements SerializableFunction<Void, DataSource>,
    HasDisplayData {
        private static final ConcurrentHashMap<DataSourceConfiguration, DataSource> instances = new ConcurrentHashMap();
        private final DataSourceConfiguration config;

        private DataSourceProviderFromDataSourceConfiguration(DataSourceConfiguration config) {
            this.config = config;
        }

        public static SerializableFunction<Void, DataSource> of(DataSourceConfiguration config) {
            return new DataSourceProviderFromDataSourceConfiguration(config);
        }

        public DataSource apply(Void input) {
            return instances.computeIfAbsent(this.config, DataSourceConfiguration::buildDatasource);
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            this.config.populateDisplayData(builder);
        }
    }

    public static class PoolableDataSourceProvider
    implements SerializableFunction<Void, DataSource>,
    HasDisplayData {
        private static final ConcurrentHashMap<DataSourceConfiguration, DataSource> instances = new ConcurrentHashMap();
        private final DataSourceProviderFromDataSourceConfiguration config;

        private PoolableDataSourceProvider(DataSourceConfiguration config) {
            this.config = new DataSourceProviderFromDataSourceConfiguration(config);
        }

        public static SerializableFunction<Void, DataSource> of(DataSourceConfiguration config) {
            return new PoolableDataSourceProvider(config);
        }

        public DataSource apply(Void input) {
            return instances.computeIfAbsent(this.config.config, ignored -> {
                DataSource basicSource = this.config.apply(input);
                DataSourceConnectionFactory connectionFactory = new DataSourceConnectionFactory(basicSource);
                PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, null);
                GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
                poolConfig.setMinIdle(0);
                poolConfig.setMinEvictableIdleTimeMillis(10000L);
                poolConfig.setSoftMinEvictableIdleTimeMillis(30000L);
                GenericObjectPool connectionPool = new GenericObjectPool((PooledObjectFactory)poolableConnectionFactory, poolConfig);
                poolableConnectionFactory.setPool((ObjectPool)connectionPool);
                poolableConnectionFactory.setDefaultAutoCommit(Boolean.valueOf(false));
                poolableConnectionFactory.setDefaultReadOnly(Boolean.valueOf(false));
                return new PoolingDataSource((ObjectPool)connectionPool);
            });
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            this.config.populateDisplayData(builder);
        }
    }

    private static class Reparallelize<T>
    extends PTransform<PCollection<T>, PCollection<T>> {
        private Reparallelize() {
        }

        public PCollection<T> expand(PCollection<T> input) {
            PCollectionView empty = (PCollectionView)((PCollection)input.apply("Consume", (PTransform)Filter.by((SerializableFunction)SerializableFunctions.constant((Object)false)))).apply((PTransform)View.asIterable());
            PCollection materialized = (PCollection)input.apply("Identity", (PTransform)ParDo.of((DoFn)new DoFn<T, T>(){

                @DoFn.ProcessElement
                public void process(DoFn.ProcessContext c) {
                    c.output(c.element());
                }
            }).withSideInputs(new PCollectionView[]{empty}));
            return (PCollection)materialized.apply((PTransform)Reshuffle.viaRandomKey());
        }
    }

    @AutoValue
    public static abstract class WriteVoid<T>
    extends PTransform<PCollection<T>, PCollection<Void>> {
        abstract @Nullable Boolean getAutoSharding();

        abstract @Nullable SerializableFunction<Void, DataSource> getDataSourceProviderFn();

        abstract @Nullable ValueProvider<String> getStatement();

        abstract long getBatchSize();

        abstract @Nullable PreparedStatementSetter<T> getPreparedStatementSetter();

        abstract @Nullable RetryStrategy getRetryStrategy();

        abstract @Nullable RetryConfiguration getRetryConfiguration();

        abstract @Nullable String getTable();

        abstract Builder<T> toBuilder();

        public WriteVoid<T> withAutoSharding() {
            return this.toBuilder().setAutoSharding(true).build();
        }

        public WriteVoid<T> withDataSourceConfiguration(DataSourceConfiguration config) {
            return this.withDataSourceProviderFn(new DataSourceProviderFromDataSourceConfiguration(config));
        }

        public WriteVoid<T> withDataSourceProviderFn(SerializableFunction<Void, DataSource> dataSourceProviderFn) {
            return this.toBuilder().setDataSourceProviderFn(dataSourceProviderFn).build();
        }

        public WriteVoid<T> withStatement(String statement) {
            return this.withStatement((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)statement));
        }

        public WriteVoid<T> withStatement(ValueProvider<String> statement) {
            return this.toBuilder().setStatement(statement).build();
        }

        public WriteVoid<T> withPreparedStatementSetter(PreparedStatementSetter<T> setter) {
            return this.toBuilder().setPreparedStatementSetter(setter).build();
        }

        public WriteVoid<T> withBatchSize(long batchSize) {
            Preconditions.checkArgument((batchSize > 0L ? 1 : 0) != 0, (String)"batchSize must be > 0, but was %s", (long)batchSize);
            return this.toBuilder().setBatchSize(batchSize).build();
        }

        public WriteVoid<T> withRetryStrategy(RetryStrategy retryStrategy) {
            Preconditions.checkArgument((retryStrategy != null ? 1 : 0) != 0, (Object)"retryStrategy can not be null");
            return this.toBuilder().setRetryStrategy(retryStrategy).build();
        }

        public WriteVoid<T> withRetryConfiguration(RetryConfiguration retryConfiguration) {
            Preconditions.checkArgument((retryConfiguration != null ? 1 : 0) != 0, (Object)"retryConfiguration can not be null");
            return this.toBuilder().setRetryConfiguration(retryConfiguration).build();
        }

        public WriteVoid<T> withTable(String table) {
            Preconditions.checkArgument((table != null ? 1 : 0) != 0, (Object)"table name can not be null");
            return this.toBuilder().setTable(table).build();
        }

        public PCollection<Void> expand(PCollection<T> input) {
            WriteVoid<T> spec = this;
            Preconditions.checkArgument((spec.getDataSourceProviderFn() != null ? 1 : 0) != 0, (Object)"withDataSourceConfiguration() or withDataSourceProviderFn() is required");
            if (input.hasSchema() && !spec.hasStatementAndSetter()) {
                Preconditions.checkArgument((spec.getTable() != null ? 1 : 0) != 0, (Object)"table cannot be null if statement is not provided");
                List<SchemaUtil.FieldWithIndex> fields = spec.getFilteredFields(input.getSchema());
                spec = spec.toBuilder().setStatement((ValueProvider<String>)spec.generateStatement(fields)).setPreparedStatementSetter(new AutoGeneratedPreparedStatementSetter(fields, input.getToRowFunction())).build();
            } else {
                Preconditions.checkArgument((spec.getStatement() != null ? 1 : 0) != 0, (Object)"withStatement() is required");
                Preconditions.checkArgument((spec.getPreparedStatementSetter() != null ? 1 : 0) != 0, (Object)"withPreparedStatementSetter() is required");
            }
            PCollection<Iterable<T>> iterables = JdbcIO.batchElements(input, this.getAutoSharding(), this.getBatchSize());
            return ((PCollection)iterables.apply((PTransform)ParDo.of(new WriteFn(WriteFn.WriteFnSpec.builder().setRetryConfiguration(spec.getRetryConfiguration()).setRetryStrategy(spec.getRetryStrategy()).setPreparedStatementSetter(spec.getPreparedStatementSetter()).setDataSourceProviderFn(spec.getDataSourceProviderFn()).setTable(spec.getTable()).setStatement(spec.getStatement()).setBatchSize(spec.getBatchSize()).setReturnResults(false).build())))).setCoder((Coder)VoidCoder.of());
        }

        private ValueProvider.StaticValueProvider<String> generateStatement(List<SchemaUtil.FieldWithIndex> fields) {
            return ValueProvider.StaticValueProvider.of((Object)JdbcUtil.generateStatement(this.getTable(), fields.stream().map(SchemaUtil.FieldWithIndex::getField).collect(Collectors.toList())));
        }

        private List<SchemaUtil.FieldWithIndex> getFilteredFields(Schema schema) {
            Schema tableSchema;
            try (Connection connection = ((DataSource)this.getDataSourceProviderFn().apply(null)).getConnection();
                 PreparedStatement statement = connection.prepareStatement(String.format("SELECT * FROM %s", this.getTable()));){
                tableSchema = SchemaUtil.toBeamSchema(statement.getMetaData());
                statement.close();
            }
            catch (SQLException e) {
                throw new RuntimeException("Error while determining columns from table: " + this.getTable(), e);
            }
            Preconditions.checkState((tableSchema.getFieldCount() >= schema.getFieldCount() ? 1 : 0) != 0, (Object)"Input schema has more fields than actual table.");
            List<Schema.Field> missingFields = tableSchema.getFields().stream().filter(line -> schema.getFields().stream().noneMatch(s -> s.getName().equalsIgnoreCase(line.getName()))).collect(Collectors.toList());
            Preconditions.checkState((!SchemaUtil.checkNullabilityForFields(missingFields) ? 1 : 0) != 0, (String)"Non nullable fields are not allowed without a matching schema. Fields %s were in the destination table but not in the input schema.", missingFields);
            List<SchemaUtil.FieldWithIndex> tableFilteredFields = tableSchema.getFields().stream().map(tableField -> {
                Optional<Schema.Field> optionalSchemaField = schema.getFields().stream().filter(f -> SchemaUtil.compareSchemaField(tableField, f)).findFirst();
                return optionalSchemaField.map(field -> SchemaUtil.FieldWithIndex.of(tableField, schema.getFields().indexOf(field))).orElse(null);
            }).filter(Objects::nonNull).collect(Collectors.toList());
            Preconditions.checkState((tableFilteredFields.size() == schema.getFieldCount() ? 1 : 0) != 0, (String)"Provided schema doesn't match with database schema.  Table has fields: ", (Object)tableFilteredFields.stream().map(f -> f.getIndex().toString() + "-" + f.getField().getName()).collect(Collectors.joining(",")), (Object)" while provided schema has fields:", (Object)schema.getFieldNames().toString());
            return tableFilteredFields;
        }

        private boolean hasStatementAndSetter() {
            return this.getStatement() != null && this.getPreparedStatementSetter() != null;
        }

        private class AutoGeneratedPreparedStatementSetter
        implements PreparedStatementSetter<T> {
            private final List<SchemaUtil.FieldWithIndex> fields;
            private final SerializableFunction<T, Row> toRowFn;
            private final List<PreparedStatementSetCaller> preparedStatementFieldSetterList = new ArrayList<PreparedStatementSetCaller>();

            AutoGeneratedPreparedStatementSetter(List<SchemaUtil.FieldWithIndex> fieldsWithIndex, SerializableFunction<T, Row> toRowFn) {
                this.fields = fieldsWithIndex;
                this.toRowFn = toRowFn;
                this.populatePreparedStatementFieldSetter();
            }

            private void populatePreparedStatementFieldSetter() {
                IntStream.range(0, this.fields.size()).forEach(index -> {
                    Schema.FieldType fieldType = this.fields.get(index).getField().getType();
                    this.preparedStatementFieldSetterList.add(JdbcUtil.getPreparedStatementSetCaller(fieldType));
                });
            }

            @Override
            public void setParameters(T element, PreparedStatement preparedStatement) throws Exception {
                Row row = element instanceof Row ? (Row)element : (Row)this.toRowFn.apply(element);
                IntStream.range(0, this.fields.size()).forEach(index -> {
                    try {
                        this.preparedStatementFieldSetterList.get(index).set(row, preparedStatement, index, this.fields.get(index));
                    }
                    catch (NullPointerException | SQLException e) {
                        throw new RuntimeException("Error while setting data to preparedStatement", e);
                    }
                });
            }
        }

        @AutoValue.Builder
        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setAutoSharding(Boolean var1);

            abstract Builder<T> setDataSourceProviderFn(SerializableFunction<Void, DataSource> var1);

            abstract Builder<T> setStatement(ValueProvider<String> var1);

            abstract Builder<T> setBatchSize(long var1);

            abstract Builder<T> setPreparedStatementSetter(PreparedStatementSetter<T> var1);

            abstract Builder<T> setRetryStrategy(RetryStrategy var1);

            abstract Builder<T> setRetryConfiguration(RetryConfiguration var1);

            abstract Builder<T> setTable(String var1);

            abstract WriteVoid<T> build();
        }
    }

    @AutoValue
    public static abstract class WriteWithResults<T, V extends JdbcWriteResult>
    extends PTransform<PCollection<T>, PCollection<V>> {
        abstract @Nullable Boolean getAutoSharding();

        abstract @Nullable SerializableFunction<Void, DataSource> getDataSourceProviderFn();

        abstract @Nullable ValueProvider<String> getStatement();

        abstract @Nullable PreparedStatementSetter<T> getPreparedStatementSetter();

        abstract @Nullable RetryStrategy getRetryStrategy();

        abstract @Nullable RetryConfiguration getRetryConfiguration();

        abstract @Nullable String getTable();

        abstract @Nullable RowMapper<V> getRowMapper();

        abstract Builder<T, V> toBuilder();

        public WriteWithResults<T, V> withDataSourceConfiguration(DataSourceConfiguration config) {
            return this.withDataSourceProviderFn(new DataSourceProviderFromDataSourceConfiguration(config));
        }

        public WriteWithResults<T, V> withDataSourceProviderFn(SerializableFunction<Void, DataSource> dataSourceProviderFn) {
            return this.toBuilder().setDataSourceProviderFn(dataSourceProviderFn).build();
        }

        public WriteWithResults<T, V> withStatement(String statement) {
            return this.withStatement((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)statement));
        }

        public WriteWithResults<T, V> withStatement(ValueProvider<String> statement) {
            return this.toBuilder().setStatement(statement).build();
        }

        public WriteWithResults<T, V> withPreparedStatementSetter(PreparedStatementSetter<T> setter) {
            return this.toBuilder().setPreparedStatementSetter(setter).build();
        }

        public WriteWithResults<T, V> withAutoSharding() {
            return this.toBuilder().setAutoSharding(true).build();
        }

        public WriteWithResults<T, V> withRetryStrategy(RetryStrategy retryStrategy) {
            Preconditions.checkArgument((retryStrategy != null ? 1 : 0) != 0, (Object)"retryStrategy can not be null");
            return this.toBuilder().setRetryStrategy(retryStrategy).build();
        }

        public WriteWithResults<T, V> withRetryConfiguration(RetryConfiguration retryConfiguration) {
            Preconditions.checkArgument((retryConfiguration != null ? 1 : 0) != 0, (Object)"retryConfiguration can not be null");
            return this.toBuilder().setRetryConfiguration(retryConfiguration).build();
        }

        public WriteWithResults<T, V> withTable(String table) {
            Preconditions.checkArgument((table != null ? 1 : 0) != 0, (Object)"table name can not be null");
            return this.toBuilder().setTable(table).build();
        }

        public WriteWithResults<T, V> withRowMapper(RowMapper<V> rowMapper) {
            Preconditions.checkArgument((rowMapper != null ? 1 : 0) != 0, (Object)"result set getter can not be null");
            return this.toBuilder().setRowMapper(rowMapper).build();
        }

        public PCollection<V> expand(PCollection<T> input) {
            Preconditions.checkArgument((this.getStatement() != null ? 1 : 0) != 0, (Object)"withStatement() is required");
            Preconditions.checkArgument((this.getPreparedStatementSetter() != null ? 1 : 0) != 0, (Object)"withPreparedStatementSetter() is required");
            Preconditions.checkArgument((this.getDataSourceProviderFn() != null ? 1 : 0) != 0, (Object)"withDataSourceConfiguration() or withDataSourceProviderFn() is required");
            Preconditions.checkArgument((this.getAutoSharding() == null || this.getAutoSharding() != false && input.isBounded() != PCollection.IsBounded.UNBOUNDED ? 1 : 0) != 0, (Object)"Autosharding is only supported for streaming pipelines.");
            PCollection<Iterable<T>> iterables = JdbcIO.batchElements(input, this.getAutoSharding(), 1000L);
            return (PCollection)iterables.apply((PTransform)ParDo.of(new WriteFn(WriteFn.WriteFnSpec.builder().setRetryStrategy(this.getRetryStrategy()).setDataSourceProviderFn(this.getDataSourceProviderFn()).setPreparedStatementSetter(this.getPreparedStatementSetter()).setRowMapper(this.getRowMapper()).setStatement(this.getStatement()).setRetryConfiguration(this.getRetryConfiguration()).setReturnResults(true).setBatchSize(1L).build())));
        }

        @AutoValue.Builder
        static abstract class Builder<T, V extends JdbcWriteResult> {
            Builder() {
            }

            abstract Builder<T, V> setDataSourceProviderFn(SerializableFunction<Void, DataSource> var1);

            abstract Builder<T, V> setAutoSharding(Boolean var1);

            abstract Builder<T, V> setStatement(ValueProvider<String> var1);

            abstract Builder<T, V> setPreparedStatementSetter(PreparedStatementSetter<T> var1);

            abstract Builder<T, V> setRetryStrategy(RetryStrategy var1);

            abstract Builder<T, V> setRetryConfiguration(RetryConfiguration var1);

            abstract Builder<T, V> setTable(String var1);

            abstract Builder<T, V> setRowMapper(RowMapper<V> var1);

            abstract WriteWithResults<T, V> build();
        }
    }

    @FunctionalInterface
    static interface PreparedStatementSetCaller
    extends Serializable {
        public void set(Row var1, PreparedStatement var2, int var3, SchemaUtil.FieldWithIndex var4) throws SQLException;
    }

    public static class Write<T>
    extends PTransform<PCollection<T>, PDone> {
        WriteVoid<T> inner;

        Write() {
            this(JdbcIO.writeVoid());
        }

        Write(WriteVoid<T> inner) {
            this.inner = inner;
        }

        public Write<T> withAutoSharding() {
            return new Write<T>(this.inner.withAutoSharding());
        }

        public Write<T> withDataSourceConfiguration(DataSourceConfiguration config) {
            return new Write<T>(this.inner.withDataSourceConfiguration(config));
        }

        public Write<T> withDataSourceProviderFn(SerializableFunction<Void, DataSource> dataSourceProviderFn) {
            return new Write<T>(this.inner.withDataSourceProviderFn(dataSourceProviderFn));
        }

        public Write<T> withStatement(String statement) {
            return new Write<T>(this.inner.withStatement(statement));
        }

        public Write<T> withPreparedStatementSetter(PreparedStatementSetter<T> setter) {
            return new Write<T>(this.inner.withPreparedStatementSetter(setter));
        }

        public Write<T> withBatchSize(long batchSize) {
            return new Write<T>(this.inner.withBatchSize(batchSize));
        }

        public Write<T> withRetryStrategy(RetryStrategy retryStrategy) {
            return new Write<T>(this.inner.withRetryStrategy(retryStrategy));
        }

        public Write<T> withRetryConfiguration(RetryConfiguration retryConfiguration) {
            return new Write<T>(this.inner.withRetryConfiguration(retryConfiguration));
        }

        public Write<T> withTable(String table) {
            return new Write<T>(this.inner.withTable(table));
        }

        public WriteVoid<T> withResults() {
            return this.inner;
        }

        public <V extends JdbcWriteResult> WriteWithResults<T, V> withWriteResults(RowMapper<V> rowMapper) {
            return new AutoValue_JdbcIO_WriteWithResults.Builder().setRowMapper(rowMapper).setRetryStrategy(this.inner.getRetryStrategy()).setRetryConfiguration(this.inner.getRetryConfiguration()).setDataSourceProviderFn(this.inner.getDataSourceProviderFn()).setPreparedStatementSetter(this.inner.getPreparedStatementSetter()).setStatement(this.inner.getStatement()).setTable(this.inner.getTable()).setAutoSharding(this.inner.getAutoSharding()).build();
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            this.inner.populateDisplayData(builder);
        }

        public PDone expand(PCollection<T> input) {
            this.inner.expand(input);
            return PDone.in((Pipeline)input.getPipeline());
        }
    }

    @FunctionalInterface
    public static interface RetryStrategy
    extends Serializable {
        public boolean apply(SQLException var1);
    }

    @FunctionalInterface
    public static interface PreparedStatementSetter<T>
    extends Serializable {
        public void setParameters(T var1, PreparedStatement var2) throws Exception;
    }

    @AutoValue
    public static abstract class RetryConfiguration
    implements Serializable {
        abstract int getMaxAttempts();

        abstract @Nullable Duration getMaxDuration();

        abstract @Nullable Duration getInitialDuration();

        abstract Builder builder();

        public static RetryConfiguration create(int maxAttempts, @Nullable Duration maxDuration, @Nullable Duration initialDuration) {
            if (maxDuration == null || maxDuration.equals((Object)Duration.ZERO)) {
                maxDuration = DEFAULT_MAX_CUMULATIVE_BACKOFF;
            }
            if (initialDuration == null || initialDuration.equals((Object)Duration.ZERO)) {
                initialDuration = DEFAULT_INITIAL_BACKOFF;
            }
            Preconditions.checkArgument((maxAttempts > 0 ? 1 : 0) != 0, (Object)"maxAttempts must be greater than 0");
            return new AutoValue_JdbcIO_RetryConfiguration.Builder().setMaxAttempts(maxAttempts).setInitialDuration(initialDuration).setMaxDuration(maxDuration).build();
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setMaxAttempts(int var1);

            abstract Builder setMaxDuration(Duration var1);

            abstract Builder setInitialDuration(Duration var1);

            abstract RetryConfiguration build();
        }
    }

    private static class ReadFn<ParameterT, OutputT>
    extends DoFn<ParameterT, OutputT> {
        private final SerializableFunction<Void, DataSource> dataSourceProviderFn;
        private final ValueProvider<String> query;
        private final PreparedStatementSetter<ParameterT> parameterSetter;
        private final RowMapper<OutputT> rowMapper;
        private final int fetchSize;
        private DataSource dataSource;
        private Connection connection;

        private ReadFn(SerializableFunction<Void, DataSource> dataSourceProviderFn, ValueProvider<String> query, PreparedStatementSetter<ParameterT> parameterSetter, RowMapper<OutputT> rowMapper, int fetchSize) {
            this.dataSourceProviderFn = dataSourceProviderFn;
            this.query = query;
            this.parameterSetter = parameterSetter;
            this.rowMapper = rowMapper;
            this.fetchSize = fetchSize;
        }

        @DoFn.Setup
        public void setup() throws Exception {
            this.dataSource = (DataSource)this.dataSourceProviderFn.apply(null);
        }

        @DoFn.ProcessElement
        @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        public void processElement(DoFn.ProcessContext context) throws Exception {
            if (this.connection == null) {
                this.connection = this.dataSource.getConnection();
            }
            LOG.info("Autocommit has been disabled");
            this.connection.setAutoCommit(false);
            try (PreparedStatement statement = this.connection.prepareStatement((String)this.query.get(), 1003, 1007);){
                statement.setFetchSize(this.fetchSize);
                this.parameterSetter.setParameters(context.element(), statement);
                try (ResultSet resultSet = statement.executeQuery();){
                    while (resultSet.next()) {
                        context.output(this.rowMapper.mapRow(resultSet));
                    }
                }
            }
        }

        @DoFn.FinishBundle
        public void finishBundle() throws Exception {
            this.cleanUpConnection();
        }

        protected void finalize() throws Throwable {
            this.cleanUpConnection();
        }

        private void cleanUpConnection() throws Exception {
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                finally {
                    this.connection = null;
                }
            }
        }
    }

    @AutoValue
    public static abstract class ReadWithPartitions<T, PartitionColumnT>
    extends PTransform<PBegin, PCollection<T>> {
        private static final int EQUAL = 0;

        abstract @Nullable SerializableFunction<Void, DataSource> getDataSourceProviderFn();

        abstract @Nullable RowMapper<T> getRowMapper();

        abstract @Nullable Coder<T> getCoder();

        abstract @Nullable Integer getNumPartitions();

        abstract @Nullable String getPartitionColumn();

        abstract boolean getUseBeamSchema();

        abstract @Nullable PartitionColumnT getLowerBound();

        abstract @Nullable PartitionColumnT getUpperBound();

        abstract @Nullable String getTable();

        abstract TypeDescriptor<PartitionColumnT> getPartitionColumnType();

        abstract Builder<T, PartitionColumnT> toBuilder();

        public ReadWithPartitions<T, PartitionColumnT> withDataSourceConfiguration(DataSourceConfiguration config) {
            return this.withDataSourceProviderFn(new DataSourceProviderFromDataSourceConfiguration(config));
        }

        public ReadWithPartitions<T, PartitionColumnT> withDataSourceProviderFn(SerializableFunction<Void, DataSource> dataSourceProviderFn) {
            return this.toBuilder().setDataSourceProviderFn(dataSourceProviderFn).build();
        }

        public ReadWithPartitions<T, PartitionColumnT> withRowMapper(RowMapper<T> rowMapper) {
            Preconditions.checkNotNull(rowMapper, (Object)"rowMapper can not be null");
            return this.toBuilder().setRowMapper(rowMapper).build();
        }

        @Deprecated
        public ReadWithPartitions<T, PartitionColumnT> withCoder(Coder<T> coder) {
            Preconditions.checkNotNull(coder, (Object)"coder can not be null");
            return this.toBuilder().setCoder(coder).build();
        }

        public ReadWithPartitions<T, PartitionColumnT> withNumPartitions(int numPartitions) {
            Preconditions.checkArgument((numPartitions > 0 ? 1 : 0) != 0, (Object)"numPartitions can not be less than 1");
            return this.toBuilder().setNumPartitions(numPartitions).build();
        }

        public ReadWithPartitions<T, PartitionColumnT> withPartitionColumn(String partitionColumn) {
            Preconditions.checkNotNull((Object)partitionColumn, (Object)"partitionColumn can not be null");
            return this.toBuilder().setPartitionColumn(partitionColumn).build();
        }

        public ReadWithPartitions<T, PartitionColumnT> withRowOutput() {
            return this.toBuilder().setUseBeamSchema(true).build();
        }

        public ReadWithPartitions<T, PartitionColumnT> withLowerBound(PartitionColumnT lowerBound) {
            return this.toBuilder().setLowerBound(lowerBound).build();
        }

        public ReadWithPartitions<T, PartitionColumnT> withUpperBound(PartitionColumnT upperBound) {
            return this.toBuilder().setUpperBound(upperBound).build();
        }

        public ReadWithPartitions<T, PartitionColumnT> withTable(String tableName) {
            Preconditions.checkNotNull((Object)tableName, (Object)"table can not be null");
            return this.toBuilder().setTable(tableName).build();
        }

        public PCollection<T> expand(PBegin input) {
            SchemaUtil.BeamRowMapper rowMapper;
            PCollection params;
            Preconditions.checkNotNull(this.getDataSourceProviderFn(), (Object)"withDataSourceConfiguration() or withDataSourceProviderFn() is required");
            Preconditions.checkNotNull((Object)this.getPartitionColumn(), (Object)"withPartitionColumn() is required");
            Preconditions.checkNotNull((Object)this.getTable(), (Object)"withTable() is required");
            Preconditions.checkArgument((boolean)(this.getUseBeamSchema() ^ this.getRowMapper() != null), (Object)"Provide only withRowOutput() or withRowMapper() arguments for JdbcIO.readWithPartitions). These are mutually exclusive.");
            Preconditions.checkArgument((this.getUpperBound() != null == (this.getLowerBound() != null) ? 1 : 0) != 0, (Object)"When providing either lower or upper bound, both parameters are mandatory for JdbcIO.readWithPartitions");
            if (this.getLowerBound() != null && this.getLowerBound() instanceof Comparable) {
                Preconditions.checkArgument((((Comparable)this.getLowerBound()).compareTo(this.getUpperBound()) < 0 ? 1 : 0) != 0, (Object)"The lower bound of partitioning column is larger or equal than the upper bound");
            }
            Preconditions.checkNotNull(JdbcUtil.JdbcReadWithPartitionsHelper.getPartitionsHelper(this.getPartitionColumnType()), (String)"readWithPartitions only supports the following types: %s", JdbcUtil.PRESET_HELPERS.keySet());
            if (this.getLowerBound() == null && this.getUpperBound() == null) {
                String query = String.format("SELECT min(%s), max(%s) FROM %s", this.getPartitionColumn(), this.getPartitionColumn(), this.getTable());
                if (this.getNumPartitions() == null) {
                    query = String.format("SELECT min(%s), max(%s), count(*) FROM %s", this.getPartitionColumn(), this.getPartitionColumn(), this.getTable());
                }
                params = (PCollection)((PCollection)input.apply(JdbcIO.read().withQuery(query).withDataSourceProviderFn(this.getDataSourceProviderFn()).withRowMapper(JdbcUtil.JdbcReadWithPartitionsHelper.getPartitionsHelper(this.getPartitionColumnType())))).apply((PTransform)MapElements.via((SimpleFunction)new SimpleFunction<KV<Long, KV<PartitionColumnT, PartitionColumnT>>, KV<Long, KV<PartitionColumnT, PartitionColumnT>>>(){

                    public KV<Long, KV<PartitionColumnT, PartitionColumnT>> apply(KV<Long, KV<PartitionColumnT, PartitionColumnT>> input) {
                        KV result;
                        if (this.getNumPartitions() == null) {
                            long numPartitions = Math.max(1L, Math.round(Math.floor(Math.sqrt(((Long)input.getKey()).longValue()) / 10.0)));
                            result = KV.of((Object)numPartitions, (Object)((KV)input.getValue()));
                        } else {
                            result = KV.of((Object)this.getNumPartitions().longValue(), (Object)((KV)input.getValue()));
                        }
                        LOG.info("Inferred min: {} - max: {} - numPartitions: {}", new Object[]{((KV)result.getValue()).getKey(), ((KV)result.getValue()).getValue(), result.getKey()});
                        return result;
                    }
                }));
            } else {
                params = (PCollection)input.apply((PTransform)Create.of((Object)KV.of((Object)this.getNumPartitions().longValue(), (Object)KV.of(this.getLowerBound(), this.getUpperBound())), (Object[])new KV[0]));
            }
            Schema schema = null;
            if (this.getUseBeamSchema()) {
                schema = ReadRows.inferBeamSchema((DataSource)this.getDataSourceProviderFn().apply(null), String.format("SELECT * FROM %s", this.getTable()));
                rowMapper = SchemaUtil.BeamRowMapper.of(schema);
            } else {
                rowMapper = this.getRowMapper();
            }
            PCollection ranges = (PCollection)((PCollection)params.apply("Partitioning", (PTransform)ParDo.of(new JdbcUtil.PartitioningFn<PartitionColumnT>(this.getPartitionColumnType())))).apply("Reshuffle partitions", (PTransform)Reshuffle.viaRandomKey());
            ReadAll<KV, Row> readAll = JdbcIO.readAll().withDataSourceProviderFn(this.getDataSourceProviderFn()).withQuery(String.format("select * from %1$s where %2$s >= ? and %2$s < ?", this.getTable(), this.getPartitionColumn())).withRowMapper(rowMapper).withParameterSetter(JdbcUtil.JdbcReadWithPartitionsHelper.getPartitionsHelper(this.getPartitionColumnType())::setParameters).withOutputParallelization(false);
            if (this.getUseBeamSchema()) {
                readAll = readAll.withCoder((Coder<Row>)RowCoder.of((Schema)schema));
            } else if (this.getCoder() != null) {
                readAll = readAll.withCoder(this.getCoder());
            }
            return (PCollection)ranges.apply("Read ranges", readAll);
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item((String)"rowMapper", (String)(this.getRowMapper() == null ? "auto-infer" : this.getRowMapper().getClass().getCanonicalName())));
            if (this.getCoder() != null) {
                builder.add(DisplayData.item((String)"coder", (String)this.getCoder().getClass().getName()));
            }
            builder.add(DisplayData.item((String)"partitionColumn", (String)this.getPartitionColumn()));
            builder.add(DisplayData.item((String)"table", (String)this.getTable()));
            builder.add(DisplayData.item((String)"numPartitions", (String)(this.getNumPartitions() == null ? "auto-infer" : this.getNumPartitions().toString())));
            builder.add(DisplayData.item((String)"lowerBound", (String)(this.getLowerBound() == null ? "auto-infer" : this.getLowerBound().toString())));
            builder.add(DisplayData.item((String)"upperBound", (String)(this.getUpperBound() == null ? "auto-infer" : this.getUpperBound().toString())));
            if (this.getDataSourceProviderFn() instanceof HasDisplayData) {
                ((HasDisplayData)this.getDataSourceProviderFn()).populateDisplayData(builder);
            }
        }

        @AutoValue.Builder
        static abstract class Builder<T, PartitionColumnT> {
            Builder() {
            }

            abstract Builder<T, PartitionColumnT> setDataSourceProviderFn(SerializableFunction<Void, DataSource> var1);

            abstract Builder<T, PartitionColumnT> setRowMapper(RowMapper<T> var1);

            abstract Builder<T, PartitionColumnT> setCoder(Coder<T> var1);

            abstract Builder<T, PartitionColumnT> setNumPartitions(int var1);

            abstract Builder<T, PartitionColumnT> setPartitionColumn(String var1);

            abstract Builder<T, PartitionColumnT> setLowerBound(PartitionColumnT var1);

            abstract Builder<T, PartitionColumnT> setUpperBound(PartitionColumnT var1);

            abstract Builder<T, PartitionColumnT> setUseBeamSchema(boolean var1);

            abstract Builder<T, PartitionColumnT> setTable(String var1);

            abstract Builder<T, PartitionColumnT> setPartitionColumnType(TypeDescriptor<PartitionColumnT> var1);

            abstract ReadWithPartitions<T, PartitionColumnT> build();
        }
    }

    @AutoValue
    public static abstract class ReadAll<ParameterT, OutputT>
    extends PTransform<PCollection<ParameterT>, PCollection<OutputT>> {
        abstract @Nullable SerializableFunction<Void, DataSource> getDataSourceProviderFn();

        abstract @Nullable ValueProvider<String> getQuery();

        abstract @Nullable PreparedStatementSetter<ParameterT> getParameterSetter();

        abstract @Nullable RowMapper<OutputT> getRowMapper();

        abstract @Nullable Coder<OutputT> getCoder();

        abstract int getFetchSize();

        abstract boolean getOutputParallelization();

        abstract Builder<ParameterT, OutputT> toBuilder();

        public ReadAll<ParameterT, OutputT> withDataSourceConfiguration(DataSourceConfiguration config) {
            return this.withDataSourceProviderFn(new DataSourceProviderFromDataSourceConfiguration(config));
        }

        public ReadAll<ParameterT, OutputT> withDataSourceProviderFn(SerializableFunction<Void, DataSource> dataSourceProviderFn) {
            if (this.getDataSourceProviderFn() != null) {
                throw new IllegalArgumentException("A dataSourceConfiguration or dataSourceProviderFn has already been provided, and does not need to be provided again.");
            }
            return this.toBuilder().setDataSourceProviderFn(dataSourceProviderFn).build();
        }

        public ReadAll<ParameterT, OutputT> withQuery(String query) {
            Preconditions.checkArgument((query != null ? 1 : 0) != 0, (Object)"JdbcIO.readAll().withQuery(query) called with null query");
            return this.withQuery((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)query));
        }

        public ReadAll<ParameterT, OutputT> withQuery(ValueProvider<String> query) {
            Preconditions.checkArgument((query != null ? 1 : 0) != 0, (Object)"JdbcIO.readAll().withQuery(query) called with null query");
            return this.toBuilder().setQuery(query).build();
        }

        public ReadAll<ParameterT, OutputT> withParameterSetter(PreparedStatementSetter<ParameterT> parameterSetter) {
            Preconditions.checkArgument((parameterSetter != null ? 1 : 0) != 0, (Object)"JdbcIO.readAll().withParameterSetter(parameterSetter) called with null statementPreparator");
            return this.toBuilder().setParameterSetter(parameterSetter).build();
        }

        public ReadAll<ParameterT, OutputT> withRowMapper(RowMapper<OutputT> rowMapper) {
            Preconditions.checkArgument((rowMapper != null ? 1 : 0) != 0, (Object)"JdbcIO.readAll().withRowMapper(rowMapper) called with null rowMapper");
            return this.toBuilder().setRowMapper(rowMapper).build();
        }

        @Deprecated
        public ReadAll<ParameterT, OutputT> withCoder(Coder<OutputT> coder) {
            Preconditions.checkArgument((coder != null ? 1 : 0) != 0, (Object)"JdbcIO.readAll().withCoder(coder) called with null coder");
            return this.toBuilder().setCoder(coder).build();
        }

        public ReadAll<ParameterT, OutputT> withFetchSize(int fetchSize) {
            Preconditions.checkArgument((fetchSize > 0 ? 1 : 0) != 0, (Object)"fetch size must be >0");
            return this.toBuilder().setFetchSize(fetchSize).build();
        }

        public ReadAll<ParameterT, OutputT> withOutputParallelization(boolean outputParallelization) {
            return this.toBuilder().setOutputParallelization(outputParallelization).build();
        }

        private Coder<OutputT> inferCoder(CoderRegistry registry, SchemaRegistry schemaRegistry) {
            if (this.getCoder() != null) {
                return this.getCoder();
            }
            RowMapper<OutputT> rowMapper = this.getRowMapper();
            TypeDescriptor outputType = TypeDescriptors.extractFromTypeParameters(rowMapper, RowMapper.class, (TypeDescriptors.TypeVariableExtractor)new TypeDescriptors.TypeVariableExtractor<RowMapper<OutputT>, OutputT>(){});
            try {
                return schemaRegistry.getSchemaCoder(outputType);
            }
            catch (NoSuchSchemaException e) {
                LOG.warn("Unable to infer a schema for type {}. Attempting to infer a coder without a schema.", (Object)outputType);
                try {
                    return registry.getCoder(outputType);
                }
                catch (CannotProvideCoderException e2) {
                    LOG.warn("Unable to infer a coder for type {}", (Object)outputType);
                    return null;
                }
            }
        }

        public PCollection<OutputT> expand(PCollection<ParameterT> input) {
            Coder<OutputT> coder = this.inferCoder(input.getPipeline().getCoderRegistry(), input.getPipeline().getSchemaRegistry());
            Preconditions.checkNotNull(coder, (Object)"Unable to infer a coder for JdbcIO.readAll() transform. Provide a coder via withCoder, or ensure that one can be inferred from the provided RowMapper.");
            PCollection output = ((PCollection)input.apply((PTransform)ParDo.of(new ReadFn(this.getDataSourceProviderFn(), this.getQuery(), this.getParameterSetter(), this.getRowMapper(), this.getFetchSize())))).setCoder(coder);
            if (this.getOutputParallelization()) {
                output = (PCollection)output.apply(new Reparallelize());
            }
            try {
                TypeDescriptor typeDesc = coder.getEncodedTypeDescriptor();
                SchemaRegistry registry = input.getPipeline().getSchemaRegistry();
                Schema schema = registry.getSchema(typeDesc);
                output.setSchema(schema, typeDesc, registry.getToRowFunction(typeDesc), registry.getFromRowFunction(typeDesc));
            }
            catch (NoSuchSchemaException noSuchSchemaException) {
                // empty catch block
            }
            return output;
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item((String)"query", this.getQuery()));
            builder.add(DisplayData.item((String)"rowMapper", (String)this.getRowMapper().getClass().getName()));
            if (this.getCoder() != null) {
                builder.add(DisplayData.item((String)"coder", (String)this.getCoder().getClass().getName()));
            }
            if (this.getDataSourceProviderFn() instanceof HasDisplayData) {
                ((HasDisplayData)this.getDataSourceProviderFn()).populateDisplayData(builder);
            }
        }

        @AutoValue.Builder
        static abstract class Builder<ParameterT, OutputT> {
            Builder() {
            }

            abstract Builder<ParameterT, OutputT> setDataSourceProviderFn(SerializableFunction<Void, DataSource> var1);

            abstract Builder<ParameterT, OutputT> setQuery(ValueProvider<String> var1);

            abstract Builder<ParameterT, OutputT> setParameterSetter(PreparedStatementSetter<ParameterT> var1);

            abstract Builder<ParameterT, OutputT> setRowMapper(RowMapper<OutputT> var1);

            abstract Builder<ParameterT, OutputT> setCoder(Coder<OutputT> var1);

            abstract Builder<ParameterT, OutputT> setFetchSize(int var1);

            abstract Builder<ParameterT, OutputT> setOutputParallelization(boolean var1);

            abstract ReadAll<ParameterT, OutputT> build();
        }
    }

    @AutoValue
    public static abstract class Read<T>
    extends PTransform<PBegin, PCollection<T>> {
        abstract @Nullable SerializableFunction<Void, DataSource> getDataSourceProviderFn();

        abstract @Nullable ValueProvider<String> getQuery();

        abstract @Nullable StatementPreparator getStatementPreparator();

        abstract @Nullable RowMapper<T> getRowMapper();

        abstract @Nullable Coder<T> getCoder();

        abstract int getFetchSize();

        abstract boolean getOutputParallelization();

        abstract Builder<T> toBuilder();

        public Read<T> withDataSourceConfiguration(DataSourceConfiguration config) {
            return this.withDataSourceProviderFn(new DataSourceProviderFromDataSourceConfiguration(config));
        }

        public Read<T> withDataSourceProviderFn(SerializableFunction<Void, DataSource> dataSourceProviderFn) {
            return this.toBuilder().setDataSourceProviderFn(dataSourceProviderFn).build();
        }

        public Read<T> withQuery(String query) {
            Preconditions.checkArgument((query != null ? 1 : 0) != 0, (Object)"query can not be null");
            return this.withQuery((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)query));
        }

        public Read<T> withQuery(ValueProvider<String> query) {
            Preconditions.checkArgument((query != null ? 1 : 0) != 0, (Object)"query can not be null");
            return this.toBuilder().setQuery(query).build();
        }

        public Read<T> withStatementPreparator(StatementPreparator statementPreparator) {
            Preconditions.checkArgument((statementPreparator != null ? 1 : 0) != 0, (Object)"statementPreparator can not be null");
            return this.toBuilder().setStatementPreparator(statementPreparator).build();
        }

        public Read<T> withRowMapper(RowMapper<T> rowMapper) {
            Preconditions.checkArgument((rowMapper != null ? 1 : 0) != 0, (Object)"rowMapper can not be null");
            return this.toBuilder().setRowMapper(rowMapper).build();
        }

        @Deprecated
        public Read<T> withCoder(Coder<T> coder) {
            Preconditions.checkArgument((coder != null ? 1 : 0) != 0, (Object)"coder can not be null");
            return this.toBuilder().setCoder(coder).build();
        }

        public Read<T> withFetchSize(int fetchSize) {
            Preconditions.checkArgument((fetchSize > 0 ? 1 : 0) != 0, (Object)"fetch size must be > 0");
            return this.toBuilder().setFetchSize(fetchSize).build();
        }

        public Read<T> withOutputParallelization(boolean outputParallelization) {
            return this.toBuilder().setOutputParallelization(outputParallelization).build();
        }

        public PCollection<T> expand(PBegin input) {
            Preconditions.checkArgument((this.getQuery() != null ? 1 : 0) != 0, (Object)"withQuery() is required");
            Preconditions.checkArgument((this.getRowMapper() != null ? 1 : 0) != 0, (Object)"withRowMapper() is required");
            Preconditions.checkArgument((this.getDataSourceProviderFn() != null ? 1 : 0) != 0, (Object)"withDataSourceConfiguration() or withDataSourceProviderFn() is required");
            ReadAll readAll = JdbcIO.readAll().withDataSourceProviderFn(this.getDataSourceProviderFn()).withQuery(this.getQuery()).withRowMapper(this.getRowMapper()).withFetchSize(this.getFetchSize()).withOutputParallelization(this.getOutputParallelization()).withParameterSetter((element, preparedStatement) -> {
                if (this.getStatementPreparator() != null) {
                    this.getStatementPreparator().setParameters(preparedStatement);
                }
            });
            if (this.getCoder() != null) {
                readAll = readAll.toBuilder().setCoder(this.getCoder()).build();
            }
            return (PCollection)((PCollection)input.apply((PTransform)Create.of((Object)null, (Object[])new Void[0]))).apply(readAll);
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item((String)"query", this.getQuery()));
            builder.add(DisplayData.item((String)"rowMapper", (String)this.getRowMapper().getClass().getName()));
            if (this.getCoder() != null) {
                builder.add(DisplayData.item((String)"coder", (String)this.getCoder().getClass().getName()));
            }
            if (this.getDataSourceProviderFn() instanceof HasDisplayData) {
                ((HasDisplayData)this.getDataSourceProviderFn()).populateDisplayData(builder);
            }
        }

        @AutoValue.Builder
        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setDataSourceProviderFn(SerializableFunction<Void, DataSource> var1);

            abstract Builder<T> setQuery(ValueProvider<String> var1);

            abstract Builder<T> setStatementPreparator(StatementPreparator var1);

            abstract Builder<T> setRowMapper(RowMapper<T> var1);

            abstract Builder<T> setCoder(Coder<T> var1);

            abstract Builder<T> setFetchSize(int var1);

            abstract Builder<T> setOutputParallelization(boolean var1);

            abstract Read<T> build();
        }
    }

    @AutoValue
    public static abstract class ReadRows
    extends PTransform<PBegin, PCollection<Row>> {
        abstract @Nullable SerializableFunction<Void, DataSource> getDataSourceProviderFn();

        abstract @Nullable ValueProvider<String> getQuery();

        abstract @Nullable StatementPreparator getStatementPreparator();

        abstract int getFetchSize();

        abstract boolean getOutputParallelization();

        abstract Builder toBuilder();

        public ReadRows withDataSourceConfiguration(DataSourceConfiguration config) {
            return this.withDataSourceProviderFn(new DataSourceProviderFromDataSourceConfiguration(config));
        }

        public ReadRows withDataSourceProviderFn(SerializableFunction<Void, DataSource> dataSourceProviderFn) {
            return this.toBuilder().setDataSourceProviderFn(dataSourceProviderFn).build();
        }

        public ReadRows withQuery(String query) {
            Preconditions.checkArgument((query != null ? 1 : 0) != 0, (Object)"query can not be null");
            return this.withQuery((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)query));
        }

        public ReadRows withQuery(ValueProvider<String> query) {
            Preconditions.checkArgument((query != null ? 1 : 0) != 0, (Object)"query can not be null");
            return this.toBuilder().setQuery(query).build();
        }

        public ReadRows withStatementPreparator(StatementPreparator statementPreparator) {
            Preconditions.checkArgument((statementPreparator != null ? 1 : 0) != 0, (Object)"statementPreparator can not be null");
            return this.toBuilder().setStatementPreparator(statementPreparator).build();
        }

        public ReadRows withFetchSize(int fetchSize) {
            Preconditions.checkArgument((fetchSize > 0 ? 1 : 0) != 0, (Object)"fetch size must be > 0");
            return this.toBuilder().setFetchSize(fetchSize).build();
        }

        public ReadRows withOutputParallelization(boolean outputParallelization) {
            return this.toBuilder().setOutputParallelization(outputParallelization).build();
        }

        public PCollection<Row> expand(PBegin input) {
            Preconditions.checkArgument((this.getQuery() != null ? 1 : 0) != 0, (Object)"withQuery() is required");
            Preconditions.checkArgument((this.getDataSourceProviderFn() != null ? 1 : 0) != 0, (Object)"withDataSourceConfiguration() or withDataSourceProviderFn() is required");
            Schema schema = ReadRows.inferBeamSchema((DataSource)this.getDataSourceProviderFn().apply(null), (String)this.getQuery().get());
            PCollection rows = (PCollection)input.apply(JdbcIO.read().withDataSourceProviderFn(this.getDataSourceProviderFn()).withQuery(this.getQuery()).withCoder(RowCoder.of((Schema)schema)).withRowMapper(SchemaUtil.BeamRowMapper.of(schema)).withFetchSize(this.getFetchSize()).withOutputParallelization(this.getOutputParallelization()).withStatementPreparator(this.getStatementPreparator()));
            rows.setRowSchema(schema);
            return rows;
        }

        /*
         * Exception decompiling
         */
        @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        private static Schema inferBeamSchema(DataSource ds, String query) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item((String)"query", this.getQuery()));
            if (this.getDataSourceProviderFn() instanceof HasDisplayData) {
                ((HasDisplayData)this.getDataSourceProviderFn()).populateDisplayData(builder);
            }
        }

        private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
            if (x0 != null) {
                try {
                    x1.close();
                }
                catch (Throwable throwable) {
                    x0.addSuppressed(throwable);
                }
            } else {
                x1.close();
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setDataSourceProviderFn(SerializableFunction<Void, DataSource> var1);

            abstract Builder setQuery(ValueProvider<String> var1);

            abstract Builder setStatementPreparator(StatementPreparator var1);

            abstract Builder setFetchSize(int var1);

            abstract Builder setOutputParallelization(boolean var1);

            abstract ReadRows build();
        }
    }

    @FunctionalInterface
    public static interface StatementPreparator
    extends Serializable {
        public void setParameters(PreparedStatement var1) throws Exception;
    }

    @AutoValue
    public static abstract class DataSourceConfiguration
    implements Serializable {
        abstract @Nullable ValueProvider<String> getDriverClassName();

        abstract @Nullable ValueProvider<String> getUrl();

        abstract @Nullable ValueProvider<String> getUsername();

        abstract @Nullable ValueProvider<String> getPassword();

        abstract @Nullable ValueProvider<String> getConnectionProperties();

        abstract @Nullable ValueProvider<Collection<String>> getConnectionInitSqls();

        abstract @Nullable DataSource getDataSource();

        abstract Builder builder();

        public static DataSourceConfiguration create(DataSource dataSource) {
            Preconditions.checkArgument((dataSource != null ? 1 : 0) != 0, (Object)"dataSource can not be null");
            Preconditions.checkArgument((boolean)(dataSource instanceof Serializable), (Object)"dataSource must be Serializable");
            return new AutoValue_JdbcIO_DataSourceConfiguration.Builder().setDataSource(dataSource).build();
        }

        public static DataSourceConfiguration create(String driverClassName, String url) {
            Preconditions.checkArgument((driverClassName != null ? 1 : 0) != 0, (Object)"driverClassName can not be null");
            Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"url can not be null");
            return DataSourceConfiguration.create((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)driverClassName), (ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)url));
        }

        public static DataSourceConfiguration create(ValueProvider<String> driverClassName, ValueProvider<String> url) {
            Preconditions.checkArgument((driverClassName != null ? 1 : 0) != 0, (Object)"driverClassName can not be null");
            Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"url can not be null");
            return new AutoValue_JdbcIO_DataSourceConfiguration.Builder().setDriverClassName(driverClassName).setUrl(url).build();
        }

        public DataSourceConfiguration withUsername(String username) {
            return this.withUsername((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)username));
        }

        public DataSourceConfiguration withUsername(ValueProvider<String> username) {
            return this.builder().setUsername(username).build();
        }

        public DataSourceConfiguration withPassword(String password) {
            return this.withPassword((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)password));
        }

        public DataSourceConfiguration withPassword(ValueProvider<String> password) {
            return this.builder().setPassword(password).build();
        }

        public DataSourceConfiguration withConnectionProperties(String connectionProperties) {
            Preconditions.checkArgument((connectionProperties != null ? 1 : 0) != 0, (Object)"connectionProperties can not be null");
            return this.withConnectionProperties((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)connectionProperties));
        }

        public DataSourceConfiguration withConnectionProperties(ValueProvider<String> connectionProperties) {
            Preconditions.checkArgument((connectionProperties != null ? 1 : 0) != 0, (Object)"connectionProperties can not be null");
            return this.builder().setConnectionProperties(connectionProperties).build();
        }

        public DataSourceConfiguration withConnectionInitSqls(Collection<String> connectionInitSqls) {
            Preconditions.checkArgument((connectionInitSqls != null ? 1 : 0) != 0, (Object)"connectionInitSqls can not be null");
            return this.withConnectionInitSqls((ValueProvider<Collection<String>>)ValueProvider.StaticValueProvider.of(connectionInitSqls));
        }

        public DataSourceConfiguration withConnectionInitSqls(ValueProvider<Collection<String>> connectionInitSqls) {
            Preconditions.checkArgument((connectionInitSqls != null ? 1 : 0) != 0, (Object)"connectionInitSqls can not be null");
            Preconditions.checkArgument((!((Collection)connectionInitSqls.get()).isEmpty() ? 1 : 0) != 0, (Object)"connectionInitSqls can not be empty");
            return this.builder().setConnectionInitSqls(connectionInitSqls).build();
        }

        void populateDisplayData(DisplayData.Builder builder) {
            if (this.getDataSource() != null) {
                builder.addIfNotNull(DisplayData.item((String)"dataSource", (String)this.getDataSource().getClass().getName()));
            } else {
                builder.addIfNotNull(DisplayData.item((String)"jdbcDriverClassName", this.getDriverClassName()));
                builder.addIfNotNull(DisplayData.item((String)"jdbcUrl", this.getUrl()));
                builder.addIfNotNull(DisplayData.item((String)"username", this.getUsername()));
            }
        }

        DataSource buildDatasource() {
            if (this.getDataSource() == null) {
                BasicDataSource basicDataSource = new BasicDataSource();
                if (this.getDriverClassName() != null) {
                    basicDataSource.setDriverClassName((String)this.getDriverClassName().get());
                }
                if (this.getUrl() != null) {
                    basicDataSource.setUrl((String)this.getUrl().get());
                }
                if (this.getUsername() != null) {
                    basicDataSource.setUsername((String)this.getUsername().get());
                }
                if (this.getPassword() != null) {
                    basicDataSource.setPassword((String)this.getPassword().get());
                }
                if (this.getConnectionProperties() != null && this.getConnectionProperties().get() != null) {
                    basicDataSource.setConnectionProperties((String)this.getConnectionProperties().get());
                }
                if (this.getConnectionInitSqls() != null && this.getConnectionInitSqls().get() != null && !((Collection)this.getConnectionInitSqls().get()).isEmpty()) {
                    basicDataSource.setConnectionInitSqls((Collection)this.getConnectionInitSqls().get());
                }
                return basicDataSource;
            }
            return this.getDataSource();
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setDriverClassName(ValueProvider<String> var1);

            abstract Builder setUrl(ValueProvider<String> var1);

            abstract Builder setUsername(ValueProvider<String> var1);

            abstract Builder setPassword(ValueProvider<String> var1);

            abstract Builder setConnectionProperties(ValueProvider<String> var1);

            abstract Builder setConnectionInitSqls(ValueProvider<Collection<String>> var1);

            abstract Builder setDataSource(DataSource var1);

            abstract DataSourceConfiguration build();
        }
    }

    @FunctionalInterface
    public static interface RowMapper<T>
    extends Serializable {
        public T mapRow(ResultSet var1) throws Exception;
    }

    public static class DefaultRetryStrategy
    implements RetryStrategy {
        private static final Set<String> errorCodesToRetry = new HashSet<String>(Arrays.asList("40001", "40P01"));

        @Override
        public boolean apply(SQLException e) {
            return errorCodesToRetry.contains(e.getSQLState());
        }
    }
}

