/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.jdbc;

import java.math.BigDecimal;
import java.sql.JDBCType;
import java.time.Instant;
import java.util.Arrays;
import java.util.Objects;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.StringUtils;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.PassThroughLogicalType;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

@Experimental(value=Experimental.Kind.SCHEMAS)
class LogicalTypes {
    static final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType JDBC_BIT_TYPE = Schema.FieldType.logicalType((Schema.LogicalType)new PassThroughLogicalType<Boolean>(JDBCType.BIT.getName(), Schema.FieldType.STRING, (Object)"", Schema.FieldType.BOOLEAN){});
    static final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType JDBC_DATE_TYPE = Schema.FieldType.logicalType((Schema.LogicalType)new PassThroughLogicalType<Instant>(JDBCType.DATE.getName(), Schema.FieldType.STRING, (Object)"", Schema.FieldType.DATETIME){});
    static final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType JDBC_FLOAT_TYPE = Schema.FieldType.logicalType((Schema.LogicalType)new PassThroughLogicalType<Double>(JDBCType.FLOAT.getName(), Schema.FieldType.STRING, (Object)"", Schema.FieldType.DOUBLE){});
    static final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType JDBC_TIME_TYPE = Schema.FieldType.logicalType((Schema.LogicalType)new PassThroughLogicalType<Instant>(JDBCType.TIME.getName(), Schema.FieldType.STRING, (Object)"", Schema.FieldType.DATETIME){});
    static final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType JDBC_TIMESTAMP_WITH_TIMEZONE_TYPE = Schema.FieldType.logicalType((Schema.LogicalType)new PassThroughLogicalType<Instant>(JDBCType.TIMESTAMP_WITH_TIMEZONE.getName(), Schema.FieldType.STRING, (Object)"", Schema.FieldType.DATETIME){});

    LogicalTypes() {
    }

    @VisibleForTesting
    static // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType fixedLengthString(@UnknownKeyFor @NonNull @Initialized JDBCType jdbcType, @UnknownKeyFor @NonNull @Initialized int length) {
        return Schema.FieldType.logicalType((Schema.LogicalType)FixedLengthString.of(jdbcType.getName(), length));
    }

    @VisibleForTesting
    static // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType fixedLengthBytes(@UnknownKeyFor @NonNull @Initialized JDBCType jdbcType, @UnknownKeyFor @NonNull @Initialized int length) {
        return Schema.FieldType.logicalType((Schema.LogicalType)FixedLengthBytes.of(jdbcType.getName(), length));
    }

    @VisibleForTesting
    static // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType variableLengthString(@UnknownKeyFor @NonNull @Initialized JDBCType jdbcType, @UnknownKeyFor @NonNull @Initialized int length) {
        return Schema.FieldType.logicalType((Schema.LogicalType)VariableLengthString.of(jdbcType.getName(), length));
    }

    @VisibleForTesting
    static // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType variableLengthBytes(@UnknownKeyFor @NonNull @Initialized JDBCType jdbcType, @UnknownKeyFor @NonNull @Initialized int length) {
        return Schema.FieldType.logicalType((Schema.LogicalType)VariableLengthBytes.of(jdbcType.getName(), length));
    }

    @VisibleForTesting
    static // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType numeric(@UnknownKeyFor @NonNull @Initialized int precision, @UnknownKeyFor @NonNull @Initialized int scale) {
        return Schema.FieldType.logicalType((Schema.LogicalType)FixedPrecisionNumeric.of(JDBCType.NUMERIC.getName(), precision, scale));
    }

    static final class FixedPrecisionNumeric
    extends JdbcLogicalType<BigDecimal> {
        private final @UnknownKeyFor @NonNull @Initialized int precision;
        private final @UnknownKeyFor @NonNull @Initialized int scale;

        static @UnknownKeyFor @NonNull @Initialized FixedPrecisionNumeric of(@UnknownKeyFor @NonNull @Initialized String identifier, @UnknownKeyFor @NonNull @Initialized int precision, @UnknownKeyFor @NonNull @Initialized int scale) {
            Schema schema = Schema.builder().addInt32Field("precision").addInt32Field("scale").build();
            return new FixedPrecisionNumeric(schema, identifier, precision, scale);
        }

        private FixedPrecisionNumeric(@UnknownKeyFor @NonNull @Initialized Schema argumentSchema, @UnknownKeyFor @NonNull @Initialized String identifier, @UnknownKeyFor @NonNull @Initialized int precision, @UnknownKeyFor @NonNull @Initialized int scale) {
            super(identifier, Schema.FieldType.row((Schema)argumentSchema), Schema.FieldType.DECIMAL, Row.withSchema((Schema)argumentSchema).addValues(new Object[]{precision, scale}).build());
            this.precision = precision;
            this.scale = scale;
        }

        public @UnknownKeyFor @NonNull @Initialized BigDecimal toInputType(@UnknownKeyFor @NonNull @Initialized BigDecimal base) {
            Preconditions.checkArgument((base == null || base.precision() == this.precision && base.scale() == this.scale ? 1 : 0) != 0);
            return base;
        }
    }

    static final class VariableLengthBytes
    extends JdbcLogicalType<byte[]> {
        private final @UnknownKeyFor @NonNull @Initialized int maxLength;

        static @UnknownKeyFor @NonNull @Initialized VariableLengthBytes of(@UnknownKeyFor @NonNull @Initialized String identifier, @UnknownKeyFor @NonNull @Initialized int maxLength) {
            return new VariableLengthBytes(identifier, maxLength);
        }

        private VariableLengthBytes(@UnknownKeyFor @NonNull @Initialized String identifier, @UnknownKeyFor @NonNull @Initialized int maxLength) {
            super(identifier, Schema.FieldType.INT32, Schema.FieldType.BYTES, maxLength);
            this.maxLength = maxLength;
        }

        public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] toInputType(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] base) {
            Preconditions.checkArgument((base == null || base.length <= this.maxLength ? 1 : 0) != 0);
            return base;
        }
    }

    static final class VariableLengthString
    extends JdbcLogicalType<String> {
        private final @UnknownKeyFor @NonNull @Initialized int maxLength;

        static @UnknownKeyFor @NonNull @Initialized VariableLengthString of(@UnknownKeyFor @NonNull @Initialized String identifier, @UnknownKeyFor @NonNull @Initialized int maxLength) {
            return new VariableLengthString(identifier, maxLength);
        }

        private VariableLengthString(@UnknownKeyFor @NonNull @Initialized String identifier, @UnknownKeyFor @NonNull @Initialized int maxLength) {
            super(identifier, Schema.FieldType.INT32, Schema.FieldType.STRING, maxLength);
            this.maxLength = maxLength;
        }

        public @UnknownKeyFor @NonNull @Initialized String toInputType(@UnknownKeyFor @NonNull @Initialized String base) {
            Preconditions.checkArgument((base == null || base.length() <= this.maxLength ? 1 : 0) != 0);
            return base;
        }
    }

    static final class FixedLengthBytes
    extends JdbcLogicalType<byte[]> {
        private final @UnknownKeyFor @NonNull @Initialized int length;

        static @UnknownKeyFor @NonNull @Initialized FixedLengthBytes of(@UnknownKeyFor @NonNull @Initialized String identifier, @UnknownKeyFor @NonNull @Initialized int length) {
            return new FixedLengthBytes(identifier, length);
        }

        private FixedLengthBytes(@UnknownKeyFor @NonNull @Initialized String identifier, @UnknownKeyFor @NonNull @Initialized int length) {
            super(identifier, Schema.FieldType.INT32, Schema.FieldType.BYTES, length);
            this.length = length;
        }

        public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] toInputType(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] base) {
            Preconditions.checkArgument((base == null || base.length <= this.length ? 1 : 0) != 0);
            if (base == null || base.length == this.length) {
                return base;
            }
            return Arrays.copyOf(base, this.length);
        }
    }

    static final class FixedLengthString
    extends JdbcLogicalType<String> {
        private final @UnknownKeyFor @NonNull @Initialized int length;

        static @UnknownKeyFor @NonNull @Initialized FixedLengthString of(@UnknownKeyFor @NonNull @Initialized String identifier, @UnknownKeyFor @NonNull @Initialized int length) {
            return new FixedLengthString(identifier, length);
        }

        private FixedLengthString(@UnknownKeyFor @NonNull @Initialized String identifier, @UnknownKeyFor @NonNull @Initialized int length) {
            super(identifier, Schema.FieldType.INT32, Schema.FieldType.STRING, length);
            this.length = length;
        }

        public @UnknownKeyFor @NonNull @Initialized String toInputType(@UnknownKeyFor @NonNull @Initialized String base) {
            Preconditions.checkArgument((base == null || base.length() <= this.length ? 1 : 0) != 0);
            return StringUtils.rightPad((String)base, (int)this.length);
        }
    }

    static abstract class JdbcLogicalType<@UnknownKeyFor T>
    implements Schema.LogicalType<T, T> {
        protected final @UnknownKeyFor @NonNull @Initialized String identifier;
        protected final // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.FieldType argumentType;
        protected final // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.FieldType baseType;
        protected final @UnknownKeyFor @NonNull @Initialized Object argument;

        protected JdbcLogicalType(@UnknownKeyFor @NonNull @Initialized String identifier, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.FieldType argumentType, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.FieldType baseType, @UnknownKeyFor @NonNull @Initialized Object argument) {
            this.identifier = identifier;
            this.argumentType = argumentType;
            this.baseType = baseType;
            this.argument = argument;
        }

        public @UnknownKeyFor @NonNull @Initialized String getIdentifier() {
            return this.identifier;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.FieldType getArgumentType() {
            return this.argumentType;
        }

        public <ArgumentT> ArgumentT getArgument() {
            return (ArgumentT)this.argument;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.FieldType getBaseType() {
            return this.baseType;
        }

        public T toBaseType(T input) {
            return input;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof JdbcLogicalType)) {
                return false;
            }
            JdbcLogicalType that = (JdbcLogicalType)o;
            return Objects.equals(this.identifier, that.identifier) && Objects.equals(this.baseType, that.baseType) && Objects.equals(this.argument, that.argument);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.identifier, this.baseType, this.argument);
        }
    }
}

