/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.jdbc;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.jdbc.JdbcIO;
import org.apache.beam.sdk.io.jdbc.JdbcUtil;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.io.SchemaIO;
import org.apache.beam.sdk.schemas.io.SchemaIOProvider;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public class JdbcSchemaIOProvider
implements SchemaIOProvider {
    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "jdbc";
    }

    public @UnknownKeyFor @NonNull @Initialized Schema configurationSchema() {
        return Schema.builder().addStringField("driverClassName").addStringField("jdbcUrl").addStringField("username").addStringField("password").addNullableField("connectionProperties", Schema.FieldType.STRING).addNullableField("connectionInitSqls", Schema.FieldType.iterable((Schema.FieldType)Schema.FieldType.STRING)).addNullableField("readQuery", Schema.FieldType.STRING).addNullableField("writeStatement", Schema.FieldType.STRING).addNullableField("fetchSize", Schema.FieldType.INT16).addNullableField("outputParallelization", Schema.FieldType.BOOLEAN).build();
    }

    public @UnknownKeyFor @NonNull @Initialized JdbcSchemaIO from(@UnknownKeyFor @NonNull @Initialized String location, @UnknownKeyFor @NonNull @Initialized Row configuration, @UnknownKeyFor @NonNull @Initialized Schema dataSchema) {
        return new JdbcSchemaIO(location, configuration);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean requiresDataSchema() {
        return false;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PCollection.IsBounded isBounded() {
        return PCollection.IsBounded.BOUNDED;
    }

    static class JdbcSchemaIO
    implements SchemaIO,
    Serializable {
        protected final @UnknownKeyFor @NonNull @Initialized Row config;
        protected final @UnknownKeyFor @NonNull @Initialized String location;

        JdbcSchemaIO(@UnknownKeyFor @NonNull @Initialized String location, @UnknownKeyFor @NonNull @Initialized Row config) {
            this.config = config;
            this.location = location;
        }

        public @UnknownKeyFor @NonNull @Initialized Schema schema() {
            return null;
        }

        public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> buildReader() {
            return new PTransform<PBegin, PCollection<Row>>(){

                public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
                    String readQuery = config.getString("readQuery") != null ? config.getString("readQuery") : String.format("SELECT * FROM %s", location);
                    JdbcIO.ReadRows readRows = JdbcIO.readRows().withDataSourceConfiguration(this.getDataSourceConfiguration()).withQuery(readQuery);
                    if (config.getInt16("fetchSize") != null) {
                        readRows = readRows.withFetchSize(config.getInt16("fetchSize").shortValue());
                    }
                    if (config.getBoolean("outputParallelization") != null) {
                        readRows = readRows.withOutputParallelization(config.getBoolean("outputParallelization"));
                    }
                    return (PCollection)input.apply((PTransform)readRows);
                }
            };
        }

        public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized PDone> buildWriter() {
            return new PTransform<PCollection<Row>, PDone>(){

                public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> input) {
                    return (PDone)input.apply(JdbcIO.write().withDataSourceConfiguration(this.getDataSourceConfiguration()).withStatement(this.generateWriteStatement(input.getSchema())).withPreparedStatementSetter(new JdbcUtil.BeamRowPreparedStatementSetter()));
                }
            };
        }

        protected @UnknownKeyFor @NonNull @Initialized JdbcIO.DataSourceConfiguration getDataSourceConfiguration() {
            Iterable connectionInitSqls = this.config.getIterable("connectionInitSqls");
            JdbcIO.DataSourceConfiguration dataSourceConfiguration = JdbcIO.DataSourceConfiguration.create(this.config.getString("driverClassName"), this.config.getString("jdbcUrl")).withUsername(this.config.getString("username")).withPassword(this.config.getString("password"));
            if (this.config.getString("connectionProperties") != null) {
                dataSourceConfiguration = dataSourceConfiguration.withConnectionProperties(this.config.getString("connectionProperties"));
            }
            if (connectionInitSqls != null) {
                List<String> initSqls = StreamSupport.stream(connectionInitSqls.spliterator(), false).collect(Collectors.toList());
                dataSourceConfiguration = dataSourceConfiguration.withConnectionInitSqls(initSqls);
            }
            return dataSourceConfiguration;
        }

        private @UnknownKeyFor @NonNull @Initialized String generateWriteStatement(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            if (this.config.getString("writeStatement") != null) {
                return this.config.getString("writeStatement");
            }
            StringBuilder writeStatement = new StringBuilder("INSERT INTO ");
            writeStatement.append(this.location);
            writeStatement.append(" VALUES(");
            for (int i = 0; i < schema.getFieldCount() - 1; ++i) {
                writeStatement.append("?, ");
            }
            writeStatement.append("?)");
            return writeStatement.toString();
        }
    }
}

