/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hadoop.format;

import java.lang.reflect.InvocationTargetException;
import java.util.UUID;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.partition.HashPartitioner;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

final class HadoopFormats {
    private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_JOB_NUMBER = 0;
    static final @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized HashPartitioner> DEFAULT_PARTITIONER_CLASS_ATTR = HashPartitioner.class;
    private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_NUM_REDUCERS = 1;

    private HadoopFormats() {
    }

    public static @UnknownKeyFor @NonNull @Initialized JobID createJobId() {
        return new JobID(UUID.randomUUID().toString(), 0);
    }

    public static @UnknownKeyFor @NonNull @Initialized JobID createJobId(@UnknownKeyFor @NonNull @Initialized String jtIdentifier) {
        return new JobID(jtIdentifier, 0);
    }

    static @UnknownKeyFor @NonNull @Initialized TaskAttemptContext createSetupTaskContext(@UnknownKeyFor @NonNull @Initialized Configuration conf, @UnknownKeyFor @NonNull @Initialized JobID jobID) {
        TaskID taskId = new TaskID(jobID, TaskType.JOB_SETUP, 0);
        return HadoopFormats.createTaskAttemptContext(conf, new TaskAttemptID(taskId, 0));
    }

    static @UnknownKeyFor @NonNull @Initialized TaskAttemptContext createTaskAttemptContext(@UnknownKeyFor @NonNull @Initialized Configuration conf, @UnknownKeyFor @NonNull @Initialized JobID jobID, @UnknownKeyFor @NonNull @Initialized int taskNumber) {
        TaskAttemptID taskAttemptID = HadoopFormats.createTaskAttemptID(jobID, taskNumber, 0);
        return HadoopFormats.createTaskAttemptContext(conf, taskAttemptID);
    }

    static @UnknownKeyFor @NonNull @Initialized TaskAttemptContext createTaskAttemptContext(@UnknownKeyFor @NonNull @Initialized Configuration conf, @UnknownKeyFor @NonNull @Initialized TaskAttemptID taskAttemptID) {
        return new TaskAttemptContextImpl(conf, taskAttemptID);
    }

    static @UnknownKeyFor @NonNull @Initialized TaskAttemptID createTaskAttemptID(@UnknownKeyFor @NonNull @Initialized JobID jobID, @UnknownKeyFor @NonNull @Initialized int taskId, @UnknownKeyFor @NonNull @Initialized int attemptId) {
        TaskID tId = HadoopFormats.createTaskID(jobID, taskId);
        return new TaskAttemptID(tId, attemptId);
    }

    static @UnknownKeyFor @NonNull @Initialized TaskID createTaskID(@UnknownKeyFor @NonNull @Initialized JobID jobID, @UnknownKeyFor @NonNull @Initialized int taskNumber) {
        return new TaskID(jobID, TaskType.REDUCE, taskNumber);
    }

    static @UnknownKeyFor @NonNull @Initialized TaskAttemptContext createCleanupTaskContext(@UnknownKeyFor @NonNull @Initialized Configuration conf, @UnknownKeyFor @NonNull @Initialized JobID jobID) {
        TaskID taskId = new TaskID(jobID, TaskType.JOB_CLEANUP, 0);
        return HadoopFormats.createTaskAttemptContext(conf, new TaskAttemptID(taskId, 0));
    }

    static <KeyT, ValueT> @UnknownKeyFor @NonNull @Initialized OutputFormat<KeyT, ValueT> createOutputFormatFromConfig(@UnknownKeyFor @NonNull @Initialized Configuration conf) throws @UnknownKeyFor @NonNull @Initialized IllegalArgumentException {
        return HadoopFormats.createInstanceFromConfig(conf, "mapreduce.job.outputformat.class", null, OutputFormat.class);
    }

    static <KeyT, ValueT> @UnknownKeyFor @NonNull @Initialized Partitioner<KeyT, ValueT> getPartitioner(@UnknownKeyFor @NonNull @Initialized Configuration conf) {
        return HadoopFormats.createInstanceFromConfig(conf, "mapreduce.job.partitioner.class", DEFAULT_PARTITIONER_CLASS_ATTR, Partitioner.class);
    }

    private static <T> T createInstanceFromConfig(@UnknownKeyFor @NonNull @Initialized Configuration conf, @UnknownKeyFor @NonNull @Initialized String configClassKey, @Nullable @UnknownKeyFor @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends T> defaultClass, @UnknownKeyFor @NonNull @Initialized Class<T> xface) {
        try {
            String className = conf.get(configClassKey);
            Preconditions.checkArgument((className != null || defaultClass != null ? 1 : 0) != 0, (Object)String.format("Configuration does not contains any value under %s key. Unable to initialize class instance from configuration. ", configClassKey));
            Class requiredClass = conf.getClass(configClassKey, defaultClass, xface);
            return requiredClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(String.format("Unable to create instance of object from configuration under key %s.", configClassKey), e);
        }
    }

    static @UnknownKeyFor @NonNull @Initialized JobID getJobId(@UnknownKeyFor @NonNull @Initialized Configuration conf) {
        String jobJtIdentifier = (String)Preconditions.checkNotNull((Object)conf.get("mapreduce.job.id"), (String)"Configuration must contain jobID under key \"%s\".", (Object)"mapreduce.job.id");
        return new JobID(jobJtIdentifier, 0);
    }

    static @UnknownKeyFor @NonNull @Initialized int getReducersCount(@UnknownKeyFor @NonNull @Initialized Configuration conf) {
        return conf.getInt("mapreduce.job.reduces", 1);
    }
}

