/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hadoop.format;

import java.io.IOException;
import java.io.Serializable;
import java.util.Random;
import org.apache.beam.sdk.io.hadoop.format.ExternalSynchronization;
import org.apache.beam.sdk.io.hadoop.format.HadoopFormats;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HDFSSynchronization
implements ExternalSynchronization {
    private static final Logger LOGGER = LoggerFactory.getLogger(HDFSSynchronization.class);
    private static final String LOCKS_DIR_PATTERN = "%s/";
    private static final String LOCKS_DIR_TASK_PATTERN = "%s/%s";
    private static final String LOCKS_DIR_TASK_ATTEMPT_PATTERN = "%s/%s_%s";
    private static final String LOCKS_DIR_JOB_FILENAME = "%s/_job";
    private static final transient Random RANDOM_GEN = new Random();
    private final String locksDir;
    private final ThrowingFunction<Configuration, FileSystem, IOException> fileSystemFactory;

    public HDFSSynchronization(String locksDir) {
        this(locksDir, FileSystem::newInstance);
    }

    HDFSSynchronization(String locksDir, ThrowingFunction<Configuration, FileSystem, IOException> fileSystemFactory) {
        this.locksDir = locksDir;
        this.fileSystemFactory = fileSystemFactory;
    }

    @Override
    public boolean tryAcquireJobLock(Configuration conf) {
        Path path = new Path(this.locksDir, String.format(LOCKS_DIR_JOB_FILENAME, this.getJobJtIdentifier(conf)));
        return this.tryCreateFile(conf, path);
    }

    @Override
    public void releaseJobIdLock(Configuration conf) {
        Path path = new Path(this.locksDir, String.format(LOCKS_DIR_PATTERN, this.getJobJtIdentifier(conf)));
        try (FileSystem fileSystem = this.fileSystemFactory.apply(conf);){
            if (fileSystem.delete(path, true)) {
                LOGGER.info("Delete of lock directory {} was successful", (Object)path);
            } else {
                LOGGER.warn("Delete of lock directory {} was unsuccessful", (Object)path);
            }
        }
        catch (IOException e) {
            String formattedExceptionMessage = String.format("Delete of lock directory %s was unsuccessful", path);
            LOGGER.warn(formattedExceptionMessage, (Throwable)e);
            throw new IllegalStateException(formattedExceptionMessage, e);
        }
    }

    @Override
    public TaskID acquireTaskIdLock(Configuration conf) {
        JobID jobId = HadoopFormats.getJobId(conf);
        boolean lockAcquired = false;
        int taskIdCandidate = 0;
        while (!lockAcquired) {
            taskIdCandidate = RANDOM_GEN.nextInt(Integer.MAX_VALUE);
            Path path = new Path(this.locksDir, String.format(LOCKS_DIR_TASK_PATTERN, this.getJobJtIdentifier(conf), taskIdCandidate));
            lockAcquired = this.tryCreateFile(conf, path);
        }
        return HadoopFormats.createTaskID(jobId, taskIdCandidate);
    }

    @Override
    public TaskAttemptID acquireTaskAttemptIdLock(Configuration conf, int taskId) {
        String jobJtIdentifier = this.getJobJtIdentifier(conf);
        JobID jobId = HadoopFormats.getJobId(conf);
        int taskAttemptCandidate = 0;
        boolean taskAttemptAcquired = false;
        while (!taskAttemptAcquired) {
            Path path = new Path(this.locksDir, String.format(LOCKS_DIR_TASK_ATTEMPT_PATTERN, jobJtIdentifier, taskId, ++taskAttemptCandidate));
            taskAttemptAcquired = this.tryCreateFile(conf, path);
        }
        return HadoopFormats.createTaskAttemptID(jobId, taskId, taskAttemptCandidate);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean tryCreateFile(Configuration conf, Path path) {
        try {
            Throwable throwable = null;
            try (FileSystem fileSystem = this.fileSystemFactory.apply(conf);){
                boolean bl = fileSystem.createNewFile(path);
                return bl;
            }
            catch (FileAlreadyExistsException | org.apache.hadoop.mapred.FileAlreadyExistsException e) {
                boolean bl = false;
                return bl;
            }
            catch (RemoteException e) {
                if (e.getClassName().equals(AlreadyBeingCreatedException.class.getName())) {
                    boolean bl = false;
                    return bl;
                }
                try {
                    throw e;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Creation of file on path %s failed", path), e);
        }
    }

    private String getJobJtIdentifier(Configuration conf) {
        JobID job = (JobID)Preconditions.checkNotNull((Object)HadoopFormats.getJobId(conf), (String)"Configuration must contain jobID under key %s.", (Object)"mapreduce.job.id");
        return job.getJtIdentifier();
    }

    @FunctionalInterface
    static interface ThrowingFunction<T1, T2, X extends Exception>
    extends Serializable {
        public T2 apply(T1 var1) throws X;
    }
}

