/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hadoop.format;

import java.lang.reflect.InvocationTargetException;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.partition.HashPartitioner;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;

final class HadoopFormats {
    private static final int DEFAULT_JOB_NUMBER = 0;
    static final Class<HashPartitioner> DEFAULT_PARTITIONER_CLASS_ATTR = HashPartitioner.class;
    private static final int DEFAULT_NUM_REDUCERS = 1;

    private HadoopFormats() {
    }

    public static JobID createJobId() {
        return new JobID(UUID.randomUUID().toString(), 0);
    }

    public static JobID createJobId(String jtIdentifier) {
        return new JobID(jtIdentifier, 0);
    }

    static TaskAttemptContext createSetupTaskContext(Configuration conf, JobID jobID) {
        TaskID taskId = new TaskID(jobID, TaskType.JOB_SETUP, 0);
        return HadoopFormats.createTaskAttemptContext(conf, new TaskAttemptID(taskId, 0));
    }

    static TaskAttemptContext createTaskAttemptContext(Configuration conf, JobID jobID, int taskNumber) {
        TaskAttemptID taskAttemptID = HadoopFormats.createTaskAttemptID(jobID, taskNumber, 0);
        return HadoopFormats.createTaskAttemptContext(conf, taskAttemptID);
    }

    static TaskAttemptContext createTaskAttemptContext(Configuration conf, TaskAttemptID taskAttemptID) {
        return new TaskAttemptContextImpl(conf, taskAttemptID);
    }

    static TaskAttemptID createTaskAttemptID(JobID jobID, int taskId, int attemptId) {
        TaskID tId = HadoopFormats.createTaskID(jobID, taskId);
        return new TaskAttemptID(tId, attemptId);
    }

    static TaskID createTaskID(JobID jobID, int taskNumber) {
        return new TaskID(jobID, TaskType.REDUCE, taskNumber);
    }

    static TaskAttemptContext createCleanupTaskContext(Configuration conf, JobID jobID) {
        TaskID taskId = new TaskID(jobID, TaskType.JOB_CLEANUP, 0);
        return HadoopFormats.createTaskAttemptContext(conf, new TaskAttemptID(taskId, 0));
    }

    static <KeyT, ValueT> OutputFormat<KeyT, ValueT> createOutputFormatFromConfig(Configuration conf) throws IllegalArgumentException {
        return HadoopFormats.createInstanceFromConfig(conf, "mapreduce.job.outputformat.class", null, OutputFormat.class);
    }

    static <KeyT, ValueT> Partitioner<KeyT, ValueT> getPartitioner(Configuration conf) {
        return HadoopFormats.createInstanceFromConfig(conf, "mapreduce.job.partitioner.class", DEFAULT_PARTITIONER_CLASS_ATTR, Partitioner.class);
    }

    private static <T> T createInstanceFromConfig(Configuration conf, String configClassKey, @Nullable Class<? extends T> defaultClass, Class<T> xface) {
        try {
            String className = conf.get(configClassKey);
            Preconditions.checkArgument((className != null || defaultClass != null ? 1 : 0) != 0, (Object)String.format("Configuration does not contains any value under %s key. Unable to initialize class instance from configuration. ", configClassKey));
            Class requiredClass = conf.getClass(configClassKey, defaultClass, xface);
            return requiredClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(String.format("Unable to create instance of object from configuration under key %s.", configClassKey), e);
        }
    }

    static JobID getJobId(Configuration conf) {
        String jobJtIdentifier = (String)Preconditions.checkNotNull((Object)conf.get("mapreduce.job.id"), (String)"Configuration must contain jobID under key \"%s\".", (Object)"mapreduce.job.id");
        return new JobID(jobJtIdentifier, 0);
    }

    static int getReducersCount(Configuration conf) {
        return conf.getInt("mapreduce.job.reduces", 1);
    }
}

