/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hadoop;

import com.google.auto.service.AutoService;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CoderProvider;
import org.apache.beam.sdk.coders.CoderProviderRegistrar;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;

public class WritableCoder<T extends Writable>
extends CustomCoder<T> {
    private static final long serialVersionUID = 0L;
    private final Class<T> type;

    public static <T extends Writable> WritableCoder<T> of(Class<T> clazz) {
        return new WritableCoder<T>(clazz);
    }

    public WritableCoder(Class<T> type) {
        this.type = type;
    }

    public void encode(T value, OutputStream outStream) throws IOException {
        value.write((DataOutput)new DataOutputStream(outStream));
    }

    public T decode(InputStream inStream) throws IOException {
        try {
            if (this.type == NullWritable.class) {
                return (T)NullWritable.get();
            }
            Writable t = (Writable)this.type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            t.readFields((DataInput)new DataInputStream(inStream));
            return (T)t;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new CoderException("unable to deserialize record", (Throwable)e);
        }
    }

    public List<Coder<?>> getCoderArguments() {
        return Collections.emptyList();
    }

    public void verifyDeterministic() throws Coder.NonDeterministicException {
        throw new Coder.NonDeterministicException((Coder)this, "Hadoop Writable may be non-deterministic.");
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof WritableCoder)) {
            return false;
        }
        WritableCoder that = (WritableCoder)((Object)other);
        return Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public static CoderProvider getCoderProvider() {
        return new WritableCoderProvider();
    }

    private static class WritableCoderProvider
    extends CoderProvider {
        private static final TypeDescriptor<Writable> WRITABLE_TYPE = new TypeDescriptor<Writable>(){};

        private WritableCoderProvider() {
        }

        public <T> Coder<T> coderFor(TypeDescriptor<T> typeDescriptor, List<? extends Coder<?>> componentCoders) throws CannotProvideCoderException {
            if (!typeDescriptor.isSubtypeOf(WRITABLE_TYPE)) {
                throw new CannotProvideCoderException(String.format("Cannot provide %s because %s does not implement the interface %s", WritableCoder.class.getSimpleName(), typeDescriptor, Writable.class.getName()));
            }
            try {
                WritableCoder coder = WritableCoder.of(typeDescriptor.getRawType());
                return coder;
            }
            catch (IllegalArgumentException e) {
                throw new CannotProvideCoderException((Throwable)e);
            }
        }
    }

    @AutoService(value=CoderProviderRegistrar.class)
    public static class WritableCoderProviderRegistrar
    implements CoderProviderRegistrar {
        public List<CoderProvider> getCoderProviders() {
            return Collections.singletonList(WritableCoder.getCoderProvider());
        }
    }
}

