/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.gcp.spanner.SerializedMutation;

class SerializedMutationCoder
extends AtomicCoder<SerializedMutation> {
    private static final SerializedMutationCoder INSTANCE = new SerializedMutationCoder();
    private final ByteArrayCoder byteArrayCoder = ByteArrayCoder.of();
    private final StringUtf8Coder stringCoder = StringUtf8Coder.of();

    public static SerializedMutationCoder of() {
        return INSTANCE;
    }

    private SerializedMutationCoder() {
    }

    public void encode(SerializedMutation value, OutputStream out) throws IOException {
        this.stringCoder.encode(value.getTableName(), out);
        this.byteArrayCoder.encode(value.getEncodedKey(), out);
        this.byteArrayCoder.encode(value.getMutationGroupBytes(), out);
    }

    public SerializedMutation decode(InputStream in) throws IOException {
        String tableName = this.stringCoder.decode(in);
        byte[] encodedKey = this.byteArrayCoder.decode(in);
        byte[] mutationBytes = this.byteArrayCoder.decode(in);
        return SerializedMutation.create(tableName, encodedKey, mutationBytes);
    }
}

