/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import java.util.ArrayList;
import java.util.List;
import org.apache.avro.util.Utf8;
import org.apache.beam.sdk.schemas.Schema;
import org.joda.time.Instant;

public class AvroUtils {
    public static Object convertAvroFormat(Schema.Field beamField, Object value) throws RuntimeException {
        Object ret;
        Schema.TypeName beamFieldTypeName = beamField.getType().getTypeName();
        switch (beamFieldTypeName) {
            case INT16: 
            case INT32: 
            case INT64: 
            case FLOAT: 
            case DOUBLE: 
            case BYTE: 
            case BOOLEAN: {
                ret = AvroUtils.convertAvroPrimitiveTypes(beamFieldTypeName, value);
                break;
            }
            case DATETIME: {
                ret = new Instant().withMillis((Long)value / 1000L);
                break;
            }
            case STRING: {
                ret = AvroUtils.convertAvroPrimitiveTypes(beamFieldTypeName, value);
                break;
            }
            case ARRAY: {
                ret = AvroUtils.convertAvroArray(beamField, value);
                break;
            }
            case DECIMAL: {
                throw new RuntimeException("Does not support converting DECIMAL type value");
            }
            case MAP: {
                throw new RuntimeException("Does not support converting MAP type value");
            }
            default: {
                throw new RuntimeException("Does not support converting unknown type value");
            }
        }
        return ret;
    }

    private static Object convertAvroArray(Schema.Field beamField, Object value) {
        List values = (List)value;
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Object v : values) {
            ret.add(AvroUtils.convertAvroPrimitiveTypes(beamField.getType().getCollectionElementType().getTypeName(), v));
        }
        return ret;
    }

    private static Object convertAvroString(Object value) {
        if (value instanceof Utf8) {
            return ((Utf8)value).toString();
        }
        if (value instanceof String) {
            return value;
        }
        throw new RuntimeException("Does not support converting avro format: " + value.getClass().getName());
    }

    private static Object convertAvroPrimitiveTypes(Schema.TypeName beamType, Object value) {
        switch (beamType) {
            case BYTE: {
                return ((Long)value).byteValue();
            }
            case INT16: {
                return ((Long)value).shortValue();
            }
            case INT32: {
                return ((Long)value).intValue();
            }
            case INT64: {
                return value;
            }
            case FLOAT: {
                return Float.valueOf(((Double)value).floatValue());
            }
            case DOUBLE: {
                return (Double)value;
            }
            case BOOLEAN: {
                return (Boolean)value;
            }
            case DECIMAL: {
                throw new RuntimeException("Does not support converting DECIMAL type value");
            }
            case STRING: {
                return AvroUtils.convertAvroString(value);
            }
        }
        throw new RuntimeException(beamType + " is not primitive type.");
    }
}

