/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.cache;

import com.google.cloud.Timestamp;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.cache.WatermarkCache;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.PartitionMetadataDao;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.cache.CacheBuilder;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.cache.CacheLoader;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.cache.LoadingCache;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

public class AsyncWatermarkCache
implements WatermarkCache {
    private static final @UnknownKeyFor @NonNull @Initialized String THREAD_NAME_FORMAT = "watermark_loading_thread_%d";
    private static final @UnknownKeyFor @NonNull @Initialized Object MIN_WATERMARK_KEY = new Object();
    private final @UnknownKeyFor @NonNull @Initialized LoadingCache<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Timestamp>> cache;
    private @UnknownKeyFor @NonNull @Initialized AtomicReference<@UnknownKeyFor @NonNull @Initialized Timestamp> lastCachedMinWatermark = new AtomicReference<Timestamp>(Timestamp.MIN_VALUE);

    public AsyncWatermarkCache(@UnknownKeyFor @NonNull @Initialized PartitionMetadataDao dao, @UnknownKeyFor @NonNull @Initialized Duration refreshRate) {
        this.cache = CacheBuilder.newBuilder().refreshAfterWrite(java.time.Duration.ofMillis(refreshRate.getMillis())).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(key -> {
            Timestamp unfinishedMinTimes = dao.getUnfinishedMinWatermarkFrom(this.lastCachedMinWatermark.get());
            if (unfinishedMinTimes != null && this.lastCachedMinWatermark.get().compareTo(unfinishedMinTimes) < 0) {
                this.lastCachedMinWatermark.set(unfinishedMinTimes);
            }
            return Optional.ofNullable(unfinishedMinTimes);
        }), (Executor)Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat(THREAD_NAME_FORMAT).build())));
    }

    @Override
    @Nullable
    public @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Timestamp getUnfinishedMinWatermark() {
        try {
            return ((Optional)this.cache.get(MIN_WATERMARK_KEY)).orElse(null);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

