/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable;

import com.google.auto.service.AutoService;
import com.google.auto.value.AutoValue;
import com.google.bigtable.v2.Mutation;
import com.google.bigtable.v2.TimestampRange;
import com.google.protobuf.ByteString;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.bigtable.AutoValue_BigtableWriteSchemaTransformProvider_BigtableWriteSchemaTransformConfiguration;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableIO;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.primitives.Longs;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoService(value={SchemaTransformProvider.class})
public class BigtableWriteSchemaTransformProvider
extends TypedSchemaTransformProvider<BigtableWriteSchemaTransformConfiguration> {
    private static final @UnknownKeyFor @NonNull @Initialized String INPUT_TAG = "input";
    private static final @UnknownKeyFor @NonNull @Initialized Schema BATCHED_MUTATIONS_SCHEMA = Schema.builder().addByteArrayField("key").addArrayField("mutations", Schema.FieldType.map((Schema.FieldType)Schema.FieldType.STRING, (Schema.FieldType)Schema.FieldType.BYTES)).build();

    protected @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized BigtableWriteSchemaTransformConfiguration configuration) {
        return new BigtableWriteSchemaTransform(configuration);
    }

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "beam:schematransform:org.apache.beam:bigtable_write:v1";
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputCollectionNames() {
        return Collections.singletonList(INPUT_TAG);
    }

    public static class GetMutationsFromBeamRow
    extends SimpleFunction<Row, KV<ByteString, Iterable<Mutation>>> {
        public @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Mutation>> apply(@UnknownKeyFor @NonNull @Initialized Row row) {
            ByteString key = ByteString.copyFrom((byte[])Optional.ofNullable(row.getBytes("key")).get());
            List beamRowMutations = (List)Optional.ofNullable(row.getArray("mutations")).get();
            ArrayList<Mutation> mutations = new ArrayList<Mutation>(beamRowMutations.size());
            for (Map mutation : beamRowMutations) {
                Mutation bigtableMutation;
                switch (new String(Optional.ofNullable((byte[])mutation.get("type")).get(), StandardCharsets.UTF_8)) {
                    case "SetCell": {
                        Mutation.SetCell.Builder setMutation = Mutation.SetCell.newBuilder().setValue(ByteString.copyFrom((byte[])Optional.ofNullable((byte[])mutation.get("value")).get())).setColumnQualifier(ByteString.copyFrom((byte[])Optional.ofNullable((byte[])mutation.get("column_qualifier")).get())).setFamilyNameBytes(ByteString.copyFrom((byte[])Optional.ofNullable((byte[])mutation.get("family_name")).get())).setTimestampMicros(mutation.containsKey("timestamp_micros") ? Longs.fromByteArray((byte[])Optional.ofNullable((byte[])mutation.get("timestamp_micros")).get()) : -1L);
                        bigtableMutation = Mutation.newBuilder().setSetCell(setMutation.build()).build();
                        break;
                    }
                    case "DeleteFromColumn": {
                        Mutation.DeleteFromColumn.Builder deleteMutation = Mutation.DeleteFromColumn.newBuilder().setColumnQualifier(ByteString.copyFrom((byte[])Optional.ofNullable((byte[])mutation.get("column_qualifier")).get())).setFamilyNameBytes(ByteString.copyFrom((byte[])Optional.ofNullable((byte[])mutation.get("family_name")).get()));
                        if (mutation.containsKey("start_timestamp_micros") || mutation.containsKey("end_timestamp_micros")) {
                            TimestampRange.Builder timeRange = TimestampRange.newBuilder();
                            if (mutation.containsKey("start_timestamp_micros")) {
                                Long startMicros = ByteBuffer.wrap(Optional.ofNullable((byte[])mutation.get("start_timestamp_micros")).get()).getLong();
                                timeRange.setStartTimestampMicros(startMicros.longValue());
                            }
                            if (mutation.containsKey("end_timestamp_micros")) {
                                Long endMicros = ByteBuffer.wrap(Optional.ofNullable((byte[])mutation.get("end_timestamp_micros")).get()).getLong();
                                timeRange.setEndTimestampMicros(endMicros.longValue());
                            }
                            deleteMutation.setTimeRange(timeRange.build());
                        }
                        bigtableMutation = Mutation.newBuilder().setDeleteFromColumn(deleteMutation.build()).build();
                        break;
                    }
                    case "DeleteFromFamily": {
                        bigtableMutation = Mutation.newBuilder().setDeleteFromFamily(Mutation.DeleteFromFamily.newBuilder().setFamilyNameBytes(ByteString.copyFrom((byte[])Optional.ofNullable((byte[])mutation.get("family_name")).get())).build()).build();
                        break;
                    }
                    case "DeleteFromRow": {
                        bigtableMutation = Mutation.newBuilder().setDeleteFromRow(Mutation.DeleteFromRow.newBuilder().build()).build();
                        break;
                    }
                    default: {
                        throw new RuntimeException(String.format("Unexpected mutation type [%s]: %s", Arrays.toString(Optional.ofNullable((byte[])mutation.get("type")).get()), mutation));
                    }
                }
                mutations.add(bigtableMutation);
            }
            return KV.of((Object)key, mutations);
        }
    }

    private static class BigtableWriteSchemaTransform
    extends SchemaTransform {
        private final @UnknownKeyFor @NonNull @Initialized BigtableWriteSchemaTransformConfiguration configuration;

        BigtableWriteSchemaTransform(@UnknownKeyFor @NonNull @Initialized BigtableWriteSchemaTransformConfiguration configuration) {
            configuration.validate();
            this.configuration = configuration;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((boolean)input.has(BigtableWriteSchemaTransformProvider.INPUT_TAG), (Object)String.format("Could not find expected input [%s] to %s.", BigtableWriteSchemaTransformProvider.INPUT_TAG, ((Object)((Object)this)).getClass().getSimpleName()));
            Schema inputSchema = input.getSinglePCollection().getSchema();
            PCollection<KV<ByteString, Iterable<Mutation>>> bigtableMutations = null;
            if (inputSchema.equals((Object)BATCHED_MUTATIONS_SCHEMA)) {
                PCollection beamRowMutations = input.get(BigtableWriteSchemaTransformProvider.INPUT_TAG);
                bigtableMutations = (PCollection<KV<ByteString, Iterable<Mutation>>>)beamRowMutations.apply((PTransform)MapElements.via((SimpleFunction)new GetMutationsFromBeamRow()));
            } else if (inputSchema.hasField("type")) {
                this.validateField(inputSchema, "key", Schema.TypeName.BYTES);
                this.validateField(inputSchema, "type", Schema.TypeName.STRING);
                if (inputSchema.hasField("value")) {
                    this.validateField(inputSchema, "value", Schema.TypeName.BYTES);
                }
                if (inputSchema.hasField("column_qualifier")) {
                    this.validateField(inputSchema, "column_qualifier", Schema.TypeName.BYTES);
                }
                if (inputSchema.hasField("family_name")) {
                    this.validateField(inputSchema, "family_name", Schema.TypeName.STRING);
                }
                if (inputSchema.hasField("timestamp_micros")) {
                    this.validateField(inputSchema, "timestamp_micros", Schema.TypeName.INT64);
                }
                if (inputSchema.hasField("start_timestamp_micros")) {
                    this.validateField(inputSchema, "start_timestamp_micros", Schema.TypeName.INT64);
                }
                if (inputSchema.hasField("end_timestamp_micros")) {
                    this.validateField(inputSchema, "end_timestamp_micros", Schema.TypeName.INT64);
                }
                bigtableMutations = this.changeMutationInput(input);
            } else {
                throw new RuntimeException("Input Schema is invalid: " + inputSchema + "\n\nSchema should be formatted in one of two ways:\n key\": ByteString\n\"type\": String\n\"value\": ByteString\n\"column_qualifier\": ByteString\n\"family_name\": String\n\"timestamp_micros\": Long\n\"start_timestamp_micros\": Long\n\"end_timestamp_micros\": Long\n\nOR\n\n\"key\": ByteString\n(\"mutations\", contains map(String, ByteString) of mutations in the mutation schema format");
            }
            if (bigtableMutations == null) {
                throw new RuntimeException("Inputted Schema caused mutation error, check error logs and input schema format");
            }
            bigtableMutations.apply((PTransform)BigtableIO.write().withTableId(this.configuration.getTableId()).withInstanceId(this.configuration.getInstanceId()).withProjectId(this.configuration.getProjectId()));
            return PCollectionRowTuple.empty((Pipeline)input.getPipeline());
        }

        private void validateField(@UnknownKeyFor @NonNull @Initialized Schema inputSchema, @UnknownKeyFor @NonNull @Initialized String field, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.TypeName expectedType) {
            Schema.TypeName actualType = inputSchema.getField(field).getType().getTypeName();
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((boolean)actualType.equals((Object)expectedType), (String)"Schema field '%s' should be of type %s, but was %s.", (Object)field, (Object)expectedType, (Object)actualType);
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Mutation>>> changeMutationInput(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple inputR) {
            PCollection beamRowMutationsList = inputR.getSinglePCollection();
            PCollection changedBeamRowMutationsList = (PCollection)beamRowMutationsList.apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.kvs((TypeDescriptor)TypeDescriptor.of(ByteString.class), (TypeDescriptor)TypeDescriptor.of(Mutation.class))).via((SerializableFunction & Serializable)input -> {
                Mutation bigtableMutation;
                ByteString key = ByteString.copyFrom((byte[])((byte[])Preconditions.checkStateNotNull((Object)input.getBytes("key"), (Object)"Encountered row with null 'key' property.")));
                String mutationType = input.getString("type");
                if (mutationType == null) {
                    throw new IllegalArgumentException("Mutation type cannot be null.");
                }
                switch (mutationType) {
                    case "SetCell": {
                        Mutation.SetCell.Builder setMutation = Mutation.SetCell.newBuilder().setValue(ByteString.copyFrom((byte[])((byte[])Preconditions.checkStateNotNull((Object)input.getBytes("value"), (Object)"Encountered SetCell mutation with null 'value' property.")))).setColumnQualifier(ByteString.copyFrom((byte[])((byte[])Preconditions.checkStateNotNull((Object)input.getBytes("column_qualifier"), (Object)"Encountered SetCell mutation with null 'column_qualifier' property. ")))).setFamilyName((String)Preconditions.checkStateNotNull((Object)input.getString("family_name"), (Object)"Encountered SetCell mutation with null 'family_name' property."));
                        Long timestampMicros = input.getInt64("timestamp_micros");
                        setMutation.setTimestampMicros(timestampMicros != null ? timestampMicros : -1L);
                        bigtableMutation = Mutation.newBuilder().setSetCell(setMutation.build()).build();
                        break;
                    }
                    case "DeleteFromColumn": {
                        Mutation.DeleteFromColumn.Builder deleteMutation = Mutation.DeleteFromColumn.newBuilder().setColumnQualifier(ByteString.copyFrom((byte[])((byte[])Preconditions.checkStateNotNull((Object)input.getBytes("column_qualifier"), (Object)"Encountered DeleteFromColumn mutation with null 'column_qualifier' property.")))).setFamilyName((String)Preconditions.checkStateNotNull((Object)input.getString("family_name"), (Object)"Encountered DeleteFromColumn mutation with null 'family_name' property."));
                        Long startTimestampMicros = null;
                        Long endTimestampMicros = null;
                        if (input.getSchema().hasField("start_timestamp_micros")) {
                            startTimestampMicros = input.getInt64("start_timestamp_micros");
                        }
                        if (input.getSchema().hasField("end_timestamp_micros")) {
                            endTimestampMicros = input.getInt64("end_timestamp_micros");
                        }
                        if (startTimestampMicros != null || endTimestampMicros != null) {
                            TimestampRange.Builder timeRange = TimestampRange.newBuilder();
                            if (startTimestampMicros != null) {
                                timeRange.setStartTimestampMicros(startTimestampMicros.longValue());
                            }
                            if (endTimestampMicros != null) {
                                timeRange.setEndTimestampMicros(endTimestampMicros.longValue());
                            }
                            deleteMutation.setTimeRange(timeRange.build());
                        }
                        bigtableMutation = Mutation.newBuilder().setDeleteFromColumn(deleteMutation.build()).build();
                        break;
                    }
                    case "DeleteFromFamily": {
                        bigtableMutation = Mutation.newBuilder().setDeleteFromFamily(Mutation.DeleteFromFamily.newBuilder().setFamilyName((String)Preconditions.checkStateNotNull((Object)input.getString("family_name"), (Object)"Encountered DeleteFromFamily mutation with null 'family_name' property.")).build()).build();
                        break;
                    }
                    case "DeleteFromRow": {
                        bigtableMutation = Mutation.newBuilder().setDeleteFromRow(Mutation.DeleteFromRow.newBuilder().build()).build();
                        break;
                    }
                    default: {
                        throw new RuntimeException(String.format("Unexpected mutation type [%s]: Key value is %s", input.getString("type"), Arrays.toString(input.getBytes("key"))));
                    }
                }
                return KV.of((Object)key, (Object)bigtableMutation);
            }));
            return (PCollection)changedBeamRowMutationsList.apply((PTransform)GroupByKey.create());
        }
    }

    @DefaultSchema(value=AutoValueSchema.class)
    @AutoValue
    public static abstract class BigtableWriteSchemaTransformConfiguration {
        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_BigtableWriteSchemaTransformProvider_BigtableWriteSchemaTransformConfiguration.Builder();
        }

        public void validate() {
            String invalidConfigMessage = "Invalid Bigtable Write configuration: %s should be a non-empty String";
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((!this.getTableId().isEmpty() ? 1 : 0) != 0, (Object)String.format(invalidConfigMessage, "table"));
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((!this.getInstanceId().isEmpty() ? 1 : 0) != 0, (Object)String.format(invalidConfigMessage, "instance"));
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((!this.getProjectId().isEmpty() ? 1 : 0) != 0, (Object)String.format(invalidConfigMessage, "project"));
        }

        public abstract @UnknownKeyFor @NonNull @Initialized String getTableId();

        public abstract @UnknownKeyFor @NonNull @Initialized String getInstanceId();

        public abstract @UnknownKeyFor @NonNull @Initialized String getProjectId();

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setTableId(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setInstanceId(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setProjectId(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized BigtableWriteSchemaTransformConfiguration build();
        }
    }
}

