/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableCell;
import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.bigquery.storage.v1.BigDecimalByteStringEncoder;
import com.google.cloud.bigquery.storage.v1.TableFieldSchema;
import com.google.cloud.bigquery.storage.v1.TableSchema;
import com.google.protobuf.ByteString;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.beam.sdk.io.gcp.bigquery.CivilTimeEncoder;
import org.apache.beam.sdk.io.gcp.bigquery.Mode;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiCDC;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.BaseEncoding;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Days;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;

public class TableRowToStorageApiProto {
    private static final @UnknownKeyFor @NonNull @Initialized DateTimeFormatter DATETIME_SPACE_FORMATTER = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().appendLiteral(' ').optionalEnd().optionalStart().appendLiteral('T').optionalEnd().append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter().withZone(ZoneOffset.UTC);
    private static final @UnknownKeyFor @NonNull @Initialized DateTimeFormatter TIMESTAMP_FORMATTER = new DateTimeFormatterBuilder().append(DATETIME_SPACE_FORMATTER).optionalStart().appendOffsetId().optionalEnd().optionalStart().appendOffset("+HH:mm", "+00:00").optionalEnd().optionalStart().appendLiteral(' ').parseCaseSensitive().appendZoneRegionId().toFormatter();
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Mode, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TableFieldSchema.Mode> MODE_MAP_JSON_PROTO = ImmutableMap.of((Object)((Object)Mode.NULLABLE), (Object)TableFieldSchema.Mode.NULLABLE, (Object)((Object)Mode.REQUIRED), (Object)TableFieldSchema.Mode.REQUIRED, (Object)((Object)Mode.REPEATED), (Object)TableFieldSchema.Mode.REPEATED);
    private static final @UnknownKeyFor @NonNull @Initialized Map<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TableFieldSchema.Mode, @UnknownKeyFor @NonNull @Initialized String> MODE_MAP_PROTO_JSON = ImmutableMap.of((Object)TableFieldSchema.Mode.NULLABLE, (Object)"NULLABLE", (Object)TableFieldSchema.Mode.REQUIRED, (Object)"REQUIRED", (Object)TableFieldSchema.Mode.REPEATED, (Object)"REPEATED");
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TableFieldSchema.Type> TYPE_MAP_JSON_PROTO = ImmutableMap.builder().put((Object)"STRUCT", (Object)TableFieldSchema.Type.STRUCT).put((Object)"RECORD", (Object)TableFieldSchema.Type.STRUCT).put((Object)"INT64", (Object)TableFieldSchema.Type.INT64).put((Object)"INTEGER", (Object)TableFieldSchema.Type.INT64).put((Object)"FLOAT64", (Object)TableFieldSchema.Type.DOUBLE).put((Object)"FLOAT", (Object)TableFieldSchema.Type.DOUBLE).put((Object)"STRING", (Object)TableFieldSchema.Type.STRING).put((Object)"BOOL", (Object)TableFieldSchema.Type.BOOL).put((Object)"BOOLEAN", (Object)TableFieldSchema.Type.BOOL).put((Object)"BYTES", (Object)TableFieldSchema.Type.BYTES).put((Object)"NUMERIC", (Object)TableFieldSchema.Type.NUMERIC).put((Object)"BIGNUMERIC", (Object)TableFieldSchema.Type.BIGNUMERIC).put((Object)"GEOGRAPHY", (Object)TableFieldSchema.Type.GEOGRAPHY).put((Object)"DATE", (Object)TableFieldSchema.Type.DATE).put((Object)"TIME", (Object)TableFieldSchema.Type.TIME).put((Object)"DATETIME", (Object)TableFieldSchema.Type.DATETIME).put((Object)"TIMESTAMP", (Object)TableFieldSchema.Type.TIMESTAMP).put((Object)"JSON", (Object)TableFieldSchema.Type.JSON).build();
    private static final @UnknownKeyFor @NonNull @Initialized Map<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TableFieldSchema.Type, @UnknownKeyFor @NonNull @Initialized String> TYPE_MAP_PROTO_JSON = ImmutableMap.builder().put((Object)TableFieldSchema.Type.STRUCT, (Object)"STRUCT").put((Object)TableFieldSchema.Type.INT64, (Object)"INT64").put((Object)TableFieldSchema.Type.DOUBLE, (Object)"FLOAT64").put((Object)TableFieldSchema.Type.STRING, (Object)"STRING").put((Object)TableFieldSchema.Type.BOOL, (Object)"BOOL").put((Object)TableFieldSchema.Type.BYTES, (Object)"BYTES").put((Object)TableFieldSchema.Type.NUMERIC, (Object)"NUMERIC").put((Object)TableFieldSchema.Type.BIGNUMERIC, (Object)"BIGNUMERIC").put((Object)TableFieldSchema.Type.GEOGRAPHY, (Object)"GEOGRAPHY").put((Object)TableFieldSchema.Type.DATE, (Object)"DATE").put((Object)TableFieldSchema.Type.TIME, (Object)"TIME").put((Object)TableFieldSchema.Type.DATETIME, (Object)"DATETIME").put((Object)TableFieldSchema.Type.TIMESTAMP, (Object)"TIMESTAMP").put((Object)TableFieldSchema.Type.JSON, (Object)"JSON").build();
    static final @UnknownKeyFor @NonNull @Initialized Map<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TableFieldSchema.Type, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DescriptorProtos.FieldDescriptorProto.Type> PRIMITIVE_TYPES_BQ_TO_PROTO = ImmutableMap.builder().put((Object)TableFieldSchema.Type.INT64, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).put((Object)TableFieldSchema.Type.DOUBLE, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_DOUBLE).put((Object)TableFieldSchema.Type.STRING, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).put((Object)TableFieldSchema.Type.BOOL, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_BOOL).put((Object)TableFieldSchema.Type.BYTES, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES).put((Object)TableFieldSchema.Type.NUMERIC, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES).put((Object)TableFieldSchema.Type.BIGNUMERIC, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES).put((Object)TableFieldSchema.Type.GEOGRAPHY, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).put((Object)TableFieldSchema.Type.DATE, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32).put((Object)TableFieldSchema.Type.TIME, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).put((Object)TableFieldSchema.Type.DATETIME, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).put((Object)TableFieldSchema.Type.TIMESTAMP, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).put((Object)TableFieldSchema.Type.JSON, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).build();
    static final @UnknownKeyFor @NonNull @Initialized Map<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.FieldDescriptor.Type, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TableFieldSchema.Type> PRIMITIVE_TYPES_PROTO_TO_BQ = ImmutableMap.builder().put((Object)Descriptors.FieldDescriptor.Type.INT32, (Object)TableFieldSchema.Type.INT64).put((Object)Descriptors.FieldDescriptor.Type.FIXED32, (Object)TableFieldSchema.Type.INT64).put((Object)Descriptors.FieldDescriptor.Type.UINT32, (Object)TableFieldSchema.Type.INT64).put((Object)Descriptors.FieldDescriptor.Type.SFIXED32, (Object)TableFieldSchema.Type.INT64).put((Object)Descriptors.FieldDescriptor.Type.SINT32, (Object)TableFieldSchema.Type.INT64).put((Object)Descriptors.FieldDescriptor.Type.INT64, (Object)TableFieldSchema.Type.INT64).put((Object)Descriptors.FieldDescriptor.Type.FIXED64, (Object)TableFieldSchema.Type.NUMERIC).put((Object)Descriptors.FieldDescriptor.Type.UINT64, (Object)TableFieldSchema.Type.NUMERIC).put((Object)Descriptors.FieldDescriptor.Type.SFIXED64, (Object)TableFieldSchema.Type.INT64).put((Object)Descriptors.FieldDescriptor.Type.SINT64, (Object)TableFieldSchema.Type.INT64).put((Object)Descriptors.FieldDescriptor.Type.DOUBLE, (Object)TableFieldSchema.Type.DOUBLE).put((Object)Descriptors.FieldDescriptor.Type.FLOAT, (Object)TableFieldSchema.Type.DOUBLE).put((Object)Descriptors.FieldDescriptor.Type.STRING, (Object)TableFieldSchema.Type.STRING).put((Object)Descriptors.FieldDescriptor.Type.BOOL, (Object)TableFieldSchema.Type.BOOL).put((Object)Descriptors.FieldDescriptor.Type.BYTES, (Object)TableFieldSchema.Type.BYTES).build();

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TableFieldSchema.Mode modeToProtoMode(@Nullable @UnknownKeyFor @Initialized String defaultValueExpression, @UnknownKeyFor @NonNull @Initialized String mode) {
        TableFieldSchema.Mode resultMode = Optional.ofNullable(mode).map(Mode::valueOf).map(MODE_MAP_JSON_PROTO::get).orElse(TableFieldSchema.Mode.NULLABLE);
        if (defaultValueExpression == null) {
            return resultMode;
        }
        return resultMode.equals((Object)TableFieldSchema.Mode.REPEATED) ? resultMode : TableFieldSchema.Mode.NULLABLE;
    }

    public static @UnknownKeyFor @NonNull @Initialized String protoModeToJsonMode(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TableFieldSchema.Mode protoMode) {
        String jsonMode = MODE_MAP_PROTO_JSON.get(protoMode);
        if (jsonMode == null) {
            throw new RuntimeException("Unknown mode " + protoMode);
        }
        return jsonMode;
    }

    public static @UnknownKeyFor @NonNull @Initialized String protoTypeToJsonType(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TableFieldSchema.Type protoType) {
        String type = TYPE_MAP_PROTO_JSON.get(protoType);
        if (type == null) {
            throw new RuntimeException("Unknown type " + protoType);
        }
        return type;
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TableFieldSchema.Type typeToProtoType(@UnknownKeyFor @NonNull @Initialized String type) {
        TableFieldSchema.Type protoType = TYPE_MAP_JSON_PROTO.get(type);
        if (protoType == null) {
            throw new RuntimeException("Unknown type " + type);
        }
        return protoType;
    }

    public static @UnknownKeyFor @NonNull @Initialized TableSchema protoSchemaToTableSchema(@UnknownKeyFor @NonNull @Initialized com.google.cloud.bigquery.storage.v1.TableSchema protoTableSchema) {
        TableSchema tableSchema = new TableSchema();
        ArrayList tableFields = Lists.newArrayListWithExpectedSize((int)protoTableSchema.getFieldsCount());
        for (com.google.cloud.bigquery.storage.v1.TableFieldSchema protoTableField : protoTableSchema.getFieldsList()) {
            tableFields.add(TableRowToStorageApiProto.protoTableFieldToTableField(protoTableField));
        }
        return tableSchema.setFields((List)tableFields);
    }

    public static @UnknownKeyFor @NonNull @Initialized TableFieldSchema protoTableFieldToTableField(@UnknownKeyFor @NonNull @Initialized com.google.cloud.bigquery.storage.v1.TableFieldSchema protoTableField) {
        TableFieldSchema tableField = new TableFieldSchema();
        if (!Strings.isNullOrEmpty((String)(tableField = tableField.setName(protoTableField.getName())).getDescription())) {
            tableField = tableField.setDescription(protoTableField.getDescription());
        }
        if (protoTableField.getMaxLength() != 0L) {
            tableField = tableField.setMaxLength(Long.valueOf(protoTableField.getMaxLength()));
        }
        if (protoTableField.getMode() != TableFieldSchema.Mode.MODE_UNSPECIFIED) {
            tableField = tableField.setMode(TableRowToStorageApiProto.protoModeToJsonMode(protoTableField.getMode()));
        }
        if (protoTableField.getPrecision() != 0L) {
            tableField = tableField.setPrecision(Long.valueOf(protoTableField.getPrecision()));
        }
        if (protoTableField.getScale() != 0L) {
            tableField = tableField.setScale(Long.valueOf(protoTableField.getScale()));
        }
        tableField = tableField.setType(TableRowToStorageApiProto.protoTypeToJsonType(protoTableField.getType()));
        if (protoTableField.getType().equals((Object)TableFieldSchema.Type.STRUCT)) {
            ArrayList subFields = Lists.newArrayListWithExpectedSize((int)protoTableField.getFieldsCount());
            for (com.google.cloud.bigquery.storage.v1.TableFieldSchema subField : protoTableField.getFieldsList()) {
                subFields.add(TableRowToStorageApiProto.protoTableFieldToTableField(subField));
            }
            tableField = tableField.setFields((List)subFields);
        }
        return tableField;
    }

    public static @UnknownKeyFor @NonNull @Initialized com.google.cloud.bigquery.storage.v1.TableSchema schemaToProtoTableSchema(@UnknownKeyFor @NonNull @Initialized TableSchema tableSchema) {
        TableSchema.Builder builder = com.google.cloud.bigquery.storage.v1.TableSchema.newBuilder();
        if (tableSchema.getFields() != null) {
            for (TableFieldSchema field : tableSchema.getFields()) {
                builder.addFields(TableRowToStorageApiProto.tableFieldToProtoTableField(field));
            }
        }
        return builder.build();
    }

    public static @UnknownKeyFor @NonNull @Initialized com.google.cloud.bigquery.storage.v1.TableFieldSchema tableFieldToProtoTableField(@UnknownKeyFor @NonNull @Initialized TableFieldSchema field) {
        TableFieldSchema.Builder builder = com.google.cloud.bigquery.storage.v1.TableFieldSchema.newBuilder();
        builder.setName(field.getName().toLowerCase());
        if (field.getDescription() != null) {
            builder.setDescription(field.getDescription());
        }
        if (field.getMaxLength() != null) {
            builder.setMaxLength(field.getMaxLength().longValue());
        }
        builder.setMode(TableRowToStorageApiProto.modeToProtoMode(field.getDefaultValueExpression(), field.getMode()));
        if (field.getPrecision() != null) {
            builder.setPrecision(field.getPrecision().longValue());
        }
        if (field.getScale() != null) {
            builder.setScale(field.getScale().longValue());
        }
        builder.setType(TableRowToStorageApiProto.typeToProtoType(field.getType()));
        if (builder.getType().equals((Object)TableFieldSchema.Type.STRUCT)) {
            for (TableFieldSchema subField : field.getFields()) {
                builder.addFields(TableRowToStorageApiProto.tableFieldToProtoTableField(subField));
            }
        }
        return builder.build();
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.Descriptor getDescriptorFromTableSchema(@UnknownKeyFor @NonNull @Initialized TableSchema jsonSchema, @UnknownKeyFor @NonNull @Initialized boolean respectRequired, @UnknownKeyFor @NonNull @Initialized boolean includeCdcColumns) throws // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.DescriptorValidationException {
        return TableRowToStorageApiProto.getDescriptorFromTableSchema(TableRowToStorageApiProto.schemaToProtoTableSchema(jsonSchema), respectRequired, includeCdcColumns);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.Descriptor getDescriptorFromTableSchema(@UnknownKeyFor @NonNull @Initialized com.google.cloud.bigquery.storage.v1.TableSchema tableSchema, @UnknownKeyFor @NonNull @Initialized boolean respectRequired, @UnknownKeyFor @NonNull @Initialized boolean includeCdcColumns) throws // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.DescriptorValidationException {
        return TableRowToStorageApiProto.wrapDescriptorProto(TableRowToStorageApiProto.descriptorSchemaFromTableSchema(tableSchema, respectRequired, includeCdcColumns));
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.Descriptor wrapDescriptorProto(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DescriptorProtos.DescriptorProto descriptorProto) throws // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.DescriptorValidationException {
        DescriptorProtos.FileDescriptorProto fileDescriptorProto = DescriptorProtos.FileDescriptorProto.newBuilder().addMessageType(descriptorProto).build();
        Descriptors.FileDescriptor fileDescriptor = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fileDescriptorProto, (Descriptors.FileDescriptor[])new Descriptors.FileDescriptor[0]);
        return (Descriptors.Descriptor)Iterables.getOnlyElement((Iterable)fileDescriptor.getMessageTypes());
    }

    public static @UnknownKeyFor @NonNull @Initialized DynamicMessage messageFromMap(@UnknownKeyFor @NonNull @Initialized SchemaInformation schemaInformation, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.Descriptor descriptor, @UnknownKeyFor @NonNull @Initialized AbstractMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> map, @UnknownKeyFor @NonNull @Initialized boolean ignoreUnknownValues, @UnknownKeyFor @NonNull @Initialized boolean allowMissingRequiredFields, @Nullable @UnknownKeyFor @Initialized TableRow unknownFields, @Nullable @UnknownKeyFor @Initialized String changeType, @Nullable @UnknownKeyFor @Initialized String changeSequenceNum) throws @UnknownKeyFor @NonNull @Initialized SchemaConversionException {
        DynamicMessage.Builder builder = DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey().toLowerCase();
            // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable Descriptors.FieldDescriptor fieldDescriptor = descriptor.findFieldByName(key);
            if (fieldDescriptor == null) {
                if (unknownFields != null) {
                    unknownFields.set(key, entry.getValue());
                }
                if (ignoreUnknownValues) continue;
                throw new SchemaTooNarrowException("TableRow contained unexpected field with name " + entry.getKey() + " not found in schema for " + schemaInformation.getFullName());
            }
            SchemaInformation fieldSchemaInformation = schemaInformation.getSchemaForField(entry.getKey());
            try {
                Supplier<@Nullable TableRow> getNestedUnknown = () -> {
                    if (unknownFields == null) {
                        return null;
                    }
                    TableRow nestedUnknown = new TableRow();
                    if (fieldDescriptor.isRepeated()) {
                        ((List)unknownFields.computeIfAbsent((Object)key, k -> new ArrayList())).add(nestedUnknown);
                        return nestedUnknown;
                    }
                    return (TableRow)unknownFields.computeIfAbsent((Object)key, k -> nestedUnknown);
                };
                @Nullable Object value = TableRowToStorageApiProto.messageValueFromFieldValue(fieldSchemaInformation, fieldDescriptor, entry.getValue(), ignoreUnknownValues, allowMissingRequiredFields, getNestedUnknown);
                if (value != null) {
                    builder.setField(fieldDescriptor, value);
                }
                if (!fieldSchemaInformation.getType().equals((Object)TableFieldSchema.Type.STRUCT) || unknownFields == null || (!(unknownFields.get((Object)key) instanceof Map) || !((Map)unknownFields.get((Object)key)).isEmpty()) && (!(unknownFields.get((Object)key) instanceof List) || !((List)unknownFields.get((Object)key)).isEmpty() && !((List)unknownFields.get((Object)key)).stream().allMatch(row -> row == null || ((Map)row).isEmpty()))) continue;
                unknownFields.remove((Object)key);
            }
            catch (Exception e) {
                throw new SchemaDoesntMatchException("Problem converting field " + fieldSchemaInformation.getFullName() + " expected type: " + fieldSchemaInformation.getType(), e);
            }
        }
        if (changeType != null) {
            builder.setField((Descriptors.FieldDescriptor)Preconditions.checkStateNotNull((Object)descriptor.findFieldByName("_CHANGE_TYPE")), (Object)changeType);
            builder.setField((Descriptors.FieldDescriptor)Preconditions.checkStateNotNull((Object)descriptor.findFieldByName("_CHANGE_SEQUENCE_NUMBER")), Preconditions.checkStateNotNull((Object)changeSequenceNum));
        }
        try {
            return builder.build();
        }
        catch (Exception e) {
            throw new SchemaDoesntMatchException("Couldn't convert schema for " + schemaInformation.getFullName(), e);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized DynamicMessage messageFromTableRow(@UnknownKeyFor @NonNull @Initialized SchemaInformation schemaInformation, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.Descriptor descriptor, @UnknownKeyFor @NonNull @Initialized TableRow tableRow, @UnknownKeyFor @NonNull @Initialized boolean ignoreUnknownValues, @UnknownKeyFor @NonNull @Initialized boolean allowMissingRequiredFields, @Nullable @UnknownKeyFor @Initialized TableRow unknownFields, @Nullable @UnknownKeyFor @Initialized String changeType, @UnknownKeyFor @NonNull @Initialized long changeSequenceNum) throws @UnknownKeyFor @NonNull @Initialized SchemaConversionException {
        return TableRowToStorageApiProto.messageFromTableRow(schemaInformation, descriptor, tableRow, ignoreUnknownValues, allowMissingRequiredFields, unknownFields, changeType, Long.toHexString(changeSequenceNum));
    }

    public static @UnknownKeyFor @NonNull @Initialized DynamicMessage messageFromTableRow(@UnknownKeyFor @NonNull @Initialized SchemaInformation schemaInformation, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.Descriptor descriptor, @UnknownKeyFor @NonNull @Initialized TableRow tableRow, @UnknownKeyFor @NonNull @Initialized boolean ignoreUnknownValues, @UnknownKeyFor @NonNull @Initialized boolean allowMissingRequiredFields, @Nullable @UnknownKeyFor @Initialized TableRow unknownFields, @Nullable @UnknownKeyFor @Initialized String changeType, @Nullable @UnknownKeyFor @Initialized String changeSequenceNum) throws @UnknownKeyFor @NonNull @Initialized SchemaConversionException {
        @Nullable Object fValue = tableRow.get((Object)"f");
        if (fValue instanceof List) {
            int i;
            List cells = (List)fValue;
            DynamicMessage.Builder builder = DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor);
            int cellsToProcess = cells.size();
            if (cells.size() > descriptor.getFields().size()) {
                if (ignoreUnknownValues) {
                    cellsToProcess = descriptor.getFields().size();
                } else {
                    throw new SchemaTooNarrowException("TableRow contained too many fields and ignoreUnknownValues not set in " + schemaInformation.getName());
                }
            }
            if (unknownFields != null) {
                ArrayList unknownValues = Lists.newArrayListWithExpectedSize((int)cells.size());
                for (int i2 = 0; i2 < cells.size(); ++i2) {
                    unknownValues.add(new TableCell().setV(null));
                }
                unknownFields.setF((List)unknownValues);
            }
            for (i = 0; i < cellsToProcess; ++i) {
                AbstractMap cell = (AbstractMap)cells.get(i);
                Descriptors.FieldDescriptor fieldDescriptor = (Descriptors.FieldDescriptor)descriptor.getFields().get(i);
                SchemaInformation fieldSchemaInformation = schemaInformation.getSchemaForField(i);
                try {
                    int finalIndex = i;
                    Supplier<@Nullable TableRow> getNestedUnknown = () -> {
                        TableRow localUnknownFields = (TableRow)Preconditions.checkStateNotNull((Object)unknownFields);
                        @Nullable TableRow nested = (TableRow)((TableCell)localUnknownFields.getF().get(finalIndex)).getV();
                        if (nested == null) {
                            nested = new TableRow();
                            localUnknownFields.getF().set(finalIndex, new TableCell().setV((Object)nested));
                        }
                        return nested;
                    };
                    @Nullable Object value = TableRowToStorageApiProto.messageValueFromFieldValue(fieldSchemaInformation, fieldDescriptor, cell.get("v"), ignoreUnknownValues, allowMissingRequiredFields, getNestedUnknown);
                    if (value == null) continue;
                    builder.setField(fieldDescriptor, value);
                    continue;
                }
                catch (Exception e) {
                    throw new SchemaDoesntMatchException("Problem converting field " + fieldSchemaInformation.getFullName() + " expected type: " + fieldSchemaInformation.getType(), e);
                }
            }
            if (changeType != null) {
                builder.setField((Descriptors.FieldDescriptor)Preconditions.checkStateNotNull((Object)descriptor.findFieldByName("_CHANGE_TYPE")), (Object)changeType);
                builder.setField((Descriptors.FieldDescriptor)Preconditions.checkStateNotNull((Object)descriptor.findFieldByName("_CHANGE_SEQUENCE_NUMBER")), Preconditions.checkStateNotNull((Object)changeSequenceNum));
            }
            if (unknownFields != null) {
                for (i = cellsToProcess; i < cells.size(); ++i) {
                    unknownFields.getF().set(i, new TableCell().setV(((AbstractMap)cells.get(i)).get("v")));
                }
            }
            try {
                return builder.build();
            }
            catch (Exception e) {
                throw new SchemaDoesntMatchException("Could convert schema for " + schemaInformation.getFullName(), e);
            }
        }
        return TableRowToStorageApiProto.messageFromMap(schemaInformation, descriptor, (AbstractMap<String, Object>)tableRow, ignoreUnknownValues, allowMissingRequiredFields, unknownFields, changeType, changeSequenceNum);
    }

    static @UnknownKeyFor @NonNull @Initialized com.google.cloud.bigquery.storage.v1.TableSchema tableSchemaFromDescriptor(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.Descriptor descriptor) {
        List tableFields = descriptor.getFields().stream().map(f -> TableRowToStorageApiProto.tableFieldSchemaFromDescriptorField(f)).collect(Collectors.toList());
        return com.google.cloud.bigquery.storage.v1.TableSchema.newBuilder().addAllFields(tableFields).build();
    }

    static @UnknownKeyFor @NonNull @Initialized com.google.cloud.bigquery.storage.v1.TableFieldSchema tableFieldSchemaFromDescriptorField(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.FieldDescriptor fieldDescriptor) {
        TableFieldSchema.Builder tableFieldSchemaBuilder = com.google.cloud.bigquery.storage.v1.TableFieldSchema.newBuilder();
        tableFieldSchemaBuilder = tableFieldSchemaBuilder.setName(fieldDescriptor.getName());
        switch (fieldDescriptor.getType()) {
            case MESSAGE: {
                tableFieldSchemaBuilder = tableFieldSchemaBuilder.setType(TableFieldSchema.Type.STRUCT);
                com.google.cloud.bigquery.storage.v1.TableSchema nestedTableField = TableRowToStorageApiProto.tableSchemaFromDescriptor(fieldDescriptor.getMessageType());
                tableFieldSchemaBuilder = tableFieldSchemaBuilder.addAllFields((Iterable)nestedTableField.getFieldsList());
                break;
            }
            default: {
                TableFieldSchema.Type type = PRIMITIVE_TYPES_PROTO_TO_BQ.get(fieldDescriptor.getType());
                if (type == null) {
                    throw new UnsupportedOperationException("proto type " + fieldDescriptor.getType() + " is unsupported.");
                }
                tableFieldSchemaBuilder = tableFieldSchemaBuilder.setType(type);
            }
        }
        tableFieldSchemaBuilder = fieldDescriptor.isRepeated() ? tableFieldSchemaBuilder.setMode(TableFieldSchema.Mode.REPEATED) : (fieldDescriptor.isRequired() ? tableFieldSchemaBuilder.setMode(TableFieldSchema.Mode.REQUIRED) : tableFieldSchemaBuilder.setMode(TableFieldSchema.Mode.NULLABLE));
        return tableFieldSchemaBuilder.build();
    }

    @VisibleForTesting
    static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DescriptorProtos.DescriptorProto descriptorSchemaFromTableSchema(@UnknownKeyFor @NonNull @Initialized TableSchema tableSchema, @UnknownKeyFor @NonNull @Initialized boolean respectRequired, @UnknownKeyFor @NonNull @Initialized boolean includeCdcColumns) {
        return TableRowToStorageApiProto.descriptorSchemaFromTableSchema(TableRowToStorageApiProto.schemaToProtoTableSchema(tableSchema), respectRequired, includeCdcColumns);
    }

    @VisibleForTesting
    static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DescriptorProtos.DescriptorProto descriptorSchemaFromTableSchema(@UnknownKeyFor @NonNull @Initialized com.google.cloud.bigquery.storage.v1.TableSchema tableSchema, @UnknownKeyFor @NonNull @Initialized boolean respectRequired, @UnknownKeyFor @NonNull @Initialized boolean includeCdcColumns) {
        return TableRowToStorageApiProto.descriptorSchemaFromTableFieldSchemas(tableSchema.getFieldsList(), respectRequired, includeCdcColumns);
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DescriptorProtos.DescriptorProto descriptorSchemaFromTableFieldSchemas(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized com.google.cloud.bigquery.storage.v1.TableFieldSchema> tableFieldSchemas, @UnknownKeyFor @NonNull @Initialized boolean respectRequired, @UnknownKeyFor @NonNull @Initialized boolean includeCdcColumns) {
        DescriptorProtos.DescriptorProto.Builder descriptorBuilder = DescriptorProtos.DescriptorProto.newBuilder();
        descriptorBuilder.setName("D" + UUID.randomUUID().toString().replace("-", "_"));
        int i = 1;
        for (com.google.cloud.bigquery.storage.v1.TableFieldSchema fieldSchema : tableFieldSchemas) {
            TableRowToStorageApiProto.fieldDescriptorFromTableField(fieldSchema, i++, descriptorBuilder, respectRequired);
        }
        if (includeCdcColumns) {
            DescriptorProtos.FieldDescriptorProto.Builder fieldDescriptorBuilder = DescriptorProtos.FieldDescriptorProto.newBuilder();
            fieldDescriptorBuilder = fieldDescriptorBuilder.setName("_CHANGE_TYPE");
            fieldDescriptorBuilder = fieldDescriptorBuilder.setNumber(i++);
            fieldDescriptorBuilder = fieldDescriptorBuilder.setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING);
            fieldDescriptorBuilder = fieldDescriptorBuilder.setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL);
            descriptorBuilder.addField(fieldDescriptorBuilder.build());
            fieldDescriptorBuilder = DescriptorProtos.FieldDescriptorProto.newBuilder();
            fieldDescriptorBuilder = fieldDescriptorBuilder.setName("_CHANGE_SEQUENCE_NUMBER");
            fieldDescriptorBuilder = fieldDescriptorBuilder.setNumber(i++);
            fieldDescriptorBuilder = fieldDescriptorBuilder.setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING);
            fieldDescriptorBuilder = fieldDescriptorBuilder.setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL);
            descriptorBuilder.addField(fieldDescriptorBuilder.build());
        }
        return descriptorBuilder.build();
    }

    private static void fieldDescriptorFromTableField(@UnknownKeyFor @NonNull @Initialized com.google.cloud.bigquery.storage.v1.TableFieldSchema fieldSchema, @UnknownKeyFor @NonNull @Initialized int fieldNumber, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DescriptorProtos.DescriptorProto.Builder descriptorBuilder, @UnknownKeyFor @NonNull @Initialized boolean respectRequired) {
        if (StorageApiCDC.COLUMNS.contains(fieldSchema.getName())) {
            throw new RuntimeException("Reserved field name " + fieldSchema.getName() + " in user schema.");
        }
        DescriptorProtos.FieldDescriptorProto.Builder fieldDescriptorBuilder = DescriptorProtos.FieldDescriptorProto.newBuilder();
        fieldDescriptorBuilder = fieldDescriptorBuilder.setName(fieldSchema.getName().toLowerCase());
        fieldDescriptorBuilder = fieldDescriptorBuilder.setNumber(fieldNumber);
        switch (fieldSchema.getType()) {
            case STRUCT: {
                DescriptorProtos.DescriptorProto nested = TableRowToStorageApiProto.descriptorSchemaFromTableFieldSchemas(fieldSchema.getFieldsList(), respectRequired, false);
                descriptorBuilder.addNestedType(nested);
                fieldDescriptorBuilder = fieldDescriptorBuilder.setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_MESSAGE).setTypeName(nested.getName());
                break;
            }
            default: {
                // Could not load outer class - annotation placement on inner may be incorrect
                 @Nullable DescriptorProtos.FieldDescriptorProto.Type type = PRIMITIVE_TYPES_BQ_TO_PROTO.get(fieldSchema.getType());
                if (type == null) {
                    throw new UnsupportedOperationException("Converting BigQuery type " + fieldSchema.getType() + " to Beam type is unsupported");
                }
                fieldDescriptorBuilder = fieldDescriptorBuilder.setType(type);
            }
        }
        fieldDescriptorBuilder = fieldSchema.getMode() == TableFieldSchema.Mode.REPEATED ? fieldDescriptorBuilder.setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED) : (!respectRequired || fieldSchema.getMode() != TableFieldSchema.Mode.REQUIRED ? fieldDescriptorBuilder.setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL) : fieldDescriptorBuilder.setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_REQUIRED));
        descriptorBuilder.addField(fieldDescriptorBuilder.build());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static @Nullable @UnknownKeyFor @Initialized Object messageValueFromFieldValue(@UnknownKeyFor @NonNull @Initialized SchemaInformation schemaInformation, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.FieldDescriptor fieldDescriptor, @Nullable @UnknownKeyFor @Initialized Object bqValue, @UnknownKeyFor @NonNull @Initialized boolean ignoreUnknownValues, @UnknownKeyFor @NonNull @Initialized boolean allowMissingRequiredFields, @UnknownKeyFor @NonNull @Initialized Supplier<@Nullable @UnknownKeyFor @Initialized TableRow> getUnknownNestedFields) throws @UnknownKeyFor @NonNull @Initialized SchemaConversionException {
        if (bqValue == null) {
            if (fieldDescriptor.isOptional() || allowMissingRequiredFields) {
                return null;
            }
            if (fieldDescriptor.isRepeated()) {
                return Collections.emptyList();
            }
            throw new SchemaDoesntMatchException("Received null value for non-nullable field " + schemaInformation.getFullName());
        }
        if (fieldDescriptor.isRepeated()) {
            List listValue = (List)bqValue;
            @Nullable ArrayList protoList = Lists.newArrayListWithCapacity((int)listValue.size());
            for (Object o : listValue) {
                if (o == null) continue;
                protoList.add(TableRowToStorageApiProto.singularFieldToProtoValue(schemaInformation, fieldDescriptor, o, ignoreUnknownValues, allowMissingRequiredFields, getUnknownNestedFields));
            }
            return protoList;
        }
        return TableRowToStorageApiProto.singularFieldToProtoValue(schemaInformation, fieldDescriptor, bqValue, ignoreUnknownValues, allowMissingRequiredFields, getUnknownNestedFields);
    }

    @VisibleForTesting
    static @Nullable @UnknownKeyFor @Initialized Object singularFieldToProtoValue(@UnknownKeyFor @NonNull @Initialized SchemaInformation schemaInformation, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.FieldDescriptor fieldDescriptor, @Nullable @UnknownKeyFor @Initialized Object value, @UnknownKeyFor @NonNull @Initialized boolean ignoreUnknownValues, @UnknownKeyFor @NonNull @Initialized boolean allowMissingRequiredFields, @UnknownKeyFor @NonNull @Initialized Supplier<@Nullable @UnknownKeyFor @Initialized TableRow> getUnknownNestedFields) throws @UnknownKeyFor @NonNull @Initialized SchemaConversionException {
        switch (schemaInformation.getType()) {
            case INT64: {
                if (value instanceof String) {
                    try {
                        return Long.valueOf((String)value);
                    }
                    catch (NumberFormatException e) {
                        throw new SingleValueConversionException(value, schemaInformation, e);
                    }
                }
                if (value instanceof Integer || value instanceof Long) {
                    return ((Number)value).longValue();
                }
                if (value instanceof BigDecimal) {
                    try {
                        return ((BigDecimal)value).longValueExact();
                    }
                    catch (ArithmeticException e) {
                        throw new SingleValueConversionException(value, schemaInformation, e);
                    }
                }
                if (!(value instanceof BigInteger)) break;
                try {
                    return ((BigInteger)value).longValueExact();
                }
                catch (ArithmeticException e) {
                    throw new SingleValueConversionException(value, schemaInformation, e);
                }
            }
            case DOUBLE: {
                if (value instanceof String) {
                    return Double.valueOf((String)value);
                }
                if (!(value instanceof Number)) break;
                return ((Number)value).doubleValue();
            }
            case BOOL: {
                if (value instanceof String) {
                    return Boolean.valueOf((String)value);
                }
                if (!(value instanceof Boolean)) break;
                return value;
            }
            case BYTES: {
                if (value instanceof String) {
                    return ByteString.copyFrom((byte[])BaseEncoding.base64().decode((CharSequence)((String)value)));
                }
                if (value instanceof byte[]) {
                    return ByteString.copyFrom((byte[])((byte[])value));
                }
                if (!(value instanceof ByteString)) break;
                return value;
            }
            case TIMESTAMP: {
                if (value instanceof String) {
                    try {
                        Instant timestamp = Instant.from(TIMESTAMP_FORMATTER.parse((String)value));
                        return TableRowToStorageApiProto.toEpochMicros(timestamp);
                    }
                    catch (DateTimeException e) {
                        try {
                            Instant timestamp = Instant.from(TIMESTAMP_FORMATTER.withZone(ZoneOffset.UTC).parse((String)value));
                            return TableRowToStorageApiProto.toEpochMicros(timestamp);
                        }
                        catch (DateTimeParseException err) {
                            Instant timestamp = Instant.ofEpochMilli(Long.parseLong((String)value));
                            return TableRowToStorageApiProto.toEpochMicros(timestamp);
                        }
                    }
                }
                if (value instanceof Instant) {
                    return TableRowToStorageApiProto.toEpochMicros((Instant)value);
                }
                if (value instanceof org.joda.time.Instant) {
                    return ((org.joda.time.Instant)value).getMillis() * 1000L;
                }
                if (value instanceof Integer || value instanceof Long) {
                    return ((Number)value).longValue();
                }
                if (!(value instanceof Double) && !(value instanceof Float)) break;
                return BigDecimal.valueOf(((Number)value).doubleValue()).scaleByPowerOfTen(6).setScale(0, RoundingMode.HALF_UP).longValue();
            }
            case DATE: {
                if (value instanceof String) {
                    return Long.valueOf(LocalDate.parse((String)value).toEpochDay()).intValue();
                }
                if (value instanceof LocalDate) {
                    return Long.valueOf(((LocalDate)value).toEpochDay()).intValue();
                }
                if (value instanceof org.joda.time.LocalDate) {
                    return Days.daysBetween((ReadablePartial)org.joda.time.Instant.EPOCH.toDateTime().toLocalDate(), (ReadablePartial)((org.joda.time.LocalDate)value)).getDays();
                }
                if (!(value instanceof Integer) && !(value instanceof Long)) break;
                return ((Number)value).intValue();
            }
            case NUMERIC: {
                if (value instanceof String) {
                    return BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal((String)value));
                }
                if (value instanceof BigDecimal) {
                    return BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)((BigDecimal)value));
                }
                if (value instanceof Double || value instanceof Float) {
                    return BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)BigDecimal.valueOf(((Number)value).doubleValue()));
                }
                if (!(value instanceof Short) && !(value instanceof Integer) && !(value instanceof Long)) break;
                return BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)BigDecimal.valueOf(((Number)value).longValue()));
            }
            case BIGNUMERIC: {
                if (value instanceof String) {
                    return BigDecimalByteStringEncoder.encodeToBigNumericByteString((BigDecimal)new BigDecimal((String)value));
                }
                if (value instanceof BigDecimal) {
                    return BigDecimalByteStringEncoder.encodeToBigNumericByteString((BigDecimal)((BigDecimal)value));
                }
                if (value instanceof Double || value instanceof Float) {
                    return BigDecimalByteStringEncoder.encodeToBigNumericByteString((BigDecimal)BigDecimal.valueOf(((Number)value).doubleValue()));
                }
                if (!(value instanceof Short) && !(value instanceof Integer) && !(value instanceof Long)) break;
                return BigDecimalByteStringEncoder.encodeToBigNumericByteString((BigDecimal)BigDecimal.valueOf(((Number)value).longValue()));
            }
            case DATETIME: {
                if (value instanceof String) {
                    try {
                        return CivilTimeEncoder.encodePacked64DatetimeMicros(LocalDateTime.parse((String)value));
                    }
                    catch (DateTimeParseException e2) {
                        return CivilTimeEncoder.encodePacked64DatetimeMicros(LocalDateTime.parse((String)value, DATETIME_SPACE_FORMATTER));
                    }
                }
                if (value instanceof Number) {
                    return ((Number)value).longValue();
                }
                if (value instanceof LocalDateTime) {
                    return CivilTimeEncoder.encodePacked64DatetimeMicros((LocalDateTime)value);
                }
                if (!(value instanceof org.joda.time.LocalDateTime)) break;
                return CivilTimeEncoder.encodePacked64DatetimeMicros((org.joda.time.LocalDateTime)value);
            }
            case TIME: {
                if (value instanceof String) {
                    return CivilTimeEncoder.encodePacked64TimeMicros(java.time.LocalTime.parse((String)value));
                }
                if (value instanceof Number) {
                    return ((Number)value).longValue();
                }
                if (value instanceof java.time.LocalTime) {
                    return CivilTimeEncoder.encodePacked64TimeMicros((java.time.LocalTime)value);
                }
                if (!(value instanceof LocalTime)) break;
                return CivilTimeEncoder.encodePacked64TimeMicros((LocalTime)value);
            }
            case STRING: 
            case JSON: 
            case GEOGRAPHY: {
                return Preconditions.checkArgumentNotNull((Object)value).toString();
            }
            case STRUCT: {
                if (value instanceof TableRow) {
                    TableRow tableRow = (TableRow)value;
                    return TableRowToStorageApiProto.messageFromTableRow(schemaInformation, fieldDescriptor.getMessageType(), tableRow, ignoreUnknownValues, allowMissingRequiredFields, getUnknownNestedFields.get(), null, null);
                }
                if (!(value instanceof AbstractMap)) break;
                AbstractMap map = (AbstractMap)value;
                return TableRowToStorageApiProto.messageFromMap(schemaInformation, fieldDescriptor.getMessageType(), map, ignoreUnknownValues, allowMissingRequiredFields, getUnknownNestedFields.get(), null, null);
            }
            default: {
                throw new RuntimeException("Unknown type " + schemaInformation.getType());
            }
        }
        throw new SchemaDoesntMatchException("Unexpected value: " + value + ", type: " + (value == null ? "null" : value.getClass()) + ". Table field name: " + schemaInformation.getFullName() + ", type: " + schemaInformation.getType());
    }

    private static @UnknownKeyFor @NonNull @Initialized long toEpochMicros(@UnknownKeyFor @NonNull @Initialized Instant timestamp) {
        return timestamp.getEpochSecond() * 1000000L + (long)(timestamp.getNano() / 1000);
    }

    @VisibleForTesting
    public static @UnknownKeyFor @NonNull @Initialized TableRow tableRowFromMessage(@UnknownKeyFor @NonNull @Initialized Message message, @UnknownKeyFor @NonNull @Initialized boolean includeCdcColumns, @UnknownKeyFor @NonNull @Initialized Predicate<@UnknownKeyFor @NonNull @Initialized String> includeField) {
        return TableRowToStorageApiProto.tableRowFromMessage(message, includeCdcColumns, includeField, "");
    }

    public static @UnknownKeyFor @NonNull @Initialized TableRow tableRowFromMessage(@UnknownKeyFor @NonNull @Initialized Message message, @UnknownKeyFor @NonNull @Initialized boolean includeCdcColumns, @UnknownKeyFor @NonNull @Initialized Predicate<@UnknownKeyFor @NonNull @Initialized String> includeField, @UnknownKeyFor @NonNull @Initialized String namePrefix) {
        TableRow tableRow = new TableRow();
        for (Map.Entry field : message.getAllFields().entrySet()) {
            StringBuilder fullName = new StringBuilder();
            Descriptors.FieldDescriptor fieldDescriptor = (Descriptors.FieldDescriptor)field.getKey();
            fullName = fullName.append(namePrefix).append(fieldDescriptor.getName());
            Object fieldValue = field.getValue();
            if (!includeCdcColumns && StorageApiCDC.COLUMNS.contains(fullName.toString()) || !includeField.test(fieldDescriptor.getName())) continue;
            tableRow.put(fieldDescriptor.getName(), TableRowToStorageApiProto.jsonValueFromMessageValue(fieldDescriptor, fieldValue, true, includeField, fullName.append(".").toString()));
        }
        return tableRow;
    }

    public static @UnknownKeyFor @NonNull @Initialized Object jsonValueFromMessageValue(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.FieldDescriptor fieldDescriptor, @UnknownKeyFor @NonNull @Initialized Object fieldValue, @UnknownKeyFor @NonNull @Initialized boolean expandRepeated, @UnknownKeyFor @NonNull @Initialized Predicate<@UnknownKeyFor @NonNull @Initialized String> includeField, @UnknownKeyFor @NonNull @Initialized String prefix) {
        if (expandRepeated && fieldDescriptor.isRepeated()) {
            List valueList = (List)fieldValue;
            return valueList.stream().map(v -> TableRowToStorageApiProto.jsonValueFromMessageValue(fieldDescriptor, v, false, includeField, prefix)).collect(Collectors.toList());
        }
        switch (fieldDescriptor.getType()) {
            case MESSAGE: 
            case GROUP: {
                return TableRowToStorageApiProto.tableRowFromMessage((Message)fieldValue, false, includeField, prefix);
            }
            case BYTES: {
                return BaseEncoding.base64().encode(((ByteString)fieldValue).toByteArray());
            }
            case ENUM: {
                throw new RuntimeException("Enumerations not supported");
            }
            case INT32: 
            case FLOAT: 
            case BOOL: 
            case DOUBLE: {
                return fieldValue;
            }
        }
        return fieldValue.toString();
    }

    static class SchemaInformation {
        private final @UnknownKeyFor @NonNull @Initialized com.google.cloud.bigquery.storage.v1.TableFieldSchema tableFieldSchema;
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SchemaInformation> subFields;
        private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized SchemaInformation> subFieldsByName;
        private final @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized SchemaInformation> parentSchemas;

        private SchemaInformation(@UnknownKeyFor @NonNull @Initialized com.google.cloud.bigquery.storage.v1.TableFieldSchema tableFieldSchema, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized SchemaInformation> parentSchemas) {
            this.tableFieldSchema = tableFieldSchema;
            this.subFields = Lists.newArrayList();
            this.subFieldsByName = Maps.newHashMap();
            this.parentSchemas = parentSchemas;
            for (com.google.cloud.bigquery.storage.v1.TableFieldSchema field : tableFieldSchema.getFieldsList()) {
                SchemaInformation schemaInformation = new SchemaInformation(field, Iterables.concat(this.parentSchemas, (Iterable)ImmutableList.of((Object)this)));
                this.subFields.add(schemaInformation);
                this.subFieldsByName.put(field.getName().toLowerCase(), schemaInformation);
            }
        }

        public @UnknownKeyFor @NonNull @Initialized String getFullName() {
            String prefix = StreamSupport.stream(this.parentSchemas.spliterator(), false).map(SchemaInformation::getName).collect(Collectors.joining("."));
            return prefix.isEmpty() ? this.getName() : prefix + "." + this.getName();
        }

        public @UnknownKeyFor @NonNull @Initialized String getName() {
            return this.tableFieldSchema.getName();
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized TableFieldSchema.Type getType() {
            return this.tableFieldSchema.getType();
        }

        public @UnknownKeyFor @NonNull @Initialized SchemaInformation getSchemaForField(@UnknownKeyFor @NonNull @Initialized String name) {
            SchemaInformation schemaInformation = this.subFieldsByName.get(name.toLowerCase());
            if (schemaInformation == null) {
                throw new RuntimeException("Schema field not found: " + name.toLowerCase());
            }
            return schemaInformation;
        }

        public @UnknownKeyFor @NonNull @Initialized SchemaInformation getSchemaForField(@UnknownKeyFor @NonNull @Initialized int i) {
            SchemaInformation schemaInformation = this.subFields.get(i);
            if (schemaInformation == null) {
                throw new RuntimeException("Schema field not found: " + i);
            }
            return schemaInformation;
        }

        static @UnknownKeyFor @NonNull @Initialized SchemaInformation fromTableSchema(@UnknownKeyFor @NonNull @Initialized com.google.cloud.bigquery.storage.v1.TableSchema tableSchema) {
            com.google.cloud.bigquery.storage.v1.TableFieldSchema root = com.google.cloud.bigquery.storage.v1.TableFieldSchema.newBuilder().addAllFields((Iterable)tableSchema.getFieldsList()).setName("root").build();
            return new SchemaInformation(root, Collections.emptyList());
        }

        static @UnknownKeyFor @NonNull @Initialized SchemaInformation fromTableSchema(@UnknownKeyFor @NonNull @Initialized TableSchema jsonTableSchema) {
            return SchemaInformation.fromTableSchema(TableRowToStorageApiProto.schemaToProtoTableSchema(jsonTableSchema));
        }
    }

    public static class SingleValueConversionException
    extends SchemaConversionException {
        SingleValueConversionException(@UnknownKeyFor @NonNull @Initialized Object sourceValue, @UnknownKeyFor @NonNull @Initialized SchemaInformation schema, @UnknownKeyFor @NonNull @Initialized Exception e) {
            super("Column: " + SingleValueConversionException.getPrettyFieldName(schema) + " (" + schema.getType() + "). Value: " + sourceValue + " (" + sourceValue.getClass().getName() + "). Reason: " + e);
        }

        private static @UnknownKeyFor @NonNull @Initialized String getPrettyFieldName(@UnknownKeyFor @NonNull @Initialized SchemaInformation schema) {
            String rootPrefix;
            String fullName = schema.getFullName();
            return fullName.startsWith(rootPrefix = "root.") ? fullName.substring(rootPrefix.length()) : fullName;
        }
    }

    public static class SchemaDoesntMatchException
    extends SchemaConversionException {
        SchemaDoesntMatchException(@UnknownKeyFor @NonNull @Initialized String msg) {
            super(msg);
        }

        SchemaDoesntMatchException(@UnknownKeyFor @NonNull @Initialized String msg, @UnknownKeyFor @NonNull @Initialized Exception e) {
            super(msg + ". Exception: " + e, e);
        }
    }

    public static class SchemaTooNarrowException
    extends SchemaConversionException {
        SchemaTooNarrowException(@UnknownKeyFor @NonNull @Initialized String msg) {
            super(msg);
        }
    }

    static abstract class SchemaConversionException
    extends Exception {
        SchemaConversionException(@UnknownKeyFor @NonNull @Initialized String msg) {
            super(msg);
        }

        SchemaConversionException(@UnknownKeyFor @NonNull @Initialized String msg, @UnknownKeyFor @NonNull @Initialized Exception e) {
            super(msg, e);
        }
    }
}

