/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery.providers;

import com.google.auto.service.AutoService;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.io.gcp.bigquery.providers.BigQueryWriteConfiguration;
import org.apache.beam.sdk.io.gcp.bigquery.providers.PortableBigQueryDestinations;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
@AutoService(value={SchemaTransformProvider.class})
public class BigQueryFileLoadsSchemaTransformProvider
extends TypedSchemaTransformProvider<BigQueryWriteConfiguration> {
    static final @UnknownKeyFor @NonNull @Initialized String INPUT_TAG = "input";

    protected @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized BigQueryWriteConfiguration configuration) {
        return new BigQueryFileLoadsSchemaTransform(configuration);
    }

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "beam:schematransform:org.apache.beam:bigquery_fileloads:v1";
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputCollectionNames() {
        return Collections.singletonList(INPUT_TAG);
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> outputCollectionNames() {
        return Collections.emptyList();
    }

    public static class BigQueryFileLoadsSchemaTransform
    extends SchemaTransform {
        private @UnknownKeyFor @NonNull @Initialized BigQueryServices testBigQueryServices = null;
        private final @UnknownKeyFor @NonNull @Initialized BigQueryWriteConfiguration configuration;

        BigQueryFileLoadsSchemaTransform(@UnknownKeyFor @NonNull @Initialized BigQueryWriteConfiguration configuration) {
            configuration.validate();
            this.configuration = configuration;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
            PCollection rowPCollection = input.getSinglePCollection();
            BigQueryIO.Write<Row> write = this.toWrite(rowPCollection.getSchema(), input.getPipeline().getOptions());
            rowPCollection.apply(write);
            return PCollectionRowTuple.empty((Pipeline)input.getPipeline());
        }

        @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write<@UnknownKeyFor @NonNull @Initialized Row> toWrite(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            PortableBigQueryDestinations dynamicDestinations = new PortableBigQueryDestinations(schema, this.configuration);
            BigQueryIO.Write<Row> write = BigQueryIO.write().to(dynamicDestinations).withMethod(BigQueryIO.Write.Method.FILE_LOADS).withFormatFunction(BigQueryUtils.toTableRow()).withCustomGcsTempLocation((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)options.getTempLocation())).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_APPEND).withFormatFunction(dynamicDestinations.getFilterFormatFunction(false));
            if (!Strings.isNullOrEmpty((String)this.configuration.getCreateDisposition())) {
                BigQueryIO.Write.CreateDisposition createDisposition = BigQueryIO.Write.CreateDisposition.valueOf(this.configuration.getCreateDisposition().toUpperCase());
                write = write.withCreateDisposition(createDisposition);
            }
            if (!Strings.isNullOrEmpty((String)this.configuration.getWriteDisposition())) {
                BigQueryIO.Write.WriteDisposition writeDisposition = BigQueryIO.Write.WriteDisposition.valueOf(this.configuration.getWriteDisposition().toUpperCase());
                write = write.withWriteDisposition(writeDisposition);
            }
            if (!Strings.isNullOrEmpty((String)this.configuration.getKmsKey())) {
                write = write.withKmsKey(this.configuration.getKmsKey());
            }
            if (this.testBigQueryServices != null) {
                write = write.withTestServices(this.testBigQueryServices);
            }
            return write;
        }

        @VisibleForTesting
        void setTestBigQueryServices(@UnknownKeyFor @NonNull @Initialized BigQueryServices testBigQueryServices) {
            this.testBigQueryServices = testBigQueryServices;
        }
    }
}

