/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery.providers;

import com.google.api.services.bigquery.model.TableRow;
import com.google.auto.service.AutoService;
import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.beam.model.pipeline.v1.ExternalTransforms;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.io.gcp.bigquery.providers.AutoValue_BigQueryDirectReadSchemaTransformProvider_BigQueryDirectReadSchemaTransformConfiguration;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.NoSuchSchemaException;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaRegistry;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.construction.BeamUrns;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.ProtocolMessageEnum;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoService(value={SchemaTransformProvider.class})
public class BigQueryDirectReadSchemaTransformProvider
extends TypedSchemaTransformProvider<BigQueryDirectReadSchemaTransformConfiguration> {
    public static final @UnknownKeyFor @NonNull @Initialized String OUTPUT_TAG = "output";

    protected @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized BigQueryDirectReadSchemaTransformConfiguration> configurationClass() {
        return BigQueryDirectReadSchemaTransformConfiguration.class;
    }

    protected @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized BigQueryDirectReadSchemaTransformConfiguration configuration) {
        return new BigQueryDirectReadSchemaTransform(configuration);
    }

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return BeamUrns.getUrn((ProtocolMessageEnum)ExternalTransforms.ManagedTransforms.Urns.BIGQUERY_READ);
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputCollectionNames() {
        return Collections.emptyList();
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> outputCollectionNames() {
        return Collections.singletonList(OUTPUT_TAG);
    }

    public static class BigQueryDirectReadSchemaTransform
    extends SchemaTransform {
        private @UnknownKeyFor @NonNull @Initialized BigQueryServices testBigQueryServices = null;
        private final @UnknownKeyFor @NonNull @Initialized BigQueryDirectReadSchemaTransformConfiguration configuration;

        BigQueryDirectReadSchemaTransform(@UnknownKeyFor @NonNull @Initialized BigQueryDirectReadSchemaTransformConfiguration configuration) {
            configuration.validate();
            this.configuration = configuration;
        }

        public @UnknownKeyFor @NonNull @Initialized Row getConfigurationRow() {
            try {
                return ((Row)SchemaRegistry.createDefault().getToRowFunction(BigQueryDirectReadSchemaTransformConfiguration.class).apply((Object)this.configuration)).sorted().toSnakeCase();
            }
            catch (NoSuchSchemaException e) {
                throw new RuntimeException(e);
            }
        }

        @VisibleForTesting
        public void setBigQueryServices(@UnknownKeyFor @NonNull @Initialized BigQueryServices testBigQueryServices) {
            this.testBigQueryServices = testBigQueryServices;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
            Preconditions.checkArgument((boolean)input.getAll().isEmpty(), (Object)String.format("Input to %s is expected to be empty, but is not.", ((Object)((Object)this)).getClass().getSimpleName()));
            BigQueryIO.TypedRead<TableRow> read = this.createDirectReadTransform();
            PCollection tableRows = (PCollection)input.getPipeline().apply(read);
            Schema schema = tableRows.getSchema();
            PCollection rows = (PCollection)tableRows.apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptor.of(Row.class)).via((SerializableFunction & Serializable)tableRow -> BigQueryUtils.toBeamRow(schema, tableRow)));
            return PCollectionRowTuple.of((String)BigQueryDirectReadSchemaTransformProvider.OUTPUT_TAG, (PCollection)rows.setRowSchema(schema));
        }

        @UnknownKeyFor @NonNull @Initialized BigQueryIO.TypedRead<@UnknownKeyFor @NonNull @Initialized TableRow> createDirectReadTransform() {
            BigQueryIO.TypedRead<TableRow> read = BigQueryIO.readTableRowsWithSchema().withMethod(BigQueryIO.TypedRead.Method.DIRECT_READ);
            if (!Strings.isNullOrEmpty((String)this.configuration.getTableSpec())) {
                read = read.from(this.configuration.getTableSpec());
                if (!Strings.isNullOrEmpty((String)this.configuration.getRowRestriction())) {
                    read = read.withRowRestriction(this.configuration.getRowRestriction());
                }
                if (this.configuration.getSelectedFields() != null) {
                    read = read.withSelectedFields(this.configuration.getSelectedFields());
                }
            } else {
                read = read.fromQuery(this.configuration.getQuery());
            }
            if (!Strings.isNullOrEmpty((String)this.configuration.getKmsKey())) {
                read = read.withKmsKey(this.configuration.getKmsKey());
            }
            if (this.testBigQueryServices != null) {
                read = read.withTestServices(this.testBigQueryServices);
            }
            return read;
        }
    }

    @DefaultSchema(value=AutoValueSchema.class)
    @AutoValue
    public static abstract class BigQueryDirectReadSchemaTransformConfiguration {
        public void validate() {
            String invalidConfigMessage = "Invalid BigQuery Direct Read configuration: ";
            if (!Strings.isNullOrEmpty((String)this.getTableSpec())) {
                Preconditions.checkNotNull((Object)BigQueryHelpers.parseTableSpec(this.getTableSpec()));
                Preconditions.checkArgument((boolean)Strings.isNullOrEmpty((String)this.getQuery()), (Object)(invalidConfigMessage + "Cannot specify both query and table spec."));
            } else {
                Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.getQuery()) ? 1 : 0) != 0, (Object)(invalidConfigMessage + "Either a query or table spec needs to be specified."));
                Preconditions.checkArgument((boolean)Strings.isNullOrEmpty((String)this.getRowRestriction()), (Object)(invalidConfigMessage + "Row restriction can only be specified when using table spec."));
                Preconditions.checkArgument((this.getSelectedFields() == null ? 1 : 0) != 0, (Object)(invalidConfigMessage + "Selected fields can only be specified when using table spec."));
            }
        }

        public static @UnknownKeyFor @Nullable @Initialized Builder builder() {
            return new AutoValue_BigQueryDirectReadSchemaTransformProvider_BigQueryDirectReadSchemaTransformConfiguration.Builder();
        }

        @SchemaFieldDescription(value="The SQL query to be executed to read from the BigQuery table.")
        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized String getQuery();

        @SchemaFieldDescription(value="The fully-qualified name of the BigQuery table to read from. Format: [${PROJECT}:]${DATASET}.${TABLE}")
        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized String getTableSpec();

        @SchemaFieldDescription(value="Read only rows that match this filter, which must be compatible with Google standard SQL. This is not supported when reading via query.")
        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized String getRowRestriction();

        @SchemaFieldDescription(value="Read only the specified fields (columns) from a BigQuery table. Fields may not be returned in the order specified. If no value is specified, then all fields are returned. Example: \"col1, col2, col3\"")
        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getSelectedFields();

        @SchemaFieldDescription(value="Use this Cloud KMS key to encrypt your data")
        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized String getKmsKey();

        @javax.annotation.Nullable
        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @Nullable @Initialized Builder setQuery(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @Nullable @Initialized Builder setTableSpec(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @Nullable @Initialized Builder setRowRestriction(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @Nullable @Initialized Builder setSelectedFields(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> var1);

            public abstract @UnknownKeyFor @Nullable @Initialized Builder setKmsKey(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized BigQueryDirectReadSchemaTransformConfiguration build();
        }
    }
}

