/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.Value;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.io.gcp.spanner.MutationGroup;
import org.apache.beam.sdk.io.gcp.spanner.OrderedCode;
import org.apache.beam.sdk.io.gcp.spanner.SpannerSchema;
import org.apache.beam.sdk.util.VarInt;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadableInstant;

class MutationGroupEncoder {
    private static final DateTime MIN_DATE = new DateTime(1, 1, 1, 0, 0);
    private final SpannerSchema schema;
    private final List<String> tables;
    private final Map<String, Integer> tablesIndexes = new HashMap<String, Integer>();

    public MutationGroupEncoder(SpannerSchema schema) {
        this.schema = schema;
        this.tables = schema.getTables();
        for (int i = 0; i < this.tables.size(); ++i) {
            this.tablesIndexes.put(this.tables.get(i).toLowerCase(), i);
        }
    }

    public byte[] encode(MutationGroup g) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            VarInt.encode((int)g.attached().size(), (OutputStream)bos);
            for (Mutation m : g) {
                this.encodeMutation(bos, m);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return bos.toByteArray();
    }

    private static void setBit(byte[] bytes, int i) {
        int word = i / 8;
        int bit = 7 - i % 8;
        bytes[word] = (byte)(bytes[word] | 1 << bit);
    }

    private static boolean getBit(byte[] bytes, int i) {
        int word = i / 8;
        int bit = 7 - i % 8;
        return (bytes[word] & 1 << bit) != 0;
    }

    private void encodeMutation(ByteArrayOutputStream bos, Mutation m) throws IOException {
        Mutation.Op op = m.getOperation();
        bos.write(op.ordinal());
        if (op == Mutation.Op.DELETE) {
            this.encodeDelete(bos, m);
        } else {
            this.encodeModification(bos, m);
        }
    }

    private void encodeDelete(ByteArrayOutputStream bos, Mutation m) throws IOException {
        String table = m.getTable().toLowerCase();
        int tableIndex = this.getTableIndex(table);
        VarInt.encode((int)tableIndex, (OutputStream)bos);
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeObject(m.getKeySet());
    }

    private Integer getTableIndex(String table) {
        Integer result = this.tablesIndexes.get(table.toLowerCase());
        Preconditions.checkArgument((result != null ? 1 : 0) != 0, (String)"Unknown table '%s'", (Object)table);
        return result;
    }

    private Mutation decodeDelete(ByteArrayInputStream bis) throws IOException {
        KeySet keySet;
        int tableIndex = VarInt.decodeInt((InputStream)bis);
        String tableName = this.tables.get(tableIndex);
        ObjectInputStream in = new ObjectInputStream(bis);
        try {
            keySet = (KeySet)in.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return Mutation.delete((String)tableName, (KeySet)keySet);
    }

    private void encodeModification(ByteArrayOutputStream bos, Mutation m) throws IOException {
        int i;
        String tableName = m.getTable().toLowerCase();
        int tableIndex = this.getTableIndex(tableName);
        VarInt.encode((int)tableIndex, (OutputStream)bos);
        List<SpannerSchema.Column> columns = this.schema.getColumns(tableName);
        Preconditions.checkArgument((columns != null ? 1 : 0) != 0, (Object)("Schema for table " + tableName + " not found"));
        Map<String, Value> map = MutationGroupEncoder.mutationAsMap(m);
        int bitsetSize = (columns.size() + 7) / 8;
        byte[] exists = new byte[bitsetSize];
        byte[] nulls = new byte[bitsetSize];
        for (i = 0; i < columns.size(); ++i) {
            boolean columnNull;
            String columnName = columns.get(i).getName();
            boolean columnExists = map.containsKey(columnName);
            boolean bl = columnNull = columnExists && map.get(columnName).isNull();
            if (columnExists) {
                MutationGroupEncoder.setBit(exists, i);
            }
            if (!columnNull) continue;
            MutationGroupEncoder.setBit(nulls, i);
            map.remove(columnName);
        }
        bos.write(exists);
        bos.write(nulls);
        for (i = 0; i < columns.size(); ++i) {
            if (!MutationGroupEncoder.getBit(exists, i) || MutationGroupEncoder.getBit(nulls, i)) continue;
            SpannerSchema.Column column = columns.get(i);
            Value value = map.remove(column.getName());
            this.encodeValue(bos, value);
        }
        Preconditions.checkArgument((boolean)map.isEmpty(), (String)"Columns %s were not defined in table %s", map.keySet(), (Object)m.getTable());
    }

    private void encodeValue(ByteArrayOutputStream bos, Value value) throws IOException {
        switch (value.getType().getCode()) {
            case ARRAY: {
                this.encodeArray(bos, value);
                break;
            }
            default: {
                this.encodePrimitive(bos, value);
            }
        }
    }

    private void encodeArray(ByteArrayOutputStream bos, Value value) throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(bos);
        switch (value.getType().getArrayElementType().getCode()) {
            case BOOL: {
                out.writeObject(new ArrayList(value.getBoolArray()));
                break;
            }
            case INT64: {
                out.writeObject(new ArrayList(value.getInt64Array()));
                break;
            }
            case FLOAT64: {
                out.writeObject(new ArrayList(value.getFloat64Array()));
                break;
            }
            case STRING: {
                out.writeObject(new ArrayList(value.getStringArray()));
                break;
            }
            case BYTES: {
                out.writeObject(new ArrayList(value.getBytesArray()));
                break;
            }
            case TIMESTAMP: {
                out.writeObject(new ArrayList(value.getTimestampArray()));
                break;
            }
            case DATE: {
                out.writeObject(new ArrayList(value.getDateArray()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type " + value.getType());
            }
        }
    }

    private void encodePrimitive(ByteArrayOutputStream bos, Value value) throws IOException {
        switch (value.getType().getCode()) {
            case BOOL: {
                bos.write(value.getBool() ? 1 : 0);
                break;
            }
            case INT64: {
                VarInt.encode((long)value.getInt64(), (OutputStream)bos);
                break;
            }
            case FLOAT64: {
                new DataOutputStream(bos).writeDouble(value.getFloat64());
                break;
            }
            case STRING: {
                String str = value.getString();
                byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
                VarInt.encode((int)bytes.length, (OutputStream)bos);
                bos.write(bytes);
                break;
            }
            case BYTES: {
                ByteArray bytes = value.getBytes();
                VarInt.encode((int)bytes.length(), (OutputStream)bos);
                bos.write(bytes.toByteArray());
                break;
            }
            case TIMESTAMP: {
                Timestamp timestamp = value.getTimestamp();
                VarInt.encode((long)timestamp.getSeconds(), (OutputStream)bos);
                VarInt.encode((int)timestamp.getNanos(), (OutputStream)bos);
                break;
            }
            case DATE: {
                Date date = value.getDate();
                VarInt.encode((int)MutationGroupEncoder.encodeDate(date), (OutputStream)bos);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type " + value.getType());
            }
        }
    }

    public MutationGroup decode(byte[] bytes) {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        try {
            int numMutations = VarInt.decodeInt((InputStream)bis);
            Mutation primary = this.decodeMutation(bis);
            ArrayList<Mutation> attached = new ArrayList<Mutation>(numMutations);
            for (int i = 0; i < numMutations; ++i) {
                attached.add(this.decodeMutation(bis));
            }
            return MutationGroup.create(primary, attached);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Mutation decodeMutation(ByteArrayInputStream bis) throws IOException {
        Mutation.Op op = Mutation.Op.values()[bis.read()];
        if (op == Mutation.Op.DELETE) {
            return this.decodeDelete(bis);
        }
        return this.decodeModification(bis, op);
    }

    private Mutation decodeModification(ByteArrayInputStream bis, Mutation.Op op) throws IOException {
        Mutation.WriteBuilder m;
        int tableIndex = VarInt.decodeInt((InputStream)bis);
        String tableName = this.tables.get(tableIndex);
        switch (op) {
            case INSERT: {
                m = Mutation.newInsertBuilder((String)tableName);
                break;
            }
            case INSERT_OR_UPDATE: {
                m = Mutation.newInsertOrUpdateBuilder((String)tableName);
                break;
            }
            case REPLACE: {
                m = Mutation.newReplaceBuilder((String)tableName);
                break;
            }
            case UPDATE: {
                m = Mutation.newUpdateBuilder((String)tableName);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operation " + op);
            }
        }
        List<SpannerSchema.Column> columns = this.schema.getColumns(tableName);
        int bitsetSize = (columns.size() + 7) / 8;
        byte[] exists = this.readBytes(bis, bitsetSize);
        byte[] nulls = this.readBytes(bis, bitsetSize);
        block11: for (int i = 0; i < columns.size(); ++i) {
            if (!MutationGroupEncoder.getBit(exists, i)) continue;
            SpannerSchema.Column column = columns.get(i);
            boolean isNull = MutationGroupEncoder.getBit(nulls, i);
            Type type = column.getType();
            String fieldName = column.getName();
            switch (type.getCode()) {
                case ARRAY: {
                    try {
                        this.decodeArray(bis, fieldName, type, isNull, m);
                        continue block11;
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
                default: {
                    this.decodePrimitive(bis, fieldName, type, isNull, m);
                }
            }
        }
        return m.build();
    }

    private void decodeArray(ByteArrayInputStream bis, String fieldName, Type type, boolean isNull, Mutation.WriteBuilder m) throws IOException, ClassNotFoundException {
        switch (type.getArrayElementType().getCode()) {
            case BOOL: {
                if (isNull) {
                    m.set(fieldName).toBoolArray((Iterable)null);
                    break;
                }
                ObjectInputStream out = new ObjectInputStream(bis);
                m.set(fieldName).toBoolArray((Iterable)((List)out.readObject()));
                break;
            }
            case INT64: {
                if (isNull) {
                    m.set(fieldName).toInt64Array((Iterable)null);
                    break;
                }
                ObjectInputStream out = new ObjectInputStream(bis);
                m.set(fieldName).toInt64Array((Iterable)((List)out.readObject()));
                break;
            }
            case FLOAT64: {
                if (isNull) {
                    m.set(fieldName).toFloat64Array((Iterable)null);
                    break;
                }
                ObjectInputStream out = new ObjectInputStream(bis);
                m.set(fieldName).toFloat64Array((Iterable)((List)out.readObject()));
                break;
            }
            case STRING: {
                if (isNull) {
                    m.set(fieldName).toStringArray(null);
                    break;
                }
                ObjectInputStream out = new ObjectInputStream(bis);
                m.set(fieldName).toStringArray((Iterable)((List)out.readObject()));
                break;
            }
            case BYTES: {
                if (isNull) {
                    m.set(fieldName).toBytesArray(null);
                    break;
                }
                ObjectInputStream out = new ObjectInputStream(bis);
                m.set(fieldName).toBytesArray((Iterable)((List)out.readObject()));
                break;
            }
            case TIMESTAMP: {
                if (isNull) {
                    m.set(fieldName).toTimestampArray(null);
                    break;
                }
                ObjectInputStream out = new ObjectInputStream(bis);
                m.set(fieldName).toTimestampArray((Iterable)((List)out.readObject()));
                break;
            }
            case DATE: {
                if (isNull) {
                    m.set(fieldName).toDateArray(null);
                    break;
                }
                ObjectInputStream out = new ObjectInputStream(bis);
                m.set(fieldName).toDateArray((Iterable)((List)out.readObject()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type " + type);
            }
        }
    }

    private void decodePrimitive(ByteArrayInputStream bis, String fieldName, Type type, boolean isNull, Mutation.WriteBuilder m) throws IOException {
        switch (type.getCode()) {
            case BOOL: {
                if (isNull) {
                    m.set(fieldName).to((Boolean)null);
                    break;
                }
                m.set(fieldName).to(bis.read() != 0);
                break;
            }
            case INT64: {
                if (isNull) {
                    m.set(fieldName).to((Long)null);
                    break;
                }
                m.set(fieldName).to(VarInt.decodeLong((InputStream)bis));
                break;
            }
            case FLOAT64: {
                if (isNull) {
                    m.set(fieldName).to((Double)null);
                    break;
                }
                m.set(fieldName).to(new DataInputStream(bis).readDouble());
                break;
            }
            case STRING: {
                if (isNull) {
                    m.set(fieldName).to((String)null);
                    break;
                }
                int len = VarInt.decodeInt((InputStream)bis);
                byte[] bytes = this.readBytes(bis, len);
                m.set(fieldName).to(new String(bytes, StandardCharsets.UTF_8));
                break;
            }
            case BYTES: {
                if (isNull) {
                    m.set(fieldName).to((ByteArray)null);
                    break;
                }
                int len = VarInt.decodeInt((InputStream)bis);
                byte[] bytes = this.readBytes(bis, len);
                m.set(fieldName).to(ByteArray.copyFrom((byte[])bytes));
                break;
            }
            case TIMESTAMP: {
                if (isNull) {
                    m.set(fieldName).to((Timestamp)null);
                    break;
                }
                long seconds = VarInt.decodeLong((InputStream)bis);
                int nanoseconds = VarInt.decodeInt((InputStream)bis);
                m.set(fieldName).to(Timestamp.ofTimeSecondsAndNanos((long)seconds, (int)nanoseconds));
                break;
            }
            case DATE: {
                if (isNull) {
                    m.set(fieldName).to((Date)null);
                    break;
                }
                int days = VarInt.decodeInt((InputStream)bis);
                m.set(fieldName).to(MutationGroupEncoder.decodeDate(days));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type " + type);
            }
        }
    }

    private byte[] readBytes(ByteArrayInputStream bis, int len) throws IOException {
        byte[] tmp = new byte[len];
        new DataInputStream(bis).readFully(tmp);
        return tmp;
    }

    public byte[] encodeKey(Mutation m) {
        Map<String, Value> mutationMap = MutationGroupEncoder.mutationAsMap(m);
        OrderedCode orderedCode = new OrderedCode();
        block9: for (SpannerSchema.KeyPart part : this.schema.getKeyParts(m.getTable())) {
            Value val = mutationMap.get(part.getField());
            if (val.isNull()) {
                if (part.isDesc()) {
                    orderedCode.writeInfinityDecreasing();
                    continue;
                }
                orderedCode.writeInfinity();
                continue;
            }
            Type.Code code = val.getType().getCode();
            switch (code) {
                case BOOL: {
                    long v;
                    long l = v = val.getBool() ? 0L : 1L;
                    if (part.isDesc()) {
                        orderedCode.writeSignedNumDecreasing(v);
                        continue block9;
                    }
                    orderedCode.writeSignedNumIncreasing(v);
                    continue block9;
                }
                case INT64: {
                    if (part.isDesc()) {
                        orderedCode.writeSignedNumDecreasing(val.getInt64());
                        continue block9;
                    }
                    orderedCode.writeSignedNumIncreasing(val.getInt64());
                    continue block9;
                }
                case FLOAT64: {
                    if (part.isDesc()) {
                        orderedCode.writeSignedNumDecreasing(Double.doubleToLongBits(val.getFloat64()));
                        continue block9;
                    }
                    orderedCode.writeSignedNumIncreasing(Double.doubleToLongBits(val.getFloat64()));
                    continue block9;
                }
                case STRING: {
                    if (part.isDesc()) {
                        orderedCode.writeBytesDecreasing(val.getString().getBytes(StandardCharsets.UTF_8));
                        continue block9;
                    }
                    orderedCode.writeBytes(val.getString().getBytes(StandardCharsets.UTF_8));
                    continue block9;
                }
                case BYTES: {
                    if (part.isDesc()) {
                        orderedCode.writeBytesDecreasing(val.getBytes().toByteArray());
                        continue block9;
                    }
                    orderedCode.writeBytes(val.getBytes().toByteArray());
                    continue block9;
                }
                case TIMESTAMP: {
                    Timestamp value = val.getTimestamp();
                    if (part.isDesc()) {
                        orderedCode.writeNumDecreasing(value.getSeconds());
                        orderedCode.writeNumDecreasing(value.getNanos());
                        continue block9;
                    }
                    orderedCode.writeNumIncreasing(value.getSeconds());
                    orderedCode.writeNumIncreasing(value.getNanos());
                    continue block9;
                }
                case DATE: {
                    Timestamp value = val.getDate();
                    if (part.isDesc()) {
                        orderedCode.writeSignedNumDecreasing(MutationGroupEncoder.encodeDate((Date)value));
                        continue block9;
                    }
                    orderedCode.writeSignedNumIncreasing(MutationGroupEncoder.encodeDate((Date)value));
                    continue block9;
                }
            }
            throw new IllegalArgumentException("Unknown type " + val.getType());
        }
        return orderedCode.getEncodedBytes();
    }

    public byte[] encodeKey(String table, Key key) {
        OrderedCode orderedCode = new OrderedCode();
        List<SpannerSchema.KeyPart> parts = this.schema.getKeyParts(table);
        Iterator it = key.getParts().iterator();
        for (SpannerSchema.KeyPart part : parts) {
            Object value = it.next();
            if (value == null) {
                if (part.isDesc()) {
                    orderedCode.writeInfinityDecreasing();
                    continue;
                }
                orderedCode.writeInfinity();
                continue;
            }
            if (value instanceof Boolean) {
                long v;
                long l = v = (Boolean)value != false ? 0L : 1L;
                if (part.isDesc()) {
                    orderedCode.writeSignedNumDecreasing(v);
                    continue;
                }
                orderedCode.writeSignedNumIncreasing(v);
                continue;
            }
            if (value instanceof Long) {
                long v = (Long)value;
                if (part.isDesc()) {
                    orderedCode.writeSignedNumDecreasing(v);
                    continue;
                }
                orderedCode.writeSignedNumIncreasing(v);
                continue;
            }
            if (value instanceof Double) {
                long v = Double.doubleToLongBits((Double)value);
                if (part.isDesc()) {
                    orderedCode.writeSignedNumDecreasing(v);
                    continue;
                }
                orderedCode.writeSignedNumIncreasing(v);
                continue;
            }
            if (value instanceof String) {
                String v = (String)value;
                if (part.isDesc()) {
                    orderedCode.writeBytesDecreasing(v.getBytes(StandardCharsets.UTF_8));
                    continue;
                }
                orderedCode.writeBytes(v.getBytes(StandardCharsets.UTF_8));
                continue;
            }
            if (value instanceof ByteArray) {
                ByteArray v = (ByteArray)value;
                if (part.isDesc()) {
                    orderedCode.writeBytesDecreasing(v.toByteArray());
                    continue;
                }
                orderedCode.writeBytes(v.toByteArray());
                continue;
            }
            if (value instanceof Timestamp) {
                Timestamp v = (Timestamp)value;
                if (part.isDesc()) {
                    orderedCode.writeNumDecreasing(v.getSeconds());
                    orderedCode.writeNumDecreasing(v.getNanos());
                    continue;
                }
                orderedCode.writeNumIncreasing(v.getSeconds());
                orderedCode.writeNumIncreasing(v.getNanos());
                continue;
            }
            if (value instanceof Date) {
                Date v = (Date)value;
                if (part.isDesc()) {
                    orderedCode.writeSignedNumDecreasing(MutationGroupEncoder.encodeDate(v));
                    continue;
                }
                orderedCode.writeSignedNumIncreasing(MutationGroupEncoder.encodeDate(v));
                continue;
            }
            throw new IllegalArgumentException("Unknown key part " + value);
        }
        return orderedCode.getEncodedBytes();
    }

    private static Map<String, Value> mutationAsMap(Mutation m) {
        HashMap<String, Value> result = new HashMap<String, Value>();
        Iterator coli = m.getColumns().iterator();
        Iterator vali = m.getValues().iterator();
        while (coli.hasNext()) {
            String column = (String)coli.next();
            Value val = (Value)vali.next();
            result.put(column.toLowerCase(), val);
        }
        return result;
    }

    private static int encodeDate(Date date) {
        MutableDateTime jodaDate = new MutableDateTime();
        jodaDate.setDate(date.getYear(), date.getMonth(), date.getDayOfMonth());
        return Days.daysBetween((ReadableInstant)MIN_DATE, (ReadableInstant)jodaDate).getDays();
    }

    private static Date decodeDate(int daysSinceEpoch) {
        DateTime jodaDate = MIN_DATE.plusDays(daysSinceEpoch);
        return Date.fromYearMonthDay((int)jodaDate.getYear(), (int)jodaDate.getMonthOfYear(), (int)jodaDate.getDayOfMonth());
    }
}

