/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.model;

import com.google.cloud.Timestamp;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.avro.reflect.AvroEncode;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.extensions.avro.coders.AvroCoder;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.encoder.TimestampEncoding;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@DefaultCoder(value=AvroCoder.class)
public class ChangeStreamRecordMetadata
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = -7294067549709034080L;
    private @UnknownKeyFor @NonNull @Initialized String partitionToken;
    @AvroEncode(using=TimestampEncoding.class)
    private @UnknownKeyFor @NonNull @Initialized Timestamp recordTimestamp;
    @AvroEncode(using=TimestampEncoding.class)
    private @UnknownKeyFor @NonNull @Initialized Timestamp partitionStartTimestamp;
    @AvroEncode(using=TimestampEncoding.class)
    private @UnknownKeyFor @NonNull @Initialized Timestamp partitionEndTimestamp;
    @AvroEncode(using=TimestampEncoding.class)
    private @UnknownKeyFor @NonNull @Initialized Timestamp partitionCreatedAt;
    @Nullable
    @org.apache.avro.reflect.Nullable
    @AvroEncode(using=TimestampEncoding.class)
    private @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Timestamp partitionScheduledAt;
    @Nullable
    @org.apache.avro.reflect.Nullable
    @AvroEncode(using=TimestampEncoding.class)
    private @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Timestamp partitionRunningAt;
    @AvroEncode(using=TimestampEncoding.class)
    private @UnknownKeyFor @NonNull @Initialized Timestamp queryStartedAt;
    @AvroEncode(using=TimestampEncoding.class)
    private @UnknownKeyFor @NonNull @Initialized Timestamp recordStreamStartedAt;
    @AvroEncode(using=TimestampEncoding.class)
    private @UnknownKeyFor @NonNull @Initialized Timestamp recordStreamEndedAt;
    @AvroEncode(using=TimestampEncoding.class)
    private @UnknownKeyFor @NonNull @Initialized Timestamp recordReadAt;
    private @UnknownKeyFor @NonNull @Initialized long totalStreamTimeMillis;
    private @UnknownKeyFor @NonNull @Initialized long numberOfRecordsRead;

    private ChangeStreamRecordMetadata() {
    }

    @VisibleForTesting
    ChangeStreamRecordMetadata(@UnknownKeyFor @NonNull @Initialized String partitionToken, @UnknownKeyFor @NonNull @Initialized Timestamp recordTimestamp, @UnknownKeyFor @NonNull @Initialized Timestamp partitionStartTimestamp, @UnknownKeyFor @NonNull @Initialized Timestamp partitionEndTimestamp, @UnknownKeyFor @NonNull @Initialized Timestamp partitionCreatedAt, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Timestamp partitionScheduledAt, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Timestamp partitionRunningAt, @UnknownKeyFor @NonNull @Initialized Timestamp queryStartedAt, @UnknownKeyFor @NonNull @Initialized Timestamp recordStreamStartedAt, @UnknownKeyFor @NonNull @Initialized Timestamp recordStreamEndedAt, @UnknownKeyFor @NonNull @Initialized Timestamp recordReadAt, @UnknownKeyFor @NonNull @Initialized long totalStreamTimeMillis, @UnknownKeyFor @NonNull @Initialized long numberOfRecordsRead) {
        this.partitionToken = partitionToken;
        this.recordTimestamp = recordTimestamp;
        this.partitionStartTimestamp = partitionStartTimestamp;
        this.partitionEndTimestamp = partitionEndTimestamp;
        this.partitionCreatedAt = partitionCreatedAt;
        this.partitionScheduledAt = partitionScheduledAt;
        this.partitionRunningAt = partitionRunningAt;
        this.queryStartedAt = queryStartedAt;
        this.recordStreamStartedAt = recordStreamStartedAt;
        this.recordStreamEndedAt = recordStreamEndedAt;
        this.recordReadAt = recordReadAt;
        this.totalStreamTimeMillis = totalStreamTimeMillis;
        this.numberOfRecordsRead = numberOfRecordsRead;
    }

    public @UnknownKeyFor @NonNull @Initialized String getPartitionToken() {
        return this.partitionToken;
    }

    public @UnknownKeyFor @NonNull @Initialized Timestamp getRecordTimestamp() {
        return this.recordTimestamp;
    }

    public @UnknownKeyFor @NonNull @Initialized Timestamp getPartitionStartTimestamp() {
        return this.partitionStartTimestamp;
    }

    public @UnknownKeyFor @NonNull @Initialized Timestamp getPartitionEndTimestamp() {
        return this.partitionEndTimestamp;
    }

    public @UnknownKeyFor @NonNull @Initialized Timestamp getPartitionCreatedAt() {
        return this.partitionCreatedAt;
    }

    @Nullable
    public @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Timestamp getPartitionScheduledAt() {
        return this.partitionScheduledAt;
    }

    @Nullable
    public @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Timestamp getPartitionRunningAt() {
        return this.partitionRunningAt;
    }

    public @UnknownKeyFor @NonNull @Initialized Timestamp getQueryStartedAt() {
        return this.queryStartedAt;
    }

    public @UnknownKeyFor @NonNull @Initialized Timestamp getRecordStreamStartedAt() {
        return this.recordStreamStartedAt;
    }

    public @UnknownKeyFor @NonNull @Initialized Timestamp getRecordStreamEndedAt() {
        return this.recordStreamEndedAt;
    }

    public @UnknownKeyFor @NonNull @Initialized Timestamp getRecordReadAt() {
        return this.recordReadAt;
    }

    public @UnknownKeyFor @NonNull @Initialized long getTotalStreamTimeMillis() {
        return this.totalStreamTimeMillis;
    }

    public @UnknownKeyFor @NonNull @Initialized long getNumberOfRecordsRead() {
        return this.numberOfRecordsRead;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangeStreamRecordMetadata)) {
            return false;
        }
        ChangeStreamRecordMetadata metadata = (ChangeStreamRecordMetadata)o;
        return this.totalStreamTimeMillis == metadata.totalStreamTimeMillis && this.numberOfRecordsRead == metadata.numberOfRecordsRead && Objects.equals(this.partitionToken, metadata.partitionToken) && Objects.equals(this.recordTimestamp, metadata.recordTimestamp) && Objects.equals(this.partitionStartTimestamp, metadata.partitionStartTimestamp) && Objects.equals(this.partitionEndTimestamp, metadata.partitionEndTimestamp) && Objects.equals(this.partitionCreatedAt, metadata.partitionCreatedAt) && Objects.equals(this.partitionScheduledAt, metadata.partitionScheduledAt) && Objects.equals(this.partitionRunningAt, metadata.partitionRunningAt) && Objects.equals(this.queryStartedAt, metadata.queryStartedAt) && Objects.equals(this.recordStreamStartedAt, metadata.recordStreamStartedAt) && Objects.equals(this.recordStreamEndedAt, metadata.recordStreamEndedAt) && Objects.equals(this.recordReadAt, metadata.recordReadAt);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.partitionToken, this.recordTimestamp, this.partitionStartTimestamp, this.partitionEndTimestamp, this.partitionCreatedAt, this.partitionScheduledAt, this.partitionRunningAt, this.queryStartedAt, this.recordStreamStartedAt, this.recordStreamEndedAt, this.recordReadAt, this.totalStreamTimeMillis, this.numberOfRecordsRead);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "ChangeStreamRecordMetadata{partitionToken='" + this.partitionToken + '\'' + ", recordTimestamp=" + this.recordTimestamp + ", partitionStartTimestamp=" + this.partitionStartTimestamp + ", partitionEndTimestamp=" + this.partitionEndTimestamp + ", partitionCreatedAt=" + this.partitionCreatedAt + ", partitionScheduledAt=" + this.partitionScheduledAt + ", partitionRunningAt=" + this.partitionRunningAt + ", queryStartedAt=" + this.queryStartedAt + ", recordStreamStartedAt=" + this.recordStreamStartedAt + ", recordStreamEndedAt=" + this.recordStreamEndedAt + ", recordReadAt=" + this.recordReadAt + ", totalStreamTimeMillis=" + this.totalStreamTimeMillis + ", numberOfRecordsRead=" + this.numberOfRecordsRead + '}';
    }

    public static @UnknownKeyFor @NonNull @Initialized Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private @UnknownKeyFor @NonNull @Initialized String partitionToken;
        private @UnknownKeyFor @NonNull @Initialized Timestamp recordTimestamp;
        private @UnknownKeyFor @NonNull @Initialized Timestamp partitionStartTimestamp;
        private @UnknownKeyFor @NonNull @Initialized Timestamp partitionEndTimestamp;
        private @UnknownKeyFor @NonNull @Initialized Timestamp partitionCreatedAt;
        @Nullable
        private @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Timestamp partitionScheduledAt;
        @Nullable
        private @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Timestamp partitionRunningAt;
        private @UnknownKeyFor @NonNull @Initialized Timestamp queryStartedAt;
        private @UnknownKeyFor @NonNull @Initialized Timestamp recordStreamStartedAt;
        private @UnknownKeyFor @NonNull @Initialized Timestamp recordStreamEndedAt;
        private @UnknownKeyFor @NonNull @Initialized Timestamp recordReadAt;
        private @UnknownKeyFor @NonNull @Initialized long totalStreamTimeMillis;
        private @UnknownKeyFor @NonNull @Initialized long numberOfRecordsRead;

        public @UnknownKeyFor @NonNull @Initialized Builder withPartitionToken(@UnknownKeyFor @NonNull @Initialized String partitionToken) {
            this.partitionToken = partitionToken;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder withRecordTimestamp(@UnknownKeyFor @NonNull @Initialized Timestamp recordTimestamp) {
            this.recordTimestamp = recordTimestamp;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder withPartitionStartTimestamp(@UnknownKeyFor @NonNull @Initialized Timestamp partitionStartTimestamp) {
            this.partitionStartTimestamp = partitionStartTimestamp;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder withPartitionEndTimestamp(@UnknownKeyFor @NonNull @Initialized Timestamp partitionEndTimestamp) {
            this.partitionEndTimestamp = partitionEndTimestamp;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder withPartitionCreatedAt(@UnknownKeyFor @NonNull @Initialized Timestamp partitionCreatedAt) {
            this.partitionCreatedAt = partitionCreatedAt;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder withPartitionScheduledAt(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Timestamp partitionScheduledAt) {
            this.partitionScheduledAt = partitionScheduledAt;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder withPartitionRunningAt(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Timestamp partitionRunningAt) {
            this.partitionRunningAt = partitionRunningAt;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder withQueryStartedAt(@UnknownKeyFor @NonNull @Initialized Timestamp queryStartedAt) {
            this.queryStartedAt = queryStartedAt;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder withRecordStreamStartedAt(@UnknownKeyFor @NonNull @Initialized Timestamp recordStreamStartedAt) {
            this.recordStreamStartedAt = recordStreamStartedAt;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder withRecordStreamEndedAt(@UnknownKeyFor @NonNull @Initialized Timestamp recordStreamEndedAt) {
            this.recordStreamEndedAt = recordStreamEndedAt;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder withRecordReadAt(@UnknownKeyFor @NonNull @Initialized Timestamp recordReadAt) {
            this.recordReadAt = recordReadAt;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder withTotalStreamTimeMillis(@UnknownKeyFor @NonNull @Initialized long totalStreamTimeMillis) {
            this.totalStreamTimeMillis = totalStreamTimeMillis;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder withNumberOfRecordsRead(@UnknownKeyFor @NonNull @Initialized long numberOfRecordsRead) {
            this.numberOfRecordsRead = numberOfRecordsRead;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized ChangeStreamRecordMetadata build() {
            return new ChangeStreamRecordMetadata(this.partitionToken, this.recordTimestamp, this.partitionStartTimestamp, this.partitionEndTimestamp, this.partitionCreatedAt, this.partitionScheduledAt, this.partitionRunningAt, this.queryStartedAt, this.recordStreamStartedAt, this.recordStreamEndedAt, this.recordReadAt, this.totalStreamTimeMillis, this.numberOfRecordsRead);
        }
    }
}

