/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.datastore;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auto.value.AutoValue;
import com.google.cloud.hadoop.util.ChainingHttpRequestInitializer;
import com.google.datastore.v1.CommitRequest;
import com.google.datastore.v1.Entity;
import com.google.datastore.v1.EntityResult;
import com.google.datastore.v1.Filter;
import com.google.datastore.v1.GqlQuery;
import com.google.datastore.v1.Key;
import com.google.datastore.v1.Mutation;
import com.google.datastore.v1.PartitionId;
import com.google.datastore.v1.PropertyFilter;
import com.google.datastore.v1.PropertyOrder;
import com.google.datastore.v1.Query;
import com.google.datastore.v1.QueryResultBatch;
import com.google.datastore.v1.ReadOptions;
import com.google.datastore.v1.RunQueryRequest;
import com.google.datastore.v1.RunQueryResponse;
import com.google.datastore.v1.Value;
import com.google.datastore.v1.client.Datastore;
import com.google.datastore.v1.client.DatastoreException;
import com.google.datastore.v1.client.DatastoreFactory;
import com.google.datastore.v1.client.DatastoreHelper;
import com.google.datastore.v1.client.DatastoreOptions;
import com.google.datastore.v1.client.QuerySplitter;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import com.google.rpc.Code;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.beam.runners.core.metrics.GcpResourceIdentifiers;
import org.apache.beam.runners.core.metrics.MonitoringInfoConstants;
import org.apache.beam.runners.core.metrics.ServiceCallMetric;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.extensions.gcp.util.RetryHttpRequestInitializer;
import org.apache.beam.sdk.io.gcp.datastore.AdaptiveThrottler;
import org.apache.beam.sdk.io.gcp.datastore.AutoValue_DatastoreV1_Read;
import org.apache.beam.sdk.io.gcp.datastore.MovingAverage;
import org.apache.beam.sdk.io.gcp.datastore.RampupThrottlingFn;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Distribution;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.BackOffUtils;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Verify;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatastoreV1 {
    @VisibleForTesting
    static final @UnknownKeyFor @NonNull @Initialized int DATASTORE_BATCH_UPDATE_ENTITIES_START = 50;
    @VisibleForTesting
    static final @UnknownKeyFor @NonNull @Initialized int DATASTORE_BATCH_UPDATE_ENTITIES_LIMIT = 500;
    @VisibleForTesting
    static final @UnknownKeyFor @NonNull @Initialized int DATASTORE_BATCH_UPDATE_ENTITIES_MIN = 5;
    @VisibleForTesting
    static final @UnknownKeyFor @NonNull @Initialized int DATASTORE_BATCH_UPDATE_BYTES_LIMIT = 9000000;
    private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_HINT_NUM_WORKERS = 500;
    private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Code> NON_RETRYABLE_ERRORS = ImmutableSet.of((Object)Code.FAILED_PRECONDITION, (Object)Code.INVALID_ARGUMENT, (Object)Code.PERMISSION_DENIED, (Object)Code.UNAUTHENTICATED);

    DatastoreV1() {
    }

    public @UnknownKeyFor @NonNull @Initialized Read read() {
        return new AutoValue_DatastoreV1_Read.Builder().setNumQuerySplits(0).build();
    }

    public @UnknownKeyFor @NonNull @Initialized Write write() {
        return new Write(null, null, true, (ValueProvider<Integer>)ValueProvider.StaticValueProvider.of((Object)500));
    }

    public @UnknownKeyFor @NonNull @Initialized DeleteEntity deleteEntity() {
        return new DeleteEntity(null, null, true, (ValueProvider<Integer>)ValueProvider.StaticValueProvider.of((Object)500));
    }

    public @UnknownKeyFor @NonNull @Initialized DeleteKey deleteKey() {
        return new DeleteKey(null, null, true, (ValueProvider<Integer>)ValueProvider.StaticValueProvider.of((Object)500));
    }

    static @UnknownKeyFor @NonNull @Initialized boolean isValidKey(@UnknownKeyFor @NonNull @Initialized Key key) {
        List elementList = key.getPathList();
        if (elementList.isEmpty()) {
            return false;
        }
        Key.PathElement lastElement = (Key.PathElement)elementList.get(elementList.size() - 1);
        return lastElement.getId() != 0L || !lastElement.getName().isEmpty();
    }

    @VisibleForTesting
    static class V1DatastoreFactory
    implements Serializable {
        V1DatastoreFactory() {
        }

        public @UnknownKeyFor @NonNull @Initialized Datastore getDatastore(@UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions, @UnknownKeyFor @NonNull @Initialized String projectId) {
            return this.getDatastore(pipelineOptions, projectId, null);
        }

        public @UnknownKeyFor @NonNull @Initialized Datastore getDatastore(@UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions, @UnknownKeyFor @NonNull @Initialized String projectId, @Nullable @UnknownKeyFor @Initialized String localhost) {
            Credentials credential = ((GcpOptions)pipelineOptions.as(GcpOptions.class)).getGcpCredential();
            HttpRequestInitializer userAgentInitializer = request -> request.getHeaders().setUserAgent(pipelineOptions.getUserAgent());
            ChainingHttpRequestInitializer initializer = credential != null ? new ChainingHttpRequestInitializer(new HttpRequestInitializer[]{new HttpCredentialsAdapter(credential), new RetryHttpRequestInitializer(), userAgentInitializer}) : new ChainingHttpRequestInitializer(new HttpRequestInitializer[]{new RetryHttpRequestInitializer(), userAgentInitializer});
            DatastoreOptions.Builder builder = new DatastoreOptions.Builder().projectId(projectId).initializer((HttpRequestInitializer)initializer);
            if (localhost != null) {
                builder.localHost(localhost);
            } else {
                builder.host("batch-datastore.googleapis.com");
            }
            return DatastoreFactory.get().create(builder.build());
        }

        public @UnknownKeyFor @NonNull @Initialized QuerySplitter getQuerySplitter() {
            return DatastoreHelper.getQuerySplitter();
        }
    }

    @VisibleForTesting
    static class DeleteKeyFn
    extends SimpleFunction<Key, Mutation> {
        DeleteKeyFn() {
        }

        public @UnknownKeyFor @NonNull @Initialized Mutation apply(@UnknownKeyFor @NonNull @Initialized Key key) {
            Preconditions.checkArgument((boolean)DatastoreV1.isValidKey(key), (String)"Keys to be deleted from the Cloud Datastore must be complete:\n%s", (Object)key);
            return DatastoreHelper.makeDelete((Key)key).build();
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            builder.add(DisplayData.item((String)"deleteKeyFn", ((Object)((Object)this)).getClass()).withLabel("Create Delete Mutation"));
        }
    }

    @VisibleForTesting
    static class DeleteEntityFn
    extends SimpleFunction<Entity, Mutation> {
        DeleteEntityFn() {
        }

        public @UnknownKeyFor @NonNull @Initialized Mutation apply(@UnknownKeyFor @NonNull @Initialized Entity entity) {
            Preconditions.checkArgument((boolean)DatastoreV1.isValidKey(entity.getKey()), (String)"Entities to be deleted from the Cloud Datastore must have complete keys:\n%s", (Object)entity);
            return DatastoreHelper.makeDelete((Key)entity.getKey()).build();
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            builder.add(DisplayData.item((String)"deleteEntityFn", ((Object)((Object)this)).getClass()).withLabel("Create Delete Mutation"));
        }
    }

    @VisibleForTesting
    static class UpsertFn
    extends SimpleFunction<Entity, Mutation> {
        UpsertFn() {
        }

        public @UnknownKeyFor @NonNull @Initialized Mutation apply(@UnknownKeyFor @NonNull @Initialized Entity entity) {
            Preconditions.checkArgument((boolean)DatastoreV1.isValidKey(entity.getKey()), (String)"Entities to be written to the Cloud Datastore must have complete keys:\n%s", (Object)entity);
            return DatastoreHelper.makeUpsert((Entity)entity).build();
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            builder.add(DisplayData.item((String)"upsertFn", ((Object)((Object)this)).getClass()).withLabel("Create Upsert Mutation"));
        }
    }

    @VisibleForTesting
    static class DatastoreWriterFn
    extends DoFn<Mutation, Void> {
        private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(DatastoreWriterFn.class);
        private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> projectId;
        private final @Nullable @UnknownKeyFor @Initialized String localhost;
        private transient @UnknownKeyFor @NonNull @Initialized Datastore datastore;
        private final @UnknownKeyFor @NonNull @Initialized V1DatastoreFactory datastoreFactory;
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Mutation> mutations = new ArrayList<Mutation>();
        private final @UnknownKeyFor @NonNull @Initialized HashSet<@UnknownKeyFor @NonNull @Initialized Key> uniqueMutationKeys = new HashSet();
        private @UnknownKeyFor @NonNull @Initialized int mutationsSize = 0;
        private @UnknownKeyFor @NonNull @Initialized WriteBatcher writeBatcher;
        private transient @UnknownKeyFor @NonNull @Initialized AdaptiveThrottler adaptiveThrottler;
        private final @UnknownKeyFor @NonNull @Initialized Counter throttlingMsecs = Metrics.counter(DatastoreWriterFn.class, (String)"throttling-msecs");
        private final @UnknownKeyFor @NonNull @Initialized Counter rpcErrors = Metrics.counter(DatastoreWriterFn.class, (String)"datastoreRpcErrors");
        private final @UnknownKeyFor @NonNull @Initialized Counter rpcSuccesses = Metrics.counter(DatastoreWriterFn.class, (String)"datastoreRpcSuccesses");
        private final @UnknownKeyFor @NonNull @Initialized Distribution batchSize = Metrics.distribution(DatastoreWriterFn.class, (String)"batchSize");
        private final @UnknownKeyFor @NonNull @Initialized Counter entitiesMutated = Metrics.counter(DatastoreWriterFn.class, (String)"datastoreEntitiesMutated");
        private final @UnknownKeyFor @NonNull @Initialized Distribution latencyMsPerMutation = Metrics.distribution(DatastoreWriterFn.class, (String)"datastoreLatencyMsPerMutation");
        private static final @UnknownKeyFor @NonNull @Initialized int MAX_RETRIES = 5;
        private static final @UnknownKeyFor @NonNull @Initialized FluentBackoff BUNDLE_WRITE_BACKOFF = FluentBackoff.DEFAULT.withMaxRetries(5).withInitialBackoff(Duration.standardSeconds((long)5L));

        DatastoreWriterFn(@UnknownKeyFor @NonNull @Initialized String projectId, @Nullable @UnknownKeyFor @Initialized String localhost) {
            this((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId), localhost, new V1DatastoreFactory(), new WriteBatcherImpl());
        }

        DatastoreWriterFn(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> projectId, @Nullable @UnknownKeyFor @Initialized String localhost) {
            this(projectId, localhost, new V1DatastoreFactory(), new WriteBatcherImpl());
        }

        @VisibleForTesting
        DatastoreWriterFn(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> projectId, @Nullable @UnknownKeyFor @Initialized String localhost, @UnknownKeyFor @NonNull @Initialized V1DatastoreFactory datastoreFactory, @UnknownKeyFor @NonNull @Initialized WriteBatcher writeBatcher) {
            this.projectId = (ValueProvider)Preconditions.checkNotNull(projectId, (Object)"projectId");
            this.localhost = localhost;
            this.datastoreFactory = datastoreFactory;
            this.writeBatcher = writeBatcher;
        }

        @DoFn.StartBundle
        public void startBundle(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized StartBundleContext c) {
            this.datastore = this.datastoreFactory.getDatastore(c.getPipelineOptions(), (String)this.projectId.get(), this.localhost);
            this.writeBatcher.start();
            if (this.adaptiveThrottler == null) {
                this.adaptiveThrottler = new AdaptiveThrottler(120000L, 10000L, 1.25);
            }
        }

        private static @UnknownKeyFor @NonNull @Initialized Key getKey(@UnknownKeyFor @NonNull @Initialized Mutation m) {
            if (m.hasUpsert()) {
                return m.getUpsert().getKey();
            }
            if (m.hasInsert()) {
                return m.getInsert().getKey();
            }
            if (m.hasDelete()) {
                return m.getDelete();
            }
            if (m.hasUpdate()) {
                return m.getUpdate().getKey();
            }
            LOG.warn("Mutation {} does not have an operation type set.", (Object)m);
            return Entity.getDefaultInstance().getKey();
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
            Mutation mutation = (Mutation)c.element();
            int size = mutation.getSerializedSize();
            if (!this.uniqueMutationKeys.add(DatastoreWriterFn.getKey(mutation))) {
                this.flushBatch();
            }
            if (this.mutations.size() > 0 && this.mutationsSize + size >= 9000000) {
                this.flushBatch();
            }
            this.mutations.add((Mutation)c.element());
            this.mutationsSize += size;
            if (this.mutations.size() >= this.writeBatcher.nextBatchSize(System.currentTimeMillis())) {
                this.flushBatch();
            }
        }

        @DoFn.FinishBundle
        public void finishBundle() throws @UnknownKeyFor @NonNull @Initialized Exception {
            if (!this.mutations.isEmpty()) {
                this.flushBatch();
            }
        }

        /*
         * Unable to fully structure code
         */
        private synchronized void flushBatch() throws @UnknownKeyFor @NonNull @Initialized DatastoreException, @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
            DatastoreWriterFn.LOG.debug("Writing batch of {} mutations", (Object)this.mutations.size());
            sleeper = Sleeper.DEFAULT;
            backoff = DatastoreWriterFn.BUNDLE_WRITE_BACKOFF.backoff();
            this.batchSize.update((long)this.mutations.size());
            while (true) {
                commitRequest = CommitRequest.newBuilder();
                commitRequest.addAllMutations(this.mutations);
                commitRequest.setMode(CommitRequest.Mode.NON_TRANSACTIONAL);
                startTime = System.currentTimeMillis();
                if (this.adaptiveThrottler.throttleRequest(startTime)) {
                    DatastoreWriterFn.LOG.info("Delaying request due to previous failures");
                    this.throttlingMsecs.inc(6000L);
                    sleeper.sleep(6000L);
                    continue;
                }
                baseLabels = new HashMap<String, String>();
                baseLabels.put("PTRANSFORM", "");
                baseLabels.put("SERVICE", "Datastore");
                baseLabels.put("METHOD", "BatchDatastoreWrite");
                baseLabels.put("RESOURCE", GcpResourceIdentifiers.datastoreResource((String)((String)this.projectId.get()), (String)""));
                baseLabels.put("DATASTORE_PROJECT", (String)this.projectId.get());
                baseLabels.put("DATASTORE_NAMESPACE", "");
                serviceCallMetric = new ServiceCallMetric(MonitoringInfoConstants.Urns.API_REQUEST_COUNT, baseLabels);
                try {
                    this.datastore.commit(commitRequest.build());
                    endTime = System.currentTimeMillis();
                    serviceCallMetric.call("ok");
                    this.writeBatcher.addRequestLatency(endTime, endTime - startTime, this.mutations.size());
                    this.adaptiveThrottler.successfulRequest(startTime);
                    this.latencyMsPerMutation.update((endTime - startTime) / (long)this.mutations.size());
                    this.rpcSuccesses.inc();
                    this.entitiesMutated.inc((long)this.mutations.size());
                }
                catch (DatastoreException exception) {
                    serviceCallMetric.call(exception.getCode().getNumber());
                    if (exception.getCode() == Code.DEADLINE_EXCEEDED) {
                        endTime = System.currentTimeMillis();
                        this.writeBatcher.addRequestLatency(endTime, endTime - startTime, this.mutations.size());
                        this.latencyMsPerMutation.update((endTime - startTime) / (long)this.mutations.size());
                    }
                    DatastoreWriterFn.LOG.error("Error writing batch of {} mutations to Datastore ({}): {}", new Object[]{this.mutations.size(), exception.getCode(), exception.getMessage()});
                    this.rpcErrors.inc();
                    if (DatastoreV1.access$200().contains(exception.getCode())) {
                        throw exception;
                    }
                    if (!BackOffUtils.next((Sleeper)sleeper, (BackOff)backoff)) ** break;
                    continue;
                    DatastoreWriterFn.LOG.error("Aborting after {} retries.", (Object)5);
                    throw exception;
                }
                break;
            }
            DatastoreWriterFn.LOG.debug("Successfully wrote {} mutations", (Object)this.mutations.size());
            this.mutations.clear();
            this.uniqueMutationKeys.clear();
            this.mutationsSize = 0;
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"projectId", this.projectId).withLabel("Output Project"));
        }
    }

    @VisibleForTesting
    static class WriteBatcherImpl
    implements WriteBatcher,
    Serializable {
        static final @UnknownKeyFor @NonNull @Initialized int DATASTORE_BATCH_TARGET_LATENCY_MS = 6000;
        private transient @UnknownKeyFor @NonNull @Initialized MovingAverage meanLatencyPerEntityMs;

        WriteBatcherImpl() {
        }

        @Override
        public void start() {
            this.meanLatencyPerEntityMs = new MovingAverage(120000L, 10000L, 1, 1);
        }

        @Override
        public void addRequestLatency(@UnknownKeyFor @NonNull @Initialized long timeSinceEpochMillis, @UnknownKeyFor @NonNull @Initialized long latencyMillis, @UnknownKeyFor @NonNull @Initialized int numMutations) {
            this.meanLatencyPerEntityMs.add(timeSinceEpochMillis, latencyMillis / (long)numMutations);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized int nextBatchSize(@UnknownKeyFor @NonNull @Initialized long timeSinceEpochMillis) {
            if (!this.meanLatencyPerEntityMs.hasValue(timeSinceEpochMillis)) {
                return 50;
            }
            long recentMeanLatency = Math.max(this.meanLatencyPerEntityMs.get(timeSinceEpochMillis), 1L);
            long targetBatchSize = 6000L / recentMeanLatency;
            return (int)Math.max(5L, Math.min(500L, targetBatchSize));
        }
    }

    @VisibleForTesting
    static interface WriteBatcher {
        public void start();

        public void addRequestLatency(@UnknownKeyFor @NonNull @Initialized long var1, @UnknownKeyFor @NonNull @Initialized long var3, @UnknownKeyFor @NonNull @Initialized int var5);

        public @UnknownKeyFor @NonNull @Initialized int nextBatchSize(@UnknownKeyFor @NonNull @Initialized long var1);
    }

    private static abstract class Mutate<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PDone> {
        protected @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> projectId;
        protected @Nullable @UnknownKeyFor @Initialized String localhost;
        protected @UnknownKeyFor @NonNull @Initialized boolean throttleRampup;
        protected @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> hintNumWorkers;
        private final @UnknownKeyFor @NonNull @Initialized SimpleFunction<T, @UnknownKeyFor @NonNull @Initialized Mutation> mutationFn;
        private @UnknownKeyFor @NonNull @Initialized RampupThrottlingFn<@UnknownKeyFor @NonNull @Initialized Mutation> rampupThrottlingFn;

        Mutate(@Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> projectId, @Nullable @UnknownKeyFor @Initialized String localhost, @UnknownKeyFor @NonNull @Initialized SimpleFunction<T, @UnknownKeyFor @NonNull @Initialized Mutation> mutationFn, @UnknownKeyFor @NonNull @Initialized boolean throttleRampup, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> hintNumWorkers) {
            this.projectId = projectId;
            this.localhost = localhost;
            this.throttleRampup = throttleRampup;
            this.hintNumWorkers = hintNumWorkers;
            this.mutationFn = (SimpleFunction)Preconditions.checkNotNull(mutationFn);
        }

        public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            Preconditions.checkArgument((this.projectId != null ? 1 : 0) != 0, (Object)"withProjectId() is required");
            if (this.projectId.isAccessible()) {
                Preconditions.checkArgument((this.projectId.get() != null ? 1 : 0) != 0, (Object)"projectId can not be null");
            }
            Preconditions.checkArgument((this.mutationFn != null ? 1 : 0) != 0, (Object)"mutationFn can not be null");
            PCollection intermediateOutput = (PCollection)input.apply("Convert to Mutation", (PTransform)MapElements.via(this.mutationFn));
            if (this.throttleRampup) {
                PCollectionView startTimestampView = (PCollectionView)input.getPipeline().apply("Generate start timestamp", (PTransform)new PTransform<PBegin, PCollectionView<Instant>>(){

                    public @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Instant> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
                        return (PCollectionView)((PCollection)((PCollection)input.apply((PTransform)Create.of((Object)"side input", (Object[])new String[0]))).apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptor.of(Instant.class)).via((SerializableFunction & Serializable)s -> Instant.now()))).apply((PTransform)View.asSingleton());
                    }
                });
                this.rampupThrottlingFn = new RampupThrottlingFn(this.hintNumWorkers, (PCollectionView<Instant>)startTimestampView);
                intermediateOutput = (PCollection)intermediateOutput.apply("Enforce ramp-up through throttling", (PTransform)ParDo.of(this.rampupThrottlingFn).withSideInputs(new PCollectionView[]{startTimestampView}));
            }
            intermediateOutput.apply("Write Mutation to Datastore", (PTransform)ParDo.of((DoFn)new DatastoreWriterFn(this.projectId, this.localhost)));
            return PDone.in((Pipeline)input.getPipeline());
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper(((Object)((Object)this)).getClass()).add("projectId", this.projectId).add("mutationFn", (Object)this.mutationFn.getClass().getName()).toString();
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"projectId", this.projectId).withLabel("Output Project")).include("mutationFn", this.mutationFn);
            if (this.rampupThrottlingFn != null) {
                builder.include("rampupThrottlingFn", this.rampupThrottlingFn);
            }
        }

        public @UnknownKeyFor @NonNull @Initialized String getProjectId() {
            return (String)this.projectId.get();
        }
    }

    public static class DeleteKey
    extends Mutate<Key> {
        DeleteKey(@Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> projectId, @Nullable @UnknownKeyFor @Initialized String localhost, @UnknownKeyFor @NonNull @Initialized boolean throttleRampup, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> hintNumWorkers) {
            super(projectId, localhost, new DeleteKeyFn(), throttleRampup, hintNumWorkers);
        }

        public @UnknownKeyFor @NonNull @Initialized DeleteKey withProjectId(@UnknownKeyFor @NonNull @Initialized String projectId) {
            Preconditions.checkArgument((projectId != null ? 1 : 0) != 0, (Object)"projectId can not be null");
            return this.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId));
        }

        public @UnknownKeyFor @NonNull @Initialized DeleteKey withLocalhost(@UnknownKeyFor @NonNull @Initialized String localhost) {
            Preconditions.checkArgument((localhost != null ? 1 : 0) != 0, (Object)"localhost can not be null");
            return new DeleteKey((ValueProvider<String>)this.projectId, localhost, this.throttleRampup, (ValueProvider<Integer>)this.hintNumWorkers);
        }

        public @UnknownKeyFor @NonNull @Initialized DeleteKey withProjectId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> projectId) {
            Preconditions.checkArgument((projectId != null ? 1 : 0) != 0, (Object)"projectId can not be null");
            return new DeleteKey(projectId, this.localhost, this.throttleRampup, (ValueProvider<Integer>)this.hintNumWorkers);
        }

        public @UnknownKeyFor @NonNull @Initialized DeleteKey withRampupThrottlingDisabled() {
            return new DeleteKey((ValueProvider<String>)this.projectId, this.localhost, false, (ValueProvider<Integer>)this.hintNumWorkers);
        }

        public @UnknownKeyFor @NonNull @Initialized DeleteKey withHintNumWorkers(@UnknownKeyFor @NonNull @Initialized int hintNumWorkers) {
            Preconditions.checkArgument((hintNumWorkers > 0 ? 1 : 0) != 0, (Object)"hintNumWorkers must be positive");
            return this.withHintNumWorkers((ValueProvider<Integer>)ValueProvider.StaticValueProvider.of((Object)hintNumWorkers));
        }

        public @UnknownKeyFor @NonNull @Initialized DeleteKey withHintNumWorkers(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> hintNumWorkers) {
            Preconditions.checkArgument((hintNumWorkers != null ? 1 : 0) != 0, (Object)"hintNumWorkers can not be null");
            return new DeleteKey((ValueProvider<String>)this.projectId, this.localhost, this.throttleRampup, hintNumWorkers);
        }
    }

    public static class DeleteEntity
    extends Mutate<Entity> {
        DeleteEntity(@Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> projectId, @Nullable @UnknownKeyFor @Initialized String localhost, @UnknownKeyFor @NonNull @Initialized boolean throttleRampup, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> hintNumWorkers) {
            super(projectId, localhost, new DeleteEntityFn(), throttleRampup, hintNumWorkers);
        }

        public @UnknownKeyFor @NonNull @Initialized DeleteEntity withProjectId(@UnknownKeyFor @NonNull @Initialized String projectId) {
            Preconditions.checkArgument((projectId != null ? 1 : 0) != 0, (Object)"projectId can not be null");
            return this.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId));
        }

        public @UnknownKeyFor @NonNull @Initialized DeleteEntity withProjectId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> projectId) {
            Preconditions.checkArgument((projectId != null ? 1 : 0) != 0, (Object)"projectId can not be null");
            return new DeleteEntity(projectId, this.localhost, this.throttleRampup, (ValueProvider<Integer>)this.hintNumWorkers);
        }

        public @UnknownKeyFor @NonNull @Initialized DeleteEntity withLocalhost(@UnknownKeyFor @NonNull @Initialized String localhost) {
            Preconditions.checkArgument((localhost != null ? 1 : 0) != 0, (Object)"localhost can not be null");
            return new DeleteEntity((ValueProvider<String>)this.projectId, localhost, this.throttleRampup, (ValueProvider<Integer>)this.hintNumWorkers);
        }

        public @UnknownKeyFor @NonNull @Initialized DeleteEntity withRampupThrottlingDisabled() {
            return new DeleteEntity((ValueProvider<String>)this.projectId, this.localhost, false, (ValueProvider<Integer>)this.hintNumWorkers);
        }

        public @UnknownKeyFor @NonNull @Initialized DeleteEntity withHintNumWorkers(@UnknownKeyFor @NonNull @Initialized int hintNumWorkers) {
            Preconditions.checkArgument((hintNumWorkers > 0 ? 1 : 0) != 0, (Object)"hintNumWorkers must be positive");
            return this.withHintNumWorkers((ValueProvider<Integer>)ValueProvider.StaticValueProvider.of((Object)hintNumWorkers));
        }

        public @UnknownKeyFor @NonNull @Initialized DeleteEntity withHintNumWorkers(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> hintNumWorkers) {
            Preconditions.checkArgument((hintNumWorkers != null ? 1 : 0) != 0, (Object)"hintNumWorkers can not be null");
            return new DeleteEntity((ValueProvider<String>)this.projectId, this.localhost, this.throttleRampup, hintNumWorkers);
        }
    }

    public static class Write
    extends Mutate<Entity> {
        Write(@Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> projectId, @Nullable @UnknownKeyFor @Initialized String localhost, @UnknownKeyFor @NonNull @Initialized boolean throttleRampup, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> hintNumWorkers) {
            super(projectId, localhost, new UpsertFn(), throttleRampup, hintNumWorkers);
        }

        public @UnknownKeyFor @NonNull @Initialized Write withProjectId(@UnknownKeyFor @NonNull @Initialized String projectId) {
            Preconditions.checkArgument((projectId != null ? 1 : 0) != 0, (Object)"projectId can not be null");
            return this.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId));
        }

        public @UnknownKeyFor @NonNull @Initialized Write withProjectId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> projectId) {
            Preconditions.checkArgument((projectId != null ? 1 : 0) != 0, (Object)"projectId can not be null");
            return new Write(projectId, this.localhost, this.throttleRampup, (ValueProvider<Integer>)this.hintNumWorkers);
        }

        public @UnknownKeyFor @NonNull @Initialized Write withLocalhost(@UnknownKeyFor @NonNull @Initialized String localhost) {
            Preconditions.checkArgument((localhost != null ? 1 : 0) != 0, (Object)"localhost can not be null");
            return new Write((ValueProvider<String>)this.projectId, localhost, this.throttleRampup, (ValueProvider<Integer>)this.hintNumWorkers);
        }

        public @UnknownKeyFor @NonNull @Initialized Write withRampupThrottlingDisabled() {
            return new Write((ValueProvider<String>)this.projectId, this.localhost, false, (ValueProvider<Integer>)this.hintNumWorkers);
        }

        public @UnknownKeyFor @NonNull @Initialized Write withHintNumWorkers(@UnknownKeyFor @NonNull @Initialized int hintNumWorkers) {
            return this.withHintNumWorkers((ValueProvider<Integer>)ValueProvider.StaticValueProvider.of((Object)hintNumWorkers));
        }

        public @UnknownKeyFor @NonNull @Initialized Write withHintNumWorkers(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> hintNumWorkers) {
            Preconditions.checkArgument((hintNumWorkers != null ? 1 : 0) != 0, (Object)"hintNumWorkers can not be null");
            return new Write((ValueProvider<String>)this.projectId, this.localhost, this.throttleRampup, hintNumWorkers);
        }
    }

    @AutoValue
    public static abstract class Read
    extends PTransform<PBegin, PCollection<Entity>> {
        private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(Read.class);
        public static final @UnknownKeyFor @NonNull @Initialized int NUM_QUERY_SPLITS_MAX = 50000;
        static final @UnknownKeyFor @NonNull @Initialized int NUM_QUERY_SPLITS_MIN = 12;
        static final @UnknownKeyFor @NonNull @Initialized long DEFAULT_BUNDLE_SIZE_BYTES = 0x4000000L;
        static final @UnknownKeyFor @NonNull @Initialized int QUERY_BATCH_LIMIT = 500;

        public abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getProjectId();

        public abstract @Nullable @UnknownKeyFor @Initialized Query getQuery();

        public abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getLiteralGqlQuery();

        public abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getNamespace();

        public abstract @UnknownKeyFor @NonNull @Initialized int getNumQuerySplits();

        public abstract @Nullable @UnknownKeyFor @Initialized String getLocalhost();

        public abstract @Nullable @UnknownKeyFor @Initialized Instant getReadTime();

        @SideEffectFree
        public abstract @UnknownKeyFor @NonNull @Initialized String toString();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        static @UnknownKeyFor @NonNull @Initialized int getEstimatedNumSplits(@UnknownKeyFor @NonNull @Initialized Datastore datastore, @UnknownKeyFor @NonNull @Initialized Query query, @Nullable @UnknownKeyFor @Initialized String namespace, @Nullable @UnknownKeyFor @Initialized Instant readTime) {
            int numSplits;
            try {
                long estimatedSizeBytes = Read.getEstimatedSizeBytes(datastore, query, namespace, readTime);
                LOG.info("Estimated size bytes for the query is: {}", (Object)estimatedSizeBytes);
                numSplits = (int)Math.min(50000L, Math.round((double)estimatedSizeBytes / 6.7108864E7));
            }
            catch (Exception e) {
                LOG.warn("Failed the fetch estimatedSizeBytes for query: {}", (Object)query, (Object)e);
                numSplits = 12;
            }
            return Math.max(numSplits, 12);
        }

        private static @UnknownKeyFor @NonNull @Initialized long queryLatestStatisticsTimestamp(@UnknownKeyFor @NonNull @Initialized Datastore datastore, @Nullable @UnknownKeyFor @Initialized String namespace, @Nullable @UnknownKeyFor @Initialized Instant readTime) throws @UnknownKeyFor @NonNull @Initialized DatastoreException {
            Query.Builder query = Query.newBuilder();
            if (Strings.isNullOrEmpty((String)namespace)) {
                query.addKindBuilder().setName("__Stat_Total__");
            } else {
                query.addKindBuilder().setName("__Stat_Ns_Total__");
            }
            query.addOrder(DatastoreHelper.makeOrder((String)"timestamp", (PropertyOrder.Direction)PropertyOrder.Direction.DESCENDING));
            query.setLimit(Int32Value.newBuilder().setValue(1));
            RunQueryRequest request = Read.makeRequest(query.build(), namespace, readTime);
            RunQueryResponse response = datastore.runQuery(request);
            QueryResultBatch batch = response.getBatch();
            if (batch.getEntityResultsCount() == 0) {
                throw new NoSuchElementException("Datastore total statistics unavailable");
            }
            Entity entity = batch.getEntityResults(0).getEntity();
            return entity.getPropertiesOrThrow("timestamp").getTimestampValue().getSeconds() * 1000000L;
        }

        private static @UnknownKeyFor @NonNull @Initialized Entity getLatestTableStats(@UnknownKeyFor @NonNull @Initialized String ourKind, @Nullable @UnknownKeyFor @Initialized String namespace, @UnknownKeyFor @NonNull @Initialized Datastore datastore, @Nullable @UnknownKeyFor @Initialized Instant readTime) throws @UnknownKeyFor @NonNull @Initialized DatastoreException {
            long latestTimestamp = Read.queryLatestStatisticsTimestamp(datastore, namespace, readTime);
            LOG.info("Latest stats timestamp for kind {} is {}", (Object)ourKind, (Object)latestTimestamp);
            Query.Builder queryBuilder = Query.newBuilder();
            if (Strings.isNullOrEmpty((String)namespace)) {
                queryBuilder.addKindBuilder().setName("__Stat_Kind__");
            } else {
                queryBuilder.addKindBuilder().setName("__Stat_Ns_Kind__");
            }
            queryBuilder.setFilter(DatastoreHelper.makeAndFilter((Filter[])new Filter[]{DatastoreHelper.makeFilter((String)"kind_name", (PropertyFilter.Operator)PropertyFilter.Operator.EQUAL, (Value)DatastoreHelper.makeValue((String)ourKind).build()).build(), DatastoreHelper.makeFilter((String)"timestamp", (PropertyFilter.Operator)PropertyFilter.Operator.EQUAL, (Value)DatastoreHelper.makeValue((long)latestTimestamp).build()).build()}));
            RunQueryRequest request = Read.makeRequest(queryBuilder.build(), namespace, readTime);
            long now = System.currentTimeMillis();
            RunQueryResponse response = datastore.runQuery(request);
            LOG.debug("Query for per-kind statistics took {}ms", (Object)(System.currentTimeMillis() - now));
            QueryResultBatch batch = response.getBatch();
            if (batch.getEntityResultsCount() == 0) {
                throw new NoSuchElementException("Datastore statistics for kind " + ourKind + " unavailable");
            }
            return batch.getEntityResults(0).getEntity();
        }

        static @UnknownKeyFor @NonNull @Initialized long getEstimatedSizeBytes(@UnknownKeyFor @NonNull @Initialized Datastore datastore, @UnknownKeyFor @NonNull @Initialized Query query, @Nullable @UnknownKeyFor @Initialized String namespace, @Nullable @UnknownKeyFor @Initialized Instant readTime) throws @UnknownKeyFor @NonNull @Initialized DatastoreException {
            String ourKind = query.getKind(0).getName();
            Entity entity = Read.getLatestTableStats(ourKind, namespace, datastore, readTime);
            return entity.getPropertiesOrThrow("entity_bytes").getIntegerValue();
        }

        private static // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PartitionId.Builder forNamespace(@Nullable @UnknownKeyFor @Initialized String namespace) {
            PartitionId.Builder partitionBuilder = PartitionId.newBuilder();
            if (!Strings.isNullOrEmpty((String)namespace)) {
                partitionBuilder.setNamespaceId(namespace);
            }
            return partitionBuilder;
        }

        static @UnknownKeyFor @NonNull @Initialized RunQueryRequest makeRequest(@UnknownKeyFor @NonNull @Initialized Query query, @Nullable @UnknownKeyFor @Initialized String namespace, @Nullable @UnknownKeyFor @Initialized Instant readTime) {
            RunQueryRequest.Builder request = RunQueryRequest.newBuilder().setQuery(query).setPartitionId(Read.forNamespace(namespace));
            if (readTime != null) {
                Timestamp readTimeProto = Timestamps.fromMillis((long)readTime.getMillis());
                request.setReadOptions(ReadOptions.newBuilder().setReadTime(readTimeProto).build());
            }
            return request.build();
        }

        @VisibleForTesting
        static @UnknownKeyFor @NonNull @Initialized RunQueryRequest makeRequest(@UnknownKeyFor @NonNull @Initialized GqlQuery gqlQuery, @Nullable @UnknownKeyFor @Initialized String namespace, @Nullable @UnknownKeyFor @Initialized Instant readTime) {
            RunQueryRequest.Builder request = RunQueryRequest.newBuilder().setGqlQuery(gqlQuery).setPartitionId(Read.forNamespace(namespace));
            if (readTime != null) {
                Timestamp readTimeProto = Timestamps.fromMillis((long)readTime.getMillis());
                request.setReadOptions(ReadOptions.newBuilder().setReadTime(readTimeProto).build());
            }
            return request.build();
        }

        private static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Query> splitQuery(@UnknownKeyFor @NonNull @Initialized Query query, @Nullable @UnknownKeyFor @Initialized String namespace, @UnknownKeyFor @NonNull @Initialized Datastore datastore, @UnknownKeyFor @NonNull @Initialized QuerySplitter querySplitter, @UnknownKeyFor @NonNull @Initialized int numSplits, @Nullable @UnknownKeyFor @Initialized Instant readTime) throws @UnknownKeyFor @NonNull @Initialized DatastoreException {
            PartitionId partitionId = Read.forNamespace(namespace).build();
            if (readTime != null) {
                Timestamp readTimeProto = Timestamps.fromMillis((long)readTime.getMillis());
                return querySplitter.getSplits(query, partitionId, numSplits, datastore, readTimeProto);
            }
            return querySplitter.getSplits(query, partitionId, numSplits, datastore);
        }

        @VisibleForTesting
        static @UnknownKeyFor @NonNull @Initialized Query translateGqlQueryWithLimitCheck(@UnknownKeyFor @NonNull @Initialized String gql, @UnknownKeyFor @NonNull @Initialized Datastore datastore, @UnknownKeyFor @NonNull @Initialized String namespace, @Nullable @UnknownKeyFor @Initialized Instant readTime) throws @UnknownKeyFor @NonNull @Initialized DatastoreException {
            String gqlQueryWithZeroLimit = gql + " LIMIT 0";
            try {
                Query translatedQuery = Read.translateGqlQuery(gqlQueryWithZeroLimit, datastore, namespace, readTime);
                return translatedQuery.toBuilder().clearLimit().build();
            }
            catch (DatastoreException e) {
                if (e.getCode() == Code.INVALID_ARGUMENT) {
                    LOG.warn("Failed to translate Gql query '{}': {}", (Object)gqlQueryWithZeroLimit, (Object)e.getMessage());
                    LOG.warn("User query might have a limit already set, so trying without zero limit");
                    return Read.translateGqlQuery(gql, datastore, namespace, readTime);
                }
                throw e;
            }
        }

        private static @UnknownKeyFor @NonNull @Initialized Query translateGqlQuery(@UnknownKeyFor @NonNull @Initialized String gql, @UnknownKeyFor @NonNull @Initialized Datastore datastore, @UnknownKeyFor @NonNull @Initialized String namespace, @Nullable @UnknownKeyFor @Initialized Instant readTime) throws @UnknownKeyFor @NonNull @Initialized DatastoreException {
            GqlQuery gqlQuery = GqlQuery.newBuilder().setQueryString(gql).setAllowLiterals(true).build();
            RunQueryRequest req = Read.makeRequest(gqlQuery, namespace, readTime);
            return datastore.runQuery(req).getQuery();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withProjectId(@UnknownKeyFor @NonNull @Initialized String projectId) {
            Preconditions.checkArgument((projectId != null ? 1 : 0) != 0, (Object)"projectId can not be null");
            return this.toBuilder().setProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withProjectId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> projectId) {
            Preconditions.checkArgument((projectId != null ? 1 : 0) != 0, (Object)"projectId can not be null");
            return this.toBuilder().setProjectId(projectId).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withQuery(@UnknownKeyFor @NonNull @Initialized Query query) {
            Preconditions.checkArgument((query != null ? 1 : 0) != 0, (Object)"query can not be null");
            Preconditions.checkArgument((!query.hasLimit() || query.getLimit().getValue() > 0 ? 1 : 0) != 0, (String)"Invalid query limit %s: must be positive", (int)query.getLimit().getValue());
            return this.toBuilder().setQuery(query).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withLiteralGqlQuery(@UnknownKeyFor @NonNull @Initialized String gqlQuery) {
            Preconditions.checkArgument((gqlQuery != null ? 1 : 0) != 0, (Object)"gqlQuery can not be null");
            return this.toBuilder().setLiteralGqlQuery((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)gqlQuery)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withLiteralGqlQuery(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> gqlQuery) {
            Preconditions.checkArgument((gqlQuery != null ? 1 : 0) != 0, (Object)"gqlQuery can not be null");
            if (gqlQuery.isAccessible()) {
                Preconditions.checkArgument((gqlQuery.get() != null ? 1 : 0) != 0, (Object)"gqlQuery can not be null");
            }
            return this.toBuilder().setLiteralGqlQuery(gqlQuery).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withNamespace(@UnknownKeyFor @NonNull @Initialized String namespace) {
            return this.toBuilder().setNamespace((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)namespace)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withNamespace(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> namespace) {
            return this.toBuilder().setNamespace(namespace).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withNumQuerySplits(@UnknownKeyFor @NonNull @Initialized int numQuerySplits) {
            return this.toBuilder().setNumQuerySplits(Math.min(Math.max(numQuerySplits, 0), 50000)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withLocalhost(@UnknownKeyFor @NonNull @Initialized String localhost) {
            return this.toBuilder().setLocalhost(localhost).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withReadTime(@UnknownKeyFor @NonNull @Initialized Instant readTime) {
            return this.toBuilder().setReadTime(readTime).build();
        }

        public @UnknownKeyFor @NonNull @Initialized long getNumEntities(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized String ourKind, @Nullable @UnknownKeyFor @Initialized String namespace) {
            try {
                V1Options v1Options = V1Options.from(this.getProjectId(), this.getNamespace(), this.getLocalhost());
                V1DatastoreFactory datastoreFactory = new V1DatastoreFactory();
                Datastore datastore = datastoreFactory.getDatastore(options, v1Options.getProjectId(), v1Options.getLocalhost());
                Entity entity = Read.getLatestTableStats(ourKind, namespace, datastore, this.getReadTime());
                return entity.getPropertiesOrThrow("count").getIntegerValue();
            }
            catch (Exception e) {
                return -1L;
            }
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Entity> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            Preconditions.checkArgument((this.getProjectId() != null ? 1 : 0) != 0, (Object)"projectId provider cannot be null");
            if (this.getProjectId().isAccessible()) {
                Preconditions.checkArgument((this.getProjectId().get() != null ? 1 : 0) != 0, (Object)"projectId cannot be null");
            }
            Preconditions.checkArgument((this.getQuery() != null || this.getLiteralGqlQuery() != null ? 1 : 0) != 0, (Object)"Either withQuery() or withLiteralGqlQuery() is required");
            Preconditions.checkArgument((this.getQuery() == null || this.getLiteralGqlQuery() == null ? 1 : 0) != 0, (Object)"withQuery() and withLiteralGqlQuery() are exclusive");
            V1Options v1Options = V1Options.from(this.getProjectId(), this.getNamespace(), this.getLocalhost());
            PCollection inputQuery = this.getQuery() != null ? (PCollection)input.apply((PTransform)Create.of((Object)this.getQuery(), (Object[])new Query[0])) : (PCollection)((PCollection)input.apply((PTransform)Create.ofProvider(this.getLiteralGqlQuery(), (Coder)StringUtf8Coder.of()))).apply((PTransform)ParDo.of((DoFn)new GqlQueryTranslateFn(v1Options, this.getReadTime())));
            return (PCollection)((PCollection)((PCollection)inputQuery.apply("Split", (PTransform)ParDo.of((DoFn)new SplitQueryFn(v1Options, this.getNumQuerySplits(), this.getReadTime())))).apply("Reshuffle", (PTransform)Reshuffle.viaRandomKey())).apply("Read", (PTransform)ParDo.of((DoFn)new ReadFn(v1Options, this.getReadTime())));
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            String query = this.getQuery() == null ? null : this.getQuery().toString();
            builder.addIfNotNull(DisplayData.item((String)"projectId", this.getProjectId()).withLabel("ProjectId")).addIfNotNull(DisplayData.item((String)"namespace", this.getNamespace()).withLabel("Namespace")).addIfNotNull(DisplayData.item((String)"query", (String)query).withLabel("Query")).addIfNotNull(DisplayData.item((String)"gqlQuery", this.getLiteralGqlQuery()).withLabel("GqlQuery")).addIfNotNull(DisplayData.item((String)"readTime", (Instant)this.getReadTime()).withLabel("ReadTime"));
        }

        @VisibleForTesting
        static class ReadFn
        extends DoFn<Query, Entity> {
            private final @UnknownKeyFor @NonNull @Initialized V1Options options;
            private final @Nullable @UnknownKeyFor @Initialized Instant readTime;
            private final @UnknownKeyFor @NonNull @Initialized V1DatastoreFactory datastoreFactory;
            private transient @UnknownKeyFor @NonNull @Initialized Datastore datastore;
            private final @UnknownKeyFor @NonNull @Initialized Counter rpcErrors = Metrics.counter(DatastoreWriterFn.class, (String)"datastoreRpcErrors");
            private final @UnknownKeyFor @NonNull @Initialized Counter rpcSuccesses = Metrics.counter(DatastoreWriterFn.class, (String)"datastoreRpcSuccesses");
            private static final @UnknownKeyFor @NonNull @Initialized int MAX_RETRIES = 5;
            private static final @UnknownKeyFor @NonNull @Initialized FluentBackoff RUNQUERY_BACKOFF = FluentBackoff.DEFAULT.withMaxRetries(5).withInitialBackoff(Duration.standardSeconds((long)5L));

            public ReadFn(@UnknownKeyFor @NonNull @Initialized V1Options options) {
                this(options, null, new V1DatastoreFactory());
            }

            public ReadFn(@UnknownKeyFor @NonNull @Initialized V1Options options, @Nullable @UnknownKeyFor @Initialized Instant readTime) {
                this(options, readTime, new V1DatastoreFactory());
            }

            @VisibleForTesting
            ReadFn(@UnknownKeyFor @NonNull @Initialized V1Options options, @Nullable @UnknownKeyFor @Initialized Instant readTime, @UnknownKeyFor @NonNull @Initialized V1DatastoreFactory datastoreFactory) {
                this.options = options;
                this.readTime = readTime;
                this.datastoreFactory = datastoreFactory;
            }

            @DoFn.StartBundle
            public void startBundle(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized StartBundleContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                this.datastore = this.datastoreFactory.getDatastore(c.getPipelineOptions(), this.options.getProjectId(), this.options.getLocalhost());
            }

            private @UnknownKeyFor @NonNull @Initialized RunQueryResponse runQueryWithRetries(@UnknownKeyFor @NonNull @Initialized RunQueryRequest request) throws @UnknownKeyFor @NonNull @Initialized Exception {
                Sleeper sleeper = Sleeper.DEFAULT;
                BackOff backoff = RUNQUERY_BACKOFF.backoff();
                while (true) {
                    HashMap<String, String> baseLabels = new HashMap<String, String>();
                    baseLabels.put("PTRANSFORM", "");
                    baseLabels.put("SERVICE", "Datastore");
                    baseLabels.put("METHOD", "BatchDatastoreRead");
                    baseLabels.put("RESOURCE", GcpResourceIdentifiers.datastoreResource((String)this.options.getProjectId(), (String)this.options.getNamespace()));
                    baseLabels.put("DATASTORE_PROJECT", this.options.getProjectId());
                    baseLabels.put("DATASTORE_NAMESPACE", String.valueOf(this.options.getNamespace()));
                    ServiceCallMetric serviceCallMetric = new ServiceCallMetric(MonitoringInfoConstants.Urns.API_REQUEST_COUNT, baseLabels);
                    try {
                        RunQueryResponse response = this.datastore.runQuery(request);
                        serviceCallMetric.call("ok");
                        this.rpcSuccesses.inc();
                        return response;
                    }
                    catch (DatastoreException exception) {
                        this.rpcErrors.inc();
                        serviceCallMetric.call(exception.getCode().getNumber());
                        if (!NON_RETRYABLE_ERRORS.contains(exception.getCode())) continue;
                        throw exception;
                        if (BackOffUtils.next((Sleeper)sleeper, (BackOff)backoff)) continue;
                        LOG.error("Aborting after {} retries.", (Object)5);
                        throw exception;
                    }
                    break;
                }
            }

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) throws @UnknownKeyFor @NonNull @Initialized Exception {
                Query query = (Query)context.element();
                String namespace = this.options.getNamespace();
                int userLimit = query.hasLimit() ? query.getLimit().getValue() : Integer.MAX_VALUE;
                boolean moreResults = true;
                QueryResultBatch currentBatch = null;
                while (moreResults) {
                    Query.Builder queryBuilder = query.toBuilder();
                    queryBuilder.setLimit(Int32Value.newBuilder().setValue(Math.min(userLimit, 500)));
                    if (currentBatch != null && !currentBatch.getEndCursor().isEmpty()) {
                        queryBuilder.setStartCursor(currentBatch.getEndCursor());
                    }
                    RunQueryRequest request = Read.makeRequest(queryBuilder.build(), namespace, this.readTime);
                    RunQueryResponse response = this.runQueryWithRetries(request);
                    currentBatch = response.getBatch();
                    int numFetch = currentBatch.getEntityResultsCount();
                    if (query.hasLimit()) {
                        Verify.verify((userLimit >= numFetch ? 1 : 0) != 0, (String)"Expected userLimit %s >= numFetch %s, because query limit %s must be <= userLimit", (Object)userLimit, (Object)numFetch, (Object)query.getLimit());
                        userLimit -= numFetch;
                    }
                    for (EntityResult entityResult : currentBatch.getEntityResultsList()) {
                        context.output((Object)entityResult.getEntity());
                    }
                    moreResults = userLimit > 0 && (numFetch == 500 || currentBatch.getMoreResults() == QueryResultBatch.MoreResultsType.NOT_FINISHED);
                }
            }

            public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
                super.populateDisplayData(builder);
                builder.include("options", (HasDisplayData)this.options);
                builder.addIfNotNull(DisplayData.item((String)"readTime", (Instant)this.readTime).withLabel("ReadTime"));
            }
        }

        @VisibleForTesting
        static class SplitQueryFn
        extends DoFn<Query, Query> {
            private final @UnknownKeyFor @NonNull @Initialized V1Options options;
            private final @UnknownKeyFor @NonNull @Initialized int numSplits;
            private final @Nullable @UnknownKeyFor @Initialized Instant readTime;
            private final @UnknownKeyFor @NonNull @Initialized V1DatastoreFactory datastoreFactory;
            private transient @UnknownKeyFor @NonNull @Initialized Datastore datastore;
            private transient @UnknownKeyFor @NonNull @Initialized QuerySplitter querySplitter;

            public SplitQueryFn(@UnknownKeyFor @NonNull @Initialized V1Options options, @UnknownKeyFor @NonNull @Initialized int numSplits) {
                this(options, numSplits, null, new V1DatastoreFactory());
            }

            public SplitQueryFn(@UnknownKeyFor @NonNull @Initialized V1Options options, @UnknownKeyFor @NonNull @Initialized int numSplits, @Nullable @UnknownKeyFor @Initialized Instant readTime) {
                this(options, numSplits, readTime, new V1DatastoreFactory());
            }

            @VisibleForTesting
            SplitQueryFn(@UnknownKeyFor @NonNull @Initialized V1Options options, @UnknownKeyFor @NonNull @Initialized int numSplits, @Nullable @UnknownKeyFor @Initialized Instant readTime, @UnknownKeyFor @NonNull @Initialized V1DatastoreFactory datastoreFactory) {
                this.options = options;
                this.numSplits = numSplits;
                this.datastoreFactory = datastoreFactory;
                this.readTime = readTime;
            }

            @DoFn.StartBundle
            public void startBundle(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized StartBundleContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                this.datastore = this.datastoreFactory.getDatastore(c.getPipelineOptions(), this.options.getProjectId(), this.options.getLocalhost());
                this.querySplitter = this.datastoreFactory.getQuerySplitter();
            }

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                Object querySplits;
                Query query = (Query)c.element();
                if (query.hasLimit()) {
                    c.output((Object)query);
                    return;
                }
                int estimatedNumSplits = this.numSplits <= 0 ? Read.getEstimatedNumSplits(this.datastore, query, this.options.getNamespace(), this.readTime) : this.numSplits;
                LOG.info("Splitting the query into {} splits", (Object)estimatedNumSplits);
                try {
                    querySplits = Read.splitQuery(query, this.options.getNamespace(), this.datastore, this.querySplitter, estimatedNumSplits, this.readTime);
                }
                catch (Exception e) {
                    LOG.warn("Unable to parallelize the given query: {}", (Object)query, (Object)e);
                    querySplits = ImmutableList.of((Object)query);
                }
                for (Query subquery : querySplits) {
                    c.output((Object)subquery);
                }
            }

            public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
                super.populateDisplayData(builder);
                builder.include("options", (HasDisplayData)this.options);
                if (this.numSplits > 0) {
                    builder.add(DisplayData.item((String)"numQuerySplits", (Integer)this.numSplits).withLabel("Requested number of Query splits"));
                }
                builder.addIfNotNull(DisplayData.item((String)"readTime", (Instant)this.readTime).withLabel("ReadTime"));
            }
        }

        static class GqlQueryTranslateFn
        extends DoFn<String, Query> {
            private final @UnknownKeyFor @NonNull @Initialized V1Options v1Options;
            private final @Nullable @UnknownKeyFor @Initialized Instant readTime;
            private transient @UnknownKeyFor @NonNull @Initialized Datastore datastore;
            private final @UnknownKeyFor @NonNull @Initialized V1DatastoreFactory datastoreFactory;

            GqlQueryTranslateFn(@UnknownKeyFor @NonNull @Initialized V1Options options) {
                this(options, null, new V1DatastoreFactory());
            }

            GqlQueryTranslateFn(@UnknownKeyFor @NonNull @Initialized V1Options options, @Nullable @UnknownKeyFor @Initialized Instant readTime) {
                this(options, readTime, new V1DatastoreFactory());
            }

            GqlQueryTranslateFn(@UnknownKeyFor @NonNull @Initialized V1Options options, @Nullable @UnknownKeyFor @Initialized Instant readTime, @UnknownKeyFor @NonNull @Initialized V1DatastoreFactory datastoreFactory) {
                this.v1Options = options;
                this.readTime = readTime;
                this.datastoreFactory = datastoreFactory;
            }

            @DoFn.StartBundle
            public void startBundle(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized StartBundleContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                this.datastore = this.datastoreFactory.getDatastore(c.getPipelineOptions(), this.v1Options.getProjectId(), this.v1Options.getLocalhost());
            }

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                String gqlQuery = (String)c.element();
                LOG.info("User query: '{}'", (Object)gqlQuery);
                Query query = Read.translateGqlQueryWithLimitCheck(gqlQuery, this.datastore, this.v1Options.getNamespace(), this.readTime);
                LOG.info("User gql query translated to Query({})", (Object)query);
                c.output((Object)query);
            }
        }

        @VisibleForTesting
        static class V1Options
        implements HasDisplayData,
        Serializable {
            private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> project;
            private final @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> namespace;
            private final @Nullable @UnknownKeyFor @Initialized String localhost;

            private V1Options(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> project, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> namespace, @UnknownKeyFor @NonNull @Initialized String localhost) {
                this.project = project;
                this.namespace = namespace;
                this.localhost = localhost;
            }

            public static @UnknownKeyFor @NonNull @Initialized V1Options from(@UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized String namespace, @UnknownKeyFor @NonNull @Initialized String localhost) {
                return V1Options.from((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId), (ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)namespace), localhost);
            }

            public static @UnknownKeyFor @NonNull @Initialized V1Options from(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> project, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> namespace, @UnknownKeyFor @NonNull @Initialized String localhost) {
                return new V1Options(project, namespace, localhost);
            }

            public @UnknownKeyFor @NonNull @Initialized String getProjectId() {
                return (String)this.project.get();
            }

            public @Nullable @UnknownKeyFor @Initialized String getNamespace() {
                return this.namespace == null ? null : (String)this.namespace.get();
            }

            public @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getProjectValueProvider() {
                return this.project;
            }

            public @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getNamespaceValueProvider() {
                return this.namespace;
            }

            public @Nullable @UnknownKeyFor @Initialized String getLocalhost() {
                return this.localhost;
            }

            public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
                builder.addIfNotNull(DisplayData.item((String)"projectId", this.getProjectValueProvider()).withLabel("ProjectId")).addIfNotNull(DisplayData.item((String)"namespace", this.getNamespaceValueProvider()).withLabel("Namespace"));
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setProjectId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setQuery(@UnknownKeyFor @NonNull @Initialized Query var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setLiteralGqlQuery(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setNamespace(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setNumQuerySplits(@UnknownKeyFor @NonNull @Initialized int var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setLocalhost(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setReadTime(@UnknownKeyFor @NonNull @Initialized Instant var1);

            abstract @UnknownKeyFor @NonNull @Initialized Read build();
        }
    }
}

