/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable;

import com.google.bigtable.v2.Cell;
import com.google.protobuf.ByteString;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.PassThroughLogicalType;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.primitives.Ints;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.primitives.Longs;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.primitives.Shorts;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.DateTime;

class CellValueParser
implements Serializable {
    CellValueParser() {
    }

    @UnknownKeyFor @NonNull @Initialized Object getCellValue(@UnknownKeyFor @NonNull @Initialized Cell cell, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Schema.FieldType type) {
        ByteString cellValue = cell.getValue();
        int valueSize = cellValue.size();
        switch (type.getTypeName()) {
            case BOOLEAN: {
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((valueSize == 1 ? 1 : 0) != 0, (Object)this.message("Boolean", 1));
                return cellValue.toByteArray()[0] != 0;
            }
            case BYTE: {
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((valueSize == 1 ? 1 : 0) != 0, (Object)this.message("Byte", 1));
                return cellValue.toByteArray()[0];
            }
            case INT16: {
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((valueSize == 2 ? 1 : 0) != 0, (Object)this.message("Int16", 2));
                return Shorts.fromByteArray((byte[])cellValue.toByteArray());
            }
            case INT32: {
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((valueSize == 4 ? 1 : 0) != 0, (Object)this.message("Int32", 4));
                return Ints.fromByteArray((byte[])cellValue.toByteArray());
            }
            case INT64: {
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((valueSize == 8 ? 1 : 0) != 0, (Object)this.message("Int64", 8));
                return Longs.fromByteArray((byte[])cellValue.toByteArray());
            }
            case FLOAT: {
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((valueSize == 4 ? 1 : 0) != 0, (Object)this.message("Float", 4));
                return Float.valueOf(Float.intBitsToFloat(Ints.fromByteArray((byte[])cellValue.toByteArray())));
            }
            case DOUBLE: {
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((valueSize == 8 ? 1 : 0) != 0, (Object)this.message("Double", 8));
                return Double.longBitsToDouble(Longs.fromByteArray((byte[])cellValue.toByteArray()));
            }
            case DATETIME: {
                return DateTime.parse((String)cellValue.toStringUtf8());
            }
            case STRING: {
                return cellValue.toStringUtf8();
            }
            case BYTES: {
                return cellValue.toByteArray();
            }
            case LOGICAL_TYPE: {
                String identifier = ((Schema.LogicalType)Preconditions.checkArgumentNotNull((Object)type.getLogicalType())).getIdentifier();
                throw new IllegalStateException("Unsupported logical type: " + identifier);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported cell value type '%s'.", type.getTypeName()));
    }

    @UnknownKeyFor @NonNull @Initialized ByteString valueToByteString(@UnknownKeyFor @NonNull @Initialized Object value, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Schema.FieldType type) {
        switch (type.getTypeName()) {
            case BOOLEAN: {
                byte[] byArray;
                if (((Boolean)value).booleanValue()) {
                    byte[] byArray2 = new byte[1];
                    byArray = byArray2;
                    byArray2[0] = 1;
                } else {
                    byte[] byArray3 = new byte[1];
                    byArray = byArray3;
                    byArray3[0] = 0;
                }
                return this.byteString(byArray);
            }
            case FLOAT: {
                return this.byteString(Ints.toByteArray((int)Float.floatToIntBits(((Float)value).floatValue())));
            }
            case DOUBLE: {
                return this.byteString(Longs.toByteArray((long)Double.doubleToLongBits((Double)value)));
            }
            case BYTE: {
                return this.byteString(new byte[]{(Byte)value});
            }
            case INT16: {
                return this.byteString(Shorts.toByteArray((short)((Short)value)));
            }
            case INT32: {
                return this.byteString(Ints.toByteArray((int)((Integer)value)));
            }
            case INT64: {
                return this.byteString(Longs.toByteArray((long)((Long)value)));
            }
            case STRING: {
                return this.byteString(((String)value).getBytes(StandardCharsets.UTF_8));
            }
            case BYTES: {
                return this.byteString((byte[])value);
            }
            case DATETIME: {
                return this.byteString(value.toString().getBytes(StandardCharsets.UTF_8));
            }
            case LOGICAL_TYPE: {
                Schema.LogicalType logicalType = (Schema.LogicalType)Preconditions.checkArgumentNotNull((Object)type.getLogicalType());
                if (logicalType instanceof PassThroughLogicalType) {
                    return this.valueToByteString(value, logicalType.getBaseType());
                }
                throw new IllegalStateException("Unsupported logical type: " + logicalType.getIdentifier());
            }
        }
        throw new IllegalStateException("Unsupported type: " + type.getTypeName());
    }

    private @UnknownKeyFor @NonNull @Initialized ByteString byteString(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] value) {
        return ByteString.copyFrom((byte[])value);
    }

    private @UnknownKeyFor @NonNull @Initialized String message(@UnknownKeyFor @NonNull @Initialized String type, @UnknownKeyFor @NonNull @Initialized int byteSize) {
        return String.format("%s has to be %s-byte%s long bytearray", type, byteSize, byteSize == 1 ? "" : "s");
    }
}

