/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable.changestreams.estimator;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Random;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.TimestampConverter;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.estimator.SizeEstimator;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.estimator.ThroughputEstimator;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

@Internal
public class BytesThroughputEstimator<@UnknownKeyFor T>
implements ThroughputEstimator<T> {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = -1147130541208370666L;
    private static final @UnknownKeyFor @NonNull @Initialized BigDecimal MAX_DOUBLE = BigDecimal.valueOf(Double.MAX_VALUE);
    private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_SAMPLE_RATE = 50;
    private final @UnknownKeyFor @NonNull @Initialized Deque<@UnknownKeyFor @NonNull @Initialized ThroughputEntry> deque = new ArrayDeque<ThroughputEntry>();
    private final @UnknownKeyFor @NonNull @Initialized int windowSizeSeconds;
    private final @UnknownKeyFor @NonNull @Initialized SizeEstimator<T> sizeEstimator;
    private final @UnknownKeyFor @NonNull @Initialized int sampleRate;
    private final @UnknownKeyFor @NonNull @Initialized Random random;

    public BytesThroughputEstimator(@UnknownKeyFor @NonNull @Initialized int windowSizeSeconds, @UnknownKeyFor @NonNull @Initialized SizeEstimator<T> sizeEstimator) {
        this(windowSizeSeconds, sizeEstimator, 50);
    }

    @VisibleForTesting
    public BytesThroughputEstimator(@UnknownKeyFor @NonNull @Initialized int windowSizeSeconds, @UnknownKeyFor @NonNull @Initialized SizeEstimator<T> sizeEstimator, @UnknownKeyFor @NonNull @Initialized int sampleRate) {
        this.windowSizeSeconds = windowSizeSeconds;
        this.sizeEstimator = sizeEstimator;
        this.sampleRate = sampleRate;
        this.random = new Random();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(@UnknownKeyFor @NonNull @Initialized Instant timeOfRecords, T element) {
        if (this.random.nextInt(this.sampleRate) == 0) {
            long bytes = this.sizeEstimator.sizeOf(element);
            Deque<ThroughputEntry> deque = this.deque;
            synchronized (deque) {
                if (this.deque.isEmpty() || TimestampConverter.toSeconds(timeOfRecords) > this.deque.getLast().getSeconds()) {
                    this.deque.addLast(new ThroughputEntry(timeOfRecords, bytes));
                } else {
                    this.deque.getLast().addBytes(bytes);
                }
                this.cleanQueue(this.deque.getLast().getTimestamp());
            }
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized double get() {
        return this.getFrom(Instant.now());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @UnknownKeyFor @NonNull @Initialized double getFrom(@UnknownKeyFor @NonNull @Initialized Instant time) {
        Deque<ThroughputEntry> deque = this.deque;
        synchronized (deque) {
            this.cleanQueue(time);
            if (this.deque.size() == 0) {
                return 0.0;
            }
            BigDecimal throughput = BigDecimal.ZERO;
            for (ThroughputEntry entry : this.deque) {
                throughput = throughput.add(entry.getBytes());
            }
            return throughput.max(BigDecimal.ZERO).divide(BigDecimal.valueOf(this.windowSizeSeconds), MathContext.DECIMAL128).multiply(BigDecimal.valueOf(this.sampleRate)).min(MAX_DOUBLE).doubleValue();
        }
    }

    private void cleanQueue(@UnknownKeyFor @NonNull @Initialized Instant time) {
        ThroughputEntry entry;
        while (this.deque.size() > 0 && ((entry = this.deque.getFirst()) == null || entry.getSeconds() < TimestampConverter.toSeconds(time) - (long)this.windowSizeSeconds)) {
            this.deque.removeFirst();
        }
    }

    private static class ThroughputEntry
    implements Serializable {
        private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 3752325891215855332L;
        private final @UnknownKeyFor @NonNull @Initialized Instant instant;
        private @UnknownKeyFor @NonNull @Initialized BigDecimal bytes;

        public ThroughputEntry(@UnknownKeyFor @NonNull @Initialized Instant instant, @UnknownKeyFor @NonNull @Initialized long bytes) {
            this.instant = instant;
            this.bytes = BigDecimal.valueOf(bytes);
        }

        public @UnknownKeyFor @NonNull @Initialized Instant getTimestamp() {
            return this.instant;
        }

        public @UnknownKeyFor @NonNull @Initialized long getSeconds() {
            return TimestampConverter.toSeconds(this.instant);
        }

        public @UnknownKeyFor @NonNull @Initialized BigDecimal getBytes() {
            return this.bytes;
        }

        public void addBytes(@UnknownKeyFor @NonNull @Initialized long bytesToAdd) {
            this.bytes = this.bytes.add(BigDecimal.valueOf(bytesToAdd));
        }
    }
}

