/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable.changestreams.dao;

import com.google.api.gax.rpc.ServerStream;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.models.ChangeStreamContinuationToken;
import com.google.cloud.bigtable.data.v2.models.ConditionalRowMutation;
import com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.cloud.bigtable.data.v2.models.Mutation;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.Range;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowCell;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.HashMap;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.SerializationException;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.SerializationUtils;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.dao.MetadataTableAdminDao;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class MetadataTableDao {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(MetadataTableDao.class);
    private final @UnknownKeyFor @NonNull @Initialized BigtableDataClient dataClient;
    private final @UnknownKeyFor @NonNull @Initialized String tableId;
    private final @UnknownKeyFor @NonNull @Initialized ByteString changeStreamNamePrefix;

    public MetadataTableDao(@UnknownKeyFor @NonNull @Initialized BigtableDataClient dataClient, @UnknownKeyFor @NonNull @Initialized String tableId, @UnknownKeyFor @NonNull @Initialized ByteString changeStreamNamePrefix) {
        this.dataClient = dataClient;
        this.tableId = tableId;
        this.changeStreamNamePrefix = changeStreamNamePrefix;
    }

    public @UnknownKeyFor @NonNull @Initialized ByteString getChangeStreamNamePrefix() {
        return this.changeStreamNamePrefix;
    }

    private @UnknownKeyFor @NonNull @Initialized ByteString getFullNewPartitionPrefix() {
        return this.changeStreamNamePrefix.concat(MetadataTableAdminDao.NEW_PARTITION_PREFIX);
    }

    private @UnknownKeyFor @NonNull @Initialized ByteString getFullStreamPartitionPrefix() {
        return this.changeStreamNamePrefix.concat(MetadataTableAdminDao.STREAM_PARTITION_PREFIX);
    }

    private @UnknownKeyFor @NonNull @Initialized ByteString getFullDetectNewPartition() {
        return this.changeStreamNamePrefix.concat(MetadataTableAdminDao.DETECT_NEW_PARTITION_SUFFIX);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange convertStreamPartitionRowKeyToPartition(@UnknownKeyFor @NonNull @Initialized ByteString rowKey) throws @UnknownKeyFor @NonNull @Initialized InvalidProtocolBufferException {
        int prefixLength = this.changeStreamNamePrefix.size() + MetadataTableAdminDao.STREAM_PARTITION_PREFIX.size();
        return Range.ByteStringRange.toByteStringRange((ByteString)rowKey.substring(prefixLength));
    }

    public @UnknownKeyFor @NonNull @Initialized ByteString convertPartitionToStreamPartitionRowKey(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange partition) {
        return this.getFullStreamPartitionPrefix().concat(Range.ByteStringRange.serializeToByteString((Range.ByteStringRange)partition));
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange convertNewPartitionRowKeyToPartition(@UnknownKeyFor @NonNull @Initialized ByteString rowKey) throws @UnknownKeyFor @NonNull @Initialized InvalidProtocolBufferException {
        int prefixLength = this.changeStreamNamePrefix.size() + MetadataTableAdminDao.NEW_PARTITION_PREFIX.size();
        return Range.ByteStringRange.toByteStringRange((ByteString)rowKey.substring(prefixLength));
    }

    public @UnknownKeyFor @NonNull @Initialized ByteString convertPartitionToNewPartitionRowKey(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange partition) {
        return this.getFullNewPartitionPrefix().concat(Range.ByteStringRange.serializeToByteString((Range.ByteStringRange)partition));
    }

    public @UnknownKeyFor @NonNull @Initialized ServerStream<@UnknownKeyFor @NonNull @Initialized Row> readNewPartitions() {
        Query query = Query.create((String)this.tableId).prefix(this.getFullNewPartitionPrefix()).filter(Filters.FILTERS.limit().cellsPerColumn(1));
        return this.dataClient.readRows(query);
    }

    public void writeNewPartition(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange newPartition, @UnknownKeyFor @NonNull @Initialized ChangeStreamContinuationToken changeStreamContinuationToken, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange parentPartition, @UnknownKeyFor @NonNull @Initialized Instant lowWatermark) {
        this.writeNewPartition(newPartition, changeStreamContinuationToken.toByteString(), Range.ByteStringRange.serializeToByteString((Range.ByteStringRange)parentPartition), lowWatermark);
    }

    private void writeNewPartition(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange newPartition, @UnknownKeyFor @NonNull @Initialized ByteString newPartitionContinuationToken, @UnknownKeyFor @NonNull @Initialized ByteString parentPartition, @UnknownKeyFor @NonNull @Initialized Instant lowWatermark) {
        LOG.debug("Insert new partition");
        ByteString rowKey = this.convertPartitionToNewPartitionRowKey(newPartition);
        RowMutation rowMutation = RowMutation.create((String)this.tableId, (ByteString)rowKey).setCell("initial_continuation_token", newPartitionContinuationToken, 1L).setCell("parent_partitions", parentPartition, 1L).setCell("parent_low_watermarks", parentPartition, lowWatermark.getMillis());
        this.dataClient.mutateRow(rowMutation);
    }

    public @UnknownKeyFor @NonNull @Initialized ServerStream<@UnknownKeyFor @NonNull @Initialized Row> readFromMdTableStreamPartitionsWithWatermark() {
        Query query = Query.create((String)this.tableId).prefix(this.getFullStreamPartitionPrefix()).filter((Filters.Filter)Filters.FILTERS.chain().filter(Filters.FILTERS.limit().cellsPerColumn(1)).filter(Filters.FILTERS.family().exactMatch("watermark")).filter(Filters.FILTERS.qualifier().exactMatch("latest")));
        return this.dataClient.readRows(query);
    }

    private void writeToMdTableWatermarkHelper(@UnknownKeyFor @NonNull @Initialized ByteString rowKey, @UnknownKeyFor @NonNull @Initialized Instant watermark, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized ChangeStreamContinuationToken currentToken) {
        RowMutation rowMutation = RowMutation.create((String)this.tableId, (ByteString)rowKey).setCell("watermark", "latest", watermark.getMillis());
        if (currentToken != null) {
            rowMutation.setCell("continuation_token", "latest", currentToken.getToken());
        }
        this.dataClient.mutateRow(rowMutation);
    }

    public void updateWatermark(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange partition, @UnknownKeyFor @NonNull @Initialized Instant watermark, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized ChangeStreamContinuationToken currentToken) {
        this.writeToMdTableWatermarkHelper(this.convertPartitionToStreamPartitionRowKey(partition), watermark, currentToken);
    }

    public void deleteStreamPartitionRow(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange partition) {
        ByteString rowKey = this.convertPartitionToStreamPartitionRowKey(partition);
        RowMutation rowMutation = RowMutation.create((String)this.tableId, (ByteString)rowKey).deleteRow();
        this.dataClient.mutateRow(rowMutation);
    }

    public void deleteRowKey(@UnknownKeyFor @NonNull @Initialized ByteString rowKey) {
        RowMutation rowMutation = RowMutation.create((String)this.tableId, (ByteString)rowKey).deleteRow();
        this.dataClient.mutateRow(rowMutation);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean lockPartition(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange partition, @UnknownKeyFor @NonNull @Initialized String uuid) {
        LOG.debug("Locking partition before processing stream");
        ByteString rowKey = this.convertPartitionToStreamPartitionRowKey(partition);
        Filters.ChainFilter lockCellFilter = Filters.FILTERS.chain().filter(Filters.FILTERS.family().exactMatch("lock")).filter(Filters.FILTERS.qualifier().exactMatch("latest")).filter(Filters.FILTERS.limit().cellsPerRow(1));
        Row row = this.dataClient.readRow(this.tableId, rowKey, (Filters.Filter)lockCellFilter);
        if (row != null) {
            return ((RowCell)row.getCells().get(0)).getValue().toStringUtf8().equals(uuid);
        }
        Mutation mutation = Mutation.create().setCell("lock", "latest", uuid);
        Filters.ChainFilter matchAnyString = Filters.FILTERS.chain().filter(Filters.FILTERS.family().exactMatch("lock")).filter(Filters.FILTERS.qualifier().exactMatch("latest")).filter(Filters.FILTERS.value().regex("\\C*"));
        ConditionalRowMutation rowMutation = ConditionalRowMutation.create((String)this.tableId, (ByteString)rowKey).condition((Filters.Filter)matchAnyString).otherwise(mutation);
        return this.dataClient.checkAndMutateRow(rowMutation) == false;
    }

    public void writeDetectNewPartitionVersion() {
        RowMutation rowMutation = RowMutation.create((String)this.tableId, (ByteString)this.getFullDetectNewPartition()).setCell("version", "latest", 1L);
        this.dataClient.mutateRow(rowMutation);
    }

    public @UnknownKeyFor @NonNull @Initialized HashMap<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange, @UnknownKeyFor @NonNull @Initialized Long> readDetectNewPartitionMissingPartitions() {
        HashMap missingPartitions = new HashMap();
        Filters.ChainFilter missingPartitionsFilter = Filters.FILTERS.chain().filter(Filters.FILTERS.family().exactMatch("missing_partitions")).filter(Filters.FILTERS.qualifier().exactMatch("latest")).filter(Filters.FILTERS.limit().cellsPerColumn(1));
        Row row = this.dataClient.readRow(this.tableId, this.getFullDetectNewPartition(), (Filters.Filter)missingPartitionsFilter);
        if (row == null || row.getCells("missing_partitions", "latest").isEmpty()) {
            return missingPartitions;
        }
        ByteString serializedMissingPartition = ((RowCell)row.getCells("missing_partitions", "latest").get(0)).getValue();
        try {
            missingPartitions = (HashMap)SerializationUtils.deserialize((byte[])serializedMissingPartition.toByteArray());
        }
        catch (NullPointerException | SerializationException exception) {
            LOG.warn("Failed to deserialize missingPartitions: {}", (Object)exception.toString());
        }
        return missingPartitions;
    }

    public void writeDetectNewPartitionMissingPartitions(@UnknownKeyFor @NonNull @Initialized HashMap<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange, @UnknownKeyFor @NonNull @Initialized Long> missingPartitionDurations) {
        byte[] serializedMissingPartition = SerializationUtils.serialize(missingPartitionDurations);
        RowMutation rowMutation = RowMutation.create((String)this.tableId, (ByteString)this.getFullDetectNewPartition()).setCell("missing_partitions", ByteString.copyFromUtf8((String)"latest"), ByteString.copyFrom((byte[])serializedMissingPartition));
        this.dataClient.mutateRow(rowMutation);
    }
}

