/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable;

import com.google.api.core.ApiFuture;
import com.google.api.gax.batching.Batcher;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.StreamController;
import com.google.bigtable.v2.MutateRowResponse;
import com.google.bigtable.v2.Mutation;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.v2.Row;
import com.google.bigtable.v2.RowFilter;
import com.google.bigtable.v2.RowRange;
import com.google.bigtable.v2.RowSet;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.cloud.bigtable.data.v2.internal.ByteStringComparator;
import com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.cloud.bigtable.data.v2.models.KeyOffset;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.RowAdapter;
import com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.protobuf.ByteString;
import io.grpc.CallOptions;
import io.grpc.Deadline;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.beam.runners.core.metrics.GcpResourceIdentifiers;
import org.apache.beam.runners.core.metrics.MonitoringInfoConstants;
import org.apache.beam.runners.core.metrics.ServiceCallMetric;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableIO;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableService;
import org.apache.beam.sdk.io.gcp.bigtable.VendoredListenableFutureAdapter;
import org.apache.beam.sdk.io.range.ByteKeyRange;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ComparisonChain;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.FutureCallback;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.Futures;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.MoreExecutors;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.SettableFuture;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BigtableServiceImpl
implements BigtableService {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(BigtableServiceImpl.class);
    private static final @UnknownKeyFor @NonNull @Initialized double DEFAULT_BYTE_LIMIT_PERCENTAGE = 0.1;
    private static final @UnknownKeyFor @NonNull @Initialized double WATERMARK_PERCENTAGE = 0.1;
    private static final @UnknownKeyFor @NonNull @Initialized long MIN_BYTE_BUFFER_SIZE = 0x6400000L;
    private final @UnknownKeyFor @NonNull @Initialized BigtableDataClient client;
    private final @UnknownKeyFor @NonNull @Initialized String projectId;
    private final @UnknownKeyFor @NonNull @Initialized String instanceId;
    private final @UnknownKeyFor @NonNull @Initialized Duration readAttemptTimeout;
    private final @UnknownKeyFor @NonNull @Initialized Duration readOperationTimeout;

    BigtableServiceImpl(@UnknownKeyFor @NonNull @Initialized BigtableDataSettings settings) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this(settings, null);
    }

    BigtableServiceImpl(@UnknownKeyFor @NonNull @Initialized BigtableDataSettings settings, @UnknownKeyFor @NonNull @Initialized Duration readWaitTimeout) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.projectId = settings.getProjectId();
        this.instanceId = settings.getInstanceId();
        RetrySettings retry = settings.getStubSettings().readRowsSettings().getRetrySettings();
        this.readAttemptTimeout = Duration.millis((long)retry.getInitialRpcTimeout().toMillis());
        this.readOperationTimeout = Duration.millis((long)retry.getTotalTimeout().toMillis());
        BigtableDataSettings.Builder builder = settings.toBuilder();
        if (readWaitTimeout != null) {
            builder.stubSettings().readRowsSettings().setRetrySettings(retry.toBuilder().setInitialRpcTimeout(org.threeten.bp.Duration.ofMillis((long)readWaitTimeout.getMillis())).setMaxRpcTimeout(org.threeten.bp.Duration.ofMillis((long)readWaitTimeout.getMillis())).build());
        }
        LOG.info("Started Bigtable service with settings " + builder.build());
        this.client = BigtableDataClient.create((BigtableDataSettings)builder.build());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BigtableWriterImpl openForWriting(@UnknownKeyFor @NonNull @Initialized String tableId) {
        return new BigtableWriterImpl(this.client, this.projectId, this.instanceId, tableId);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BigtableService.Reader createReader(@UnknownKeyFor @NonNull @Initialized BigtableIO.BigtableSource source) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (source.getMaxBufferElementCount() != null) {
            return BigtableSegmentReaderImpl.create(this.client, this.projectId, this.instanceId, (String)source.getTableId().get(), source.getRanges(), source.getRowFilter(), source.getMaxBufferElementCount(), this.readAttemptTimeout, this.readOperationTimeout);
        }
        return new BigtableReaderImpl(this.client, this.projectId, this.instanceId, (String)source.getTableId().get(), source.getRanges(), source.getRowFilter(), this.readAttemptTimeout, this.readOperationTimeout);
    }

    private static @UnknownKeyFor @NonNull @Initialized GrpcCallContext createScanCallContext(@UnknownKeyFor @NonNull @Initialized Duration attemptTimeout, @UnknownKeyFor @NonNull @Initialized Duration operationTimeout) {
        GrpcCallContext ctx = GrpcCallContext.createDefault();
        ctx.withCallOptions(CallOptions.DEFAULT.withDeadline(Deadline.after((long)operationTimeout.getMillis(), (TimeUnit)TimeUnit.MILLISECONDS)));
        ctx.withTimeout(org.threeten.bp.Duration.ofMillis((long)attemptTimeout.getMillis()));
        return ctx;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized KeyOffset> getSampleRowKeys(@UnknownKeyFor @NonNull @Initialized BigtableIO.BigtableSource source) {
        return this.client.sampleRowKeys((String)source.getTableId().get());
    }

    public static @UnknownKeyFor @NonNull @Initialized ServiceCallMetric createCallMetric(@UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized String instanceId, @UnknownKeyFor @NonNull @Initialized String tableId) {
        HashMap<String, String> baseLabels = new HashMap<String, String>();
        baseLabels.put("PTRANSFORM", "");
        baseLabels.put("SERVICE", "BigTable");
        baseLabels.put("METHOD", "google.bigtable.v2.ReadRows");
        baseLabels.put("RESOURCE", GcpResourceIdentifiers.bigtableResource((String)projectId, (String)instanceId, (String)tableId));
        baseLabels.put("BIGTABLE_PROJECT_ID", projectId);
        baseLabels.put("INSTANCE_ID", instanceId);
        baseLabels.put("TABLE_ID", GcpResourceIdentifiers.bigtableTableID((String)projectId, (String)instanceId, (String)tableId));
        return new ServiceCallMetric(MonitoringInfoConstants.Urns.API_REQUEST_COUNT, baseLabels);
    }

    @Override
    public void close() {
        this.client.close();
    }

    static class BigtableRowProtoAdapter
    implements RowAdapter<Row> {
        BigtableRowProtoAdapter() {
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized RowAdapter.RowBuilder<@UnknownKeyFor @NonNull @Initialized Row> createRowBuilder() {
            return new DefaultRowBuilder();
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isScanMarkerRow(@UnknownKeyFor @NonNull @Initialized Row row) {
            return Objects.equals(row, Row.getDefaultInstance());
        }

        public @UnknownKeyFor @NonNull @Initialized ByteString getKey(@UnknownKeyFor @NonNull @Initialized Row row) {
            return row.getKey();
        }

        private static class DefaultRowBuilder
        implements RowAdapter.RowBuilder<Row> {
            private // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized Row.Builder protoBuilder = Row.newBuilder();
            private @Nullable @UnknownKeyFor @Initialized ByteString currentValue;
            private // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable @UnknownKeyFor @Initialized Family.Builder lastFamily;
            private @Nullable @UnknownKeyFor @Initialized String lastFamilyName;
            private // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable @UnknownKeyFor @Initialized Column.Builder lastColumn;
            private @Nullable @UnknownKeyFor @Initialized ByteString lastColumnName;
            private // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable @UnknownKeyFor @Initialized Cell.Builder lastCell;

            private DefaultRowBuilder() {
            }

            public void startRow(@UnknownKeyFor @NonNull @Initialized ByteString key) {
                this.protoBuilder.setKey(key);
                this.lastFamilyName = null;
                this.lastFamily = null;
                this.lastColumnName = null;
                this.lastColumn = null;
            }

            public void startCell(@UnknownKeyFor @NonNull @Initialized String family, @UnknownKeyFor @NonNull @Initialized ByteString qualifier, @UnknownKeyFor @NonNull @Initialized long timestamp, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> labels, @UnknownKeyFor @NonNull @Initialized long size) {
                boolean familyChanged = false;
                if (!family.equals(this.lastFamilyName)) {
                    familyChanged = true;
                    this.lastFamily = this.protoBuilder.addFamiliesBuilder().setName(family);
                    this.lastFamilyName = family;
                }
                if (!qualifier.equals((Object)this.lastColumnName) || familyChanged) {
                    this.lastColumn = this.lastFamily.addColumnsBuilder().setQualifier(qualifier);
                    this.lastColumnName = qualifier;
                }
                this.lastCell = this.lastColumn.addCellsBuilder().setTimestampMicros(timestamp).addAllLabels(labels);
                this.currentValue = null;
            }

            public void cellValue(@UnknownKeyFor @NonNull @Initialized ByteString value) {
                this.currentValue = this.currentValue == null ? value : this.currentValue.concat(value);
            }

            public void finishCell() {
                this.lastCell.setValue(this.currentValue);
            }

            public @UnknownKeyFor @NonNull @Initialized Row finishRow() {
                return this.protoBuilder.build();
            }

            public void reset() {
                this.lastFamilyName = null;
                this.lastFamily = null;
                this.lastColumnName = null;
                this.lastColumn = null;
                this.currentValue = null;
                this.protoBuilder = Row.newBuilder();
            }

            public @UnknownKeyFor @NonNull @Initialized Row createScanMarkerRow(@UnknownKeyFor @NonNull @Initialized ByteString key) {
                return Row.newBuilder().getDefaultInstanceForType();
            }
        }
    }

    private static final class EndPoint
    implements Comparable<EndPoint> {
        private final @UnknownKeyFor @NonNull @Initialized ByteString value;
        private final @UnknownKeyFor @NonNull @Initialized boolean isClosed;

        static @NonNull @UnknownKeyFor @Initialized EndPoint extract(@NonNull @UnknownKeyFor @Initialized RowRange rowRange) {
            switch (rowRange.getEndKeyCase()) {
                case ENDKEY_NOT_SET: {
                    return new EndPoint(ByteString.EMPTY, true);
                }
                case END_KEY_CLOSED: {
                    return new EndPoint(rowRange.getEndKeyClosed(), true);
                }
                case END_KEY_OPEN: {
                    if (rowRange.getEndKeyOpen().isEmpty()) {
                        return new EndPoint(ByteString.EMPTY, true);
                    }
                    return new EndPoint(rowRange.getEndKeyOpen(), false);
                }
            }
            throw new IllegalArgumentException("Unknown endKeyCase: " + rowRange.getEndKeyCase());
        }

        private EndPoint(@NonNull @UnknownKeyFor @Initialized ByteString value, @UnknownKeyFor @NonNull @Initialized boolean isClosed) {
            this.value = value;
            this.isClosed = isClosed;
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized int compareTo(@NonNull @UnknownKeyFor @Initialized EndPoint o) {
            return ComparisonChain.start().compareFalseFirst(this.value.isEmpty(), o.value.isEmpty()).compare((Object)this.value, (Object)o.value, (Comparator)ByteStringComparator.INSTANCE).compareFalseFirst(this.isClosed, o.isClosed).result();
        }
    }

    private static final class StartPoint
    implements Comparable<StartPoint> {
        private final @UnknownKeyFor @NonNull @Initialized ByteString value;
        private final @UnknownKeyFor @NonNull @Initialized boolean isClosed;

        static @NonNull @UnknownKeyFor @Initialized StartPoint extract(@NonNull @UnknownKeyFor @Initialized RowRange rowRange) {
            switch (rowRange.getStartKeyCase()) {
                case STARTKEY_NOT_SET: {
                    return new StartPoint(ByteString.EMPTY, true);
                }
                case START_KEY_CLOSED: {
                    return new StartPoint(rowRange.getStartKeyClosed(), true);
                }
                case START_KEY_OPEN: {
                    if (rowRange.getStartKeyOpen().isEmpty()) {
                        return new StartPoint(ByteString.EMPTY, true);
                    }
                    return new StartPoint(rowRange.getStartKeyOpen(), false);
                }
            }
            throw new IllegalArgumentException("Unknown startKeyCase: " + rowRange.getStartKeyCase());
        }

        private StartPoint(@NonNull @UnknownKeyFor @Initialized ByteString value, @UnknownKeyFor @NonNull @Initialized boolean isClosed) {
            this.value = value;
            this.isClosed = isClosed;
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized int compareTo(@NonNull @UnknownKeyFor @Initialized StartPoint o) {
            return ComparisonChain.start().compareTrueFirst(this.value.isEmpty(), o.value.isEmpty()).compare((Object)this.value, (Object)o.value, (Comparator)ByteStringComparator.INSTANCE).compareTrueFirst(this.isClosed, o.isClosed).result();
        }
    }

    @VisibleForTesting
    static class BigtableWriterImpl
    implements BigtableService.Writer {
        private @UnknownKeyFor @NonNull @Initialized Batcher<@UnknownKeyFor @NonNull @Initialized RowMutationEntry, @UnknownKeyFor @Nullable @Initialized Void> bulkMutation;
        private @UnknownKeyFor @NonNull @Initialized String projectId;
        private @UnknownKeyFor @NonNull @Initialized String instanceId;
        private @UnknownKeyFor @NonNull @Initialized String tableId;

        BigtableWriterImpl(@UnknownKeyFor @NonNull @Initialized BigtableDataClient client, @UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized String instanceId, @UnknownKeyFor @NonNull @Initialized String tableId) {
            this.projectId = projectId;
            this.instanceId = instanceId;
            this.tableId = tableId;
            this.bulkMutation = client.newBulkMutationBatcher(tableId);
        }

        @Override
        public void flush() throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (this.bulkMutation != null) {
                try {
                    this.bulkMutation.flush();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IOException(e);
                }
            }
        }

        @Override
        public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (this.bulkMutation != null) {
                try {
                    this.bulkMutation.flush();
                    this.bulkMutation.close();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IOException(e);
                }
                this.bulkMutation = null;
            }
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized CompletionStage<@UnknownKeyFor @NonNull @Initialized MutateRowResponse> writeRecord(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Mutation>> record) throws @UnknownKeyFor @NonNull @Initialized IOException {
            com.google.cloud.bigtable.data.v2.models.Mutation mutation = com.google.cloud.bigtable.data.v2.models.Mutation.fromProtoUnsafe((Iterable)((Iterable)record.getValue()));
            RowMutationEntry entry = RowMutationEntry.createFromMutationUnsafe((ByteString)((ByteString)record.getKey()), (com.google.cloud.bigtable.data.v2.models.Mutation)mutation);
            HashMap<String, String> baseLabels = new HashMap<String, String>();
            baseLabels.put("PTRANSFORM", "");
            baseLabels.put("SERVICE", "BigTable");
            baseLabels.put("METHOD", "google.bigtable.v2.MutateRows");
            baseLabels.put("RESOURCE", GcpResourceIdentifiers.bigtableResource((String)this.projectId, (String)this.instanceId, (String)this.tableId));
            baseLabels.put("BIGTABLE_PROJECT_ID", this.projectId);
            baseLabels.put("INSTANCE_ID", this.instanceId);
            baseLabels.put("TABLE_ID", GcpResourceIdentifiers.bigtableTableID((String)this.projectId, (String)this.instanceId, (String)this.tableId));
            final ServiceCallMetric serviceCallMetric = new ServiceCallMetric(MonitoringInfoConstants.Urns.API_REQUEST_COUNT, baseLabels);
            final CompletableFuture<MutateRowResponse> result = new CompletableFuture<MutateRowResponse>();
            Futures.addCallback(new VendoredListenableFutureAdapter((ApiFuture<Void>)this.bulkMutation.add((Object)entry)), (FutureCallback)new FutureCallback<MutateRowResponse>(){

                public void onSuccess(@UnknownKeyFor @NonNull @Initialized MutateRowResponse mutateRowResponse) {
                    result.complete(mutateRowResponse);
                    serviceCallMetric.call("ok");
                }

                public void onFailure(@UnknownKeyFor @NonNull @Initialized Throwable throwable) {
                    if (throwable instanceof StatusRuntimeException) {
                        serviceCallMetric.call(((StatusRuntimeException)throwable).getStatus().getCode().value());
                    } else {
                        serviceCallMetric.call("unknown");
                    }
                    result.completeExceptionally(throwable);
                }
            }, (Executor)MoreExecutors.directExecutor());
            return result;
        }
    }

    @VisibleForTesting
    static class BigtableSegmentReaderImpl
    implements BigtableService.Reader {
        private final @UnknownKeyFor @NonNull @Initialized BigtableDataClient client;
        private @Nullable @UnknownKeyFor @Initialized ReadRowsRequest nextRequest;
        private @Nullable @UnknownKeyFor @Initialized Row currentRow;
        private @Nullable @UnknownKeyFor @Initialized Future<@UnknownKeyFor @NonNull @Initialized UpstreamResults> future;
        private final @UnknownKeyFor @NonNull @Initialized Queue<@UnknownKeyFor @NonNull @Initialized Row> buffer;
        private final @UnknownKeyFor @NonNull @Initialized int refillSegmentWaterMark;
        private final @UnknownKeyFor @NonNull @Initialized long maxSegmentByteSize;
        private @UnknownKeyFor @NonNull @Initialized ServiceCallMetric serviceCallMetric;
        private final @UnknownKeyFor @NonNull @Initialized Duration attemptTimeout;
        private final @UnknownKeyFor @NonNull @Initialized Duration operationTimeout;

        static @UnknownKeyFor @NonNull @Initialized BigtableSegmentReaderImpl create(@UnknownKeyFor @NonNull @Initialized BigtableDataClient client, @UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized String instanceId, @UnknownKeyFor @NonNull @Initialized String tableId, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ByteKeyRange> ranges, @Nullable @UnknownKeyFor @Initialized RowFilter rowFilter, @UnknownKeyFor @NonNull @Initialized int maxBufferedElementCount, @UnknownKeyFor @NonNull @Initialized Duration attemptTimeout, @UnknownKeyFor @NonNull @Initialized Duration operationTimeout) {
            RowSet.Builder rowSetBuilder = RowSet.newBuilder();
            if (ranges.isEmpty()) {
                rowSetBuilder = RowSet.newBuilder().addRowRanges(RowRange.getDefaultInstance());
            } else {
                for (ByteKeyRange beamRange : ranges) {
                    RowRange.Builder rangeBuilder = rowSetBuilder.addRowRangesBuilder();
                    rangeBuilder.setStartKeyClosed(ByteString.copyFrom((ByteBuffer)beamRange.getStartKey().getValue())).setEndKeyOpen(ByteString.copyFrom((ByteBuffer)beamRange.getEndKey().getValue()));
                }
            }
            RowSet rowSet = rowSetBuilder.build();
            RowFilter filter = (RowFilter)MoreObjects.firstNonNull((Object)rowFilter, (Object)RowFilter.getDefaultInstance());
            long maxSegmentByteSize = (long)Math.max(1.048576E8, (double)Runtime.getRuntime().totalMemory() * 0.1);
            return new BigtableSegmentReaderImpl(client, projectId, instanceId, tableId, rowSet, filter, maxBufferedElementCount, maxSegmentByteSize, attemptTimeout, operationTimeout, BigtableServiceImpl.createCallMetric(projectId, instanceId, tableId));
        }

        @VisibleForTesting
        BigtableSegmentReaderImpl(@UnknownKeyFor @NonNull @Initialized BigtableDataClient client, @UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized String instanceId, @UnknownKeyFor @NonNull @Initialized String tableId, @UnknownKeyFor @NonNull @Initialized RowSet rowSet, @Nullable @UnknownKeyFor @Initialized RowFilter filter, @UnknownKeyFor @NonNull @Initialized int maxRowsInBuffer, @UnknownKeyFor @NonNull @Initialized long maxSegmentByteSize, @UnknownKeyFor @NonNull @Initialized Duration attemptTimeout, @UnknownKeyFor @NonNull @Initialized Duration operationTimeout, @UnknownKeyFor @NonNull @Initialized ServiceCallMetric serviceCallMetric) {
            if (rowSet.equals((Object)rowSet.getDefaultInstanceForType())) {
                rowSet = RowSet.newBuilder().addRowRanges(RowRange.getDefaultInstance()).build();
            }
            ReadRowsRequest request = ReadRowsRequest.newBuilder().setTableName(NameUtil.formatTableName((String)projectId, (String)instanceId, (String)tableId)).setRows(rowSet).setFilter(filter).setRowsLimit((long)maxRowsInBuffer).build();
            this.client = client;
            this.nextRequest = request;
            this.maxSegmentByteSize = maxSegmentByteSize;
            this.serviceCallMetric = serviceCallMetric;
            this.buffer = new ArrayDeque<Row>();
            this.refillSegmentWaterMark = (int)((double)request.getRowsLimit() * 0.1);
            this.attemptTimeout = attemptTimeout;
            this.operationTimeout = operationTimeout;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean start() throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.future = this.fetchNextSegment();
            return this.advance();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean advance() throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (this.buffer.size() < this.refillSegmentWaterMark && this.future == null) {
                this.future = this.fetchNextSegment();
            }
            if (this.buffer.isEmpty() && this.future != null) {
                this.waitReadRowsFuture();
            }
            this.currentRow = this.buffer.poll();
            return this.currentRow != null;
        }

        private @UnknownKeyFor @NonNull @Initialized Future<@UnknownKeyFor @NonNull @Initialized UpstreamResults> fetchNextSegment() {
            final SettableFuture future = SettableFuture.create();
            if (this.nextRequest == null) {
                future.set((Object)new UpstreamResults((List)ImmutableList.of(), null));
                return future;
            }
            this.client.readRowsCallable((RowAdapter)new BigtableRowProtoAdapter()).call((Object)Query.fromProto((ReadRowsRequest)this.nextRequest), (ResponseObserver)new ResponseObserver<Row>(){
                private @UnknownKeyFor @NonNull @Initialized StreamController controller;
                @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Row> rows = new ArrayList<Row>();
                @UnknownKeyFor @NonNull @Initialized long currentByteSize = 0L;
                @UnknownKeyFor @NonNull @Initialized boolean byteLimitReached = false;

                public void onStart(@UnknownKeyFor @NonNull @Initialized StreamController controller) {
                    this.controller = controller;
                }

                public void onResponse(@UnknownKeyFor @NonNull @Initialized Row response) {
                    this.currentByteSize += (long)response.getSerializedSize();
                    this.rows.add(response);
                    if (this.currentByteSize > maxSegmentByteSize) {
                        this.byteLimitReached = true;
                        this.controller.cancel();
                        return;
                    }
                }

                public void onError(@UnknownKeyFor @NonNull @Initialized Throwable t) {
                    future.setException(t);
                }

                public void onComplete() {
                    ReadRowsRequest nextNextRequest = null;
                    if (this.byteLimitReached || (long)this.rows.size() == nextRequest.getRowsLimit()) {
                        nextNextRequest = this.truncateRequest(nextRequest, this.rows.get(this.rows.size() - 1).getKey());
                    }
                    future.set((Object)new UpstreamResults(this.rows, nextNextRequest));
                }
            }, (ApiCallContext)BigtableServiceImpl.createScanCallContext(this.attemptTimeout, this.operationTimeout));
            return future;
        }

        private void waitReadRowsFuture() throws @UnknownKeyFor @NonNull @Initialized IOException {
            try {
                UpstreamResults r = this.future.get();
                this.buffer.addAll(r.rows);
                this.nextRequest = r.nextRequest;
                this.future = null;
                this.serviceCallMetric.call("ok");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(e);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof StatusRuntimeException) {
                    this.serviceCallMetric.call(((StatusRuntimeException)cause).getStatus().getCode().toString());
                }
                throw new IOException(cause);
            }
        }

        private @UnknownKeyFor @NonNull @Initialized ReadRowsRequest truncateRequest(@UnknownKeyFor @NonNull @Initialized ReadRowsRequest request, @UnknownKeyFor @NonNull @Initialized ByteString lastKey) {
            RowSet.Builder segment = RowSet.newBuilder();
            for (RowRange rowRange : request.getRows().getRowRangesList()) {
                int startCmp = StartPoint.extract(rowRange).compareTo(new StartPoint(lastKey, true));
                int endCmp = EndPoint.extract(rowRange).compareTo(new EndPoint(lastKey, true));
                if (startCmp > 0) {
                    segment.addRowRanges(rowRange);
                    continue;
                }
                if (endCmp <= 0) continue;
                RowRange subRange = rowRange.toBuilder().setStartKeyOpen(lastKey).build();
                segment.addRowRanges(subRange);
            }
            if (segment.getRowRangesCount() == 0) {
                return null;
            }
            ReadRowsRequest.Builder requestBuilder = request.toBuilder();
            requestBuilder.clearRows();
            return requestBuilder.setRows(segment).build();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Row getCurrentRow() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
            if (this.currentRow == null) {
                throw new NoSuchElementException();
            }
            return this.currentRow;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Duration getAttemptTimeout() {
            return this.attemptTimeout;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Duration getOperationTimeout() {
            return this.operationTimeout;
        }

        private static class UpstreamResults {
            private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Row> rows;
            private final @Nullable @UnknownKeyFor @Initialized ReadRowsRequest nextRequest;

            private UpstreamResults(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Row> rows, @Nullable @UnknownKeyFor @Initialized ReadRowsRequest nextRequest) {
                this.rows = rows;
                this.nextRequest = nextRequest;
            }
        }
    }

    @VisibleForTesting
    static class BigtableReaderImpl
    implements BigtableService.Reader {
        private final @UnknownKeyFor @NonNull @Initialized BigtableDataClient client;
        private final @UnknownKeyFor @NonNull @Initialized String projectId;
        private final @UnknownKeyFor @NonNull @Initialized String instanceId;
        private final @UnknownKeyFor @NonNull @Initialized String tableId;
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ByteKeyRange> ranges;
        private final @UnknownKeyFor @NonNull @Initialized RowFilter rowFilter;
        private @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized Row> results;
        private final @UnknownKeyFor @NonNull @Initialized Duration attemptTimeout;
        private final @UnknownKeyFor @NonNull @Initialized Duration operationTimeout;
        private @UnknownKeyFor @NonNull @Initialized Row currentRow;

        @VisibleForTesting
        BigtableReaderImpl(@UnknownKeyFor @NonNull @Initialized BigtableDataClient client, @UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized String instanceId, @UnknownKeyFor @NonNull @Initialized String tableId, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ByteKeyRange> ranges, @Nullable @UnknownKeyFor @Initialized RowFilter rowFilter, @UnknownKeyFor @NonNull @Initialized Duration attemptTimeout, @UnknownKeyFor @NonNull @Initialized Duration operationTimeout) {
            this.client = client;
            this.projectId = projectId;
            this.instanceId = instanceId;
            this.tableId = tableId;
            this.ranges = ranges;
            this.rowFilter = rowFilter;
            this.attemptTimeout = attemptTimeout;
            this.operationTimeout = operationTimeout;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean start() throws @UnknownKeyFor @NonNull @Initialized IOException {
            ServiceCallMetric serviceCallMetric = BigtableServiceImpl.createCallMetric(this.projectId, this.instanceId, this.tableId);
            Query query = Query.create((String)this.tableId);
            for (ByteKeyRange sourceRange : this.ranges) {
                query.range(ByteString.copyFrom((ByteBuffer)sourceRange.getStartKey().getValue()), ByteString.copyFrom((ByteBuffer)sourceRange.getEndKey().getValue()));
            }
            if (this.rowFilter != null) {
                query.filter(Filters.FILTERS.fromProto(this.rowFilter));
            }
            try {
                this.results = this.client.readRowsCallable((RowAdapter)new BigtableRowProtoAdapter()).call((Object)query, (ApiCallContext)BigtableServiceImpl.createScanCallContext(this.attemptTimeout, this.operationTimeout)).iterator();
                serviceCallMetric.call("ok");
            }
            catch (StatusRuntimeException e) {
                serviceCallMetric.call(e.getStatus().getCode().toString());
                throw e;
            }
            return this.advance();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean advance() throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (this.results.hasNext()) {
                this.currentRow = this.results.next();
                return true;
            }
            return false;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Row getCurrentRow() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
            if (this.currentRow == null) {
                throw new NoSuchElementException();
            }
            return this.currentRow;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Duration getAttemptTimeout() {
            return this.attemptTimeout;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Duration getOperationTimeout() {
            return this.operationTimeout;
        }
    }
}

