/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.auto.value.AutoValue;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.Type;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerSchema;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerSchema_Column;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerSchema_KeyPart;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableListMultimap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableTable;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoValue
abstract class SpannerSchema
implements Serializable {
    SpannerSchema() {
    }

    abstract @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized String> tables();

    abstract @UnknownKeyFor @NonNull @Initialized Dialect dialect();

    abstract @UnknownKeyFor @NonNull @Initialized ImmutableListMultimap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Column> columns();

    abstract @UnknownKeyFor @NonNull @Initialized ImmutableListMultimap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized KeyPart> keyParts();

    abstract @UnknownKeyFor @NonNull @Initialized ImmutableTable<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Long> cellsMutatedPerColumn();

    abstract @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Long> cellsMutatedPerRow();

    public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
        return SpannerSchema.builder(Dialect.GOOGLE_STANDARD_SQL);
    }

    public static @UnknownKeyFor @NonNull @Initialized Builder builder(@UnknownKeyFor @NonNull @Initialized Dialect dialect) {
        return new AutoValue_SpannerSchema.Builder().setDialect(dialect);
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getTables() {
        return this.tables();
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Column> getColumns(@UnknownKeyFor @NonNull @Initialized String table) {
        return this.columns().get((Object)table.toLowerCase());
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized KeyPart> getKeyParts(@UnknownKeyFor @NonNull @Initialized String table) {
        return this.keyParts().get((Object)table.toLowerCase());
    }

    public @UnknownKeyFor @NonNull @Initialized long getCellsMutatedPerColumn(@UnknownKeyFor @NonNull @Initialized String table, @UnknownKeyFor @NonNull @Initialized String column) {
        return (Long)this.cellsMutatedPerColumn().row((Object)table.toLowerCase()).getOrDefault((Object)column.toLowerCase(), (Object)1L);
    }

    public @UnknownKeyFor @NonNull @Initialized long getCellsMutatedPerRow(@UnknownKeyFor @NonNull @Initialized String table) {
        return (Long)this.cellsMutatedPerRow().getOrDefault((Object)table.toLowerCase(), (Object)1L);
    }

    @AutoValue
    static abstract class Column
    implements Serializable {
        Column() {
        }

        static @UnknownKeyFor @NonNull @Initialized Column create(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Type type) {
            return new AutoValue_SpannerSchema_Column(name, type);
        }

        static @UnknownKeyFor @NonNull @Initialized Column create(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized String spannerType, @UnknownKeyFor @NonNull @Initialized Dialect dialect) {
            return Column.create(name, Column.parseSpannerType(spannerType, dialect));
        }

        public abstract @UnknownKeyFor @NonNull @Initialized String getName();

        public abstract @UnknownKeyFor @NonNull @Initialized Type getType();

        private static @UnknownKeyFor @NonNull @Initialized Type parseSpannerType(@UnknownKeyFor @NonNull @Initialized String spannerType, @UnknownKeyFor @NonNull @Initialized Dialect dialect) {
            spannerType = spannerType.toUpperCase();
            switch (dialect) {
                case GOOGLE_STANDARD_SQL: {
                    if ("BOOL".equals(spannerType)) {
                        return Type.bool();
                    }
                    if ("INT64".equals(spannerType)) {
                        return Type.int64();
                    }
                    if ("FLOAT64".equals(spannerType)) {
                        return Type.float64();
                    }
                    if (spannerType.startsWith("STRING")) {
                        return Type.string();
                    }
                    if (spannerType.startsWith("BYTES")) {
                        return Type.bytes();
                    }
                    if ("TIMESTAMP".equals(spannerType)) {
                        return Type.timestamp();
                    }
                    if ("DATE".equals(spannerType)) {
                        return Type.date();
                    }
                    if ("NUMERIC".equals(spannerType)) {
                        return Type.numeric();
                    }
                    if ("JSON".equals(spannerType)) {
                        return Type.json();
                    }
                    if (spannerType.startsWith("ARRAY")) {
                        String spannerArrayType = spannerType.substring(6, spannerType.length() - 1);
                        Type itemType = Column.parseSpannerType(spannerArrayType, dialect);
                        return Type.array((Type)itemType);
                    }
                    throw new IllegalArgumentException("Unknown spanner type " + spannerType);
                }
                case POSTGRESQL: {
                    if (spannerType.endsWith("[]")) {
                        String spannerArrayType = spannerType.substring(0, spannerType.length() - 2);
                        Type itemType = Column.parseSpannerType(spannerArrayType, dialect);
                        return Type.array((Type)itemType);
                    }
                    if ("BOOLEAN".equals(spannerType)) {
                        return Type.bool();
                    }
                    if ("BIGINT".equals(spannerType)) {
                        return Type.int64();
                    }
                    if ("DOUBLE PRECISION".equals(spannerType)) {
                        return Type.float64();
                    }
                    if (spannerType.startsWith("CHARACTER VARYING") || "TEXT".equals(spannerType)) {
                        return Type.string();
                    }
                    if ("BYTEA".equals(spannerType)) {
                        return Type.bytes();
                    }
                    if ("TIMESTAMP WITH TIME ZONE".equals(spannerType)) {
                        return Type.timestamp();
                    }
                    if ("DATE".equals(spannerType)) {
                        return Type.date();
                    }
                    if (spannerType.startsWith("NUMERIC")) {
                        return Type.pgNumeric();
                    }
                    throw new IllegalArgumentException("Unknown spanner type " + spannerType);
                }
            }
            throw new IllegalArgumentException("Unrecognized dialect: " + dialect.name());
        }
    }

    @AutoValue
    static abstract class KeyPart
    implements Serializable {
        KeyPart() {
        }

        static @UnknownKeyFor @NonNull @Initialized KeyPart create(@UnknownKeyFor @NonNull @Initialized String field, @UnknownKeyFor @NonNull @Initialized boolean desc) {
            return new AutoValue_SpannerSchema_KeyPart(field, desc);
        }

        abstract @UnknownKeyFor @NonNull @Initialized String getField();

        abstract @UnknownKeyFor @NonNull @Initialized boolean isDesc();
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized Builder setTables(@UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized String> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setDialect(@UnknownKeyFor @NonNull @Initialized Dialect var1);

        abstract @UnknownKeyFor @NonNull @Initialized Dialect dialect();

        abstract // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized ImmutableListMultimap.Builder<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Column> columnsBuilder();

        abstract // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized ImmutableListMultimap.Builder<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized KeyPart> keyPartsBuilder();

        abstract // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized ImmutableTable.Builder<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Long> cellsMutatedPerColumnBuilder();

        abstract // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized ImmutableMap.Builder<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Long> cellsMutatedPerRowBuilder();

        abstract @UnknownKeyFor @NonNull @Initialized ImmutableListMultimap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Column> columns();

        abstract @UnknownKeyFor @NonNull @Initialized ImmutableTable<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Long> cellsMutatedPerColumn();

        @VisibleForTesting
        public @UnknownKeyFor @NonNull @Initialized Builder addColumn(@UnknownKeyFor @NonNull @Initialized String table, @UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized String type) {
            return this.addColumn(table, name, type, 1L);
        }

        public @UnknownKeyFor @NonNull @Initialized Builder addColumn(@UnknownKeyFor @NonNull @Initialized String table, @UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized String type, @UnknownKeyFor @NonNull @Initialized long cellsMutated) {
            String tableLower = table.toLowerCase();
            String nameLower = name.toLowerCase();
            this.columnsBuilder().put((Object)tableLower, (Object)Column.create(nameLower, type, this.dialect()));
            this.cellsMutatedPerColumnBuilder().put((Object)tableLower, (Object)nameLower, (Object)cellsMutated);
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder addKeyPart(@UnknownKeyFor @NonNull @Initialized String table, @UnknownKeyFor @NonNull @Initialized String column, @UnknownKeyFor @NonNull @Initialized boolean desc) {
            this.keyPartsBuilder().put((Object)table.toLowerCase(), (Object)KeyPart.create(column.toLowerCase(), desc));
            return this;
        }

        abstract @UnknownKeyFor @NonNull @Initialized SpannerSchema autoBuild();

        public final @UnknownKeyFor @NonNull @Initialized SpannerSchema build() {
            this.cellsMutatedPerRowBuilder().putAll(Maps.transformValues((Map)this.cellsMutatedPerColumn().rowMap(), entry -> entry.values().stream().mapToLong(Long::longValue).sum()));
            this.setTables((ImmutableList<String>)ImmutableList.copyOf((Collection)this.columns().keySet()));
            return this.autoBuild();
        }
    }
}

