/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import java.util.concurrent.ExecutionException;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiDynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiWritePayload;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowToStorageApiProto;
import org.apache.beam.sdk.io.gcp.bigquery.TableSchemaCache;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

public class StorageApiDynamicDestinationsTableRow<@UnknownKeyFor T, @UnknownKeyFor DestinationT>
extends StorageApiDynamicDestinations<T, DestinationT> {
    private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized TableRow> formatFunction;
    private final  @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.CreateDisposition createDisposition;
    private final @UnknownKeyFor @NonNull @Initialized boolean ignoreUnknownValues;
    private final @UnknownKeyFor @NonNull @Initialized boolean autoSchemaUpdates;
    private static final @UnknownKeyFor @NonNull @Initialized TableSchemaCache SCHEMA_CACHE = new TableSchemaCache(Duration.standardSeconds((long)1L));

    StorageApiDynamicDestinationsTableRow(@UnknownKeyFor @NonNull @Initialized DynamicDestinations<T, DestinationT> inner, @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized TableRow> formatFunction,  @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.CreateDisposition createDisposition, @UnknownKeyFor @NonNull @Initialized boolean ignoreUnknownValues, @UnknownKeyFor @NonNull @Initialized boolean autoSchemaUpdates) {
        super(inner);
        this.formatFunction = formatFunction;
        this.createDisposition = createDisposition;
        this.ignoreUnknownValues = ignoreUnknownValues;
        this.autoSchemaUpdates = autoSchemaUpdates;
    }

    static void clearSchemaCache() throws @UnknownKeyFor @NonNull @Initialized ExecutionException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        SCHEMA_CACHE.clear();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized StorageApiDynamicDestinations.MessageConverter<T> getMessageConverter(DestinationT destination, @UnknownKeyFor @NonNull @Initialized BigQueryServices.DatasetService datasetService) throws @UnknownKeyFor @NonNull @Initialized Exception {
        return new TableRowConverter(destination, datasetService);
    }

    static {
        SCHEMA_CACHE.start();
    }

    class TableRowConverter
    implements StorageApiDynamicDestinations.MessageConverter<T> {
        final @Nullable @UnknownKeyFor @Initialized TableSchema tableSchema;
        final @UnknownKeyFor @NonNull @Initialized com.google.cloud.bigquery.storage.v1.TableSchema protoTableSchema;
        final @UnknownKeyFor @NonNull @Initialized TableRowToStorageApiProto.SchemaInformation schemaInformation;
        final // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Descriptors.Descriptor descriptor;

        TableRowConverter(@UnknownKeyFor @NonNull @Initialized TableSchema tableSchema, @UnknownKeyFor @NonNull @Initialized TableRowToStorageApiProto.SchemaInformation schemaInformation, Descriptors.Descriptor descriptor) {
            this.tableSchema = tableSchema;
            this.protoTableSchema = TableRowToStorageApiProto.schemaToProtoTableSchema(tableSchema);
            this.schemaInformation = schemaInformation;
            this.descriptor = descriptor;
        }

        TableRowConverter(@UnknownKeyFor @NonNull @Initialized DestinationT destination, BigQueryServices.DatasetService datasetService) throws @UnknownKeyFor @NonNull @Initialized Exception {
            TableSchema localTableSchema = StorageApiDynamicDestinationsTableRow.this.getSchema(destination);
            TableReference tableReference = StorageApiDynamicDestinationsTableRow.this.getTable(destination).getTableReference();
            if (localTableSchema == null) {
                localTableSchema = SCHEMA_CACHE.getSchema(tableReference, datasetService);
                if (localTableSchema == null) {
                    if (StorageApiDynamicDestinationsTableRow.this.createDisposition == BigQueryIO.Write.CreateDisposition.CREATE_NEVER) {
                        throw new RuntimeException("BigQuery table " + tableReference + " not found. If you wanted to automatically create the table, set the create disposition to CREATE_IF_NEEDED and specify a schema.");
                    }
                    throw new RuntimeException("Schema must be set for table " + tableReference + " when writing TableRows using Storage API and using a create disposition of CREATE_IF_NEEDED.");
                }
            } else {
                localTableSchema = (TableSchema)MoreObjects.firstNonNull((Object)SCHEMA_CACHE.putSchemaIfAbsent(tableReference, localTableSchema), (Object)localTableSchema);
            }
            this.tableSchema = localTableSchema;
            this.protoTableSchema = TableRowToStorageApiProto.schemaToProtoTableSchema(this.tableSchema);
            this.schemaInformation = TableRowToStorageApiProto.SchemaInformation.fromTableSchema(this.protoTableSchema);
            this.descriptor = TableRowToStorageApiProto.getDescriptorFromTableSchema((TableSchema)Preconditions.checkStateNotNull((Object)this.tableSchema), !StorageApiDynamicDestinationsTableRow.this.autoSchemaUpdates);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized com.google.cloud.bigquery.storage.v1.TableSchema getTableSchema() {
            return this.protoTableSchema;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TableRow toTableRow(T element) {
            return (TableRow)StorageApiDynamicDestinationsTableRow.this.formatFunction.apply(element);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized StorageApiWritePayload toMessage(T element) throws @UnknownKeyFor @NonNull @Initialized Exception {
            return this.toMessage((TableRow)StorageApiDynamicDestinationsTableRow.this.formatFunction.apply(element), true);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized StorageApiWritePayload toMessage(@UnknownKeyFor @NonNull @Initialized TableRow tableRow, @UnknownKeyFor @NonNull @Initialized boolean respectRequired) throws @UnknownKeyFor @NonNull @Initialized Exception {
            boolean ignoreUnknown = StorageApiDynamicDestinationsTableRow.this.ignoreUnknownValues || StorageApiDynamicDestinationsTableRow.this.autoSchemaUpdates;
            TableRow unknownFields = StorageApiDynamicDestinationsTableRow.this.autoSchemaUpdates ? new TableRow() : null;
            boolean allowMissingFields = StorageApiDynamicDestinationsTableRow.this.autoSchemaUpdates;
            DynamicMessage msg = TableRowToStorageApiProto.messageFromTableRow(this.schemaInformation, this.descriptor, tableRow, ignoreUnknown, allowMissingFields, unknownFields);
            return StorageApiWritePayload.of(msg.toByteArray(), unknownFields);
        }
    }
}

