/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import com.google.cloud.bigquery.storage.v1.TableSchema;
import com.google.protobuf.DynamicMessage;
import org.apache.beam.sdk.io.gcp.bigquery.AutoValue_StorageApiWritePayload;
import org.apache.beam.sdk.io.gcp.bigquery.BeamRowToStorageApiProto;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiDynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiWritePayload;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowToStorageApiProto;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class StorageApiDynamicDestinationsBeamRow<@UnknownKeyFor T, @UnknownKeyFor DestinationT>
extends StorageApiDynamicDestinations<T, DestinationT> {
    private final @UnknownKeyFor @NonNull @Initialized TableSchema tableSchema;
    private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized Row> toRow;

    StorageApiDynamicDestinationsBeamRow(@UnknownKeyFor @NonNull @Initialized DynamicDestinations<T, DestinationT> inner, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized Row> toRow) {
        super(inner);
        this.tableSchema = BeamRowToStorageApiProto.protoTableSchemaFromBeamSchema(schema);
        this.toRow = toRow;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized StorageApiDynamicDestinations.MessageConverter<T> getMessageConverter(DestinationT destination,  @UnknownKeyFor @NonNull @Initialized BigQueryServices.DatasetService datasetService) throws @UnknownKeyFor @NonNull @Initialized Exception {
        return new BeamRowConverter();
    }

    class BeamRowConverter
    implements StorageApiDynamicDestinations.MessageConverter<T> {
        final // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Descriptors.Descriptor descriptor;

        BeamRowConverter() throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.descriptor = TableRowToStorageApiProto.getDescriptorFromTableSchema(StorageApiDynamicDestinationsBeamRow.this.tableSchema, true);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TableSchema getTableSchema() {
            return StorageApiDynamicDestinationsBeamRow.this.tableSchema;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized StorageApiWritePayload toMessage(T element) {
            DynamicMessage msg = BeamRowToStorageApiProto.messageFromBeamRow(this.descriptor, (Row)StorageApiDynamicDestinationsBeamRow.this.toRow.apply(element));
            return new AutoValue_StorageApiWritePayload(msg.toByteArray());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TableRow toTableRow(T element) {
            return BigQueryUtils.toTableRow((Row)StorageApiDynamicDestinationsBeamRow.this.toRow.apply(element));
        }
    }
}

