/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.model;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;

@DefaultCoder(value=AvroCoder.class)
public class ChildPartition
implements Serializable {
    private static final long serialVersionUID = -650413326832931368L;
    private String token;
    private HashSet<String> parentTokens;

    private ChildPartition() {
    }

    public ChildPartition(String token, HashSet<String> parentTokens) {
        this.token = token;
        this.parentTokens = parentTokens;
    }

    public ChildPartition(String token, String parentToken) {
        this(token, Sets.newHashSet((Object[])new String[]{parentToken}));
    }

    public String getToken() {
        return this.token;
    }

    public HashSet<String> getParentTokens() {
        return this.parentTokens;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChildPartition)) {
            return false;
        }
        ChildPartition that = (ChildPartition)o;
        return Objects.equals(this.token, that.token) && Objects.equals(this.parentTokens, that.parentTokens);
    }

    public int hashCode() {
        return Objects.hash(this.token, this.parentTokens);
    }

    public String toString() {
        return "ChildPartition{childToken='" + this.token + '\'' + ", parentTokens=" + this.parentTokens + '}';
    }
}

