/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import java.util.concurrent.ExecutionException;
import org.apache.beam.sdk.io.gcp.bigquery.AutoValue_StorageApiWritePayload;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiDynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiWritePayload;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowToStorageApiProto;
import org.apache.beam.sdk.io.gcp.bigquery.TableSchemaCache;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageApiDynamicDestinationsTableRow<T, DestinationT>
extends StorageApiDynamicDestinations<T, DestinationT> {
    private final SerializableFunction<T, TableRow> formatFunction;
    private final BigQueryIO.Write.CreateDisposition createDisposition;
    private final boolean ignoreUnknownValues;
    private final int schemaUpdateRetries;
    private static final TableSchemaCache SCHEMA_CACHE = new TableSchemaCache(Duration.standardSeconds((long)1L));
    private static final Logger LOG = LoggerFactory.getLogger(StorageApiDynamicDestinationsTableRow.class);

    StorageApiDynamicDestinationsTableRow(DynamicDestinations<T, DestinationT> inner, SerializableFunction<T, TableRow> formatFunction, BigQueryIO.Write.CreateDisposition createDisposition, boolean ignoreUnknownValues, int schemaUpdateRetries) {
        super(inner);
        this.formatFunction = formatFunction;
        this.createDisposition = createDisposition;
        this.ignoreUnknownValues = ignoreUnknownValues;
        this.schemaUpdateRetries = schemaUpdateRetries;
    }

    static void clearSchemaCache() throws ExecutionException, InterruptedException {
        SCHEMA_CACHE.clear();
    }

    @Override
    public StorageApiDynamicDestinations.MessageConverter<T> getMessageConverter(final DestinationT destination, final BigQueryServices.DatasetService datasetService) throws Exception {
        return new StorageApiDynamicDestinations.MessageConverter<T>(){
            TableSchema tableSchema;
            TableRowToStorageApiProto.SchemaInformation schemaInformation;
            Descriptors.Descriptor descriptor;
            long descriptorHash;
            {
                this.tableSchema = StorageApiDynamicDestinationsTableRow.this.getSchema(destination);
                TableReference tableReference = StorageApiDynamicDestinationsTableRow.this.getTable(destination).getTableReference();
                if (this.tableSchema == null) {
                    this.tableSchema = SCHEMA_CACHE.getSchema(tableReference, datasetService);
                    if (this.tableSchema == null) {
                        if (StorageApiDynamicDestinationsTableRow.this.createDisposition == BigQueryIO.Write.CreateDisposition.CREATE_NEVER) {
                            throw new RuntimeException("BigQuery table " + tableReference + " not found. If you wanted to automatically create the table, set the create disposition to CREATE_IF_NEEDED and specify a schema.");
                        }
                        throw new RuntimeException("Schema must be set for table " + tableReference + " when writing TableRows using Storage API and using a create disposition of CREATE_IF_NEEDED.");
                    }
                } else {
                    this.tableSchema = (TableSchema)MoreObjects.firstNonNull((Object)SCHEMA_CACHE.putSchemaIfAbsent(tableReference, this.tableSchema), (Object)this.tableSchema);
                }
                this.schemaInformation = TableRowToStorageApiProto.SchemaInformation.fromTableSchema(this.tableSchema);
                this.descriptor = TableRowToStorageApiProto.getDescriptorFromTableSchema(this.tableSchema);
                this.descriptorHash = BigQueryUtils.hashSchemaDescriptorDeterministic(this.descriptor);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public StorageApiDynamicDestinations.DescriptorWrapper getSchemaDescriptor() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    return new StorageApiDynamicDestinations.DescriptorWrapper(this.descriptor, this.descriptorHash);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void refreshSchema(long expectedHash) throws Exception {
                1 var3_2 = this;
                synchronized (var3_2) {
                    if (expectedHash == this.descriptorHash) {
                        return;
                    }
                }
                this.refreshSchemaInternal();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void refreshSchemaInternal() throws Exception {
                TableReference tableReference = StorageApiDynamicDestinationsTableRow.this.getTable(destination).getTableReference();
                LOG.info("Refreshing schema for table " + BigQueryHelpers.toTableSpec(tableReference));
                SCHEMA_CACHE.refreshSchema(tableReference, datasetService);
                TableSchema newSchema = SCHEMA_CACHE.getSchema(tableReference, datasetService);
                if (newSchema == null) {
                    throw new RuntimeException("BigQuery table " + tableReference + " not found");
                }
                1 var3_3 = this;
                synchronized (var3_3) {
                    this.tableSchema = newSchema;
                    this.schemaInformation = TableRowToStorageApiProto.SchemaInformation.fromTableSchema(this.tableSchema);
                    this.descriptor = TableRowToStorageApiProto.getDescriptorFromTableSchema(this.tableSchema);
                    long newHash = BigQueryUtils.hashSchemaDescriptorDeterministic(this.descriptor);
                    if (this.descriptorHash != newHash) {
                        LOG.info("Refreshed table " + BigQueryHelpers.toTableSpec(tableReference) + " has a new schema.");
                    }
                    this.descriptorHash = newHash;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public StorageApiWritePayload toMessage(T element) throws Exception {
                int attempt = 0;
                while (true) {
                    long localDescriptorHash;
                    Descriptors.Descriptor localDescriptor;
                    TableRowToStorageApiProto.SchemaInformation localSchemaInformation;
                    1 var7_7 = this;
                    synchronized (var7_7) {
                        localSchemaInformation = this.schemaInformation;
                        localDescriptor = this.descriptor;
                        localDescriptorHash = this.descriptorHash;
                    }
                    try {
                        DynamicMessage msg = TableRowToStorageApiProto.messageFromTableRow(localSchemaInformation, localDescriptor, (TableRow)StorageApiDynamicDestinationsTableRow.this.formatFunction.apply(element), StorageApiDynamicDestinationsTableRow.this.ignoreUnknownValues);
                        return new AutoValue_StorageApiWritePayload(msg.toByteArray(), localDescriptorHash);
                    }
                    catch (TableRowToStorageApiProto.SchemaTooNarrowException e) {
                        if (attempt > StorageApiDynamicDestinationsTableRow.this.schemaUpdateRetries) {
                            throw e;
                        }
                        this.refreshSchemaInternal();
                        ++attempt;
                        continue;
                    }
                    break;
                }
            }
        };
    }

    static {
        SCHEMA_CACHE.start();
    }
}

