/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.dofn;

import com.google.cloud.Timestamp;
import io.opencensus.common.Scope;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import java.io.Serializable;
import java.util.Optional;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.ChangeStreamMetrics;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.TimestampConverter;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.action.ActionFactory;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.action.ChildPartitionsRecordAction;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.action.DataChangeRecordAction;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.action.HeartbeatRecordAction;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.action.QueryChangeStreamAction;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.ChangeStreamDao;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.DaoFactory;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.PartitionMetadataDao;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.mapper.ChangeStreamRecordMapper;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.mapper.MapperFactory;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.mapper.PartitionMetadataMapper;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.DataChangeRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.PartitionMetadata;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.ReadChangeStreamPartitionRangeTracker;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.splittabledofn.ManualWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.WatermarkEstimators;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DoFn.UnboundedPerElement
public class ReadChangeStreamPartitionDoFn
extends DoFn<PartitionMetadata, DataChangeRecord>
implements Serializable {
    private static final long serialVersionUID = -7574596218085711975L;
    private static final Logger LOG = LoggerFactory.getLogger(ReadChangeStreamPartitionDoFn.class);
    private static final Tracer TRACER = Tracing.getTracer();
    private final DaoFactory daoFactory;
    private final MapperFactory mapperFactory;
    private final ActionFactory actionFactory;
    private final ChangeStreamMetrics metrics;
    private transient QueryChangeStreamAction queryChangeStreamAction;

    public ReadChangeStreamPartitionDoFn(DaoFactory daoFactory, MapperFactory mapperFactory, ActionFactory actionFactory, ChangeStreamMetrics metrics) {
        this.daoFactory = daoFactory;
        this.mapperFactory = mapperFactory;
        this.actionFactory = actionFactory;
        this.metrics = metrics;
    }

    @DoFn.GetInitialWatermarkEstimatorState
    public Instant getInitialWatermarkEstimatorState(@DoFn.Element PartitionMetadata partition) {
        return new Instant((Object)partition.getStartTimestamp().toSqlTimestamp());
    }

    @DoFn.NewWatermarkEstimator
    public ManualWatermarkEstimator<Instant> newWatermarkEstimator(@DoFn.WatermarkEstimatorState Instant watermarkEstimatorState) {
        return new WatermarkEstimators.Manual(watermarkEstimatorState);
    }

    @DoFn.GetInitialRestriction
    public OffsetRange initialRestriction(@DoFn.Element PartitionMetadata partition) {
        String token = partition.getPartitionToken();
        Timestamp startTimestamp = partition.getStartTimestamp();
        long startMicros = TimestampConverter.timestampToMicros(startTimestamp);
        long endMicros = Optional.ofNullable(partition.getEndTimestamp()).map(TimestampConverter::timestampToMicros).map(micros -> micros + 1L).orElse(TimestampConverter.MAX_MICROS + 1L);
        Timestamp partitionScheduledAt = partition.getScheduledAt();
        Timestamp partitionRunningAt = this.daoFactory.getPartitionMetadataDao().updateToRunning(token);
        if (partitionScheduledAt != null && partitionRunningAt != null) {
            this.metrics.updatePartitionScheduledToRunning(new Duration(partitionScheduledAt.toSqlTimestamp().getTime(), partitionRunningAt.toSqlTimestamp().getTime()));
        }
        return new OffsetRange(startMicros, endMicros);
    }

    @DoFn.NewTracker
    public ReadChangeStreamPartitionRangeTracker newTracker(@DoFn.Element PartitionMetadata partition, @DoFn.Restriction OffsetRange offsetRange) {
        return new ReadChangeStreamPartitionRangeTracker(partition, offsetRange);
    }

    @DoFn.Setup
    public void setup() {
        PartitionMetadataDao partitionMetadataDao = this.daoFactory.getPartitionMetadataDao();
        ChangeStreamDao changeStreamDao = this.daoFactory.getChangeStreamDao();
        ChangeStreamRecordMapper changeStreamRecordMapper = this.mapperFactory.changeStreamRecordMapper();
        PartitionMetadataMapper partitionMetadataMapper = this.mapperFactory.partitionMetadataMapper();
        DataChangeRecordAction dataChangeRecordAction = this.actionFactory.dataChangeRecordAction();
        HeartbeatRecordAction heartbeatRecordAction = this.actionFactory.heartbeatRecordAction(this.metrics);
        ChildPartitionsRecordAction childPartitionsRecordAction = this.actionFactory.childPartitionsRecordAction(partitionMetadataDao, this.metrics);
        this.queryChangeStreamAction = this.actionFactory.queryChangeStreamAction(changeStreamDao, partitionMetadataDao, changeStreamRecordMapper, partitionMetadataMapper, dataChangeRecordAction, heartbeatRecordAction, childPartitionsRecordAction);
    }

    @DoFn.ProcessElement
    public DoFn.ProcessContinuation processElement(@DoFn.Element PartitionMetadata partition, RestrictionTracker<OffsetRange, Long> tracker, DoFn.OutputReceiver<DataChangeRecord> receiver, ManualWatermarkEstimator<Instant> watermarkEstimator, DoFn.BundleFinalizer bundleFinalizer) {
        String token = partition.getPartitionToken();
        try (Scope scope = TRACER.spanBuilder("ReadChangeStreamPartitionDoFn.processElement").setRecordEvents(true).startScopedSpan();){
            TRACER.getCurrentSpan().putAttribute("PartitionID", AttributeValue.stringAttributeValue((String)token));
            LOG.debug("[" + token + "] Processing element with restriction " + tracker.currentRestriction());
            DoFn.ProcessContinuation processContinuation = this.queryChangeStreamAction.run(partition, tracker, receiver, watermarkEstimator, bundleFinalizer);
            return processContinuation;
        }
    }
}

