/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import java.io.Serializable;
import java.time.Duration;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiDynamicDestinations;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.Cache;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.CacheBuilder;

class TwoLevelMessageConverterCache<DestinationT, ElementT>
implements Serializable {
    final String operationName;
    private static final Cache<KV<String, ?>, StorageApiDynamicDestinations.MessageConverter<?>> CACHED_MESSAGE_CONVERTERS = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(15L)).build();
    private final Cache<DestinationT, StorageApiDynamicDestinations.MessageConverter<ElementT>> localMessageConverters = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(15L)).build();

    TwoLevelMessageConverterCache(String operationName) {
        this.operationName = operationName;
    }

    public StorageApiDynamicDestinations.MessageConverter<ElementT> get(DestinationT destination, StorageApiDynamicDestinations<ElementT, DestinationT> dynamicDestinations) throws Exception {
        return (StorageApiDynamicDestinations.MessageConverter)this.localMessageConverters.get(destination, () -> (StorageApiDynamicDestinations.MessageConverter)CACHED_MESSAGE_CONVERTERS.get((Object)KV.of((Object)this.operationName, (Object)destination), () -> dynamicDestinations.getMessageConverter(destination)));
    }
}

