/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.JobStatistics;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.cloud.bigquery.storage.v1.DataFormat;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryQueryHelper;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageSourceBase;
import org.apache.beam.sdk.io.gcp.bigquery.SchemaAndRecord;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;

class BigQueryStorageQuerySource<T>
extends BigQueryStorageSourceBase<T> {
    private final String stepUuid;
    private final ValueProvider<String> queryProvider;
    private final Boolean flattenResults;
    private final Boolean useLegacySql;
    private final BigQueryIO.TypedRead.QueryPriority priority;
    private final String location;
    private final String queryTempDataset;
    private final String kmsKey;
    private transient AtomicReference<JobStatistics> dryRunJobStats;

    public static <T> BigQueryStorageQuerySource<T> create(String stepUuid, ValueProvider<String> queryProvider, Boolean flattenResults, Boolean useLegacySql, BigQueryIO.TypedRead.QueryPriority priority, @Nullable String location, @Nullable String queryTempDataset, @Nullable String kmsKey, @Nullable DataFormat format, SerializableFunction<SchemaAndRecord, T> parseFn, Coder<T> outputCoder, BigQueryServices bqServices) {
        return new BigQueryStorageQuerySource<T>(stepUuid, queryProvider, flattenResults, useLegacySql, priority, location, queryTempDataset, kmsKey, format, parseFn, outputCoder, bqServices);
    }

    public static <T> BigQueryStorageQuerySource<T> create(String stepUuid, ValueProvider<String> queryProvider, Boolean flattenResults, Boolean useLegacySql, BigQueryIO.TypedRead.QueryPriority priority, @Nullable String location, @Nullable String kmsKey, SerializableFunction<SchemaAndRecord, T> parseFn, Coder<T> outputCoder, BigQueryServices bqServices) {
        return new BigQueryStorageQuerySource<T>(stepUuid, queryProvider, flattenResults, useLegacySql, priority, location, null, kmsKey, null, parseFn, outputCoder, bqServices);
    }

    private BigQueryStorageQuerySource(String stepUuid, ValueProvider<String> queryProvider, Boolean flattenResults, Boolean useLegacySql, BigQueryIO.TypedRead.QueryPriority priority, @Nullable String location, @Nullable String queryTempDataset, @Nullable String kmsKey, DataFormat format, SerializableFunction<SchemaAndRecord, T> parseFn, Coder<T> outputCoder, BigQueryServices bqServices) {
        super(format, null, null, parseFn, outputCoder, bqServices);
        this.stepUuid = (String)Preconditions.checkNotNull((Object)stepUuid, (Object)"stepUuid");
        this.queryProvider = (ValueProvider)Preconditions.checkNotNull(queryProvider, (Object)"queryProvider");
        this.flattenResults = (Boolean)Preconditions.checkNotNull((Object)flattenResults, (Object)"flattenResults");
        this.useLegacySql = (Boolean)Preconditions.checkNotNull((Object)useLegacySql, (Object)"useLegacySql");
        this.priority = (BigQueryIO.TypedRead.QueryPriority)((Object)Preconditions.checkNotNull((Object)((Object)priority), (Object)"priority"));
        this.location = location;
        this.queryTempDataset = queryTempDataset;
        this.kmsKey = kmsKey;
        this.dryRunJobStats = new AtomicReference();
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.dryRunJobStats = new AtomicReference();
    }

    public void populateDisplayData(DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        builder.add(DisplayData.item((String)"query", this.queryProvider).withLabel("Query"));
        builder.add(DisplayData.item((String)"launchesBigQueryJobs", (Boolean)true).withLabel("This transform launches BigQuery jobs to read/write elements."));
    }

    public long getEstimatedSizeBytes(PipelineOptions options) throws Exception {
        return BigQueryQueryHelper.dryRunQueryIfNeeded(this.bqServices, (BigQueryOptions)options.as(BigQueryOptions.class), this.dryRunJobStats, (String)this.queryProvider.get(), this.flattenResults, this.useLegacySql, this.location).getQuery().getTotalBytesProcessed();
    }

    @Override
    protected Table getTargetTable(BigQueryOptions options) throws Exception {
        TableReference queryResultTable = BigQueryQueryHelper.executeQuery(this.bqServices, options, this.dryRunJobStats, this.stepUuid, (String)this.queryProvider.get(), this.flattenResults, this.useLegacySql, this.priority, this.location, this.queryTempDataset, this.kmsKey);
        return this.bqServices.getDatasetService(options).getTable(queryResultTable);
    }
}

