/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import com.google.api.core.ApiService;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.cloudpubsub.FlowControlSettings;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.wire.Subscriber;
import com.google.cloud.pubsublite.proto.Cursor;
import com.google.cloud.pubsublite.proto.FlowControlRequest;
import com.google.cloud.pubsublite.proto.SeekRequest;
import com.google.cloud.pubsublite.proto.SequencedMessage;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.beam.sdk.io.gcp.pubsublite.OffsetByteProgress;
import org.apache.beam.sdk.io.gcp.pubsublite.SubscriptionPartitionProcessor;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.MoreExecutors;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.SettableFuture;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;

class SubscriptionPartitionProcessorImpl
extends ApiService.Listener
implements SubscriptionPartitionProcessor {
    private final @UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @NonNull @Initialized OffsetRange, @UnknownKeyFor @NonNull @Initialized OffsetByteProgress> tracker;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized SequencedMessage> receiver;
    private final @UnknownKeyFor @NonNull @Initialized Subscriber subscriber;
    private final @UnknownKeyFor @NonNull @Initialized SettableFuture<@UnknownKeyFor @Nullable @Initialized Void> completionFuture = SettableFuture.create();
    private final @UnknownKeyFor @NonNull @Initialized FlowControlSettings flowControlSettings;
    private @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Offset> lastClaimedOffset = Optional.empty();

    SubscriptionPartitionProcessorImpl(@UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @NonNull @Initialized OffsetRange, @UnknownKeyFor @NonNull @Initialized OffsetByteProgress> tracker, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized SequencedMessage> receiver, @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SequencedMessage>>, @UnknownKeyFor @NonNull @Initialized Subscriber> subscriberFactory, @UnknownKeyFor @NonNull @Initialized FlowControlSettings flowControlSettings) {
        this.tracker = tracker;
        this.receiver = receiver;
        this.subscriber = subscriberFactory.apply(this::onMessages);
        this.flowControlSettings = flowControlSettings;
    }

    @Override
    public void start() throws @UnknownKeyFor @NonNull @Initialized CheckedApiException {
        this.subscriber.addListener((ApiService.Listener)this, MoreExecutors.directExecutor());
        this.subscriber.startAsync();
        this.subscriber.awaitRunning();
        try {
            this.subscriber.seek(SeekRequest.newBuilder().setCursor(Cursor.newBuilder().setOffset(((OffsetRange)this.tracker.currentRestriction()).getFrom())).build()).get();
            this.subscriber.allowFlow(FlowControlRequest.newBuilder().setAllowedBytes(this.flowControlSettings.bytesOutstanding()).setAllowedMessages(this.flowControlSettings.messagesOutstanding()).build());
        }
        catch (ExecutionException e) {
            throw ExtractStatus.toCanonical((Throwable)e.getCause());
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t);
        }
    }

    private void onMessages(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SequencedMessage> messages) {
        long byteSize;
        if (this.completionFuture.isDone()) {
            return;
        }
        Offset lastOffset = Offset.of((long)((SequencedMessage)Iterables.getLast(messages)).getCursor().getOffset());
        if (this.tracker.tryClaim((Object)OffsetByteProgress.of(lastOffset, byteSize = messages.stream().mapToLong(SequencedMessage::getSizeBytes).sum()))) {
            this.lastClaimedOffset = Optional.of(lastOffset);
            messages.forEach(message -> this.receiver.outputWithTimestamp(message, new Instant(Timestamps.toMillis((Timestamp)message.getPublishTime()))));
            try {
                this.subscriber.allowFlow(FlowControlRequest.newBuilder().setAllowedBytes(byteSize).setAllowedMessages((long)messages.size()).build());
            }
            catch (CheckedApiException e) {
                this.completionFuture.setException((Throwable)e);
            }
        } else {
            this.completionFuture.set(null);
        }
    }

    public void failed(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized ApiService.State from, @UnknownKeyFor @NonNull @Initialized Throwable failure) {
        this.completionFuture.setException((Throwable)ExtractStatus.toCanonical((Throwable)failure));
    }

    @Override
    public void close() {
        this.subscriber.stopAsync().awaitTerminated();
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DoFn.ProcessContinuation waitForCompletion(@UnknownKeyFor @NonNull @Initialized Duration duration) {
        try {
            this.completionFuture.get(duration.getMillis(), TimeUnit.MILLISECONDS);
            return DoFn.ProcessContinuation.stop();
        }
        catch (TimeoutException ignored) {
            return DoFn.ProcessContinuation.resume();
        }
        catch (ExecutionException e) {
            throw ExtractStatus.toCanonical((Throwable)e.getCause()).underlying;
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Offset> lastClaimed() {
        return this.lastClaimedOffset;
    }
}

