/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import java.util.Map;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class PubsubMessage {
    private @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] message;
    private @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> attributes;
    private @Nullable @UnknownKeyFor @Initialized String messageId;

    public PubsubMessage(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] payload, @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> attributes) {
        this.message = payload;
        this.attributes = attributes;
        this.messageId = null;
    }

    public PubsubMessage(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] payload, @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> attributes, @Nullable @UnknownKeyFor @Initialized String messageId) {
        this.message = payload;
        this.attributes = attributes;
        this.messageId = messageId;
    }

    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] getPayload() {
        return this.message;
    }

    public @Nullable @UnknownKeyFor @Initialized String getAttribute(@UnknownKeyFor @NonNull @Initialized String attribute) {
        Preconditions.checkNotNull((Object)attribute, (Object)"attribute");
        return this.attributes.get(attribute);
    }

    public @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> getAttributeMap() {
        return this.attributes;
    }

    public @Nullable @UnknownKeyFor @Initialized String getMessageId() {
        return this.messageId;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return MoreObjects.toStringHelper((Object)this).add("message", (Object)this.message).add("attributes", this.attributes).add("messageId", (Object)this.messageId).toString();
    }
}

