/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfigurationExtract;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.AvroSource;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryResourceNaming;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.SchemaAndRecord;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Function;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Supplier;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Suppliers;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BigQuerySourceBase<@UnknownKeyFor T>
extends BoundedSource<T> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(BigQuerySourceBase.class);
    protected static final @UnknownKeyFor @NonNull @Initialized int JOB_POLL_MAX_RETRIES = Integer.MAX_VALUE;
    protected final @UnknownKeyFor @NonNull @Initialized String stepUuid;
    protected final @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices;
    private transient @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BoundedSource<T>> cachedSplitResult;
    private @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized SchemaAndRecord, T> parseFn;
    private @UnknownKeyFor @NonNull @Initialized Coder<T> coder;
    private final @UnknownKeyFor @NonNull @Initialized boolean useAvroLogicalTypes;

    BigQuerySourceBase(@UnknownKeyFor @NonNull @Initialized String stepUuid, @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices, @UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized SchemaAndRecord, T> parseFn, @UnknownKeyFor @NonNull @Initialized boolean useAvroLogicalTypes) {
        this.stepUuid = (String)Preconditions.checkNotNull((Object)stepUuid, (Object)"stepUuid");
        this.bqServices = (BigQueryServices)Preconditions.checkNotNull((Object)bqServices, (Object)"bqServices");
        this.coder = (Coder)Preconditions.checkNotNull(coder, (Object)"coder");
        this.parseFn = (SerializableFunction)Preconditions.checkNotNull(parseFn, (Object)"parseFn");
        this.useAvroLogicalTypes = useAvroLogicalTypes;
    }

    protected @UnknownKeyFor @NonNull @Initialized ExtractResult extractFiles(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
        BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
        TableReference tableToExtract = this.getTableToExtract(bqOptions);
        BigQueryServices.DatasetService datasetService = this.bqServices.getDatasetService(bqOptions);
        Table table = datasetService.getTable(tableToExtract);
        if (table == null) {
            throw new IOException(String.format("Cannot start an export job since table %s does not exist", BigQueryHelpers.toTableSpec(tableToExtract)));
        }
        TableSchema schema = table.getSchema();
        BigQueryServices.JobService jobService = this.bqServices.getJobService(bqOptions);
        String extractJobId = BigQueryResourceNaming.createJobIdPrefix(options.getJobName(), this.stepUuid, BigQueryResourceNaming.JobType.EXPORT);
        String extractDestinationDir = BigQueryHelpers.resolveTempLocation(bqOptions.getTempLocation(), "BigQueryExtractTemp", this.stepUuid);
        String bqLocation = BigQueryHelpers.getDatasetLocation(datasetService, tableToExtract.getProjectId(), tableToExtract.getDatasetId());
        List<ResourceId> tempFiles = this.executeExtract(extractJobId, tableToExtract, jobService, bqOptions.getProject(), extractDestinationDir, bqLocation, this.useAvroLogicalTypes);
        return new ExtractResult(schema, tempFiles);
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BoundedSource<T>> split(@UnknownKeyFor @NonNull @Initialized long desiredBundleSizeBytes, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (this.cachedSplitResult == null) {
            BigQueryOptions bqOptions;
            String extractDestinationDir;
            List matches;
            ExtractResult res = this.extractFiles(options);
            LOG.info("Extract job produced {} files", (Object)res.extractedFiles.size());
            if (res.extractedFiles.size() > 0 && (matches = FileSystems.match((List)ImmutableList.of((Object)((extractDestinationDir = BigQueryHelpers.resolveTempLocation((bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class)).getTempLocation(), "BigQueryExtractTemp", this.stepUuid)) + "*")))).size() > 0) {
                res.metadata = ((MatchResult)matches.get(0)).metadata();
            }
            this.cleanupTempResource((BigQueryOptions)options.as(BigQueryOptions.class));
            this.cachedSplitResult = (List)Preconditions.checkNotNull(this.createSources(res.extractedFiles, res.schema, res.metadata));
        }
        return this.cachedSplitResult;
    }

    protected abstract @UnknownKeyFor @NonNull @Initialized TableReference getTableToExtract(@UnknownKeyFor @NonNull @Initialized BigQueryOptions var1) throws @UnknownKeyFor @NonNull @Initialized Exception;

    protected abstract void cleanupTempResource(@UnknownKeyFor @NonNull @Initialized BigQueryOptions var1) throws @UnknownKeyFor @NonNull @Initialized Exception;

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized BoundedSource.BoundedReader<T> createReader(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized IOException {
        throw new UnsupportedOperationException("BigQuery source must be split before being read");
    }

    public void validate() {
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<T> getOutputCoder() {
        return this.coder;
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ResourceId> executeExtract(@UnknownKeyFor @NonNull @Initialized String jobId, @UnknownKeyFor @NonNull @Initialized TableReference table, @UnknownKeyFor @NonNull @Initialized BigQueryServices.JobService jobService, @UnknownKeyFor @NonNull @Initialized String executingProject, @UnknownKeyFor @NonNull @Initialized String extractDestinationDir, @UnknownKeyFor @NonNull @Initialized String bqLocation, @UnknownKeyFor @NonNull @Initialized boolean useAvroLogicalTypes) throws @UnknownKeyFor @NonNull @Initialized InterruptedException, @UnknownKeyFor @NonNull @Initialized IOException {
        JobReference jobRef = new JobReference().setProjectId(executingProject).setLocation(bqLocation).setJobId(jobId);
        String destinationUri = BigQueryIO.getExtractDestinationUri(extractDestinationDir);
        JobConfigurationExtract extract = new JobConfigurationExtract().setSourceTable(table).setDestinationFormat("AVRO").setUseAvroLogicalTypes(Boolean.valueOf(useAvroLogicalTypes)).setDestinationUris((List)ImmutableList.of((Object)destinationUri));
        LOG.info("Starting BigQuery extract job: {}", (Object)jobId);
        jobService.startExtractJob(jobRef, extract);
        Job extractJob = jobService.pollJob(jobRef, Integer.MAX_VALUE);
        if (BigQueryHelpers.parseStatus(extractJob) != BigQueryHelpers.Status.SUCCEEDED) {
            throw new IOException(String.format("Extract job %s failed, status: %s.", extractJob.getJobReference().getJobId(), BigQueryHelpers.statusToPrettyString(extractJob.getStatus())));
        }
        LOG.info("BigQuery extract job completed: {}", (Object)jobId);
        return BigQueryIO.getExtractFilePaths(extractDestinationDir, extractJob);
    }

    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BoundedSource<T>> createSources(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ResourceId> files, @UnknownKeyFor @NonNull @Initialized TableSchema schema, @UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized MatchResult.Metadata> metadata) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        final String jsonSchema = BigQueryIO.JSON_FACTORY.toString((Object)schema);
        SerializableFunction fnWrapper = new SerializableFunction<GenericRecord, T>(){
            private @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized TableSchema> schema;
            {
                this.schema = Suppliers.memoize((Supplier)Suppliers.compose((Function)new TableSchemaFunction(), (Supplier)Suppliers.ofInstance((Object)jsonSchema)));
            }

            public T apply(@UnknownKeyFor @NonNull @Initialized GenericRecord input) {
                return BigQuerySourceBase.this.parseFn.apply((Object)new SchemaAndRecord(input, (TableSchema)this.schema.get()));
            }
        };
        ArrayList avroSources = Lists.newArrayList();
        if (metadata != null) {
            for (MatchResult.Metadata file : metadata) {
                avroSources.add(AvroSource.from((MatchResult.Metadata)file).withParseFn(fnWrapper, this.getOutputCoder()));
            }
        } else {
            for (ResourceId file : files) {
                avroSources.add(AvroSource.from((String)file.toString()).withParseFn(fnWrapper, this.getOutputCoder()));
            }
        }
        return ImmutableList.copyOf((Collection)avroSources);
    }

    private static class TableSchemaFunction
    implements Serializable,
    Function<String, TableSchema> {
        private TableSchemaFunction() {
        }

        public @Nullable @UnknownKeyFor @Initialized TableSchema apply(@Nullable @UnknownKeyFor @Initialized String input) {
            return BigQueryHelpers.fromJsonString(input, TableSchema.class);
        }
    }

    protected static class ExtractResult {
        public final @UnknownKeyFor @NonNull @Initialized TableSchema schema;
        public final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ResourceId> extractedFiles;
        public @UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized MatchResult.Metadata> metadata = null;

        public ExtractResult(@UnknownKeyFor @NonNull @Initialized TableSchema schema, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ResourceId> extractedFiles) {
            this(schema, extractedFiles, null);
        }

        public ExtractResult(@UnknownKeyFor @NonNull @Initialized TableSchema schema, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ResourceId> extractedFiles, @UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized MatchResult.Metadata> metadata) {
            this.schema = schema;
            this.extractedFiles = extractedFiles;
            this.metadata = metadata;
        }
    }
}

