/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.Dataset;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfigurationExtract;
import com.google.api.services.bigquery.model.JobConfigurationLoad;
import com.google.api.services.bigquery.model.JobConfigurationQuery;
import com.google.api.services.bigquery.model.JobConfigurationTableCopy;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.JobStatistics;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.cloud.bigquery.storage.v1.CreateReadSessionRequest;
import com.google.cloud.bigquery.storage.v1.ReadRowsRequest;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.cloud.bigquery.storage.v1.SplitReadStreamRequest;
import com.google.cloud.bigquery.storage.v1.SplitReadStreamResponse;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.ErrorContainer;
import org.apache.beam.sdk.io.gcp.bigquery.InsertRetryPolicy;
import org.apache.beam.sdk.util.Histogram;
import org.apache.beam.sdk.values.FailsafeValueInSingleWindow;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public interface BigQueryServices
extends Serializable {
    public @UnknownKeyFor @NonNull @Initialized JobService getJobService(@UnknownKeyFor @NonNull @Initialized BigQueryOptions var1);

    public @UnknownKeyFor @NonNull @Initialized DatasetService getDatasetService(@UnknownKeyFor @NonNull @Initialized BigQueryOptions var1);

    public @UnknownKeyFor @NonNull @Initialized DatasetService getDatasetService(@UnknownKeyFor @NonNull @Initialized BigQueryOptions var1, @UnknownKeyFor @NonNull @Initialized Histogram var2);

    public @UnknownKeyFor @NonNull @Initialized StorageClient getStorageClient(@UnknownKeyFor @NonNull @Initialized BigQueryOptions var1) throws @UnknownKeyFor @NonNull @Initialized IOException;

    public static interface StorageClient
    extends AutoCloseable {
        public @UnknownKeyFor @NonNull @Initialized ReadSession createReadSession(@UnknownKeyFor @NonNull @Initialized CreateReadSessionRequest var1);

        public @UnknownKeyFor @NonNull @Initialized BigQueryServerStream<@UnknownKeyFor @NonNull @Initialized ReadRowsResponse> readRows(@UnknownKeyFor @NonNull @Initialized ReadRowsRequest var1);

        public @UnknownKeyFor @NonNull @Initialized SplitReadStreamResponse splitReadStream(@UnknownKeyFor @NonNull @Initialized SplitReadStreamRequest var1);

        @Override
        public void close();
    }

    public static interface BigQueryServerStream<@UnknownKeyFor T>
    extends Iterable<T>,
    Serializable {
        public void cancel();
    }

    public static interface DatasetService {
        public @Nullable @UnknownKeyFor @Initialized Table getTable(@UnknownKeyFor @NonNull @Initialized TableReference var1) throws @UnknownKeyFor @NonNull @Initialized InterruptedException, @UnknownKeyFor @NonNull @Initialized IOException;

        public @Nullable @UnknownKeyFor @Initialized Table getTable(@UnknownKeyFor @NonNull @Initialized TableReference var1, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> var2) throws @UnknownKeyFor @NonNull @Initialized InterruptedException, @UnknownKeyFor @NonNull @Initialized IOException;

        public void createTable(@UnknownKeyFor @NonNull @Initialized Table var1) throws @UnknownKeyFor @NonNull @Initialized InterruptedException, @UnknownKeyFor @NonNull @Initialized IOException;

        public void deleteTable(@UnknownKeyFor @NonNull @Initialized TableReference var1) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException;

        public @UnknownKeyFor @NonNull @Initialized boolean isTableEmpty(@UnknownKeyFor @NonNull @Initialized TableReference var1) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException;

        public @UnknownKeyFor @NonNull @Initialized Dataset getDataset(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized String var2) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException;

        public void createDataset(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized String var2, @Nullable @UnknownKeyFor @Initialized String var3, @Nullable @UnknownKeyFor @Initialized String var4, @Nullable @UnknownKeyFor @Initialized Long var5) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException;

        public void deleteDataset(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized String var2) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException;

        public <T> @UnknownKeyFor @NonNull @Initialized long insertAll(@UnknownKeyFor @NonNull @Initialized TableReference var1, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FailsafeValueInSingleWindow<@UnknownKeyFor @NonNull @Initialized TableRow, @UnknownKeyFor @NonNull @Initialized TableRow>> var2, @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized String> var3, @UnknownKeyFor @NonNull @Initialized InsertRetryPolicy var4, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T>> var5, @UnknownKeyFor @NonNull @Initialized ErrorContainer<T> var6, @UnknownKeyFor @NonNull @Initialized boolean var7, @UnknownKeyFor @NonNull @Initialized boolean var8, @UnknownKeyFor @NonNull @Initialized boolean var9) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException;

        public @UnknownKeyFor @NonNull @Initialized Table patchTableDescription(@UnknownKeyFor @NonNull @Initialized TableReference var1, @Nullable @UnknownKeyFor @Initialized String var2) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException;
    }

    public static interface JobService {
        public void startLoadJob(@UnknownKeyFor @NonNull @Initialized JobReference var1, @UnknownKeyFor @NonNull @Initialized JobConfigurationLoad var2) throws @UnknownKeyFor @NonNull @Initialized InterruptedException, @UnknownKeyFor @NonNull @Initialized IOException;

        public void startExtractJob(@UnknownKeyFor @NonNull @Initialized JobReference var1, @UnknownKeyFor @NonNull @Initialized JobConfigurationExtract var2) throws @UnknownKeyFor @NonNull @Initialized InterruptedException, @UnknownKeyFor @NonNull @Initialized IOException;

        public void startQueryJob(@UnknownKeyFor @NonNull @Initialized JobReference var1, @UnknownKeyFor @NonNull @Initialized JobConfigurationQuery var2) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException;

        public void startCopyJob(@UnknownKeyFor @NonNull @Initialized JobReference var1, @UnknownKeyFor @NonNull @Initialized JobConfigurationTableCopy var2) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException;

        public @UnknownKeyFor @NonNull @Initialized Job pollJob(@UnknownKeyFor @NonNull @Initialized JobReference var1, @UnknownKeyFor @NonNull @Initialized int var2) throws @UnknownKeyFor @NonNull @Initialized InterruptedException;

        public @UnknownKeyFor @NonNull @Initialized JobStatistics dryRunQuery(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized JobConfigurationQuery var2, @UnknownKeyFor @NonNull @Initialized String var3) throws @UnknownKeyFor @NonNull @Initialized InterruptedException, @UnknownKeyFor @NonNull @Initialized IOException;

        public @UnknownKeyFor @NonNull @Initialized Job getJob(@UnknownKeyFor @NonNull @Initialized JobReference var1) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException;
    }
}

