/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.auto.value.AutoValue;
import com.google.cloud.ServiceFactory;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.PartitionOptions;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TimestampBound;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.OptionalInt;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerIO_CreateTransaction;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerIO_Read;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerIO_ReadAll;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerIO_Write;
import org.apache.beam.sdk.io.gcp.spanner.BatchSpannerRead;
import org.apache.beam.sdk.io.gcp.spanner.CreateTransactionFn;
import org.apache.beam.sdk.io.gcp.spanner.MutationCellCounter;
import org.apache.beam.sdk.io.gcp.spanner.MutationGroup;
import org.apache.beam.sdk.io.gcp.spanner.MutationKeyEncoder;
import org.apache.beam.sdk.io.gcp.spanner.MutationSizeEstimator;
import org.apache.beam.sdk.io.gcp.spanner.MutationUtils;
import org.apache.beam.sdk.io.gcp.spanner.NaiveSpannerRead;
import org.apache.beam.sdk.io.gcp.spanner.ReadOperation;
import org.apache.beam.sdk.io.gcp.spanner.ReadSpannerSchema;
import org.apache.beam.sdk.io.gcp.spanner.SpannerAccessor;
import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.io.gcp.spanner.SpannerSchema;
import org.apache.beam.sdk.io.gcp.spanner.SpannerWriteResult;
import org.apache.beam.sdk.io.gcp.spanner.Transaction;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Distribution;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.Wait;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.DefaultTrigger;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Stopwatch;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.primitives.UnsignedBytes;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class SpannerIO {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SpannerIO.class);
    private static final @UnknownKeyFor @NonNull @Initialized long DEFAULT_BATCH_SIZE_BYTES = 0x100000L;
    private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_MAX_NUM_MUTATIONS = 5000;
    private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_MAX_NUM_ROWS = 500;
    private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_GROUPING_FACTOR = 1000;

    public static @UnknownKeyFor @NonNull @Initialized Read read() {
        return new AutoValue_SpannerIO_Read.Builder().setSpannerConfig(SpannerConfig.create()).setTimestampBound(TimestampBound.strong()).setReadOperation(ReadOperation.create()).setBatching(true).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized ReadAll readAll() {
        return new AutoValue_SpannerIO_ReadAll.Builder().setSpannerConfig(SpannerConfig.create()).setTimestampBound(TimestampBound.strong()).setBatching(true).build();
    }

    @Experimental
    public static @UnknownKeyFor @NonNull @Initialized CreateTransaction createTransaction() {
        return new AutoValue_SpannerIO_CreateTransaction.Builder().setSpannerConfig(SpannerConfig.create()).setTimestampBound(TimestampBound.strong()).build();
    }

    @Experimental
    public static @UnknownKeyFor @NonNull @Initialized Write write() {
        return new AutoValue_SpannerIO_Write.Builder().setSpannerConfig(SpannerConfig.create()).setBatchSizeBytes(0x100000L).setMaxNumMutations(5000L).setMaxNumRows(500L).setFailureMode(FailureMode.FAIL_FAST).build();
    }

    private SpannerIO() {
    }

    @VisibleForTesting
    static class WriteToSpannerFn
    extends DoFn<Iterable<MutationGroup>, Void> {
        private final @UnknownKeyFor @NonNull @Initialized SpannerConfig spannerConfig;
        private final @UnknownKeyFor @NonNull @Initialized FailureMode failureMode;
        private transient @UnknownKeyFor @NonNull @Initialized SpannerAccessor spannerAccessor;
        private static final @UnknownKeyFor @NonNull @Initialized int ABORTED_RETRY_ATTEMPTS = 5;
        private final @UnknownKeyFor @NonNull @Initialized String errString = "Transaction aborted. Database schema probably changed during transaction, retry may succeed.";
        @VisibleForTesting
        static @UnknownKeyFor @NonNull @Initialized Sleeper sleeper = Sleeper.DEFAULT;
        private final @UnknownKeyFor @NonNull @Initialized Counter mutationGroupBatchesReceived = Metrics.counter(WriteGrouped.class, (String)"mutation_group_batches_received");
        private final @UnknownKeyFor @NonNull @Initialized Counter mutationGroupBatchesWriteSuccess = Metrics.counter(WriteGrouped.class, (String)"mutation_group_batches_write_success");
        private final @UnknownKeyFor @NonNull @Initialized Counter mutationGroupBatchesWriteFail = Metrics.counter(WriteGrouped.class, (String)"mutation_group_batches_write_fail");
        private final @UnknownKeyFor @NonNull @Initialized Counter mutationGroupsReceived = Metrics.counter(WriteGrouped.class, (String)"mutation_groups_received");
        private final @UnknownKeyFor @NonNull @Initialized Counter mutationGroupsWriteSuccess = Metrics.counter(WriteGrouped.class, (String)"mutation_groups_write_success");
        private final @UnknownKeyFor @NonNull @Initialized Counter mutationGroupsWriteFail = Metrics.counter(WriteGrouped.class, (String)"mutation_groups_write_fail");
        private final @UnknownKeyFor @NonNull @Initialized Counter spannerWriteSuccess = Metrics.counter(WriteGrouped.class, (String)"spanner_write_success");
        private final @UnknownKeyFor @NonNull @Initialized Counter spannerWriteFail = Metrics.counter(WriteGrouped.class, (String)"spanner_write_fail");
        private final @UnknownKeyFor @NonNull @Initialized Distribution spannerWriteLatency = Metrics.distribution(WriteGrouped.class, (String)"spanner_write_latency_ms");
        private final @UnknownKeyFor @NonNull @Initialized Counter spannerWriteTimeouts = Metrics.counter(WriteGrouped.class, (String)"spanner_write_timeouts");
        private final @UnknownKeyFor @NonNull @Initialized Counter spannerWriteRetries = Metrics.counter(WriteGrouped.class, (String)"spanner_write_retries");
        private final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized MutationGroup> failedTag;
        private transient @UnknownKeyFor @NonNull @Initialized FluentBackoff bundleWriteBackoff;

        WriteToSpannerFn(@UnknownKeyFor @NonNull @Initialized SpannerConfig spannerConfig, @UnknownKeyFor @NonNull @Initialized FailureMode failureMode, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized MutationGroup> failedTag) {
            this.spannerConfig = spannerConfig;
            this.failureMode = failureMode;
            this.failedTag = failedTag;
        }

        @DoFn.Setup
        public void setup() {
            this.spannerAccessor = SpannerAccessor.getOrCreate(this.spannerConfig);
            this.bundleWriteBackoff = FluentBackoff.DEFAULT.withMaxCumulativeBackoff((Duration)this.spannerConfig.getMaxCumulativeBackoff().get()).withInitialBackoff(((Duration)this.spannerConfig.getMaxCumulativeBackoff().get()).dividedBy(60L));
        }

        @DoFn.Teardown
        public void teardown() {
            this.spannerAccessor.close();
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
            Iterable mutations = (Iterable)c.element();
            try {
                this.mutationGroupBatchesReceived.inc();
                this.mutationGroupsReceived.inc((long)Iterables.size((Iterable)mutations));
                Iterable batch = Iterables.concat((Iterable)mutations);
                this.writeMutations(batch);
                this.mutationGroupBatchesWriteSuccess.inc();
                this.mutationGroupsWriteSuccess.inc((long)Iterables.size((Iterable)mutations));
                return;
            }
            catch (SpannerException e) {
                this.mutationGroupBatchesWriteFail.inc();
                if (this.failureMode != FailureMode.REPORT_FAILURES) {
                    if (this.failureMode == FailureMode.FAIL_FAST) {
                        this.mutationGroupsWriteFail.inc((long)Iterables.size((Iterable)mutations));
                        throw e;
                    }
                    throw new IllegalArgumentException("Unknown failure mode " + (Object)((Object)this.failureMode));
                }
                for (MutationGroup mg : mutations) {
                    try {
                        this.spannerWriteRetries.inc();
                        this.writeMutations(mg);
                        this.mutationGroupsWriteSuccess.inc();
                    }
                    catch (SpannerException e2) {
                        this.mutationGroupsWriteFail.inc();
                        LOG.warn("Failed to write the mutation group: " + mg, (Throwable)e2);
                        c.output(this.failedTag, (Object)mg);
                    }
                }
                return;
            }
        }

        private void spannerWriteWithRetryIfSchemaChange(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Mutation> batch) throws @UnknownKeyFor @NonNull @Initialized SpannerException {
            int retry = 1;
            while (true) {
                try {
                    this.spannerAccessor.getDatabaseClient().writeAtLeastOnce(batch);
                    return;
                }
                catch (AbortedException e) {
                    if (retry >= 5) {
                        throw e;
                    }
                    if (!e.isRetryable() && !e.getMessage().contains("Transaction aborted. Database schema probably changed during transaction, retry may succeed.")) {
                        throw e;
                    }
                    ++retry;
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeMutations(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Mutation> mutations) throws @UnknownKeyFor @NonNull @Initialized SpannerException, @UnknownKeyFor @NonNull @Initialized IOException {
            BackOff backoff = this.bundleWriteBackoff.backoff();
            long mutationsSize = Iterables.size(mutations);
            while (true) {
                Stopwatch timer = Stopwatch.createStarted();
                try {
                    this.spannerWriteWithRetryIfSchemaChange(mutations);
                    this.spannerWriteSuccess.inc();
                    return;
                }
                catch (SpannerException exception) {
                    if (exception.getErrorCode() == ErrorCode.DEADLINE_EXCEEDED) {
                        this.spannerWriteTimeouts.inc();
                        long sleepTimeMsecs = backoff.nextBackOffMillis();
                        if (sleepTimeMsecs == -1L) {
                            LOG.error("DEADLINE_EXCEEDED writing batch of {} mutations to Cloud Spanner. Aborting after too many retries.", (Object)mutationsSize);
                            this.spannerWriteFail.inc();
                            throw exception;
                        }
                        LOG.info("DEADLINE_EXCEEDED writing batch of {} mutations to Cloud Spanner, retrying after backoff of {}ms\n({})", new Object[]{mutationsSize, sleepTimeMsecs, exception.getMessage()});
                        this.spannerWriteRetries.inc();
                        try {
                            sleeper.sleep(sleepTimeMsecs);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    this.spannerWriteFail.inc();
                    throw exception;
                }
                finally {
                    this.spannerWriteLatency.update(timer.elapsed(TimeUnit.MILLISECONDS));
                    continue;
                }
                break;
            }
        }
    }

    @VisibleForTesting
    static class BatchableMutationFilterFn
    extends DoFn<MutationGroup, MutationGroup> {
        private final @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized SpannerSchema> schemaView;
        private final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MutationGroup>> unbatchableMutationsTag;
        private final @UnknownKeyFor @NonNull @Initialized long batchSizeBytes;
        private final @UnknownKeyFor @NonNull @Initialized long maxNumMutations;
        private final @UnknownKeyFor @NonNull @Initialized long maxNumRows;
        private final @UnknownKeyFor @NonNull @Initialized Counter batchableMutationGroupsCounter = Metrics.counter(WriteGrouped.class, (String)"batchable_mutation_groups");
        private final @UnknownKeyFor @NonNull @Initialized Counter unBatchableMutationGroupsCounter = Metrics.counter(WriteGrouped.class, (String)"unbatchable_mutation_groups");

        BatchableMutationFilterFn(@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized SpannerSchema> schemaView, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MutationGroup>> unbatchableMutationsTag, @UnknownKeyFor @NonNull @Initialized long batchSizeBytes, @UnknownKeyFor @NonNull @Initialized long maxNumMutations, @UnknownKeyFor @NonNull @Initialized long maxNumRows) {
            this.schemaView = schemaView;
            this.unbatchableMutationsTag = unbatchableMutationsTag;
            this.batchSizeBytes = batchSizeBytes;
            this.maxNumMutations = maxNumMutations;
            this.maxNumRows = maxNumRows;
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            MutationGroup mg = (MutationGroup)c.element();
            if (mg.primary().getOperation() == Mutation.Op.DELETE && !MutationUtils.isPointDelete(mg.primary())) {
                c.output(this.unbatchableMutationsTag, Arrays.asList(mg));
                this.unBatchableMutationGroupsCounter.inc();
                return;
            }
            SpannerSchema spannerSchema = (SpannerSchema)c.sideInput(this.schemaView);
            long groupSize = MutationSizeEstimator.sizeOf(mg);
            long groupCells = MutationCellCounter.countOf(spannerSchema, mg);
            long groupRows = Iterables.size((Iterable)mg);
            if (groupSize >= this.batchSizeBytes || groupCells >= this.maxNumMutations || groupRows >= this.maxNumRows) {
                c.output(this.unbatchableMutationsTag, Arrays.asList(mg));
                this.unBatchableMutationGroupsCounter.inc();
            } else {
                c.output((Object)mg);
                this.batchableMutationGroupsCounter.inc();
            }
        }
    }

    @VisibleForTesting
    static class GatherSortCreateBatchesFn
    extends DoFn<MutationGroup, Iterable<MutationGroup>> {
        private final @UnknownKeyFor @NonNull @Initialized long maxBatchSizeBytes;
        private final @UnknownKeyFor @NonNull @Initialized long maxBatchNumMutations;
        private final @UnknownKeyFor @NonNull @Initialized long maxBatchNumRows;
        private final @UnknownKeyFor @NonNull @Initialized long maxSortableSizeBytes;
        private final @UnknownKeyFor @NonNull @Initialized long maxSortableNumMutations;
        private final @UnknownKeyFor @NonNull @Initialized long maxSortableNumRows;
        private final @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized SpannerSchema> schemaView;
        private final @UnknownKeyFor @NonNull @Initialized ArrayList<@UnknownKeyFor @NonNull @Initialized MutationGroupContainer> mutationsToSort = new ArrayList();
        private @UnknownKeyFor @NonNull @Initialized long sortableSizeBytes = 0L;
        private @UnknownKeyFor @NonNull @Initialized long sortableNumCells = 0L;
        private @UnknownKeyFor @NonNull @Initialized long sortableNumRows = 0L;

        GatherSortCreateBatchesFn(@UnknownKeyFor @NonNull @Initialized long maxBatchSizeBytes, @UnknownKeyFor @NonNull @Initialized long maxNumMutations, @UnknownKeyFor @NonNull @Initialized long maxNumRows, @UnknownKeyFor @NonNull @Initialized long groupingFactor, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized SpannerSchema> schemaView) {
            this.maxBatchSizeBytes = maxBatchSizeBytes;
            this.maxBatchNumMutations = maxNumMutations;
            this.maxBatchNumRows = maxNumRows;
            if (groupingFactor <= 0L) {
                groupingFactor = 1L;
            }
            this.maxSortableSizeBytes = maxBatchSizeBytes * groupingFactor;
            this.maxSortableNumMutations = maxNumMutations * groupingFactor;
            this.maxSortableNumRows = maxNumRows * groupingFactor;
            this.schemaView = schemaView;
            this.initSorter();
        }

        private synchronized void initSorter() {
            this.mutationsToSort.clear();
            this.sortableSizeBytes = 0L;
            this.sortableNumCells = 0L;
            this.sortableNumRows = 0L;
        }

        @DoFn.FinishBundle
        public synchronized void finishBundle(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.sortAndOutputBatches(new OutputReceiverForFinishBundle(c));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void sortAndOutputBatches(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MutationGroup>> out) throws @UnknownKeyFor @NonNull @Initialized IOException {
            try {
                if (this.mutationsToSort.isEmpty()) {
                    return;
                }
                if (this.maxSortableNumMutations == this.maxBatchNumMutations) {
                    this.outputBatch(out, 0, this.mutationsToSort.size());
                    return;
                }
                this.mutationsToSort.sort(Comparator.naturalOrder());
                int batchStart = 0;
                int batchEnd = 0;
                long batchSizeBytes = 0L;
                long batchCells = 0L;
                long batchRows = 0L;
                while (batchEnd < this.mutationsToSort.size()) {
                    MutationGroupContainer mg = this.mutationsToSort.get(batchEnd);
                    if (batchCells + mg.numCells > this.maxBatchNumMutations || batchSizeBytes + mg.sizeBytes > this.maxBatchSizeBytes || batchRows + mg.numRows > this.maxBatchNumRows) {
                        this.outputBatch(out, batchStart, batchEnd);
                        batchStart = batchEnd;
                        batchSizeBytes = 0L;
                        batchCells = 0L;
                        batchRows = 0L;
                    }
                    ++batchEnd;
                    batchSizeBytes += mg.sizeBytes;
                    batchCells += mg.numCells;
                    batchRows += mg.numRows;
                }
                if (batchStart < batchEnd) {
                    this.outputBatch(out, batchStart, this.mutationsToSort.size());
                }
            }
            finally {
                this.initSorter();
            }
        }

        private void outputBatch(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MutationGroup>> out, @UnknownKeyFor @NonNull @Initialized int batchStart, @UnknownKeyFor @NonNull @Initialized int batchEnd) {
            out.output((Object)this.mutationsToSort.subList(batchStart, batchEnd).stream().map(o -> o.mutationGroup).collect(Collectors.toList()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @DoFn.ProcessElement
        public synchronized void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MutationGroup>> out) throws @UnknownKeyFor @NonNull @Initialized Exception {
            SpannerSchema spannerSchema = (SpannerSchema)c.sideInput(this.schemaView);
            MutationKeyEncoder encoder = new MutationKeyEncoder(spannerSchema);
            MutationGroup mg = (MutationGroup)c.element();
            long groupSize = MutationSizeEstimator.sizeOf(mg);
            long groupCells = MutationCellCounter.countOf(spannerSchema, mg);
            long groupRows = mg.size();
            GatherSortCreateBatchesFn gatherSortCreateBatchesFn = this;
            synchronized (gatherSortCreateBatchesFn) {
                if (this.sortableNumCells + groupCells > this.maxSortableNumMutations || this.sortableSizeBytes + groupSize > this.maxSortableSizeBytes || this.sortableNumRows + groupRows > this.maxSortableNumRows) {
                    this.sortAndOutputBatches(out);
                }
                this.mutationsToSort.add(new MutationGroupContainer(mg, groupSize, groupCells, groupRows, encoder.encodeTableNameAndKey(mg.primary())));
                this.sortableSizeBytes += groupSize;
                this.sortableNumCells += groupCells;
                this.sortableNumRows += groupRows;
            }
        }

        private static class OutputReceiverForFinishBundle
        implements DoFn.OutputReceiver<Iterable<MutationGroup>> {
            private final /*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext c;

            OutputReceiverForFinishBundle(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext c) {
                this.c = c;
            }

            public void output(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MutationGroup> output) {
                this.outputWithTimestamp(output, Instant.now());
            }

            public void outputWithTimestamp(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MutationGroup> output, @UnknownKeyFor @NonNull @Initialized Instant timestamp) {
                this.c.output(output, timestamp, (BoundedWindow)GlobalWindow.INSTANCE);
            }
        }

        private static final class MutationGroupContainer
        implements Comparable<MutationGroupContainer> {
            final @UnknownKeyFor @NonNull @Initialized MutationGroup mutationGroup;
            final @UnknownKeyFor @NonNull @Initialized long sizeBytes;
            final @UnknownKeyFor @NonNull @Initialized long numCells;
            final @UnknownKeyFor @NonNull @Initialized long numRows;
            final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] encodedKey;

            MutationGroupContainer(@UnknownKeyFor @NonNull @Initialized MutationGroup mutationGroup, @UnknownKeyFor @NonNull @Initialized long sizeBytes, @UnknownKeyFor @NonNull @Initialized long numCells, @UnknownKeyFor @NonNull @Initialized long numRows, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] encodedKey) {
                this.mutationGroup = mutationGroup;
                this.sizeBytes = sizeBytes;
                this.numCells = numCells;
                this.numRows = numRows;
                this.encodedKey = encodedKey;
            }

            @Override
            @Pure
            public @UnknownKeyFor @NonNull @Initialized int compareTo(@UnknownKeyFor @NonNull @Initialized MutationGroupContainer o) {
                return UnsignedBytes.lexicographicalComparator().compare(this.encodedKey, o.encodedKey);
            }
        }
    }

    private static class ToMutationGroupFn
    extends DoFn<Mutation, MutationGroup> {
        private ToMutationGroupFn() {
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            Mutation value = (Mutation)c.element();
            c.output((Object)MutationGroup.create(value, new Mutation[0]));
        }
    }

    public static class WriteGrouped
    extends PTransform<PCollection<MutationGroup>, SpannerWriteResult> {
        private final @UnknownKeyFor @NonNull @Initialized Write spec;
        private static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized MutationGroup> BATCHABLE_MUTATIONS_TAG = new TupleTag<MutationGroup>("batchableMutations"){};
        private static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MutationGroup>> UNBATCHABLE_MUTATIONS_TAG = new TupleTag<Iterable<MutationGroup>>("unbatchableMutations"){};
        private static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @Nullable @Initialized Void> MAIN_OUT_TAG = new TupleTag<Void>("mainOut"){};
        private static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized MutationGroup> FAILED_MUTATIONS_TAG = new TupleTag<MutationGroup>("failedMutations"){};
        private static final @UnknownKeyFor @NonNull @Initialized SerializableCoder<@UnknownKeyFor @NonNull @Initialized MutationGroup> CODER = SerializableCoder.of(MutationGroup.class);

        public WriteGrouped(@UnknownKeyFor @NonNull @Initialized Write spec) {
            this.spec = spec;
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            this.spec.populateDisplayDataWithParamaters(builder);
        }

        public @UnknownKeyFor @NonNull @Initialized SpannerWriteResult expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized MutationGroup> input) {
            PCollection batches;
            if (this.spec.getBatchSizeBytes() <= 1L || this.spec.getMaxNumMutations() <= 1L || this.spec.getMaxNumRows() <= 1L) {
                LOG.info("Batching of mutationGroups is disabled");
                TypeDescriptor<Iterable<MutationGroup>> descriptor = new TypeDescriptor<Iterable<MutationGroup>>(){};
                batches = (PCollection)input.apply((PTransform)MapElements.into((TypeDescriptor)descriptor).via((SerializableFunction & Serializable)element -> ImmutableList.of((Object)element)));
            } else {
                PCollection schemaSeed = (PCollection)input.getPipeline().apply("Create Seed", (PTransform)Create.of((Object)null, (Object[])new Void[0]));
                if (this.spec.getSchemaReadySignal() != null) {
                    schemaSeed = (PCollection)schemaSeed.apply("Wait for schema", (PTransform)Wait.on((PCollection[])new PCollection[]{this.spec.getSchemaReadySignal()}));
                }
                PCollectionView schemaView = (PCollectionView)((PCollection)schemaSeed.apply("Read information schema", (PTransform)ParDo.of((DoFn)new ReadSpannerSchema(this.spec.getSpannerConfig())))).apply("Schema View", (PTransform)View.asSingleton());
                PCollectionTuple filteredMutations = (PCollectionTuple)((PCollection)input.apply("RewindowIntoGlobal", (PTransform)Window.into((WindowFn)new GlobalWindows()).triggering((Trigger)DefaultTrigger.of()).discardingFiredPanes())).apply("Filter Unbatchable Mutations", (PTransform)ParDo.of((DoFn)new BatchableMutationFilterFn((PCollectionView<SpannerSchema>)schemaView, UNBATCHABLE_MUTATIONS_TAG, this.spec.getBatchSizeBytes(), this.spec.getMaxNumMutations(), this.spec.getMaxNumRows())).withSideInputs(new PCollectionView[]{schemaView}).withOutputTags(BATCHABLE_MUTATIONS_TAG, TupleTagList.of(UNBATCHABLE_MUTATIONS_TAG)));
                PCollection batchedMutations = (PCollection)filteredMutations.get(BATCHABLE_MUTATIONS_TAG).apply("Gather Sort And Create Batches", (PTransform)ParDo.of((DoFn)new GatherSortCreateBatchesFn(this.spec.getBatchSizeBytes(), this.spec.getMaxNumMutations(), this.spec.getMaxNumRows(), this.spec.getGroupingFactor().orElse(input.isBounded() == PCollection.IsBounded.BOUNDED ? 1000 : 1), (PCollectionView<SpannerSchema>)schemaView)).withSideInputs(new PCollectionView[]{schemaView}));
                batches = (PCollection)PCollectionList.of((PCollection)filteredMutations.get(UNBATCHABLE_MUTATIONS_TAG)).and(batchedMutations).apply("Merge", (PTransform)Flatten.pCollections());
            }
            PCollectionTuple result = (PCollectionTuple)batches.apply("Write batches to Spanner", (PTransform)ParDo.of((DoFn)new WriteToSpannerFn(this.spec.getSpannerConfig(), this.spec.getFailureMode(), FAILED_MUTATIONS_TAG)).withOutputTags(MAIN_OUT_TAG, TupleTagList.of(FAILED_MUTATIONS_TAG)));
            return new SpannerWriteResult(input.getPipeline(), (PCollection<Void>)result.get(MAIN_OUT_TAG), (PCollection<MutationGroup>)result.get(FAILED_MUTATIONS_TAG), FAILED_MUTATIONS_TAG);
        }

        @VisibleForTesting
        static @UnknownKeyFor @NonNull @Initialized MutationGroup decode(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] bytes) {
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            try {
                return (MutationGroup)CODER.decode((InputStream)bis);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @VisibleForTesting
        static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] encode(@UnknownKeyFor @NonNull @Initialized MutationGroup g) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                CODER.encode((Serializable)g, (OutputStream)bos);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return bos.toByteArray();
        }
    }

    @AutoValue
    public static abstract class Write
    extends PTransform<PCollection<Mutation>, SpannerWriteResult> {
        abstract @UnknownKeyFor @NonNull @Initialized SpannerConfig getSpannerConfig();

        abstract @UnknownKeyFor @NonNull @Initialized long getBatchSizeBytes();

        abstract @UnknownKeyFor @NonNull @Initialized long getMaxNumMutations();

        abstract @UnknownKeyFor @NonNull @Initialized long getMaxNumRows();

        abstract @UnknownKeyFor @NonNull @Initialized FailureMode getFailureMode();

        abstract /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getSchemaReadySignal();

        abstract @UnknownKeyFor @NonNull @Initialized OptionalInt getGroupingFactor();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        public @UnknownKeyFor @NonNull @Initialized Write withSpannerConfig(@UnknownKeyFor @NonNull @Initialized SpannerConfig spannerConfig) {
            return this.toBuilder().setSpannerConfig(spannerConfig).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withProjectId(@UnknownKeyFor @NonNull @Initialized String projectId) {
            return this.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId));
        }

        public @UnknownKeyFor @NonNull @Initialized Write withProjectId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> projectId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withProjectId(projectId));
        }

        public @UnknownKeyFor @NonNull @Initialized Write withInstanceId(@UnknownKeyFor @NonNull @Initialized String instanceId) {
            return this.withInstanceId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)instanceId));
        }

        public @UnknownKeyFor @NonNull @Initialized Write withInstanceId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> instanceId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withInstanceId(instanceId));
        }

        public @UnknownKeyFor @NonNull @Initialized Write withDatabaseId(@UnknownKeyFor @NonNull @Initialized String databaseId) {
            return this.withDatabaseId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)databaseId));
        }

        public @UnknownKeyFor @NonNull @Initialized Write withDatabaseId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> databaseId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withDatabaseId(databaseId));
        }

        public @UnknownKeyFor @NonNull @Initialized Write withHost(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> host) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withHost(host));
        }

        public @UnknownKeyFor @NonNull @Initialized Write withHost(@UnknownKeyFor @NonNull @Initialized String host) {
            return this.withHost((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)host));
        }

        public @UnknownKeyFor @NonNull @Initialized Write withCommitDeadline(@UnknownKeyFor @NonNull @Initialized Duration commitDeadline) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withCommitDeadline(commitDeadline));
        }

        public @UnknownKeyFor @NonNull @Initialized Write withMaxCumulativeBackoff(@UnknownKeyFor @NonNull @Initialized Duration maxCumulativeBackoff) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withMaxCumulativeBackoff(maxCumulativeBackoff));
        }

        @VisibleForTesting
        @UnknownKeyFor @NonNull @Initialized Write withServiceFactory(@UnknownKeyFor @NonNull @Initialized ServiceFactory<@UnknownKeyFor @NonNull @Initialized Spanner, @UnknownKeyFor @NonNull @Initialized SpannerOptions> serviceFactory) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withServiceFactory(serviceFactory));
        }

        public @UnknownKeyFor @NonNull @Initialized WriteGrouped grouped() {
            return new WriteGrouped(this);
        }

        public @UnknownKeyFor @NonNull @Initialized Write withBatchSizeBytes(@UnknownKeyFor @NonNull @Initialized long batchSizeBytes) {
            return this.toBuilder().setBatchSizeBytes(batchSizeBytes).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withFailureMode(@UnknownKeyFor @NonNull @Initialized FailureMode failureMode) {
            return this.toBuilder().setFailureMode(failureMode).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withMaxNumMutations(@UnknownKeyFor @NonNull @Initialized long maxNumMutations) {
            return this.toBuilder().setMaxNumMutations(maxNumMutations).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withMaxNumRows(@UnknownKeyFor @NonNull @Initialized long maxNumRows) {
            return this.toBuilder().setMaxNumRows(maxNumRows).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withSchemaReadySignal(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> signal) {
            return this.toBuilder().setSchemaReadySignal(signal).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withGroupingFactor(@UnknownKeyFor @NonNull @Initialized int groupingFactor) {
            return this.toBuilder().setGroupingFactor(groupingFactor).build();
        }

        public @UnknownKeyFor @NonNull @Initialized SpannerWriteResult expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Mutation> input) {
            this.getSpannerConfig().validate();
            return (SpannerWriteResult)((PCollection)input.apply("To mutation group", (PTransform)ParDo.of((DoFn)new ToMutationGroupFn()))).apply("Write mutations to Cloud Spanner", (PTransform)new WriteGrouped(this));
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            this.populateDisplayDataWithParamaters(builder);
        }

        private void populateDisplayDataWithParamaters(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            this.getSpannerConfig().populateDisplayData(builder);
            builder.add(DisplayData.item((String)"batchSizeBytes", (Long)this.getBatchSizeBytes()).withLabel("Max batch size in bytes"));
            builder.add(DisplayData.item((String)"maxNumMutations", (Long)this.getMaxNumMutations()).withLabel("Max number of mutated cells in each batch"));
            builder.add(DisplayData.item((String)"maxNumRows", (Long)this.getMaxNumRows()).withLabel("Max number of rows in each batch"));
            builder.add(DisplayData.item((String)"groupingFactor", (String)(this.getGroupingFactor().isPresent() ? Integer.toString(this.getGroupingFactor().getAsInt()) : "DEFAULT")).withLabel("Number of batches to sort over"));
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setSpannerConfig(@UnknownKeyFor @NonNull @Initialized SpannerConfig var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setBatchSizeBytes(@UnknownKeyFor @NonNull @Initialized long var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxNumMutations(@UnknownKeyFor @NonNull @Initialized long var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxNumRows(@UnknownKeyFor @NonNull @Initialized long var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setFailureMode(@UnknownKeyFor @NonNull @Initialized FailureMode var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setSchemaReadySignal(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setGroupingFactor(@UnknownKeyFor @NonNull @Initialized int var1);

            abstract @UnknownKeyFor @NonNull @Initialized Write build();
        }
    }

    public static enum FailureMode {
        FAIL_FAST,
        REPORT_FAILURES;

    }

    @AutoValue
    public static abstract class CreateTransaction
    extends PTransform<PBegin, PCollectionView<Transaction>> {
        abstract @UnknownKeyFor @NonNull @Initialized SpannerConfig getSpannerConfig();

        abstract @Nullable @UnknownKeyFor @Initialized TimestampBound getTimestampBound();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        public @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Transaction> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            this.getSpannerConfig().validate();
            return (PCollectionView)((PCollection)((PCollection)input.apply((PTransform)Create.of((Object)1, (Object[])new Integer[0]))).apply("Create transaction", (PTransform)ParDo.of((DoFn)new CreateTransactionFn(this)))).apply("As PCollectionView", (PTransform)View.asSingleton());
        }

        public @UnknownKeyFor @NonNull @Initialized CreateTransaction withSpannerConfig(@UnknownKeyFor @NonNull @Initialized SpannerConfig spannerConfig) {
            return this.toBuilder().setSpannerConfig(spannerConfig).build();
        }

        public @UnknownKeyFor @NonNull @Initialized CreateTransaction withProjectId(@UnknownKeyFor @NonNull @Initialized String projectId) {
            return this.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId));
        }

        public @UnknownKeyFor @NonNull @Initialized CreateTransaction withProjectId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> projectId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withProjectId(projectId));
        }

        public @UnknownKeyFor @NonNull @Initialized CreateTransaction withInstanceId(@UnknownKeyFor @NonNull @Initialized String instanceId) {
            return this.withInstanceId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)instanceId));
        }

        public @UnknownKeyFor @NonNull @Initialized CreateTransaction withInstanceId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> instanceId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withInstanceId(instanceId));
        }

        public @UnknownKeyFor @NonNull @Initialized CreateTransaction withDatabaseId(@UnknownKeyFor @NonNull @Initialized String databaseId) {
            return this.withDatabaseId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)databaseId));
        }

        public @UnknownKeyFor @NonNull @Initialized CreateTransaction withDatabaseId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> databaseId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withDatabaseId(databaseId));
        }

        public @UnknownKeyFor @NonNull @Initialized CreateTransaction withHost(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> host) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withHost(host));
        }

        public @UnknownKeyFor @NonNull @Initialized CreateTransaction withHost(@UnknownKeyFor @NonNull @Initialized String host) {
            return this.withHost((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)host));
        }

        @VisibleForTesting
        @UnknownKeyFor @NonNull @Initialized CreateTransaction withServiceFactory(@UnknownKeyFor @NonNull @Initialized ServiceFactory<@UnknownKeyFor @NonNull @Initialized Spanner, @UnknownKeyFor @NonNull @Initialized SpannerOptions> serviceFactory) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withServiceFactory(serviceFactory));
        }

        public @UnknownKeyFor @NonNull @Initialized CreateTransaction withTimestampBound(@UnknownKeyFor @NonNull @Initialized TimestampBound timestampBound) {
            return this.toBuilder().setTimestampBound(timestampBound).build();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setSpannerConfig(@UnknownKeyFor @NonNull @Initialized SpannerConfig var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setTimestampBound(@UnknownKeyFor @NonNull @Initialized TimestampBound var1);

            public abstract @UnknownKeyFor @NonNull @Initialized CreateTransaction build();
        }
    }

    @AutoValue
    public static abstract class Read
    extends PTransform<PBegin, PCollection<Struct>> {
        abstract @UnknownKeyFor @NonNull @Initialized SpannerConfig getSpannerConfig();

        abstract @UnknownKeyFor @NonNull @Initialized ReadOperation getReadOperation();

        abstract @Nullable @UnknownKeyFor @Initialized TimestampBound getTimestampBound();

        abstract @Nullable @UnknownKeyFor @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Transaction> getTransaction();

        abstract @Nullable @UnknownKeyFor @Initialized PartitionOptions getPartitionOptions();

        abstract @UnknownKeyFor @NonNull @Initialized Boolean getBatching();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        public @UnknownKeyFor @NonNull @Initialized Read withSpannerConfig(@UnknownKeyFor @NonNull @Initialized SpannerConfig spannerConfig) {
            return this.toBuilder().setSpannerConfig(spannerConfig).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withProjectId(@UnknownKeyFor @NonNull @Initialized String projectId) {
            return this.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withProjectId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> projectId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withProjectId(projectId));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withInstanceId(@UnknownKeyFor @NonNull @Initialized String instanceId) {
            return this.withInstanceId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)instanceId));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withInstanceId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> instanceId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withInstanceId(instanceId));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withDatabaseId(@UnknownKeyFor @NonNull @Initialized String databaseId) {
            return this.withDatabaseId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)databaseId));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withDatabaseId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> databaseId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withDatabaseId(databaseId));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withHost(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> host) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withHost(host));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withHost(@UnknownKeyFor @NonNull @Initialized String host) {
            return this.withHost((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)host));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withBatching(@UnknownKeyFor @NonNull @Initialized boolean batching) {
            return this.toBuilder().setBatching(batching).build();
        }

        @VisibleForTesting
        @UnknownKeyFor @NonNull @Initialized Read withServiceFactory(@UnknownKeyFor @NonNull @Initialized ServiceFactory<@UnknownKeyFor @NonNull @Initialized Spanner, @UnknownKeyFor @NonNull @Initialized SpannerOptions> serviceFactory) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withServiceFactory(serviceFactory));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withTransaction(@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Transaction> transaction) {
            return this.toBuilder().setTransaction(transaction).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withTimestamp(@UnknownKeyFor @NonNull @Initialized Timestamp timestamp) {
            return this.withTimestampBound(TimestampBound.ofReadTimestamp((Timestamp)timestamp));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withTimestampBound(@UnknownKeyFor @NonNull @Initialized TimestampBound timestampBound) {
            return this.toBuilder().setTimestampBound(timestampBound).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withTable(@UnknownKeyFor @NonNull @Initialized String table) {
            return this.withReadOperation(this.getReadOperation().withTable(table));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withReadOperation(@UnknownKeyFor @NonNull @Initialized ReadOperation operation) {
            return this.toBuilder().setReadOperation(operation).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withColumns(String ... columns) {
            return this.withColumns(Arrays.asList(columns));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withColumns(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> columns) {
            return this.withReadOperation(this.getReadOperation().withColumns(columns));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withQuery(@UnknownKeyFor @NonNull @Initialized Statement statement) {
            return this.withReadOperation(this.getReadOperation().withQuery(statement));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withQuery(@UnknownKeyFor @NonNull @Initialized String sql) {
            return this.withQuery(Statement.of((String)sql));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withKeySet(@UnknownKeyFor @NonNull @Initialized KeySet keySet) {
            return this.withReadOperation(this.getReadOperation().withKeySet(keySet));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withIndex(@UnknownKeyFor @NonNull @Initialized String index) {
            return this.withReadOperation(this.getReadOperation().withIndex(index));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withPartitionOptions(@UnknownKeyFor @NonNull @Initialized PartitionOptions partitionOptions) {
            return this.withReadOperation(this.getReadOperation().withPartitionOptions(partitionOptions));
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Struct> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            this.getSpannerConfig().validate();
            Preconditions.checkArgument((this.getTimestampBound() != null ? 1 : 0) != 0, (Object)"SpannerIO.read() runs in a read only transaction and requires timestamp to be set with withTimestampBound or withTimestamp method");
            if (this.getReadOperation().getQuery() == null) {
                if (this.getReadOperation().getTable() != null) {
                    Preconditions.checkNotNull(this.getReadOperation().getColumns(), (Object)"For a read operation SpannerIO.read() requires a list of columns to set with withColumns method");
                    Preconditions.checkArgument((!this.getReadOperation().getColumns().isEmpty() ? 1 : 0) != 0, (Object)"For a read operation SpannerIO.read() requires a list of columns to set with withColumns method");
                } else {
                    throw new IllegalArgumentException("SpannerIO.read() requires configuring query or read operation.");
                }
            }
            ReadAll readAll = SpannerIO.readAll().withSpannerConfig(this.getSpannerConfig()).withTimestampBound(this.getTimestampBound()).withBatching(this.getBatching()).withTransaction(this.getTransaction());
            return (PCollection)((PCollection)input.apply((PTransform)Create.of((Object)this.getReadOperation(), (Object[])new ReadOperation[0]))).apply("Execute query", (PTransform)readAll);
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setSpannerConfig(@UnknownKeyFor @NonNull @Initialized SpannerConfig var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setReadOperation(@UnknownKeyFor @NonNull @Initialized ReadOperation var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setTimestampBound(@UnknownKeyFor @NonNull @Initialized TimestampBound var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setTransaction(@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Transaction> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setPartitionOptions(@UnknownKeyFor @NonNull @Initialized PartitionOptions var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setBatching(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Read build();
        }
    }

    @AutoValue
    public static abstract class ReadAll
    extends PTransform<PCollection<ReadOperation>, PCollection<Struct>> {
        abstract @UnknownKeyFor @NonNull @Initialized SpannerConfig getSpannerConfig();

        abstract @Nullable @UnknownKeyFor @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Transaction> getTransaction();

        abstract @Nullable @UnknownKeyFor @Initialized TimestampBound getTimestampBound();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        public @UnknownKeyFor @NonNull @Initialized ReadAll withSpannerConfig(@UnknownKeyFor @NonNull @Initialized SpannerConfig spannerConfig) {
            return this.toBuilder().setSpannerConfig(spannerConfig).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadAll withProjectId(@UnknownKeyFor @NonNull @Initialized String projectId) {
            return this.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId));
        }

        public @UnknownKeyFor @NonNull @Initialized ReadAll withProjectId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> projectId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withProjectId(projectId));
        }

        public @UnknownKeyFor @NonNull @Initialized ReadAll withInstanceId(@UnknownKeyFor @NonNull @Initialized String instanceId) {
            return this.withInstanceId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)instanceId));
        }

        public @UnknownKeyFor @NonNull @Initialized ReadAll withInstanceId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> instanceId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withInstanceId(instanceId));
        }

        public @UnknownKeyFor @NonNull @Initialized ReadAll withDatabaseId(@UnknownKeyFor @NonNull @Initialized String databaseId) {
            return this.withDatabaseId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)databaseId));
        }

        public @UnknownKeyFor @NonNull @Initialized ReadAll withHost(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> host) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withHost(host));
        }

        public @UnknownKeyFor @NonNull @Initialized ReadAll withHost(@UnknownKeyFor @NonNull @Initialized String host) {
            return this.withHost((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)host));
        }

        public @UnknownKeyFor @NonNull @Initialized ReadAll withDatabaseId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> databaseId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withDatabaseId(databaseId));
        }

        @VisibleForTesting
        @UnknownKeyFor @NonNull @Initialized ReadAll withServiceFactory(@UnknownKeyFor @NonNull @Initialized ServiceFactory<@UnknownKeyFor @NonNull @Initialized Spanner, @UnknownKeyFor @NonNull @Initialized SpannerOptions> serviceFactory) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withServiceFactory(serviceFactory));
        }

        public @UnknownKeyFor @NonNull @Initialized ReadAll withTransaction(@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Transaction> transaction) {
            return this.toBuilder().setTransaction(transaction).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadAll withTimestamp(@UnknownKeyFor @NonNull @Initialized Timestamp timestamp) {
            return this.withTimestampBound(TimestampBound.ofReadTimestamp((Timestamp)timestamp));
        }

        public @UnknownKeyFor @NonNull @Initialized ReadAll withTimestampBound(@UnknownKeyFor @NonNull @Initialized TimestampBound timestampBound) {
            return this.toBuilder().setTimestampBound(timestampBound).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadAll withBatching(@UnknownKeyFor @NonNull @Initialized boolean batching) {
            return this.toBuilder().setBatching(batching).build();
        }

        abstract @UnknownKeyFor @NonNull @Initialized Boolean getBatching();

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Struct> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ReadOperation> input) {
            PTransform readTransform = this.getBatching() != false ? BatchSpannerRead.create(this.getSpannerConfig(), this.getTransaction(), this.getTimestampBound()) : NaiveSpannerRead.create(this.getSpannerConfig(), this.getTransaction(), this.getTimestampBound());
            return (PCollection)((PCollection)input.apply("Reshuffle", (PTransform)Reshuffle.viaRandomKey())).apply("Read from Cloud Spanner", readTransform);
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setSpannerConfig(@UnknownKeyFor @NonNull @Initialized SpannerConfig var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setTransaction(@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Transaction> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setTimestampBound(@UnknownKeyFor @NonNull @Initialized TimestampBound var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setBatching(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized ReadAll build();
        }
    }
}

