/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.Value;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.beam.sdk.io.gcp.spanner.MutationUtils;
import org.apache.beam.sdk.io.gcp.spanner.OrderedCode;
import org.apache.beam.sdk.io.gcp.spanner.SpannerSchema;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MutationKeyEncoder {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(MutationKeyEncoder.class);
    private static final @UnknownKeyFor @NonNull @Initialized int ROWS_PER_UNKNOWN_TABLE_LOG_MESSAGE = 10000;
    private static final @UnknownKeyFor @NonNull @Initialized DateTime MIN_DATE = new DateTime(1, 1, 1, 0, 0);
    private final @UnknownKeyFor @NonNull @Initialized SpannerSchema schema;
    @VisibleForTesting
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized AtomicInteger> unknownTablesWarnings = new ConcurrentHashMap<String, AtomicInteger>();

    public MutationKeyEncoder(@UnknownKeyFor @NonNull @Initialized SpannerSchema schema) {
        this.schema = schema;
    }

    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] encodeTableNameAndKey(@UnknownKeyFor @NonNull @Initialized Mutation m) {
        OrderedCode orderedCode = new OrderedCode();
        String tableName = m.getTable().toLowerCase();
        if (this.schema.getColumns(tableName).isEmpty()) {
            int numWarnings;
            if (!unknownTablesWarnings.containsKey(tableName)) {
                unknownTablesWarnings.putIfAbsent(tableName, new AtomicInteger(0));
            }
            if (1 == (numWarnings = unknownTablesWarnings.get(tableName).incrementAndGet()) % 10000) {
                System.err.printf("Performance issue: Mutation references an unknown table: %s. See SpannerIO documentation section 'Database Schema Preparation' (At least %,d occurrences)\n", tableName, numWarnings);
            }
        }
        orderedCode.writeBytes(tableName.getBytes(StandardCharsets.UTF_8));
        if (m.getOperation() == Mutation.Op.DELETE) {
            if (MutationUtils.isPointDelete(m)) {
                Key key = (Key)m.getKeySet().getKeys().iterator().next();
                this.encodeKey(orderedCode, tableName, key);
            }
        } else {
            this.encodeKey(orderedCode, m);
        }
        return orderedCode.getEncodedBytes();
    }

    private void encodeKey(@UnknownKeyFor @NonNull @Initialized OrderedCode orderedCode, @UnknownKeyFor @NonNull @Initialized Mutation m) {
        Map<String, Value> mutationMap = MutationKeyEncoder.mutationAsMap(m);
        block9: for (SpannerSchema.KeyPart part : this.schema.getKeyParts(m.getTable())) {
            Value val = mutationMap.get(part.getField());
            if (val == null || val.isNull()) {
                if (part.isDesc()) {
                    orderedCode.writeInfinityDecreasing();
                    continue;
                }
                orderedCode.writeInfinity();
                continue;
            }
            Type.Code code = val.getType().getCode();
            switch (code) {
                case BOOL: {
                    this.writeNumber(orderedCode, part, val.getBool() ? 0 : 1);
                    continue block9;
                }
                case INT64: {
                    this.writeNumber(orderedCode, part, val.getInt64());
                    continue block9;
                }
                case FLOAT64: {
                    this.writeNumber(orderedCode, part, Double.doubleToLongBits(val.getFloat64()));
                    continue block9;
                }
                case STRING: {
                    this.writeString(orderedCode, part, val.getString());
                    continue block9;
                }
                case BYTES: {
                    this.writeBytes(orderedCode, part, val.getBytes());
                    continue block9;
                }
                case TIMESTAMP: {
                    this.writeTimestamp(orderedCode, part, val.getTimestamp());
                    continue block9;
                }
                case DATE: {
                    this.writeNumber(orderedCode, part, MutationKeyEncoder.encodeDate(val.getDate()));
                    continue block9;
                }
            }
            throw new IllegalArgumentException("Unknown type " + val.getType());
        }
    }

    private void encodeKey(@UnknownKeyFor @NonNull @Initialized OrderedCode orderedCode, @UnknownKeyFor @NonNull @Initialized String tableName, @UnknownKeyFor @NonNull @Initialized Key key) {
        List<SpannerSchema.KeyPart> parts = this.schema.getKeyParts(tableName);
        Iterator it = key.getParts().iterator();
        for (SpannerSchema.KeyPart part : parts) {
            Object value = it.next();
            if (value == null) {
                if (part.isDesc()) {
                    orderedCode.writeInfinityDecreasing();
                    continue;
                }
                orderedCode.writeInfinity();
                continue;
            }
            if (value instanceof Boolean) {
                this.writeNumber(orderedCode, part, (Boolean)value != false ? 0 : 1);
                continue;
            }
            if (value instanceof Long) {
                this.writeNumber(orderedCode, part, (Long)value);
                continue;
            }
            if (value instanceof Double) {
                this.writeNumber(orderedCode, part, Double.doubleToLongBits((Double)value));
                continue;
            }
            if (value instanceof String) {
                this.writeString(orderedCode, part, (String)value);
                continue;
            }
            if (value instanceof ByteArray) {
                this.writeBytes(orderedCode, part, (ByteArray)value);
                continue;
            }
            if (value instanceof Timestamp) {
                this.writeTimestamp(orderedCode, part, (Timestamp)value);
                continue;
            }
            if (value instanceof Date) {
                this.writeNumber(orderedCode, part, MutationKeyEncoder.encodeDate((Date)value));
                continue;
            }
            throw new IllegalArgumentException("Unknown key part " + value);
        }
    }

    private void writeBytes(@UnknownKeyFor @NonNull @Initialized OrderedCode orderedCode, @UnknownKeyFor @NonNull @Initialized SpannerSchema.KeyPart part, @UnknownKeyFor @NonNull @Initialized ByteArray bytes) {
        if (part.isDesc()) {
            orderedCode.writeBytesDecreasing(bytes.toByteArray());
        } else {
            orderedCode.writeBytes(bytes.toByteArray());
        }
    }

    private void writeNumber(@UnknownKeyFor @NonNull @Initialized OrderedCode orderedCode, @UnknownKeyFor @NonNull @Initialized SpannerSchema.KeyPart part, @UnknownKeyFor @NonNull @Initialized long v) {
        if (part.isDesc()) {
            orderedCode.writeSignedNumDecreasing(v);
        } else {
            orderedCode.writeSignedNumIncreasing(v);
        }
    }

    private void writeString(@UnknownKeyFor @NonNull @Initialized OrderedCode orderedCode, @UnknownKeyFor @NonNull @Initialized SpannerSchema.KeyPart part, @UnknownKeyFor @NonNull @Initialized String v) {
        if (part.isDesc()) {
            orderedCode.writeBytesDecreasing(v.getBytes(StandardCharsets.UTF_8));
        } else {
            orderedCode.writeBytes(v.getBytes(StandardCharsets.UTF_8));
        }
    }

    private void writeTimestamp(@UnknownKeyFor @NonNull @Initialized OrderedCode orderedCode, @UnknownKeyFor @NonNull @Initialized SpannerSchema.KeyPart part, @UnknownKeyFor @NonNull @Initialized Timestamp v) {
        if (part.isDesc()) {
            orderedCode.writeNumDecreasing(v.getSeconds());
            orderedCode.writeNumDecreasing(v.getNanos());
        } else {
            orderedCode.writeNumIncreasing(v.getSeconds());
            orderedCode.writeNumIncreasing(v.getNanos());
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Value> mutationAsMap(@UnknownKeyFor @NonNull @Initialized Mutation m) {
        HashMap<String, Value> result = new HashMap<String, Value>();
        Iterator coli = m.getColumns().iterator();
        Iterator vali = m.getValues().iterator();
        while (coli.hasNext()) {
            String column = (String)coli.next();
            Value val = (Value)vali.next();
            result.put(column.toLowerCase(), val);
        }
        return result;
    }

    private static @UnknownKeyFor @NonNull @Initialized int encodeDate(@UnknownKeyFor @NonNull @Initialized Date date) {
        MutableDateTime jodaDate = new MutableDateTime();
        jodaDate.setDate(date.getYear(), date.getMonth(), date.getDayOfMonth());
        return Days.daysBetween((ReadableInstant)MIN_DATE, (ReadableInstant)jodaDate).getDays();
    }

    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized AtomicInteger> getUnknownTablesWarningsMap() {
        return unknownTablesWarnings;
    }
}

