/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import com.google.auth.Credentials;
import com.google.protobuf.Timestamp;
import com.google.pubsub.v1.AcknowledgeRequest;
import com.google.pubsub.v1.DeleteSubscriptionRequest;
import com.google.pubsub.v1.DeleteTopicRequest;
import com.google.pubsub.v1.GetSubscriptionRequest;
import com.google.pubsub.v1.ListSubscriptionsRequest;
import com.google.pubsub.v1.ListSubscriptionsResponse;
import com.google.pubsub.v1.ListTopicsRequest;
import com.google.pubsub.v1.ListTopicsResponse;
import com.google.pubsub.v1.ModifyAckDeadlineRequest;
import com.google.pubsub.v1.PublishRequest;
import com.google.pubsub.v1.PublishResponse;
import com.google.pubsub.v1.PublisherGrpc;
import com.google.pubsub.v1.PubsubMessage;
import com.google.pubsub.v1.PullRequest;
import com.google.pubsub.v1.PullResponse;
import com.google.pubsub.v1.ReceivedMessage;
import com.google.pubsub.v1.SubscriberGrpc;
import com.google.pubsub.v1.Subscription;
import com.google.pubsub.v1.Topic;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.ManagedChannel;
import io.grpc.auth.ClientAuthInterceptor;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubClient;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubOptions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class PubsubGrpcClient
extends PubsubClient {
    private static final @UnknownKeyFor @NonNull @Initialized int LIST_BATCH_SIZE = 1000;
    private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_TIMEOUT_S = 60;
    public static final @UnknownKeyFor @NonNull @Initialized PubsubClient.PubsubClientFactory FACTORY = new PubsubGrpcClientFactory();
    private final @UnknownKeyFor @NonNull @Initialized int timeoutSec;
    private @Nullable @UnknownKeyFor @Initialized ManagedChannel publisherChannel;
    private final @UnknownKeyFor @NonNull @Initialized Credentials credentials;
    private final @Nullable @UnknownKeyFor @Initialized String timestampAttribute;
    private final @Nullable @UnknownKeyFor @Initialized String idAttribute;
    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable @UnknownKeyFor @Initialized PublisherGrpc.PublisherBlockingStub cachedPublisherStub;
    private // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized SubscriberGrpc.SubscriberBlockingStub cachedSubscriberStub;

    private static @UnknownKeyFor @NonNull @Initialized ManagedChannel channelForRootUrl(@UnknownKeyFor @NonNull @Initialized String urlString) throws @UnknownKeyFor @NonNull @Initialized IOException {
        URL url;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(String.format("Could not parse pubsub root url \"%s\"", urlString), e);
        }
        int port = url.getPort();
        if (port < 0) {
            switch (url.getProtocol()) {
                case "https": {
                    port = 443;
                    break;
                }
                case "http": {
                    port = 80;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Could not determine port for pubsub root url \"%s\". You must either specify the port or use the protocol \"https\" or \"http\"", urlString));
                }
            }
        }
        return NettyChannelBuilder.forAddress((String)url.getHost(), (int)port).negotiationType(NegotiationType.TLS).sslContext(GrpcSslContexts.forClient().ciphers(null).build()).build();
    }

    @VisibleForTesting
    PubsubGrpcClient(@Nullable @UnknownKeyFor @Initialized String timestampAttribute, @Nullable @UnknownKeyFor @Initialized String idAttribute, @UnknownKeyFor @NonNull @Initialized int timeoutSec, @UnknownKeyFor @NonNull @Initialized ManagedChannel publisherChannel, @UnknownKeyFor @NonNull @Initialized Credentials credentials) {
        this.timestampAttribute = timestampAttribute;
        this.idAttribute = idAttribute;
        this.timeoutSec = timeoutSec;
        this.publisherChannel = publisherChannel;
        this.credentials = credentials;
    }

    @Override
    public void close() {
        if (this.publisherChannel == null) {
            return;
        }
        this.cachedPublisherStub = null;
        this.cachedSubscriberStub = null;
        ManagedChannel publisherChannel = this.publisherChannel;
        this.publisherChannel = null;
        publisherChannel.shutdown();
        try {
            publisherChannel.awaitTermination((long)this.timeoutSec, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private @UnknownKeyFor @NonNull @Initialized Channel newChannel() throws @UnknownKeyFor @NonNull @Initialized IOException {
        Preconditions.checkState((this.publisherChannel != null ? 1 : 0) != 0, (Object)"PubsubGrpcClient has been closed");
        ClientAuthInterceptor interceptor = new ClientAuthInterceptor(this.credentials, (Executor)Executors.newSingleThreadExecutor());
        return ClientInterceptors.intercept((Channel)this.publisherChannel, (ClientInterceptor[])new ClientInterceptor[]{interceptor});
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PublisherGrpc.PublisherBlockingStub publisherStub() throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.cachedPublisherStub == null) {
            this.cachedPublisherStub = PublisherGrpc.newBlockingStub((Channel)this.newChannel());
        }
        return (PublisherGrpc.PublisherBlockingStub)this.cachedPublisherStub.withDeadlineAfter((long)this.timeoutSec, TimeUnit.SECONDS);
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized SubscriberGrpc.SubscriberBlockingStub subscriberStub() throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.cachedSubscriberStub == null) {
            this.cachedSubscriberStub = SubscriberGrpc.newBlockingStub((Channel)this.newChannel());
        }
        return (SubscriberGrpc.SubscriberBlockingStub)this.cachedSubscriberStub.withDeadlineAfter((long)this.timeoutSec, TimeUnit.SECONDS);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int publish(@UnknownKeyFor @NonNull @Initialized PubsubClient.TopicPath topic, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PubsubClient.OutgoingMessage> outgoingMessages) throws @UnknownKeyFor @NonNull @Initialized IOException {
        PublishRequest.Builder request = PublishRequest.newBuilder().setTopic(topic.getPath());
        for (PubsubClient.OutgoingMessage outgoingMessage : outgoingMessages) {
            PubsubMessage.Builder message = outgoingMessage.message().toBuilder();
            if (this.timestampAttribute != null) {
                message.putAttributes(this.timestampAttribute, String.valueOf(outgoingMessage.timestampMsSinceEpoch()));
            }
            if (this.idAttribute != null && !Strings.isNullOrEmpty((String)outgoingMessage.recordId())) {
                message.putAttributes(this.idAttribute, outgoingMessage.recordId());
            }
            request.addMessages(message);
        }
        PublishResponse response = this.publisherStub().publish(request.build());
        return response.getMessageIdsCount();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PubsubClient.IncomingMessage> pull(@UnknownKeyFor @NonNull @Initialized long requestTimeMsSinceEpoch, @UnknownKeyFor @NonNull @Initialized PubsubClient.SubscriptionPath subscription, @UnknownKeyFor @NonNull @Initialized int batchSize, @UnknownKeyFor @NonNull @Initialized boolean returnImmediately) throws @UnknownKeyFor @NonNull @Initialized IOException {
        PullRequest request = PullRequest.newBuilder().setSubscription(subscription.getPath()).setReturnImmediately(returnImmediately).setMaxMessages(batchSize).build();
        PullResponse response = this.subscriberStub().pull(request);
        if (response.getReceivedMessagesCount() == 0) {
            return ImmutableList.of();
        }
        ArrayList<PubsubClient.IncomingMessage> incomingMessages = new ArrayList<PubsubClient.IncomingMessage>(response.getReceivedMessagesCount());
        for (ReceivedMessage message : response.getReceivedMessagesList()) {
            PubsubMessage pubsubMessage = message.getMessage();
            @Nullable Map attributes = pubsubMessage.getAttributes();
            String pubsubTimestampString = null;
            Timestamp timestampProto = pubsubMessage.getPublishTime();
            if (timestampProto != null) {
                pubsubTimestampString = String.valueOf(timestampProto.getSeconds() + (long)timestampProto.getNanos() / 1000L);
            }
            long timestampMsSinceEpoch = PubsubGrpcClient.extractTimestamp(this.timestampAttribute, pubsubTimestampString, attributes);
            String ackId = message.getAckId();
            Preconditions.checkState((!Strings.isNullOrEmpty((String)ackId) ? 1 : 0) != 0);
            String recordId = null;
            if (this.idAttribute != null && attributes != null) {
                recordId = (String)attributes.get(this.idAttribute);
            }
            if (Strings.isNullOrEmpty(recordId)) {
                recordId = pubsubMessage.getMessageId();
            }
            incomingMessages.add(PubsubClient.IncomingMessage.of(pubsubMessage, timestampMsSinceEpoch, requestTimeMsSinceEpoch, ackId, recordId));
        }
        return incomingMessages;
    }

    @Override
    public void acknowledge(@UnknownKeyFor @NonNull @Initialized PubsubClient.SubscriptionPath subscription, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> ackIds) throws @UnknownKeyFor @NonNull @Initialized IOException {
        AcknowledgeRequest request = AcknowledgeRequest.newBuilder().setSubscription(subscription.getPath()).addAllAckIds(ackIds).build();
        this.subscriberStub().acknowledge(request);
    }

    @Override
    public void modifyAckDeadline(@UnknownKeyFor @NonNull @Initialized PubsubClient.SubscriptionPath subscription, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> ackIds, @UnknownKeyFor @NonNull @Initialized int deadlineSeconds) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ModifyAckDeadlineRequest request = ModifyAckDeadlineRequest.newBuilder().setSubscription(subscription.getPath()).addAllAckIds(ackIds).setAckDeadlineSeconds(deadlineSeconds).build();
        this.subscriberStub().modifyAckDeadline(request);
    }

    @Override
    public void createTopic(@UnknownKeyFor @NonNull @Initialized PubsubClient.TopicPath topic) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Topic request = Topic.newBuilder().setName(topic.getPath()).build();
        this.publisherStub().createTopic(request);
    }

    @Override
    public void deleteTopic(@UnknownKeyFor @NonNull @Initialized PubsubClient.TopicPath topic) throws @UnknownKeyFor @NonNull @Initialized IOException {
        DeleteTopicRequest request = DeleteTopicRequest.newBuilder().setTopic(topic.getPath()).build();
        this.publisherStub().deleteTopic(request);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PubsubClient.TopicPath> listTopics(@UnknownKeyFor @NonNull @Initialized PubsubClient.ProjectPath project) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ListTopicsRequest.Builder request = ListTopicsRequest.newBuilder().setProject(project.getPath()).setPageSize(1000);
        ListTopicsResponse response = this.publisherStub().listTopics(request.build());
        if (response.getTopicsCount() == 0) {
            return ImmutableList.of();
        }
        ArrayList<PubsubClient.TopicPath> topics = new ArrayList<PubsubClient.TopicPath>(response.getTopicsCount());
        while (true) {
            for (Topic topic : response.getTopicsList()) {
                topics.add(PubsubGrpcClient.topicPathFromPath(topic.getName()));
            }
            if (response.getNextPageToken().isEmpty()) break;
            request.setPageToken(response.getNextPageToken());
            response = this.publisherStub().listTopics(request.build());
        }
        return topics;
    }

    @Override
    public void createSubscription(@UnknownKeyFor @NonNull @Initialized PubsubClient.TopicPath topic, @UnknownKeyFor @NonNull @Initialized PubsubClient.SubscriptionPath subscription, @UnknownKeyFor @NonNull @Initialized int ackDeadlineSeconds) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Subscription request = Subscription.newBuilder().setTopic(topic.getPath()).setName(subscription.getPath()).setAckDeadlineSeconds(ackDeadlineSeconds).build();
        this.subscriberStub().createSubscription(request);
    }

    @Override
    public void deleteSubscription(@UnknownKeyFor @NonNull @Initialized PubsubClient.SubscriptionPath subscription) throws @UnknownKeyFor @NonNull @Initialized IOException {
        DeleteSubscriptionRequest request = DeleteSubscriptionRequest.newBuilder().setSubscription(subscription.getPath()).build();
        this.subscriberStub().deleteSubscription(request);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PubsubClient.SubscriptionPath> listSubscriptions(@UnknownKeyFor @NonNull @Initialized PubsubClient.ProjectPath project, @UnknownKeyFor @NonNull @Initialized PubsubClient.TopicPath topic) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ListSubscriptionsRequest.Builder request = ListSubscriptionsRequest.newBuilder().setProject(project.getPath()).setPageSize(1000);
        ListSubscriptionsResponse response = this.subscriberStub().listSubscriptions(request.build());
        if (response.getSubscriptionsCount() == 0) {
            return ImmutableList.of();
        }
        ArrayList<PubsubClient.SubscriptionPath> subscriptions = new ArrayList<PubsubClient.SubscriptionPath>(response.getSubscriptionsCount());
        while (true) {
            for (Subscription subscription : response.getSubscriptionsList()) {
                if (!subscription.getTopic().equals(topic.getPath())) continue;
                subscriptions.add(PubsubGrpcClient.subscriptionPathFromPath(subscription.getName()));
            }
            if (response.getNextPageToken().isEmpty()) break;
            request.setPageToken(response.getNextPageToken());
            response = this.subscriberStub().listSubscriptions(request.build());
        }
        return subscriptions;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int ackDeadlineSeconds(@UnknownKeyFor @NonNull @Initialized PubsubClient.SubscriptionPath subscription) throws @UnknownKeyFor @NonNull @Initialized IOException {
        GetSubscriptionRequest request = GetSubscriptionRequest.newBuilder().setSubscription(subscription.getPath()).build();
        Subscription response = this.subscriberStub().getSubscription(request);
        return response.getAckDeadlineSeconds();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isEOF() {
        return false;
    }

    private static class PubsubGrpcClientFactory
    implements PubsubClient.PubsubClientFactory {
        private PubsubGrpcClientFactory() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PubsubClient newClient(@Nullable @UnknownKeyFor @Initialized String timestampAttribute, @Nullable @UnknownKeyFor @Initialized String idAttribute, @UnknownKeyFor @NonNull @Initialized PubsubOptions options) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return new PubsubGrpcClient(timestampAttribute, idAttribute, 60, PubsubGrpcClient.channelForRootUrl(options.getPubsubRootUrl()), options.getGcpCredential());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String getKind() {
            return "Grpc";
        }
    }
}

