/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.datastore;

import com.google.datastore.v1.Query;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.datastore.DatastoreIO;
import org.apache.beam.sdk.io.gcp.datastore.DatastoreV1;
import org.apache.beam.sdk.io.gcp.datastore.EntityToRow;
import org.apache.beam.sdk.io.gcp.datastore.RowToEntity;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.io.InvalidConfigurationException;
import org.apache.beam.sdk.schemas.io.InvalidLocationException;
import org.apache.beam.sdk.schemas.io.SchemaIO;
import org.apache.beam.sdk.schemas.io.SchemaIOProvider;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public class DataStoreV1SchemaIOProvider
implements SchemaIOProvider {
    public static final @UnknownKeyFor @NonNull @Initialized String KEY_FIELD_PROPERTY = "keyField";
    static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_KEY_FIELD = "__key__";
    private static final @UnknownKeyFor @NonNull @Initialized Pattern locationPattern = Pattern.compile("(?<projectId>.+)/(?<kind>.+)");

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "datastoreV1";
    }

    public @UnknownKeyFor @NonNull @Initialized Schema configurationSchema() {
        return Schema.builder().addNullableField(KEY_FIELD_PROPERTY, Schema.FieldType.STRING).build();
    }

    public @UnknownKeyFor @NonNull @Initialized DataStoreV1SchemaIO from(@UnknownKeyFor @NonNull @Initialized String location, @UnknownKeyFor @NonNull @Initialized Row configuration, @UnknownKeyFor @NonNull @Initialized Schema dataSchema) {
        return new DataStoreV1SchemaIO(location, configuration, dataSchema);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean requiresDataSchema() {
        return true;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PCollection.IsBounded isBounded() {
        return PCollection.IsBounded.BOUNDED;
    }

    public static class DataStoreV1SchemaIO
    implements SchemaIO,
    Serializable {
        protected final @UnknownKeyFor @NonNull @Initialized Schema dataSchema;
        protected final @UnknownKeyFor @NonNull @Initialized String location;
        protected final @UnknownKeyFor @NonNull @Initialized String kind;
        protected final @UnknownKeyFor @NonNull @Initialized String projectId;
        protected final @UnknownKeyFor @NonNull @Initialized String keyField;

        private DataStoreV1SchemaIO(@UnknownKeyFor @NonNull @Initialized String location, @UnknownKeyFor @NonNull @Initialized Row config, @UnknownKeyFor @NonNull @Initialized Schema dataSchema) {
            this.location = location;
            this.dataSchema = dataSchema;
            this.keyField = this.determineKeyField(config.getString(DataStoreV1SchemaIOProvider.KEY_FIELD_PROPERTY));
            Matcher matcher = locationPattern.matcher(this.location);
            this.validateLocation(location, matcher);
            this.kind = matcher.group("kind");
            this.projectId = matcher.group("projectId");
        }

        public @UnknownKeyFor @NonNull @Initialized Schema schema() {
            return this.dataSchema;
        }

        public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> buildReader() {
            return new PTransform<PBegin, PCollection<Row>>(){

                public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PBegin begin) {
                    Query.Builder q = Query.newBuilder();
                    q.addKindBuilder().setName(kind);
                    Query query = q.build();
                    DatastoreV1.Read readInstance = DatastoreIO.v1().read().withProjectId(projectId).withQuery(query);
                    return (PCollection)((PCollection)begin.apply("Read Datastore Entities", (PTransform)readInstance)).apply("Convert Datastore Entities to Rows", (PTransform)EntityToRow.create(dataSchema, keyField));
                }
            };
        }

        public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized POutput> buildWriter() {
            return new PTransform<PCollection<Row>, POutput>(){

                public @UnknownKeyFor @NonNull @Initialized POutput expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> input) {
                    return ((PCollection)input.apply("Convert Rows to Datastore Entities", (PTransform)RowToEntity.create(keyField, kind))).apply("Write Datastore Entities", (PTransform)DatastoreIO.v1().write().withProjectId(projectId));
                }
            };
        }

        public @UnknownKeyFor @NonNull @Initialized String getProjectId() {
            return this.projectId;
        }

        public @UnknownKeyFor @NonNull @Initialized String getKind() {
            return this.kind;
        }

        private @UnknownKeyFor @NonNull @Initialized String determineKeyField(@UnknownKeyFor @NonNull @Initialized String configKey) {
            if (configKey != null && configKey.isEmpty()) {
                throw new InvalidConfigurationException(String.format("'%s' property cannot be null.", DataStoreV1SchemaIOProvider.KEY_FIELD_PROPERTY));
            }
            if (configKey != null) {
                return configKey;
            }
            return DataStoreV1SchemaIOProvider.DEFAULT_KEY_FIELD;
        }

        private void validateLocation(@UnknownKeyFor @NonNull @Initialized String location, @UnknownKeyFor @NonNull @Initialized Matcher matcher) {
            if (location == null) {
                throw new InvalidLocationException("DataStoreV1 location must be set. ");
            }
            if (!matcher.matches()) {
                throw new InvalidLocationException("DataStoreV1 location must be in the following format: 'projectId/kind' but was:" + location);
            }
        }
    }
}

