/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.testing;

import com.google.api.client.util.Base64;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableRow;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowJsonCoder;
import org.apache.beam.sdk.io.gcp.testing.FakeDatasetService;
import org.apache.beam.sdk.util.Histogram;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;

@Internal
public class FakeBigQueryServices
implements BigQueryServices {
    private BigQueryServices.JobService jobService;
    private BigQueryServices.DatasetService datasetService;
    private BigQueryServices.StorageClient storageClient;

    public FakeBigQueryServices withJobService(BigQueryServices.JobService jobService) {
        this.jobService = jobService;
        return this;
    }

    public FakeBigQueryServices withDatasetService(FakeDatasetService datasetService) {
        this.datasetService = datasetService;
        return this;
    }

    public FakeBigQueryServices withStorageClient(BigQueryServices.StorageClient storageClient) {
        this.storageClient = storageClient;
        return this;
    }

    @Override
    public BigQueryServices.JobService getJobService(BigQueryOptions bqOptions) {
        return this.jobService;
    }

    @Override
    public BigQueryServices.DatasetService getDatasetService(BigQueryOptions bqOptions) {
        return this.datasetService;
    }

    @Override
    public BigQueryServices.DatasetService getDatasetService(BigQueryOptions bqOptions, Histogram requestLatencies) {
        return this.datasetService;
    }

    @Override
    public BigQueryServices.StorageClient getStorageClient(BigQueryOptions bqOptions) {
        return this.storageClient;
    }

    public static String encodeQueryResult(Table table) throws IOException {
        return FakeBigQueryServices.encodeQueryResult(table, (List<TableRow>)ImmutableList.of());
    }

    public static String encodeQueryResult(Table table, List<TableRow> rows) throws IOException {
        KvCoder coder = KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)ListCoder.of((Coder)TableRowJsonCoder.of()));
        KV kv = KV.of((Object)BigQueryHelpers.toJsonString(table), rows);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        coder.encode(kv, (OutputStream)outputStream);
        return Base64.encodeBase64String((byte[])outputStream.toByteArray());
    }

    public static KV<Table, List<TableRow>> decodeQueryResult(String queryResult) throws IOException {
        KvCoder coder = KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)ListCoder.of((Coder)TableRowJsonCoder.of()));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64.decodeBase64((String)queryResult));
        KV kv = coder.decode((InputStream)inputStream);
        Table table = BigQueryHelpers.fromJsonString((String)kv.getKey(), Table.class);
        List rows = (List)kv.getValue();
        rows.forEach(FakeBigQueryServices::convertNumbers);
        return KV.of((Object)table, (Object)rows);
    }

    public static TableRow convertNumbers(TableRow tableRow) {
        for (Map.Entry entry : tableRow.entrySet()) {
            if (!(entry.getValue() instanceof Integer)) continue;
            entry.setValue(Long.valueOf(((Integer)entry.getValue()).intValue()));
        }
        return tableRow;
    }

    public static class FakeBigQueryServerStream<T>
    implements BigQueryServices.BigQueryServerStream<T> {
        private final List<T> items;

        public FakeBigQueryServerStream(List<T> items) {
            this.items = items;
        }

        @Override
        public Iterator<T> iterator() {
            return this.items.iterator();
        }

        @Override
        public void cancel() {
        }
    }
}

