/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.PublishMetadata;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.Publisher;
import com.google.cloud.pubsublite.internal.wire.PubsubContext;
import com.google.cloud.pubsublite.internal.wire.RoutingPublisherBuilder;
import com.google.cloud.pubsublite.internal.wire.SinglePartitionPublisherBuilder;
import com.google.cloud.pubsublite.proto.PublisherServiceGrpc;
import io.grpc.StatusException;
import java.io.Serializable;
import java.util.Optional;
import org.apache.beam.sdk.io.gcp.pubsublite.AutoValue_PublisherOptions;
import org.apache.beam.sdk.io.gcp.pubsublite.SerializableSupplier;
import org.checkerframework.checker.nullness.qual.Nullable;

@AutoValue
public abstract class PublisherOptions
implements Serializable {
    private static final long serialVersionUID = 275311613L;
    private static final PubsubContext.Framework FRAMEWORK = PubsubContext.Framework.of((String)"BEAM");

    public abstract TopicPath topicPath();

    public abstract @Nullable SerializableSupplier<// Could not load outer class - annotation placement on inner may be incorrect
    PublisherServiceGrpc.PublisherServiceStub> stubSupplier();

    public abstract int hashCode();

    public static Builder newBuilder() {
        return new AutoValue_PublisherOptions.Builder();
    }

    public boolean usesCache() {
        return this.stubSupplier() == null;
    }

    Publisher<PublishMetadata> getPublisher() throws StatusException {
        SinglePartitionPublisherBuilder.Builder singlePartitionPublisherBuilder = SinglePartitionPublisherBuilder.newBuilder().setContext(PubsubContext.of((PubsubContext.Framework)FRAMEWORK));
        if (this.stubSupplier() != null) {
            singlePartitionPublisherBuilder.setStub(Optional.of(this.stubSupplier().get()));
        }
        return RoutingPublisherBuilder.newBuilder().setTopic(this.topicPath()).setPublisherBuilder(singlePartitionPublisherBuilder).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setTopicPath(TopicPath var1);

        public abstract Builder setStubSupplier(SerializableSupplier<PublisherServiceGrpc.PublisherServiceStub> var1);

        public abstract PublisherOptions build();
    }
}

