/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.testing;

import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableRow;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowJsonCoder;

class TableContainer {
    Table table;
    List<TableRow> rows;
    List<String> ids;
    Long sizeBytes;

    TableContainer(Table table) {
        this.table = table;
        this.rows = new ArrayList<TableRow>();
        this.ids = new ArrayList<String>();
        this.sizeBytes = 0L;
    }

    long addRow(TableRow row, String id) {
        this.rows.add(row);
        if (id != null) {
            this.ids.add(id);
        }
        long tableSize = this.table.getNumBytes() == null ? 0L : this.table.getNumBytes();
        try {
            long rowSize = TableRowJsonCoder.of().getEncodedElementByteSize(row);
            this.table.setNumBytes(Long.valueOf(tableSize + rowSize));
            return rowSize;
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to convert the row to JSON", ex);
        }
    }

    Table getTable() {
        return this.table;
    }

    List<TableRow> getRows() {
        return this.rows;
    }

    List<String> getIds() {
        return this.ids;
    }
}

